/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.RcvrImageException;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GraphicsUtil {
    public static final int defaultWidgetColor = GraphicsUtil.getColorFromRGB(new RGB(255, 128, 0));
    public static final int WIDGET_NORMAL_ALPHA = 128;
    public static final int WIDGET_SELECTED_ALPHA = 175;

    public static RGB getRGBFromColor(int color) {
        return new RGB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
    }

    public static int getColorFromRGB(RGB rgb) {
        return rgb.red << 16 | rgb.green << 8 | rgb.blue;
    }

    public static int getColorWithAlpha(int color, int alpha) {
        return color | alpha << 24;
    }

    public static Image getImageFromResource(String resource) {
        InputStream strm = ClassLoader.getSystemResourceAsStream(resource);
        if (strm != null) {
            return new Image((Device)Display.getCurrent(), new ImageData(strm));
        }
        return null;
    }

    public static ImageData getImageDataFromResource(String resource) {
        InputStream strm = ClassLoader.getSystemResourceAsStream(resource);
        if (strm != null) {
            return new ImageData(strm);
        }
        return null;
    }

    public static byte[] loadImage(InputStream stream) {
        ByteArrayOutputStream cache = new ByteArrayOutputStream();
        try {
            while (stream.available() > 0) {
                cache.write(stream.read());
            }
        }
        catch (IOException e) {
            throw new RcvrImageException("Could not loage image from stream: " + e.getMessage(), e);
        }
        return cache.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadImageFromFile(String imageURL) throws IOException {
        if (imageURL == null) {
            return null;
        }
        RandomAccessFile imageFile = null;
        byte[] imageData = null;
        try {
            imageFile = new RandomAccessFile(new File(imageURL), "r");
            imageData = new byte[(int)imageFile.length()];
            imageFile.readFully(imageData);
        }
        finally {
            if (imageFile != null) {
                imageFile.close();
            }
        }
        return imageData;
    }

    public static byte[] rasterizeSVG(Reader image, int width, int height, int color) {
        try {
            if (width < 0 || height < 0) {
                throw new IllegalArgumentException("Width & height cannot be negative");
            }
            ByteArrayOutputStream raster = new ByteArrayOutputStream();
            PNGTranscoder t = new PNGTranscoder();
            Document doc = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument("http://www.w3.org/2000/svg", "svg", null, image);
            if (width > 0 && height > 0) {
                Element root = doc.getDocumentElement();
                root.setAttributeNS(null, "width", String.valueOf(width));
                root.setAttributeNS(null, "height", String.valueOf(height));
            } else if (width > 0) {
                t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)new Float(width));
            } else if (height > 0) {
                t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)new Float(height));
            }
            t.addTranscodingHint(PNGTranscoder.KEY_BACKGROUND_COLOR, (Object)new Color(color, true));
            t.transcode(new TranscoderInput(doc), new TranscoderOutput((OutputStream)raster));
            return raster.toByteArray();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static byte[] cropImage(byte[] image, double x, double y, double width, double height) {
        Image img = new Image(null, new ImageData((InputStream)new ByteArrayInputStream(image)));
        Image out = new Image(null, PrecisionUtilities.round(width), PrecisionUtilities.round(height));
        GC gc = new GC((Drawable)out);
        gc.drawImage(img, -PrecisionUtilities.round(x), -PrecisionUtilities.round(y));
        ImageLoader saver = new ImageLoader();
        saver.data = new ImageData[]{out.getImageData()};
        gc.dispose();
        out.dispose();
        img.dispose();
        ByteArrayOutputStream ret = new ByteArrayOutputStream();
        saver.save((OutputStream)ret, 4);
        return ret.toByteArray();
    }

    public static DoubleRectangle getImageBounds(byte[] image) {
        if (image == null) {
            return new DoubleRectangle(0.0, 0.0, 0.0, 0.0);
        }
        Image img = new Image(null, (InputStream)new ByteArrayInputStream(image));
        Rectangle rect = img.getBounds();
        img.dispose();
        return new DoubleRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public static void drawOverlay(GC gc, ImageData overlayData, Rectangle area) {
        Image overlay = new Image(null, overlayData.scaledTo(area.width, area.height));
        gc.drawImage(overlay, area.x, area.y);
        overlay.dispose();
    }
}

