/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.GlobalAttributed;
import edu.cmu.cs.hcii.cogtool.util.IAttributed;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class GlobalAttributedTest
extends TestCase {
    private static final boolean pedantic = true;
    private GlobalAttributed ga1;
    private GlobalAttributed ga2;
    private GlobalAttributed ga3;
    private MockPCL[] pcls;

    public static void main(String[] args) {
        TestRunner.run((Class)GlobalAttributedTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ga1 = new GATester();
        this.ga2 = new GATester2();
        this.ga3 = new GATester3();
        this.pcls = new MockPCL[5];
        for (int i = 0; i < this.pcls.length; ++i) {
            this.pcls[i] = new MockPCL();
        }
    }

    protected void tearDown() throws Exception {
        GlobalAttributed.undefineAllAttributes();
    }

    public void testGetGlobalAuthority() {
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        GlobalAttributedTest.assertNotNull((String)"The global authority should not be null", (Object)ga);
        GlobalAttributedTest.assertEquals((String)"The global authority should always be the same object.", (Object)ga, (Object)GlobalAttributed.getGlobalAuthority());
        GlobalAttributedTest.assertEquals((String)"The authority for the global authority should be itself.", (Object)ga, (Object)ga.getAuthority());
        try {
            ga.defineAttribute("testAttr", String.class, "testing...");
            GlobalAttributedTest.fail((String)"defineAttribute should throw an UnsupportedOperationException when called on the global authority.");
        }
        catch (UnsupportedOperationException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("defineAttribute on the global authority threw the wrong exception: " + e));
        }
        try {
            ga.setAuthority(ga);
            GlobalAttributedTest.fail((String)"setAuthority should throw an UnsupportedOperationException when called on the global authority.");
        }
        catch (UnsupportedOperationException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAuthority on the global authority threw the wrong exception: " + e));
        }
        this.setupAttrs();
        GlobalAttributedTest.assertTrue((String)"defining attrs anywhere should also define them on the global authority", (boolean)ga.isDefined("testAttr"));
        GlobalAttributedTest.assertTrue((String)"defining attrs anywhere should also define them on the global authority", (boolean)ga.isDefined("testAttr2"));
        GlobalAttributedTest.assertEquals((String)"The global authority should return the default values for getAttr", (Object)"testing...", (Object)ga.getAttribute("testAttr"));
        GlobalAttributedTest.assertEquals((String)"The global authority should return the default values for getAttr", (Object)"testing2...", (Object)ga.getAttribute("testAttr2"));
    }

    public void testGetAuthority() {
        IAttributed auth = this.ga1.getAuthority();
        GlobalAttributedTest.assertNotNull((String)"getAuthority() should never be null", (Object)auth);
        GlobalAttributedTest.assertEquals((String)"Immediately after construction, getAuthority() == getGlobalAuthority()", (Object)GlobalAttributed.getGlobalAuthority(), (Object)auth);
        this.ga1.setAuthority(this.ga2);
        GlobalAttributedTest.assertEquals((String)"getAuthority() should change after setAuthority()", (Object)this.ga2, (Object)this.ga1.getAuthority());
        GlobalAttributedTest.assertNotNull((String)"getAuthority() should never be null", (Object)this.ga1.getAuthority());
    }

    public void testSetAuthority() {
        try {
            this.ga1.setAuthority(null);
            GlobalAttributedTest.fail((String)"setAuthority with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAuthority threw the wrong exception for null auth: " + e));
        }
        this.ga1.setAuthority(this.ga3);
        GlobalAttributedTest.assertEquals((String)"getAuthority() should change after setAuthority()", (Object)this.ga3, (Object)this.ga1.getAuthority());
        this.ga1.setAuthority(this.ga2);
        GlobalAttributedTest.assertEquals((String)"getAuthority() should change after setAuthority()", (Object)this.ga2, (Object)this.ga1.getAuthority());
        this.ga1.setAuthority(GlobalAttributed.getGlobalAuthority());
        this.setupAttrs();
        this.ga1.setAuthority(this.ga3);
        try {
            this.ga1.setAuthority(this.ga2);
            GlobalAttributedTest.fail((String)"setAuthority with !auth.isDefined(x) should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAuthority on threw the wrong exception for !auth.isDefined(attr): " + e));
        }
    }

    public void testDefineAttribute() {
        try {
            this.ga1.defineAttribute(null, null, null);
            GlobalAttributedTest.fail((String)"defineAttribute with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("defineAttribute threw the wrong exception for null auth: " + e));
        }
    }

    public void testUndefineAttribute() {
        this.ga1.undefineAttribute(null);
    }

    public void testUndefineAllAttributes() {
        this.setupAttrs();
        this.ga1.addPropertyChangeListener(this.pcls[0]);
        this.ga1.addPropertyChangeListener("testAttr", this.pcls[1]);
        this.ga3.addPropertyChangeListener(this.pcls[0]);
        this.ga3.addPropertyChangeListener("testAttr", this.pcls[1]);
        GlobalAttributed.undefineAllAttributes();
        GlobalAttributedTest.assertEquals((String)"After undefineAllAttributes, getAttributeNames should be empty", (int)0, (int)GlobalAttributed.getGlobalAuthority().getAttributeNames().size());
        GlobalAttributedTest.assertFalse((String)"After undefineAllAttributes, testAttr should not be defined", (boolean)this.ga1.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"After undefineAllAttributes, testAttr should not be defined", (boolean)this.ga2.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"After undefineAllAttributes, testAttr should not be defined", (boolean)this.ga3.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"After undefineAllAttributes, testAttr2 should not be defined", (boolean)this.ga1.isDefined("testAttr2"));
        GlobalAttributedTest.assertFalse((String)"After undefineAllAttributes, testAttr2 should not be defined", (boolean)this.ga3.isDefined("testAttr2"));
        GlobalAttributedTest.assertFalse((String)"After undefineAllAttributes, testAttr3 should not be defined", (boolean)this.ga3.isDefined("testAttr3"));
        this.setupAttrs();
        GlobalAttributedTest.assertTrue((String)"After undefineAll, global PropertyChangeListeners should still be present", (boolean)this.ga1.hasListeners("testAttr"));
        GlobalAttributedTest.assertTrue((String)"After undefineAll, global PropertyChangeListeners should still be present", (boolean)this.ga3.hasListeners("testAttr"));
        this.ga1.removeAllListeners();
        this.ga3.removeAllListeners();
        GlobalAttributedTest.assertFalse((String)"After undefineAll, specific PropertyChangeListeners should be gone", (boolean)this.ga3.hasListeners("testAttr"));
        GlobalAttributedTest.assertFalse((String)"After undefineAll, specific PropertyChangeListeners should be gone", (boolean)this.ga1.hasListeners("testAttr"));
    }

    public void testIsDefined() {
        GlobalAttributedTest.assertFalse((String)"A null attribute should always be !isDefined", (boolean)this.ga1.isDefined(null));
        GlobalAttributedTest.assertFalse((String)"isDefined(attr) should start as false for all attrs", (boolean)this.ga1.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"isDefined(attr) should start as false for all attrs", (boolean)this.ga1.isDefined("not-an-attr"));
        GlobalAttributedTest.assertFalse((String)"isDefined(attr) should start as false for all attrs, even empty string", (boolean)this.ga1.isDefined(""));
        this.ga1.defineAttribute("testAttr", String.class, "testing...");
        GlobalAttributedTest.assertTrue((String)"isDefined should be true after defineAttr", (boolean)this.ga1.isDefined("testAttr"));
        GATester ga4 = new GATester();
        GlobalAttributedTest.assertTrue((String)"isDefined should be true after defineAttr for all direct members of a class", (boolean)ga4.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"isDefined should be false after defineAttr for sibling classes", (boolean)this.ga3.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"isDefined should be false after defineAttr for superclasses", (boolean)this.ga2.isDefined("testAttr"));
        this.ga2.defineAttribute("testAttr2", String.class, "testing...");
        GlobalAttributedTest.assertFalse((String)"isDefined should be false after defineAttr for subclasses", (boolean)this.ga1.isDefined("testAttr2"));
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        GlobalAttributedTest.assertTrue((String)"isDefined should be true for global authority after defineAttr", (boolean)ga.isDefined("testAttr"));
        GlobalAttributed ga5 = new GlobalAttributed();
        GlobalAttributedTest.assertFalse((String)"isDefined should be false for base class after defineAttr for subclass", (boolean)ga5.isDefined("testAttr"));
        this.ga1.setAttribute("testAttr", "new value");
        GlobalAttributedTest.assertTrue((String)"isDefined should stay true after setAttr", (boolean)this.ga1.isDefined("testAttr"));
        this.ga1.setAttributeToDefault("testAttr");
        GlobalAttributedTest.assertTrue((String)"isDefined should stay true after setAttrToDefault", (boolean)this.ga1.isDefined("testAttr"));
        this.ga1.undefineAttribute("testAttr");
        GlobalAttributedTest.assertFalse((String)"isDefined should be false after undefineAttr", (boolean)this.ga1.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"isDefined should stay false after undefineAttr for sibling classes", (boolean)this.ga3.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"isDefined should stay false after undefineAttr for superclasses", (boolean)this.ga2.isDefined("testAttr"));
        this.ga2.undefineAttribute("testAttr2");
        GlobalAttributedTest.assertFalse((String)"isDefined should stay false after undefineAttr for subclasses", (boolean)this.ga1.isDefined("testAttr2"));
        GlobalAttributedTest.assertFalse((String)"isDefined should be false for global authority after undefineAttr", (boolean)ga.isDefined("testAttr"));
        GlobalAttributedTest.assertFalse((String)"isDefined should be false for base class after undefineAttr on subclass", (boolean)ga5.isDefined("testAttr"));
    }

    public void testGetAttributeType() {
        try {
            this.ga1.getAttributeType(null);
            GlobalAttributedTest.fail((String)"getAttributeType with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("getAttributeType threw the wrong exception for null auth: " + e));
        }
        GlobalAttributedTest.assertNull((String)"Attribute type for an undefined attr should be null", (Object)this.ga1.getAttributeType("attr"));
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        GlobalAttributedTest.assertNull((String)"Attribute type for an undefined attr should be null", (Object)ga.getAttributeType("attr"));
        this.setupAttrs();
        GlobalAttributedTest.assertEquals((String)"Attribute type should be the same type given in defineAttribute", (Object)String.class, (Object)this.ga1.getAttributeType("testAttr"));
        GlobalAttributedTest.assertEquals((String)"Attribute type should be the same for all classes", (Object)this.ga1.getAttributeType("testAttr"), (Object)this.ga2.getAttributeType("testAttr"));
        GlobalAttributedTest.assertEquals((String)"Attribute type should be the same for all classes", (Object)this.ga1.getAttributeType("testAttr"), (Object)ga.getAttributeType("testAttr"));
        this.ga3.undefineAttribute("testAttr3");
        this.ga3.defineAttribute("testAttr3", Integer.class, new Integer(42));
        GlobalAttributedTest.assertEquals((String)"Attribute type should change after undefine/define", (Object)Integer.class, (Object)this.ga3.getAttributeType("testAttr3"));
    }

    public void testGetAttributeNames() {
        GlobalAttributedTest.assertNotNull((String)"getAttributeNames should never return null", (Object)this.ga1.getAttributeNames());
        GlobalAttributedTest.assertNotNull((String)"getAttributeNames should never return null", (Object)this.ga2.getAttributeNames());
        GlobalAttributedTest.assertNotNull((String)"getAttributeNames should never return null", (Object)this.ga3.getAttributeNames());
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        GlobalAttributedTest.assertNotNull((String)"getAttributeNames should never return null, even for the global auth", (Object)ga.getAttributeNames());
        Set names = ga.getAttributeNames();
        int before = names.size();
        this.setupAttrs();
        int after = names.size();
        GlobalAttributedTest.assertEquals((String)"getAttributeNames value size should not be changed by future defineAttrs", (int)before, (int)after);
        names = this.ga1.getAttributeNames();
        GlobalAttributedTest.assertTrue((String)"getAttributeNames should include attr immediately after define", (boolean)names.contains("testAttr"));
        GlobalAttributedTest.assertTrue((String)"getAttributeNames should include attr immediately after define", (boolean)names.contains("testAttr2"));
        this.ga3.undefineAttribute("testAttr2");
        names = this.ga3.getAttributeNames();
        GlobalAttributedTest.assertFalse((String)"getAttributeNames should remove attr immediately after undefine", (boolean)names.contains("testAttr2"));
        names = ga.getAttributeNames();
        GlobalAttributedTest.assertTrue((String)"getAttributeNames on globalAuth should include all attrs everywhere", (boolean)names.contains("testAttr"));
        GlobalAttributedTest.assertTrue((String)"getAttributeNames on globalAuth should include all attrs everywhere", (boolean)names.contains("testAttr2"));
        GlobalAttributedTest.assertTrue((String)"getAttributeNames on globalAuth should include all attrs everywhere", (boolean)names.contains("testAttr3"));
        this.ga3.undefineAttribute("testAttr3");
        names = this.ga3.getAttributeNames();
        GlobalAttributedTest.assertFalse((String)"getAttributeNames should remove attr immediately after undefine", (boolean)names.contains("testAttr3"));
        names = ga.getAttributeNames();
        GlobalAttributedTest.assertTrue((String)"getAttributeNames on globalAuth should include all attrs everywhere", (boolean)names.contains("testAttr"));
        GlobalAttributedTest.assertTrue((String)"getAttributeNames on globalAuth should include all attrs everywhere", (boolean)names.contains("testAttr2"));
        GlobalAttributedTest.assertFalse((String)"getAttributeNames on globalAuth should include all attrs everywhere", (boolean)names.contains("testAttr3"));
    }

    public void testIsDefaultValue() {
        try {
            this.ga1.isDefaultValue(null);
            GlobalAttributedTest.fail((String)"isDefaultValue with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("isDefaultValue threw the wrong exception for null auth: " + e));
        }
        try {
            this.ga1.isDefaultValue("non-an-attr");
            GlobalAttributedTest.fail((String)"isDefaultValue with undefined auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("isDefaultValue threw the wrong exception for undefined auth: " + e));
        }
        this.setupAttrs();
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        GlobalAttributedTest.assertFalse((String)"isDefaultValue should always be false for GlobalAuth", (boolean)ga.isDefaultValue("testAttr"));
        GlobalAttributedTest.assertFalse((String)"isDefaultValue should always be false for GlobalAuth", (boolean)ga.isDefaultValue("testAttr2"));
        GlobalAttributedTest.assertTrue((String)"isDefaultValue should start out true for new attrs", (boolean)this.ga1.isDefaultValue("testAttr2"));
        GlobalAttributedTest.assertFalse((String)"isDefaultValue should return false after setAttr", (boolean)this.ga1.isDefaultValue("testAttr"));
        this.ga1.setAttributeToDefault("testAttr");
        GlobalAttributedTest.assertTrue((String)"isDefaultValue should start out true for new attrs", (boolean)this.ga1.isDefaultValue("testAttr"));
    }

    public void testGetAttribute() {
        try {
            this.ga1.getAttribute(null);
            GlobalAttributedTest.fail((String)"getAttribute with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("getAttribute threw the wrong exception for null auth: " + e));
        }
        try {
            this.ga1.getAttribute("non-an-attr");
            GlobalAttributedTest.fail((String)"getAttribute with undefined auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("getAttribute threw the wrong exception for undefined auth: " + e));
        }
        this.setupAttrs();
        GlobalAttributedTest.assertEquals((String)"getAttribute should return concrete default value if isDefaultValue(attr)", (Object)"testing...", (Object)this.ga2.getAttribute("testAttr"));
        this.ga2.setAttribute("testAttr", "changed!");
        GlobalAttributedTest.assertEquals((String)"getAttribute should change after setAttr", (Object)"changed!", (Object)this.ga2.getAttribute("testAttr"));
        this.ga2.setAttribute("testAttr", "changed again!");
        GlobalAttributedTest.assertEquals((String)"getAttribute should change after setAttr", (Object)"changed again!", (Object)this.ga2.getAttribute("testAttr"));
        this.ga2.setAttribute("testAttr", null);
        GlobalAttributedTest.assertNull((String)"getAttribute should support null values w/o exceptions", (Object)this.ga2.getAttribute("testAttr"));
        this.ga2.setAttributeToDefault("testAttr");
        GlobalAttributedTest.assertEquals((String)"getAttribute should change after setAttrToDefault, if was previously concrete value", (Object)"testing...", (Object)this.ga2.getAttribute("testAttr"));
        this.ga2.setAuthority(this.ga3);
        this.ga3.setAttribute("testAttr", "auth changed!");
        GlobalAttributedTest.assertEquals((String)"getAttribute should change after auth.setAttr if isDefaultValue(attr)", (Object)"auth changed!", (Object)this.ga2.getAttribute("testAttr"));
        this.ga2.setAttribute("testAttr", "local value!");
        this.ga3.setAttribute("testAttr", "auth changed again!");
        GlobalAttributedTest.assertEquals((String)"getAttribute should not change after auth.setAttr if !isDefaultValue(attr)", (Object)"local value!", (Object)this.ga2.getAttribute("testAttr"));
    }

    public void testSetAttribute() {
        try {
            this.ga1.setAttribute(null, "changed!");
            GlobalAttributedTest.fail((String)"setAttribute with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAttribute threw the wrong exception for null auth: " + e));
        }
        try {
            this.ga1.setAttribute("non-an-attr", "changed!");
            GlobalAttributedTest.fail((String)"setAttribute with undefined auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAttribute threw the wrong exception for undefined auth: " + e));
        }
        this.setupAttrs();
        try {
            this.ga1.setAttribute("testAttr", null);
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAttribute threw an exception for null value: " + e));
        }
    }

    public void testSetAttributeToDefault() {
        try {
            this.ga1.setAttributeToDefault(null);
            GlobalAttributedTest.fail((String)"setAttributeToDefault with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAttributeToDefault threw the wrong exception for null auth: " + e));
        }
        try {
            this.ga1.setAttributeToDefault("non-an-attr");
            GlobalAttributedTest.fail((String)"setAttributeToDefault with undefined auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAttributeToDefault threw the wrong exception for undefined auth: " + e));
        }
        this.setupAttrs();
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        try {
            ga.setAttributeToDefault("testAttr");
            GlobalAttributedTest.fail((String)"setAttributeToDefault on global auth should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("setAttributeToDefault threw the wrong exception on global auth: " + e));
        }
    }

    public void testAddPropertyChangeListenerPropertyChangeListener() {
        this.setupAttrs();
        String attr = "testAttr";
        String attr2 = "testAttr2";
        int oldCallCount = 0;
        try {
            this.ga1.addPropertyChangeListener(null);
            GlobalAttributedTest.fail((String)"addPropertyChangeListener with null pcl should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("addPropertyChangeListener threw the wrong exception for null pcl: " + e));
        }
        this.ga1.addPropertyChangeListener(this.pcls[0]);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val");
        GlobalAttributedTest.assertEquals((String)"Global PCL should recieve events for all setAttr calls", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"Global PCL should recieve events for all setAttr calls with proper oldVal", (Object)"non-default", (Object)this.pcls[0].lastOldVal);
        GlobalAttributedTest.assertEquals((String)"Global PCL should recieve events for all setAttr calls with proper newVal", (Object)"new val", (Object)this.pcls[0].lastNewVal);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr2, "new val2");
        GlobalAttributedTest.assertEquals((String)"Global PCL should recieve events for all setAttr calls", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"Global PCL should recieve events for all setAttr calls with proper oldVal", (Object)"testing2...", (Object)this.pcls[0].lastOldVal);
        GlobalAttributedTest.assertEquals((String)"Global PCL should recieve events for all setAttr calls with proper newVal", (Object)"new val2", (Object)this.pcls[0].lastNewVal);
        this.helpTestBasicNotification();
        this.ga1.removePropertyChangeListener(this.pcls[0]);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val8");
        GlobalAttributedTest.assertEquals((String)"number of calls to PCL should be reduced by one if remove called once", (int)oldCallCount, (int)this.pcls[0].callCount);
        this.ga1.undefineAttribute(attr);
        this.ga1.defineAttribute(attr, String.class, "testing...");
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val9");
        GlobalAttributedTest.assertEquals((String)"PCL should not recieve events after undefineAttr", (int)oldCallCount, (int)this.pcls[0].callCount);
        this.ga2.addPropertyChangeListener(this.pcls[0]);
        this.helpTestAuthNotification();
    }

    public void testAddPropertyChangeListenerStringPropertyChangeListener() {
        this.setupAttrs();
        String attr = "testAttr";
        String attr2 = "testAttr2";
        try {
            this.ga1.addPropertyChangeListener(null, this.pcls[0]);
            GlobalAttributedTest.fail((String)"addPropertyChangeListener with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("addPropertyChangeListener threw the wrong exception for null auth: " + e));
        }
        try {
            this.ga1.addPropertyChangeListener("non-an-attr", this.pcls[0]);
            GlobalAttributedTest.fail((String)"addPropertyChangeListener with undefined auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("addPropertyChangeListener threw the wrong exception for undefined auth: " + e));
        }
        try {
            this.ga1.addPropertyChangeListener("testAttr", null);
            GlobalAttributedTest.fail((String)"addPropertyChangeListener with null pcl should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("addPropertyChangeListener threw the wrong exception for null pcl: " + e));
        }
        this.ga1.addPropertyChangeListener(attr, this.pcls[0]);
        int oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val");
        GlobalAttributedTest.assertEquals((String)"Specific PCL should recieve events for setAttr calls", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"Specific PCL should recieve events for setAttr calls with proper oldVal", (Object)"non-default", (Object)this.pcls[0].lastOldVal);
        GlobalAttributedTest.assertEquals((String)"Specific PCL should recieve events for setAttr calls with proper newVal", (Object)"new val", (Object)this.pcls[0].lastNewVal);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr2, "new val2");
        GlobalAttributedTest.assertEquals((String)"Specific PCL should recieve events for only specific setAttr calls", (int)oldCallCount, (int)this.pcls[0].callCount);
        this.helpTestBasicNotification();
        this.ga1.removePropertyChangeListener(attr, this.pcls[0]);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val8");
        GlobalAttributedTest.assertEquals((String)"number of calls to PCL should be reduced by one if remove called once", (int)oldCallCount, (int)this.pcls[0].callCount);
        this.ga1.undefineAttribute(attr);
        this.ga1.defineAttribute(attr, String.class, "testing...");
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val9");
        GlobalAttributedTest.assertEquals((String)"PCL should not recieve events after undefineAttr", (int)oldCallCount, (int)this.pcls[0].callCount);
        this.ga2.addPropertyChangeListener(attr, this.pcls[0]);
        this.helpTestAuthNotification();
    }

    void helpTestBasicNotification() {
        String attr = "testAttr";
        String attr2 = "testAttr2";
        int oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val");
        GlobalAttributedTest.assertEquals((String)"PCL should recieve no update if new value is same as old value", (int)oldCallCount, (int)this.pcls[0].callCount);
        this.ga1.addPropertyChangeListener(this.pcls[0]);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val3");
        GlobalAttributedTest.assertEquals((String)"number of calls to PCL should be equal to number of times added", (int)(oldCallCount + 2), (int)this.pcls[0].callCount);
        this.ga1.removePropertyChangeListener(this.pcls[0]);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val4");
        GlobalAttributedTest.assertEquals((String)"number of calls to PCL should be reduced by one if remove called once", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        this.ga1.addPropertyChangeListener(attr, this.pcls[0]);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val5");
        GlobalAttributedTest.assertEquals((String)"PCL should recieve separate event for each change if set with specific add variant", (int)(oldCallCount + 2), (int)this.pcls[0].callCount);
        this.ga1.removePropertyChangeListener(attr, this.pcls[0]);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val6");
        GlobalAttributedTest.assertEquals((String)"number of calls to PCL should be reduced by one if remove called once", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        oldCallCount = this.pcls[0].callCount;
        this.ga2.setAttribute(attr, "new val7");
        GlobalAttributedTest.assertEquals((String)"PCL should not recieve events for other GAs", (int)oldCallCount, (int)this.pcls[0].callCount);
    }

    void helpTestAuthNotification() {
        String attr = "testAttr";
        int oldCallCount = this.pcls[0].callCount;
        this.ga2.setAttributeToDefault(attr);
        GlobalAttributedTest.assertEquals((String)"setAttrToDefault should trigger notification", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        oldCallCount = this.pcls[0].callCount;
        this.ga2.setAuthority(this.ga1);
        GlobalAttributedTest.assertEquals((String)"when default, setAuth should trigger notification", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"PCL should recieve events for setAuth call with proper oldVal", (Object)"testing...", (Object)this.pcls[0].lastOldVal);
        GlobalAttributedTest.assertEquals((String)"PCL should recieve events for setAuth call with proper newVal", (Object)"new val9", (Object)this.pcls[0].lastNewVal);
        GlobalAttributedTest.assertEquals((String)"in a change notification, getAuthority should return the new auth", (Object)this.pcls[0].lastAuth, (Object)this.ga1);
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val10");
        GlobalAttributedTest.assertEquals((String)"when default, auth.setAttr should trigger local notification", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"when default, auth.setAttr should change getAttr", (Object)"new val10", (Object)this.ga2.getAttribute(attr));
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttributeToDefault(attr);
        GlobalAttributedTest.assertEquals((String)"when default, auth.setAttrToDefault should trigger local notification", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"PCL should recieve events for auth.setAttrToDefault call with proper oldVal", (Object)"new val10", (Object)this.pcls[0].lastOldVal);
        GlobalAttributedTest.assertEquals((String)"PCL should recieve events for auth.setAttrToDefault call with proper newVal", (Object)"testing...", (Object)this.pcls[0].lastNewVal);
        GlobalAttributedTest.assertEquals((String)"when default, auth.setAttrToDefault should change getAttr", (Object)"testing...", (Object)this.ga2.getAttribute(attr));
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        oldCallCount = this.pcls[0].callCount;
        ga.setAttribute(attr, "new default");
        GlobalAttributedTest.assertEquals((String)"when default up to root, global setAttr should trigger local notification", (int)(oldCallCount + 1), (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"PCL should recieve events for global setAttr call with proper oldVal", (Object)"testing...", (Object)this.pcls[0].lastOldVal);
        GlobalAttributedTest.assertEquals((String)"PCL should recieve events for global setAttr call with proper newVal", (Object)"new default", (Object)this.pcls[0].lastNewVal);
        GlobalAttributedTest.assertEquals((String)"when default up to root, global setAttr should change getAttr", (Object)"new default", (Object)this.ga2.getAttribute(attr));
        this.ga2.setAttribute(attr, "not default");
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttribute(attr, "new val11");
        GlobalAttributedTest.assertEquals((String)"when not default, auth.setAttr should not trigger a change notification", (int)oldCallCount, (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"when not default, auth.setAttr should not change getAttr", (Object)"not default", (Object)this.ga2.getAttribute(attr));
        this.ga2.setAttribute(attr, "not default");
        oldCallCount = this.pcls[0].callCount;
        this.ga1.setAttributeToDefault(attr);
        GlobalAttributedTest.assertEquals((String)"when not default, auth.setAttrToDefault should not trigger a change notification", (int)oldCallCount, (int)this.pcls[0].callCount);
        GlobalAttributedTest.assertEquals((String)"when not default, auth.setAttrToDefault should not change getAttr", (Object)"not default", (Object)this.ga2.getAttribute(attr));
    }

    public void testRemovePropertyChangeListenerPropertyChangeListener() {
        this.setupAttrs();
        try {
            this.ga1.removePropertyChangeListener(null);
            GlobalAttributedTest.fail((String)"removePropertyChangeListener with null pcl should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("removePropertyChangeListener threw the wrong exception for null pcl: " + e));
        }
    }

    public void testRemovePropertyChangeListenerStringPropertyChangeListener() {
        try {
            this.ga1.removePropertyChangeListener(null, this.pcls[0]);
            GlobalAttributedTest.fail((String)"removePropertyChangeListener with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("removePropertyChangeListener threw the wrong exception for null auth: " + e));
        }
        try {
            this.ga1.removePropertyChangeListener("non-an-attr", this.pcls[0]);
            GlobalAttributedTest.fail((String)"removePropertyChangeListener with undefined auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("removePropertyChangeListener threw the wrong exception for undefined auth: " + e));
        }
        this.setupAttrs();
        try {
            this.ga1.removePropertyChangeListener("testAttr", null);
            GlobalAttributedTest.fail((String)"removePropertyChangeListener with null pcl should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("removePropertyChangeListener threw the wrong exception for null pcl: " + e));
        }
    }

    public void testRemoveAllListeners() {
        this.setupAttrs();
        String attr = "testAttr";
        String attr2 = "testAttr2";
        this.ga1.addPropertyChangeListener(this.pcls[0]);
        this.ga3.addPropertyChangeListener(this.pcls[0]);
        this.ga1.addPropertyChangeListener(attr2, this.pcls[1]);
        this.ga3.addPropertyChangeListener(attr2, this.pcls[1]);
        this.ga1.removeAllListeners();
        this.ga3.removeAllListeners();
        GlobalAttributedTest.assertFalse((String)"After removeAllListeners(), global PropertyChangeListeners should be gone", (boolean)this.ga1.hasListeners(attr));
        GlobalAttributedTest.assertFalse((String)"After removeAllListeners(), global PropertyChangeListeners should be gone", (boolean)this.ga3.hasListeners(attr));
        GlobalAttributedTest.assertTrue((String)"After removeAllListeners(), specific PropertyChangeListeners should still be present", (boolean)this.ga1.hasListeners(attr2));
        GlobalAttributedTest.assertTrue((String)"After removeAllListeners(), specific PropertyChangeListeners should still be present", (boolean)this.ga3.hasListeners(attr2));
    }

    public void testRemoveAllListenersString() {
        this.setupAttrs();
        String attr = "testAttr";
        String attr2 = "testAttr2";
        this.ga2.addPropertyChangeListener(attr, this.pcls[0]);
        this.ga3.addPropertyChangeListener(attr, this.pcls[0]);
        this.ga1.addPropertyChangeListener(attr2, this.pcls[1]);
        this.ga3.addPropertyChangeListener(attr2, this.pcls[1]);
        this.ga1.removeAllListeners(attr);
        this.ga3.removeAllListeners(attr);
        GlobalAttributedTest.assertFalse((String)"After removeAllListeners(attr), specific PropertyChangeListeners should be gone for attr", (boolean)this.ga1.hasListeners(attr));
        GlobalAttributedTest.assertFalse((String)"After removeAllListeners(attr), specific PropertyChangeListeners should be gone for attr", (boolean)this.ga3.hasListeners(attr));
        GlobalAttributedTest.assertTrue((String)"After removeAllListeners(attr), specific PropertyChangeListeners should still be present for attr2", (boolean)this.ga1.hasListeners(attr2));
        GlobalAttributedTest.assertTrue((String)"After removeAllListeners(attr), specific PropertyChangeListeners should still be present for attr2", (boolean)this.ga3.hasListeners(attr2));
    }

    public void testHasListeners() {
        try {
            this.ga1.hasListeners(null);
            GlobalAttributedTest.fail((String)"hasListeners with null auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("hasListeners threw the wrong exception for null auth: " + e));
        }
        try {
            this.ga1.hasListeners("non-an-attr");
            GlobalAttributedTest.fail((String)"hasListeners with undefined auth should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            GlobalAttributedTest.fail((String)("hasListeners threw the wrong exception for undefined auth: " + e));
        }
        this.setupAttrs();
        this.helpTestHasListeners(this.ga1);
        this.helpTestHasListeners(GlobalAttributed.getGlobalAuthority());
        String attr = "testAttr";
        this.ga1.removeAllListeners();
        this.ga1.removeAllListeners(attr);
        this.ga2.setAuthority(this.ga1);
        this.ga2.setAttributeToDefault(attr);
        this.ga2.addPropertyChangeListener(attr, this.pcls[0]);
        GlobalAttributedTest.assertFalse((String)"hasListeners should be false even if child hasListeners", (boolean)this.ga1.hasListeners(attr));
        GlobalAttributed ga = GlobalAttributed.getGlobalAuthority();
        ga.addPropertyChangeListener(attr, this.pcls[0]);
        GlobalAttributedTest.assertTrue((String)"hasListeners on GlobalAuth should still work", (boolean)ga.hasListeners(attr));
        GlobalAttributedTest.assertFalse((String)"hasListeners should be false even if GlobalAuth hasListeners", (boolean)this.ga1.hasListeners(attr));
    }

    void helpTestHasListeners(GlobalAttributed ga) {
        GlobalAttributedTest.assertFalse((String)"hasListeners should start out false", (boolean)ga.hasListeners("testAttr"));
        ga.addPropertyChangeListener("testAttr", this.pcls[0]);
        GlobalAttributedTest.assertTrue((String)"hasListeners should be true after addPCL(attr,pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.removePropertyChangeListener("testAttr", this.pcls[0]);
        GlobalAttributedTest.assertFalse((String)"hasListeners should be false after balanced removePCL(attr,pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.addPropertyChangeListener("testAttr", this.pcls[1]);
        ga.addPropertyChangeListener("testAttr", this.pcls[2]);
        GlobalAttributedTest.assertTrue((String)"hasListeners should be true after addPCL(attr,pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.removePropertyChangeListener("testAttr", this.pcls[1]);
        ga.removePropertyChangeListener("testAttr", this.pcls[2]);
        GlobalAttributedTest.assertFalse((String)"hasListeners should be false after balanced removePCL(attr,pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.addPropertyChangeListener(this.pcls[0]);
        GlobalAttributedTest.assertTrue((String)"hasListeners should be true after addPCL(pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.removePropertyChangeListener(this.pcls[0]);
        GlobalAttributedTest.assertFalse((String)"hasListeners should be false after balanced removePCL(attr,pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.addPropertyChangeListener(this.pcls[1]);
        ga.addPropertyChangeListener(this.pcls[2]);
        GlobalAttributedTest.assertTrue((String)"hasListeners should be true after addPCL(pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.removePropertyChangeListener(this.pcls[1]);
        ga.removePropertyChangeListener(this.pcls[2]);
        GlobalAttributedTest.assertFalse((String)"hasListeners should be false after balanced removePCL(pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.addPropertyChangeListener(this.pcls[1]);
        ga.addPropertyChangeListener(this.pcls[2]);
        ga.removePropertyChangeListener("testAttr", this.pcls[1]);
        ga.removePropertyChangeListener("testAttr", this.pcls[2]);
        GlobalAttributedTest.assertTrue((String)"hasListeners should be true after global addPCL + selective removePCL", (boolean)ga.hasListeners("testAttr"));
        ga.removePropertyChangeListener(this.pcls[1]);
        ga.removePropertyChangeListener(this.pcls[2]);
        ga.addPropertyChangeListener("testAttr2", this.pcls[0]);
        GlobalAttributedTest.assertFalse((String)"hasListeners should still be false after addPCL(other-attr,pcl)", (boolean)ga.hasListeners("testAttr"));
        ga.addPropertyChangeListener("testAttr", this.pcls[0]);
        ga.removePropertyChangeListener("testAttr2", this.pcls[0]);
        GlobalAttributedTest.assertTrue((String)"hasListeners should still be true after removePCL(other-attr,pcl)", (boolean)ga.hasListeners("testAttr"));
    }

    private void invariants() {
    }

    private void setupAttrs() {
        this.ga1.defineAttribute("testAttr", String.class, "testing...");
        this.ga1.defineAttribute("testAttr2", String.class, "testing2...");
        this.ga1.setAttribute("testAttr", "non-default");
        this.ga2.defineAttribute("testAttr", String.class, "testing...");
        this.ga3.defineAttribute("testAttr", String.class, "testing...");
        this.ga3.defineAttribute("testAttr2", String.class, "testing2...");
        this.ga3.defineAttribute("testAttr3", String.class, "testing3...");
    }

    private static class MockPCL
    implements PropertyChangeListener {
        public int callCount = 0;
        public Object lastOldVal;
        public Object lastNewVal;
        public IAttributed lastAuth;

        private MockPCL() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ++this.callCount;
            this.lastOldVal = evt.getOldValue();
            this.lastNewVal = evt.getNewValue();
            this.lastAuth = ((GlobalAttributed)evt.getSource()).getAuthority();
        }
    }

    private static class GATester3
    extends GlobalAttributed {
        private GATester3() {
        }
    }

    private static class GATester2
    extends GATester {
        private GATester2() {
        }
    }

    private static class GATester
    extends GlobalAttributed {
        private GATester() {
        }
    }
}

