/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.util.IAttributed;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.list.CursorableLinkedList;

public class GlobalAttributed
extends Alerter
implements IAttributed {
    private static final Map definedAttrs = new HashMap();
    private static final Map typeRegistry = new HashMap();
    private static final Map hostCounts = new HashMap();
    private static final Map instances = new HashMap();
    private static CursorableLinkedList eventQ = new CursorableLinkedList();
    private static final GlobalAttributed globalAuth = GlobalAuthority.ONLY;
    private GlobalAttributed localAuth;
    private Map localStore;
    private Map defaultFlags;
    private ArrayList children;
    private PropertyChangeSupport pcs;

    public GlobalAttributed() {
        HashSet<GlobalAttributed> sibs;
        Set attrs = (HashSet)definedAttrs.get(this.getClass());
        if (attrs == null) {
            attrs = new HashSet();
            definedAttrs.put(this.getClass(), attrs);
        }
        if ((sibs = (HashSet<GlobalAttributed>)instances.get(this.getClass())) == null) {
            sibs = new HashSet<GlobalAttributed>();
            instances.put(this.getClass(), sibs);
        }
        if (globalAuth != null && this != globalAuth) {
            sibs.add(this);
        }
        if (globalAuth == null) {
            this.localAuth = this;
        } else {
            this.localAuth = globalAuth;
            globalAuth.registerChild(this);
        }
        this.localStore = new HashMap();
        this.defaultFlags = new HashMap();
        attrs = this.getAttributeNames();
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            String attr = (String)it.next();
            this.defaultFlags.put(attr, Boolean.TRUE);
        }
        this.children = new ArrayList();
        this.pcs = new PropertyChangeSupport(this);
    }

    public static GlobalAttributed getGlobalAuthority() {
        return globalAuth;
    }

    public static void undefineAllAttributes() {
        Set attrs = globalAuth.getAttributeNames();
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            String attr = (String)it.next();
            globalAuth.undefineAttribute(attr);
        }
    }

    public IAttributed getAuthority() {
        return this.localAuth;
    }

    public void setAuthority(IAttributed auth) {
        if (auth == null) {
            throw new IllegalArgumentException("New authority cannot be null!");
        }
        if (!(auth instanceof GlobalAttributed)) {
            throw new IllegalArgumentException("New authority must be an instance of GlobalAttributed!");
        }
        Set localDefinedAttrs = this.definedAttrs(this.getClass());
        Iterator i = localDefinedAttrs.iterator();
        while (i.hasNext()) {
            String attr = (String)i.next();
            if (auth.isDefined(attr)) continue;
            throw new IllegalArgumentException("New authority does not define attribute: \"" + attr + '\"');
        }
        GlobalAttributed oldAuth = this.localAuth;
        oldAuth.unregisterChild(this);
        this.localAuth = (GlobalAttributed)auth;
        this.localAuth.registerChild(this);
        Iterator i2 = localDefinedAttrs.iterator();
        while (i2.hasNext()) {
            String attr = (String)i2.next();
            if (!this.isDefaultValue(attr)) continue;
            this.firePropertyChange(attr, oldAuth.getAttribute(attr), auth.getAttribute(attr));
        }
    }

    public void defineAttribute(String attr, Class type, Object defaultValue) {
        if (attr == null) {
            throw new IllegalArgumentException("Cannot define an attribute with null identifier!");
        }
        if (type == null) {
            throw new IllegalArgumentException("Cannot define an attribute with null type!");
        }
        if (this.isDefined(attr)) {
            throw new IllegalArgumentException("Cannot define the same attribute on the same host class more than once!");
        }
        if (typeRegistry.containsKey(attr)) {
            Class curType = this.valueType(attr);
            if (!curType.equals(type)) {
                throw new IllegalArgumentException("New attribute value type is inconsistent with current definition! current: " + curType + ", new: " + type);
            }
            Object curDefault = globalAuth.getAttribute(attr);
            if (curDefault == null && defaultValue != null || curDefault != null && !curDefault.equals(defaultValue)) {
                throw new IllegalArgumentException("New attribute default value is inconsistent with current definition! current: " + curDefault + ", new: " + defaultValue);
            }
            if (!this.isCorrectType(attr, defaultValue)) {
                throw new IllegalArgumentException("Default value for \"" + attr + "\" has incorrect type: " + defaultValue.getClass() + ", expected: " + this.getAttributeType(attr));
            }
            int oldCount = (Integer)hostCounts.remove(attr);
            hostCounts.put(attr, new Integer(oldCount + 1));
        } else {
            if (!type.isAssignableFrom(defaultValue.getClass())) {
                throw new IllegalArgumentException("Default value for \"" + attr + "\" has inconsistent type: " + defaultValue.getClass() + ", expected: " + type);
            }
            typeRegistry.put(attr, type);
            hostCounts.put(attr, new Integer(1));
            GlobalAttributed.globalAuth.defaultFlags.put(attr, Boolean.FALSE);
        }
        this.addToDefinedAttrs(attr);
        Set sibs = (Set)instances.get(this.getClass());
        Iterator it = sibs.iterator();
        while (it.hasNext()) {
            GlobalAttributed sib = (GlobalAttributed)it.next();
            sib.defaultFlags.put(attr, Boolean.TRUE);
        }
        globalAuth.setAttribute(attr, defaultValue);
    }

    public void undefineAttribute(String attr) {
        if (attr == null) {
            return;
        }
        Set attrs = this.definedAttrs(this.getClass());
        attrs.remove(attr);
        Set sibs = (Set)instances.get(this.getClass());
        Iterator sibIt = sibs.iterator();
        while (sibIt.hasNext()) {
            GlobalAttributed sib = (GlobalAttributed)sibIt.next();
            sib.clearValue(attr);
            sib.removeAllListeners(attr);
        }
        int hostCount = (Integer)hostCounts.remove(attr);
        if (hostCount == 1) {
            typeRegistry.remove(attr);
        } else {
            hostCounts.put(attr, new Integer(hostCount - 1));
        }
    }

    public boolean isDefined(String attr) {
        return this.definedAttrs(this.getClass()).contains(attr);
    }

    public Class getAttributeType(String attr) {
        if (attr == null) {
            throw new IllegalArgumentException("Cannot retrieve type information for a null attribute!");
        }
        if (this.isDefined(attr)) {
            return this.valueType(attr);
        }
        return null;
    }

    public Set getAttributeNames() {
        return new HashSet(this.definedAttrs(this.getClass()));
    }

    public boolean isDefaultValue(String attr) {
        if (attr == null) {
            throw new IllegalArgumentException("Cannot check value for a null attribute!");
        }
        if (this.isDefined(attr)) {
            Boolean def = (Boolean)this.defaultFlags.get(attr);
            return def;
        }
        throw new IllegalArgumentException("Cannot check value for an undefined attribute!");
    }

    public Object getAttribute(String attr) {
        if (attr == null || !this.isDefined(attr)) {
            throw new IllegalArgumentException("Attribute not defined: \"" + attr + '\"');
        }
        Boolean def = (Boolean)this.defaultFlags.get(attr);
        if (def.booleanValue()) {
            return this.localAuth.getAttribute(attr);
        }
        Object val = this.localStore.get(attr);
        if (val == null || this.isCorrectType(attr, val)) {
            return val;
        }
        throw new IllegalStateException("Stored attribute value for \"" + attr + "\" has incorrect type: " + val.getClass() + ", expected: " + this.getAttributeType(attr));
    }

    public void setAttribute(String attr, Object value) {
        this.changeAttribute(attr, value, false);
    }

    public void setAttributeToDefault(String attr) {
        this.changeAttribute(attr, null, true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add null listener.");
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == null || !this.isDefined(propertyName)) {
            throw new IllegalArgumentException("Attribute not defined: \"" + propertyName + '\"');
        }
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add null listener.");
        }
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot remove null listener.");
        }
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (propertyName == null || !this.isDefined(propertyName)) {
            throw new IllegalArgumentException("Attribute not defined: \"" + propertyName + '\"');
        }
        if (listener == null) {
            throw new IllegalArgumentException("Cannot remove null listener.");
        }
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void removeAllListeners() {
        PropertyChangeListener[] pcls = this.pcs.getPropertyChangeListeners();
        for (int i = 0; i < pcls.length; ++i) {
            if (pcls[i] instanceof PropertyChangeListenerProxy) continue;
            this.pcs.removePropertyChangeListener(pcls[i]);
        }
    }

    public void removeAllListeners(String attr) {
        PropertyChangeListener[] pcls = this.pcs.getPropertyChangeListeners(attr);
        for (int i = 0; i < pcls.length; ++i) {
            this.pcs.removePropertyChangeListener(attr, pcls[i]);
        }
    }

    public boolean hasListeners(String propertyName) {
        if (propertyName == null || !this.isDefined(propertyName)) {
            throw new IllegalArgumentException("Attribute not defined: \"" + propertyName + '\"');
        }
        return this.pcs.hasListeners(propertyName);
    }

    boolean isCorrectType(String attr, Object val) {
        if (val == null) {
            return false;
        }
        return this.valueType(attr).isAssignableFrom(val.getClass());
    }

    void addToDefinedAttrs(String attr) {
        HashSet<String> attrs = (HashSet<String>)definedAttrs.get(this.getClass());
        if (attrs == null) {
            attrs = new HashSet<String>();
            attrs.add(attr);
            definedAttrs.put(this.getClass(), attrs);
        } else {
            attrs.add(attr);
        }
    }

    void clearValue(String attr) {
        this.localStore.remove(attr);
        this.defaultFlags.remove(attr);
    }

    void changeAttribute(String attr, Object value, boolean defaultVal) {
        Object oldVal;
        if (attr == null || !this.isDefined(attr)) {
            throw new IllegalArgumentException("Attribute not defined: \"" + attr + '\"');
        }
        if (value == null || this.isCorrectType(attr, value)) {
            Boolean def = (Boolean)this.defaultFlags.get(attr);
            oldVal = def != false ? this.localAuth.getAttribute(attr) : this.localStore.get(attr);
            if (defaultVal) {
                this.defaultFlags.put(attr, Boolean.TRUE);
                this.localStore.remove(attr);
                value = this.localAuth.getAttribute(attr);
            } else {
                this.defaultFlags.put(attr, Boolean.FALSE);
                this.localStore.put(attr, value);
            }
        } else {
            throw new IllegalArgumentException("Attribute value for \"" + attr + "\" has incorrect type: " + value.getClass() + ", expected: " + this.getAttributeType(attr));
        }
        this.firePropertyChange(attr, oldVal, value);
    }

    Set definedAttrs(Class host) {
        HashSet attrs = (HashSet)definedAttrs.get(host);
        if (attrs == null) {
            System.err.println("Violation of GlobalAttributed invariants: !definedAttrs.contains(" + host + ")");
            attrs = new HashSet();
        }
        return attrs;
    }

    Class valueType(String attr) {
        return (Class)typeRegistry.get(attr);
    }

    void registerChild(GlobalAttributed child) {
        this.children.add(child);
    }

    void unregisterChild(GlobalAttributed child) {
        this.children.remove(child);
    }

    void firePropertyChange(String attr, Object oldVal, Object newVal) {
        this.enqueuePropertyChanges(attr, oldVal, newVal);
        ListIterator it = eventQ.listIterator();
        while (it.hasNext()) {
            GlobalAttributed target = (GlobalAttributed)it.next();
            it.remove();
            PropertyChangeEvent pce = (PropertyChangeEvent)it.next();
            it.remove();
            target.pcs.firePropertyChange(pce);
        }
    }

    void enqueuePropertyChanges(String attr, Object oldVal, Object newVal) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, attr, oldVal, newVal);
        eventQ.addLast((Object)this);
        eventQ.addLast((Object)pce);
        for (int i = 0; i < this.children.size(); ++i) {
            GlobalAttributed child = (GlobalAttributed)this.children.get(i);
            if (!child.isDefined(attr) || !child.isDefaultValue(attr)) continue;
            child.enqueuePropertyChanges(attr, oldVal, newVal);
        }
    }

    public String toString() {
        Class<?> c = this.getClass();
        String out = c.getName();
        return out + ' ' + this.attrsToString();
    }

    String attrsToString() {
        String out = "[";
        Set attrs = this.getAttributeNames();
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            String attr = (String)it.next();
            out = out + attr + (this.isDefaultValue(attr) ? "*: " : ": ") + this.getAttribute(attr) + ", ";
        }
        if (out.length() > 1) {
            out = out.substring(0, out.length() - 2);
        }
        out = out + "]";
        return out;
    }

    private static final class GlobalAuthority
    extends GlobalAttributed {
        public static final GlobalAuthority ONLY = new GlobalAuthority();

        private GlobalAuthority() {
        }

        public void setAuthority(IAttributed auth) {
            throw new UnsupportedOperationException("Cannot change the local authority for the global authority singleton!");
        }

        public void defineAttribute(String attr, Class type, Object defaultValue) {
            throw new UnsupportedOperationException("Cannot define an attribute on the global authority!");
        }

        public void undefineAttribute(String attr) {
            typeRegistry.remove(attr);
            hostCounts.remove(attr);
            Iterator it = definedAttrs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Class host = (Class)entry.getKey();
                Set attrs = (Set)entry.getValue();
                attrs.remove(attr);
                HashSet sibs = (HashSet)instances.get(host);
                if (sibs == null) {
                    System.err.println("Violation of GlobalAttributed invariants: !instances.contains(" + host + ")");
                    sibs = new HashSet();
                    instances.put(host, sibs);
                }
                Iterator sibIt = sibs.iterator();
                while (sibIt.hasNext()) {
                    GlobalAttributed sib = (GlobalAttributed)sibIt.next();
                    sib.clearValue(attr);
                    sib.removeAllListeners(attr);
                }
            }
        }

        public boolean isDefined(String attr) {
            return typeRegistry.containsKey(attr);
        }

        public Set getAttributeNames() {
            return new HashSet(typeRegistry.keySet());
        }

        public void setAttributeToDefault(String attr) {
            throw new UnsupportedOperationException("Cannot set an attribute to default value on the global authority!");
        }

        public String toString() {
            return "GlobalAttributed.GlobalAuthority";
        }
    }
}

