/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ErrorDialog
extends WindowUtil.SimpleDialog {
    private Exception exception;
    private String description;
    private StyledText detailTextField;
    private GridData detailLayoutData;
    private boolean detailVisible;
    private Button detailButton;
    private Button okButton;
    private GridData okButtonLayoutData;
    private Image errorIcon;

    public ErrorDialog(String errorTitle, String errorDescription, Exception e) {
        super(errorTitle, 65536);
        this.exception = e;
        this.description = errorDescription;
    }

    protected void buildDialog() {
        this.detailVisible = false;
        GridLayout dialogLayout = new GridLayout(3, false);
        dialogLayout.horizontalSpacing = 10;
        dialogLayout.verticalSpacing = 0;
        dialogLayout.marginLeft = 12;
        dialogLayout.marginRight = 12;
        dialogLayout.marginTop = 12;
        dialogLayout.marginBottom = 12;
        this.dialog.setLayout((Layout)dialogLayout);
        this.errorIcon = this.dialog.getDisplay().getSystemImage(1);
        Label icon = new Label((Composite)this.dialog, 0);
        icon.setImage(this.errorIcon);
        GridData gridData = new GridData();
        gridData.widthHint = 40;
        gridData.verticalAlignment = 1;
        gridData.verticalIndent = 10;
        icon.setLayoutData((Object)gridData);
        Label descLabel = new Label((Composite)this.dialog, 16448);
        descLabel.setText(this.description);
        gridData = new GridData();
        gridData.verticalAlignment = 2;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalIndent = 10;
        gridData.minimumWidth = 300;
        gridData.widthHint = 400;
        descLabel.setLayoutData((Object)gridData);
        this.detailButton = new Button((Composite)this.dialog, 32);
        this.detailButton.setText("Show Details");
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.horizontalSpan = 3;
        gridData.verticalIndent = 10;
        this.detailButton.setLayoutData((Object)gridData);
        this.detailButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ErrorDialog.this.toggleDetail();
            }
        });
        this.detailTextField = new StyledText((Composite)this.dialog, 778);
        this.detailLayoutData = new GridData();
        this.detailLayoutData.verticalAlignment = 4;
        this.detailLayoutData.verticalIndent = 10;
        this.detailLayoutData.horizontalAlignment = 4;
        this.detailLayoutData.horizontalSpan = 3;
        this.detailLayoutData.grabExcessHorizontalSpace = true;
        this.detailLayoutData.heightHint = 0;
        this.detailLayoutData.minimumHeight = 0;
        this.detailLayoutData.widthHint = 400;
        this.detailTextField.setLayoutData((Object)this.detailLayoutData);
        this.detailTextField.setVisible(false);
        this.detailTextField.setText(this.exception.getMessage() + System.getProperty("line.separator") + System.getProperty("line.separator") + ErrorDialog.getStackTraceAsString(this.exception));
        this.detailTextField.setSelection(0, this.detailTextField.getTextLimit());
        this.okButton = new Button((Composite)this.dialog, 8);
        this.okButton.setText("OK");
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ErrorDialog.this.dialog.close();
            }
        });
        this.okButtonLayoutData = new GridData();
        this.okButtonLayoutData.horizontalSpan = 3;
        this.okButtonLayoutData.verticalIndent = 0;
        this.okButtonLayoutData.horizontalAlignment = 3;
        this.okButtonLayoutData.widthHint = 82;
        this.okButton.setLayoutData((Object)this.okButtonLayoutData);
        this.dialog.setDefaultButton(this.okButton);
        this.dialog.pack();
    }

    protected static String getStackTraceAsString(Throwable t) {
        if (t == null) {
            return "";
        }
        String trace = "";
        StackTraceElement[] stack = t.getStackTrace();
        boolean causePrinted = false;
        for (int x = 0; x < stack.length; ++x) {
            if (!causePrinted) {
                trace = trace + "Caused by: " + stack[x].getClassName() + ": " + t.getMessage() + System.getProperty("line.separator");
                causePrinted = true;
            }
            trace = trace + "\tat " + stack[x].toString() + System.getProperty("line.separator");
        }
        return trace + System.getProperty("line.separator") + ErrorDialog.getStackTraceAsString(t.getCause());
    }

    public Button getOK() {
        return this.okButton;
    }

    public void toggleDetail() {
        if (this.detailVisible) {
            this.detailLayoutData.minimumHeight = 0;
            this.detailLayoutData.heightHint = 0;
            this.okButtonLayoutData.verticalIndent = 0;
        } else {
            this.detailLayoutData.minimumHeight = 300;
            this.detailLayoutData.heightHint = 300;
            this.okButtonLayoutData.verticalIndent = 10;
            this.detailTextField.setSelection(0, this.detailTextField.getText().length());
            this.detailTextField.setFocus();
        }
        this.detailVisible = !this.detailVisible;
        this.detailTextField.setVisible(this.detailVisible);
        this.dialog.pack();
        this.dialog.layout();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        RowLayout layout = new RowLayout();
        layout.justify = true;
        layout.pack = true;
        shell.setLayout((Layout)layout);
        shell.setText("Hello, World!");
        Label label = new Label((Composite)shell, 0x1000000);
        label.setText("Hello, world!");
        shell.pack();
        shell.open();
        ErrorDialog dlog = new ErrorDialog("This is a test Error Message", "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Integer vel justo. Curabitur vitae ipsum luctus magna molestie dignissim. Cras a erat. Sed lectus. Aenean enim. In id nibh. Nulla vel massa. Pellentesque vel tellus sed lectus ullamcorper sagittis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Mauris a tortor non ligula congue dictum. Quisque quis ante eget arcu interdum fringilla.", new Exception("nullity"));
        dlog.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

