/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.AUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEditSequence;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class CompoundUndoableEdit
extends AUndoableEdit
implements IUndoableEditSequence {
    protected boolean inProgress = true;
    protected Vector edits = new Vector();
    protected boolean significant = false;
    protected String presentationName;

    public CompoundUndoableEdit(String title, ListenerIdentifier listenerID) {
        super(listenerID);
        this.presentationName = title;
    }

    public boolean addEdit(IUndoableEdit editToAbsorb) {
        if (this.isInProgress()) {
            if (!this.significant) {
                this.significant = editToAbsorb.isSignificant();
            }
            return this.edits.add(editToAbsorb);
        }
        return false;
    }

    public void end() {
        this.inProgress = false;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    protected IUndoableEdit lastEdit() {
        int editCount = this.edits.size();
        if (editCount > 0) {
            return (IUndoableEdit)this.edits.get(editCount - 1);
        }
        return null;
    }

    public String getPresentationName() {
        if (this.presentationName != null) {
            return this.presentationName;
        }
        return super.getPresentationName();
    }

    public String getRedoPresentationName() {
        IUndoableEdit lastAddedEdit = this.lastEdit();
        if (lastAddedEdit != null) {
            return lastAddedEdit.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    public String getUndoPresentationName() {
        IUndoableEdit lastAddedEdit = this.lastEdit();
        if (lastAddedEdit != null) {
            return lastAddedEdit.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    public boolean isSignificant() {
        return this.significant;
    }

    public void die() {
        ListIterator editsInReverse = this.edits.listIterator(this.edits.size());
        while (editsInReverse.hasPrevious()) {
            IUndoableEdit edit = (IUndoableEdit)editsInReverse.previous();
            edit.die();
        }
        super.die();
    }

    public boolean canRedo() {
        if (super.canRedo() && !this.isInProgress()) {
            Iterator editsInOrder = this.edits.iterator();
            while (editsInOrder.hasNext()) {
                IUndoableEdit edit = (IUndoableEdit)editsInOrder.next();
                if (edit.canRedo()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void redo() {
        super.redo();
        Iterator editsInOrder = this.edits.iterator();
        while (editsInOrder.hasNext()) {
            IUndoableEdit edit = (IUndoableEdit)editsInOrder.next();
            edit.redo();
        }
    }

    public void undo() {
        super.undo();
        ListIterator editsInReverse = this.edits.listIterator(this.edits.size());
        while (editsInReverse.hasPrevious()) {
            IUndoableEdit edit = (IUndoableEdit)editsInReverse.previous();
            edit.undo();
        }
    }
}

