/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.EmptyIterator;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.IAlerter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Alerter
implements IAlerter {
    protected ArrayList handlers = null;

    public void addHandler(Object observer, Class eventClass, IAlertHandler handler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(new IAlerter.AlertHandlerEntry(observer, eventClass, handler));
    }

    public boolean removeHandler(Class eventClass, IAlertHandler handler) {
        Iterator allHandlers = this.getHandlers();
        while (allHandlers.hasNext()) {
            IAlerter.AlertHandlerEntry entry = (IAlerter.AlertHandlerEntry)allHandlers.next();
            if (entry.eventClass != eventClass || entry.handler != handler) continue;
            allHandlers.remove();
            return true;
        }
        return false;
    }

    public void removeAllHandlers(Object observer) {
        Iterator allHandlers = this.getHandlers();
        while (allHandlers.hasNext()) {
            IAlerter.AlertHandlerEntry entry = (IAlerter.AlertHandlerEntry)allHandlers.next();
            if (entry.observer != observer) continue;
            allHandlers.remove();
        }
    }

    public Iterator getHandlers() {
        if (this.handlers != null) {
            return this.handlers.iterator();
        }
        return new EmptyIterator();
    }

    public Iterator getHandlers(Class eventClass) {
        if (this.handlers != null) {
            ArrayList<IAlerter.AlertHandlerEntry> applicableHandlers = new ArrayList<IAlerter.AlertHandlerEntry>();
            Iterator allHandlers = this.handlers.iterator();
            while (allHandlers.hasNext()) {
                IAlerter.AlertHandlerEntry entry = (IAlerter.AlertHandlerEntry)allHandlers.next();
                if (!entry.eventClass.isAssignableFrom(eventClass)) continue;
                applicableHandlers.add(entry);
            }
            return applicableHandlers.iterator();
        }
        return new EmptyIterator();
    }

    public void raiseAlert(EventObject alert) {
        Iterator handlers = this.getHandlers(alert.getClass());
        while (handlers.hasNext()) {
            IAlerter.AlertHandlerEntry entry = (IAlerter.AlertHandlerEntry)handlers.next();
            entry.handler.handleAlert(alert);
        }
    }

    protected static class AlertHandlerIterator
    implements Iterator {
        protected Class alertClass;
        protected Iterator allHandlers;
        protected IAlerter.AlertHandlerEntry nextEntry;

        public AlertHandlerIterator(Class alertType, Iterator alertAllHandlers) {
            this.alertClass = alertType;
            this.allHandlers = alertAllHandlers;
            this.nextEntry = null;
            this.hasNext();
        }

        public boolean hasNext() {
            if (this.nextEntry == null) {
                while (this.allHandlers.hasNext()) {
                    IAlerter.AlertHandlerEntry entry = (IAlerter.AlertHandlerEntry)this.allHandlers.next();
                    if (!entry.eventClass.isAssignableFrom(this.alertClass)) continue;
                    this.nextEntry = entry;
                    return true;
                }
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.nextEntry != null || this.hasNext()) {
                IAlerter.AlertHandlerEntry returnValue = this.nextEntry;
                this.nextEntry = null;
                return returnValue;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

