/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.util;

import edu.cmu.cs.hcii.cogtool.util.CannotRedoException;
import edu.cmu.cs.hcii.cogtool.util.CannotUndoException;
import edu.cmu.cs.hcii.cogtool.util.IUndoableEdit;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;

public abstract class AUndoableEdit
implements IUndoableEdit {
    protected boolean active = true;
    protected boolean hasBeenDone = true;
    protected ListenerIdentifier lid;

    public AUndoableEdit(ListenerIdentifier listenerID) {
        this.lid = listenerID;
    }

    public ListenerIdentifier getLID() {
        return this.lid;
    }

    public String getPresentationName() {
        return "";
    }

    public String getRedoPresentationName() {
        String description = this.getPresentationName();
        if (description != null && description != "") {
            return L10N.get("REDO", "Redo") + ' ' + description;
        }
        return L10N.get("UNDO.Redo", "Redo");
    }

    public String getUndoPresentationName() {
        String description = this.getPresentationName();
        if (description != null && description != "") {
            return L10N.get("UNDO", "Undo") + ' ' + description;
        }
        return L10N.get("UNDO.Undo", "Undo");
    }

    public boolean isSignificant() {
        return true;
    }

    public void die() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean canRedo() {
        return this.active && !this.hasBeenDone;
    }

    public void redo() {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    public void undo() {
        if (!this.active || !this.hasBeenDone) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }
}

