/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorTransition;
import edu.cmu.cs.hcii.cogtool.uimodel.IFrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.IStructureViewUIModel;
import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.view.IScalableInteractiveFigure;
import edu.cmu.cs.hcii.cogtool.view.ScalableFrameFigure;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class StructureViewUIModel
extends Alerter
implements IStructureViewUIModel {
    protected IStructureViewUIModel.FrameShapeChange frameShapeChangeEvent = new IStructureViewUIModel.FrameShapeChange(this, null);
    protected IAlertHandler shapeChangeHandler = new IAlertHandler(){

        public void handleAlert(EventObject alert) {
            IFrameUIModel.WidgetShapeImageChange chg = (IFrameUIModel.WidgetShapeImageChange)alert;
            IFrameUIModel frameUIModel = (IFrameUIModel)chg.getSource();
            StructureViewUIModel.this.frameShapeChangeEvent.frameFigure = (DesignEditorFrame)StructureViewUIModel.this.installedFrames.get(frameUIModel.getFrame());
            StructureViewUIModel.this.raiseAlert(StructureViewUIModel.this.frameShapeChangeEvent);
        }
    };
    protected IDesign design;
    protected boolean showToolTips;
    protected int sourceRolloverCursor;
    protected Map installedFrames = new HashMap();
    protected ScalableFrameFigure contents;
    protected IStructureViewUIModel.FrameAdd frameAddEvent = new IStructureViewUIModel.FrameAdd(this);
    protected IStructureViewUIModel.FrameRecovery frameRecoveryEvent = new IStructureViewUIModel.FrameRecovery(this);
    protected IStructureViewUIModel.TransitionAddRemove transitionAddRemoveEvent = new IStructureViewUIModel.TransitionAddRemove(this);
    protected IAlertHandler widgetRecoveryHandler = new IAlertHandler(){

        public void handleAlert(EventObject alert) {
            IFrameUIModel.WidgetRecovery evt = (IFrameUIModel.WidgetRecovery)alert;
            if (evt != null) {
                StructureViewUIModel.this.uninstallSourceTransitions(evt.widgetFigure);
            }
        }
    };
    protected IAlertHandler destinationChangeHandler = null;
    protected IAlertHandler actionChangeHandler = null;
    protected static final FigureFilterSearch figureFilter = new FigureFilterSearch(0);
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange;

    public StructureViewUIModel(IDesign model, boolean supportToolTips) {
        this(model, null, null, supportToolTips, 0);
    }

    public StructureViewUIModel(IDesign model, IAlertHandler destinationChgHandler, IAlertHandler actionChgHandler, int srcRolloverCursor) {
        this(model, destinationChgHandler, actionChgHandler, true, srcRolloverCursor);
    }

    public StructureViewUIModel(IDesign model, IAlertHandler destinationChgHandler, IAlertHandler actionChgHandler, boolean supportToolTips, int srcRolloverCursor) {
        this.showToolTips = supportToolTips;
        this.sourceRolloverCursor = srcRolloverCursor;
        this.destinationChangeHandler = destinationChgHandler;
        this.actionChangeHandler = actionChgHandler;
        if (model == null) {
            throw new IllegalArgumentException("Cannot create a StructureViewUIModel with a null IDesign model");
        }
        this.design = model;
        this.setUpContents();
        IAlertHandler designChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign.FrameChange chg = (IDesign.FrameChange)alert;
                if (chg != null) {
                    if (chg.isAdd) {
                        DesignEditorFrame frameFigure = StructureViewUIModel.this.installFrame((IFrame)chg.element);
                        StructureViewUIModel.this.installFrameTransitions((IFrame)chg.element, frameFigure);
                        StructureViewUIModel.this.frameAddEvent.setFrameFigure(frameFigure);
                        StructureViewUIModel.this.raiseAlert(StructureViewUIModel.this.frameAddEvent);
                        StructureViewUIModel.this.contents.repaint();
                    } else {
                        StructureViewUIModel.this.recoverFrame((IFrame)chg.element);
                    }
                }
            }
        };
        this.design.addHandler(this, IDesign.FrameChange.class, designChangeHandler);
        designChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign.FrameSetChange chg = (IDesign.FrameSetChange)alert;
                if (chg != null && chg.isAdd) {
                    int i;
                    for (i = 0; i < chg.frames.length; ++i) {
                        DesignEditorFrame ignore = StructureViewUIModel.this.installFrame(chg.frames[i]);
                    }
                    for (i = 0; i < chg.frames.length; ++i) {
                        StructureViewUIModel.this.installFrameTransitions(chg.frames[i]);
                    }
                }
            }
        };
        this.design.addHandler(this, IDesign.FrameSetChange.class, designChangeHandler);
    }

    protected void setUpContents() {
        this.contents = new ScalableFrameFigure(GraphicsUtil.defaultWidgetColor);
        this.contents.setScale(1.0);
        this.contents.setLayoutManager((LayoutManager)new XYLayout());
        this.installFrames();
        DoubleSize s = this.getPreferredSize();
        this.contents.setSize(PrecisionUtilities.round(s.width), PrecisionUtilities.round(s.height));
    }

    public IScalableInteractiveFigure getContents() {
        return this.contents;
    }

    public DoubleSize getPreferredSize() {
        return this.getPreferredSize(this.contents.getScale());
    }

    public DoubleSize getPreferredSize(double scaleFactor) {
        Rectangle r = this.computeFrameArea();
        return new DoubleSize((double)r.width * scaleFactor, (double)r.height * scaleFactor);
    }

    public Rectangle computeFrameArea() {
        Rectangle r = null;
        Iterator frames = this.installedFrames.values().iterator();
        while (frames.hasNext()) {
            DesignEditorFrame frameFigure = (DesignEditorFrame)frames.next();
            if (r == null) {
                r = new Rectangle(frameFigure.getBounds());
                continue;
            }
            r.union(frameFigure.getBounds());
        }
        return r != null ? r : new Rectangle(0, 0, 0, 0);
    }

    public IFigure getFigureAtXY(int x, int y, int filter) {
        figureFilter.setFilter(filter);
        return this.contents.findFigureAt(x, y, figureFilter);
    }

    public DesignEditorFrame getFrameAtXY(int x, int y) {
        return (DesignEditorFrame)this.getFigureAtXY(x, y, 4);
    }

    public IGraphicalSource getSourceAtXY(int x, int y) {
        return (IGraphicalSource)this.getFigureAtXY(x, y, 5);
    }

    public Iterator getAllFrameFigures() {
        return this.installedFrames.values().iterator();
    }

    public DesignEditorFrame getFrameFigure(IFrame frame) {
        return (DesignEditorFrame)this.installedFrames.get(frame);
    }

    public void dispose() {
        this.design.removeAllHandlers(this);
        Iterator frames = this.design.getFrames().iterator();
        while (frames.hasNext()) {
            IFrame frame = (IFrame)frames.next();
            this.recoverFrame(frame);
        }
    }

    public double getZoom() {
        return this.contents.getScale();
    }

    public void setZoom(double scale) {
        this.contents.setScale(scale);
    }

    protected void recoverFrame(IFrame frame) {
        DesignEditorFrame frameFigure = (DesignEditorFrame)this.installedFrames.remove(frame);
        if (frameFigure != null) {
            this.frameRecoveryEvent.setFrameFigure(frameFigure);
            this.raiseAlert(this.frameRecoveryEvent);
            Iterator sourceFigures = frameFigure.getSourceFigureIterator();
            while (sourceFigures.hasNext()) {
                IGraphicalSource sourceFigure = (IGraphicalSource)sourceFigures.next();
                this.uninstallSourceTransitions(sourceFigure);
            }
        } else {
            throw new IllegalStateException("No DesignEditorFrame to recover for the given IFrame.");
        }
        this.contents.remove((IFigure)frameFigure);
        frameFigure.dispose();
    }

    protected DesignEditorFrame installFrame(IFrame frame) {
        final DesignEditorFrame frameFig = new DesignEditorFrame(frame, this.showToolTips, this.sourceRolloverCursor);
        frameFig.addWidgetShapeChangeHandler(this.shapeChangeHandler);
        frameFig.addWidgetRecoveryHandler(this.widgetRecoveryHandler);
        frameFig.addOriginChangeHandler(new OriginChangeHandler(frameFig));
        final IAlertHandler transitionHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                ITransitionSource.TransitionChange chg = (ITransitionSource.TransitionChange)alert;
                if (chg != null) {
                    IGraphicalSource sourceFigure = frameFig.getSourceFigure((ITransitionSource)alert.getSource());
                    if (chg.isAdd) {
                        StructureViewUIModel.this.installSourceTransition((ITransition)chg.element, sourceFigure);
                    } else {
                        StructureViewUIModel.this.uninstallSourceTransition((ITransition)chg.element, sourceFigure);
                    }
                }
            }
        };
        frameFig.addTransitionChangeHandler(transitionHandler);
        IAlertHandler widgetHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IFrame.WidgetChange chg = (IFrame.WidgetChange)alert;
                if (chg != null) {
                    if (chg.action == 1) {
                        chg.widget.removeHandler(class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange == null ? (class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange = StructureViewUIModel.class$("edu.cmu.cs.hcii.cogtool.model.ITransitionSource$TransitionChange")) : class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange, transitionHandler);
                    } else if (chg.action == 0) {
                        StructureViewUIModel.this.installSourceTransitions(frameFig, chg.widget);
                        chg.widget.addHandler(frameFig, class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange == null ? (class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange = StructureViewUIModel.class$("edu.cmu.cs.hcii.cogtool.model.ITransitionSource$TransitionChange")) : class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange, transitionHandler);
                    }
                    StructureViewUIModel.this.contents.repaint();
                }
            }
        };
        frameFig.addWidgetChangeHandler(widgetHandler);
        this.installedFrames.put(frame, frameFig);
        this.contents.add((IFigure)frameFig);
        return frameFig;
    }

    protected void installSourceTransition(final ITransition transition, IGraphicalSource sourceFigure) {
        DesignEditorFrame targetFigure = this.getFrameFigure(transition.getDestination());
        final DesignEditorTransition transitionFigure = new DesignEditorTransition(transition, sourceFigure, targetFigure, this.showToolTips);
        IAlertHandler localDestChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                DesignEditorFrame newTargetFigure = (DesignEditorFrame)StructureViewUIModel.this.installedFrames.get(transition.getDestination());
                if (newTargetFigure != null) {
                    transitionFigure.changeTarget(newTargetFigure);
                }
                if (StructureViewUIModel.this.destinationChangeHandler != null) {
                    StructureViewUIModel.this.destinationChangeHandler.handleAlert(alert);
                }
            }
        };
        transitionFigure.addDestinationChangeHandler(localDestChangeHandler);
        if (this.actionChangeHandler != null) {
            transitionFigure.addActionChangeHandler(this.actionChangeHandler);
        }
        this.contents.add((IFigure)transitionFigure);
        sourceFigure.addTransition(transition, (IFigure)transitionFigure);
        this.transitionAddRemoveEvent.setTransitionFigure(transitionFigure, true);
        this.raiseAlert(this.transitionAddRemoveEvent);
    }

    protected void installSourceTransitions(DesignEditorFrame srcFrameFigure, ITransitionSource source) {
        IGraphicalSource sourceFigure = srcFrameFigure.getSourceFigure(source);
        Iterator transitions = source.getTransitions().values().iterator();
        while (transitions.hasNext()) {
            ITransition transition = (ITransition)transitions.next();
            this.installSourceTransition(transition, sourceFigure);
        }
    }

    protected void recoverTransition(DesignEditorTransition transitionFig) {
        this.transitionAddRemoveEvent.setTransitionFigure(transitionFig, false);
        this.raiseAlert(this.transitionAddRemoveEvent);
        this.contents.remove((IFigure)transitionFig);
        transitionFig.dispose();
    }

    protected void uninstallSourceTransition(ITransition transition, IGraphicalSource sourceFigure) {
        DesignEditorTransition transitionFigure = (DesignEditorTransition)sourceFigure.removeTransition(transition);
        this.recoverTransition(transitionFigure);
    }

    protected void uninstallWidgetTransitions(DesignEditorFrame srcFrameFigure, IWidget widget) {
        IGraphicalWidget sourceFigure = srcFrameFigure.getWidgetFigure(widget);
        this.uninstallSourceTransitions(sourceFigure);
    }

    protected void uninstallSourceTransitions(IGraphicalSource sourceFigure) {
        Iterator transitionFigures = sourceFigure.getTransitionsIterator();
        while (transitionFigures.hasNext()) {
            DesignEditorTransition transitionFigure = (DesignEditorTransition)((Object)transitionFigures.next());
            this.recoverTransition(transitionFigure);
            transitionFigures.remove();
        }
    }

    protected void installFrameTransitions(IFrame frame) {
        DesignEditorFrame sourceFrame = (DesignEditorFrame)this.installedFrames.get(frame);
        this.installFrameTransitions(frame, sourceFrame);
    }

    protected void installFrameTransitions(IFrame frame, DesignEditorFrame sourceFrame) {
        Iterator widgets = frame.getWidgets().iterator();
        while (widgets.hasNext()) {
            IWidget widget = (IWidget)widgets.next();
            this.installSourceTransitions(sourceFrame, widget);
        }
        Iterator devices = frame.getInputDevices().iterator();
        while (devices.hasNext()) {
            IInputDevice device = (IInputDevice)devices.next();
            this.installSourceTransitions(sourceFrame, device);
        }
    }

    protected void installFrames() {
        IFrame frame;
        Iterator frames = this.design.getFrames().iterator();
        while (frames.hasNext()) {
            frame = (IFrame)frames.next();
            DesignEditorFrame designEditorFrame = this.installFrame(frame);
        }
        frames = this.design.getFrames().iterator();
        while (frames.hasNext()) {
            frame = (IFrame)frames.next();
            this.installFrameTransitions(frame);
        }
    }

    protected static class FigureFilterSearch
    implements TreeSearch {
        protected int filter;

        public FigureFilterSearch(int figureFilter) {
            this.filter = figureFilter;
        }

        public void setFilter(int newFigureFilter) {
            this.filter = newFigureFilter;
        }

        protected boolean canBeTransitionSource(IFigure figure) {
            if (figure instanceof IGraphicalSource) {
                IGraphicalWidget gw;
                IWidget w;
                return !(figure instanceof IGraphicalWidget) || (w = (gw = (IGraphicalWidget)figure).getWidgetModel()).getWidgetType() != WidgetType.Noninteractive;
            }
            return false;
        }

        public boolean accept(IFigure figure) {
            switch (this.filter) {
                case 1: {
                    return figure instanceof DesignEditorFrame || figure instanceof DesignEditorFrame.FrameLabel;
                }
                case 2: {
                    return figure instanceof DesignEditorFrame || this.canBeTransitionSource(figure) || figure instanceof DesignEditorTransition;
                }
                case 3: {
                    return figure instanceof DesignEditorFrame || this.canBeTransitionSource(figure);
                }
                case 6: {
                    return figure instanceof DesignEditorFrame || figure instanceof DesignEditorTransition;
                }
                case 4: {
                    return figure instanceof DesignEditorFrame;
                }
                case 5: {
                    return this.canBeTransitionSource(figure);
                }
            }
            return true;
        }

        public boolean prune(IFigure figure) {
            return false;
        }
    }

    public class OriginChangeHandler
    extends IStructureViewUIModel.FrameShapeChange
    implements IAlertHandler {
        public OriginChangeHandler(DesignEditorFrame figure) {
            super(StructureViewUIModel.this, figure);
        }

        public void handleAlert(EventObject alert) {
            IFrame frame;
            IFrame.OriginChange chg = (IFrame.OriginChange)alert;
            if (chg != null && (frame = (IFrame)chg.getSource()) != null) {
                DoublePoint origin = frame.getFrameOrigin();
                Point localOrigin = PrecisionUtilities.getDraw2DPoint(origin);
                this.frameFigure.setLocation(localOrigin);
                StructureViewUIModel.this.raiseAlert(this);
            }
        }
    }
}

