/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.ActionScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ILookAtScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.model.TextActionSegment;
import edu.cmu.cs.hcii.cogtool.uimodel.DefaultUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.view.SWTListMultiColumn;
import org.eclipse.swt.graphics.Color;

public class ScriptUIModel
extends DefaultUIModel
implements SWTListMultiColumn.MultiColRowPropertyDisplay {
    protected static final Color autoInsertedScriptStepColor = new Color(null, 255, 255, 204);
    protected static final Color invalidScriptStepColor = new Color(null, 255, 0, 0);
    protected IScript script;
    protected ITask task;
    protected IDesign design;

    public ScriptUIModel(IScript modelScript, ITask scriptTask, IDesign scriptDesign, IProject scriptProject) {
        super(scriptProject);
        if (modelScript == null) {
            throw new IllegalArgumentException("Cannot create a SEDemoUIModel with a null IScript");
        }
        this.script = modelScript;
        this.task = scriptTask;
        this.design = scriptDesign;
    }

    public String getColumnText(Object o) {
        return "Multi Column Data Only";
    }

    public String[] getMultiColumnText(Object o) {
        if (o instanceof TextActionSegment) {
            TextActionSegment tas = (TextActionSegment)o;
            String segmentDisplay = KeyDisplayUtil.convertActionToDisplay(tas.getStepLocalizedString());
            return new String[]{tas.getCurrentFrame().getName(), segmentDisplay, tas.getStepFocus().getName()};
        }
        if (o instanceof ActionScriptStep) {
            ActionScriptStep ss = (ActionScriptStep)o;
            return new String[]{ss.getCurrentFrame().getName(), ss.getStepLocalizedString(), ss.getWidgetName()};
        }
        if (o instanceof ILookAtScriptStep) {
            ILookAtScriptStep lookAt = (ILookAtScriptStep)o;
            return new String[]{lookAt.getCurrentFrame().getName(), lookAt.getStepLocalizedString(), lookAt.getLookAtTarget().getName()};
        }
        if (o instanceof IScriptStep) {
            IScriptStep ss = (IScriptStep)o;
            return new String[]{ss.getCurrentFrame().getName(), ss.getStepLocalizedString(), ""};
        }
        if (o instanceof IFrame) {
            IFrame endFrame = (IFrame)o;
            String frameName = endFrame.getName();
            return new String[]{frameName, "", ""};
        }
        throw new IllegalArgumentException("Call to GetColumnText was made with an unexpected object");
    }

    public Color getRowColor(Object o) {
        Color c = null;
        if (o instanceof IScriptStep) {
            IScriptStep ss = (IScriptStep)o;
            if (!ss.isValidScriptStep()) {
                return invalidScriptStepColor;
            }
            if (!ss.getInsertedByUser()) {
                return autoInsertedScriptStepColor;
            }
        }
        return c;
    }
}

