/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidgetRenderer;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.RcvrImageException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class SVGRenderer
implements GraphicalWidgetRenderer {
    private static final String TEXT_PLACEHOLDER = "TEXT_PLACEHOLDER";
    protected Dimension size = new Dimension(0, 0);
    protected String svg;
    protected String vector;

    public SVGRenderer(InputStream image) {
        try {
            this.svg = new String(GraphicsUtil.loadImage(image), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RcvrImageException("UTF-8 charset support required", e);
        }
        this.setText("");
    }

    public void paintForeground(Graphics g) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintMidground(Graphics g) {
        g.pushState();
        try {
            int colorVals = GraphicsUtil.getColorFromRGB(g.getBackgroundColor().getRGB());
            int color = GraphicsUtil.getColorWithAlpha(colorVals, g.getAlpha());
            g.setAlpha(255);
            byte[] raster = GraphicsUtil.rasterizeSVG(new StringReader(this.vector), this.size.width, this.size.height, color);
            Image rasterImg = new Image(null, new ImageData((InputStream)new ByteArrayInputStream(raster)));
            try {
                g.drawImage(rasterImg, 0, 0);
            }
            finally {
                rasterImg.dispose();
            }
        }
        finally {
            g.popState();
        }
    }

    public void setText(String text) {
        this.vector = this.svg.replaceAll(TEXT_PLACEHOLDER, text);
    }

    public void setSize(int width, int height) {
        this.size.width = width;
        this.size.height = height;
    }

    public Font getFont() {
        return null;
    }
}

