/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.uimodel.DefaultUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IStructureViewUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.StructureViewUIModel;
import edu.cmu.cs.hcii.cogtool.view.SWTList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class SEFrameChooserUIModel
extends DefaultUIModel
implements SWTList.SingleColRowPropertyDisplay {
    protected IScript script;
    protected ITask task;
    protected IDesign design;
    protected IStructureViewUIModel structureView;

    public SEFrameChooserUIModel(IScript modelScript, ITask scriptTask, IDesign scriptDesign, IProject scriptProject) {
        super(scriptProject);
        if (modelScript == null) {
            throw new IllegalArgumentException("Cannot create a SEFrameChooserUIModel with a null IScript");
        }
        this.script = modelScript;
        this.task = scriptTask;
        this.design = scriptDesign;
        this.structureView = new StructureViewUIModel(this.script.getDesign(), false);
    }

    public ITask getTask() {
        return this.task;
    }

    public IDesign getDesign() {
        return this.design;
    }

    public IStructureViewUIModel getStructureView() {
        return this.structureView;
    }

    public void dispose() {
        this.task.removeAllHandlers(this);
        this.design.removeAllHandlers(this);
        this.structureView.removeAllHandlers(this);
        this.structureView.dispose();
        super.dispose();
    }

    public ArrayList getFramesSorted() {
        Set framesSet = this.script.getDesign().getFrames();
        ArrayList<IFrame> frames = new ArrayList<IFrame>(framesSet.size());
        Iterator iter = framesSet.iterator();
        while (iter.hasNext()) {
            IFrame f = (IFrame)iter.next();
            frames.add(f);
        }
        Collections.sort(frames, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof IFrame && arg1 instanceof IFrame) {
                    IFrame f1 = (IFrame)arg0;
                    IFrame f2 = (IFrame)arg1;
                    return f1.getName().compareTo(f2.getName());
                }
                return arg0 == arg1 ? 0 : 1;
            }
        });
        return frames;
    }

    public String getColumnText(Object o) {
        if (o instanceof IFrame) {
            IFrame f = (IFrame)o;
            return f.getName();
        }
        return "Not a frame";
    }
}

