/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.uimodel.DefaultUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.ScriptUIModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;

public class SEDemoUIModel
extends DefaultUIModel {
    protected static final Color autoInsertedScriptStepColor = new Color(null, 255, 255, 204);
    protected static final Color invalidScriptStepColor = new Color(null, 255, 0, 0);
    protected ScriptUIModel scriptUIModel;
    protected IScript script;
    protected ITask task;
    protected IDesign design;
    protected DesignEditorFrame currentFrame;

    public SEDemoUIModel(IScript modelScript, ITask scriptTask, IDesign scriptDesign, IProject scriptProject) {
        super(scriptProject);
        if (modelScript == null) {
            throw new IllegalArgumentException("Cannot create a SEDemoUIModel with a null IScript");
        }
        this.script = modelScript;
        this.task = scriptTask;
        this.design = scriptDesign;
        this.scriptUIModel = new ScriptUIModel(modelScript, scriptTask, scriptDesign, scriptProject);
        this.currentFrame = new DesignEditorFrame(modelScript.getStartFrame(), 1.0, 21);
        this.currentFrame.setLocation(new Point(0, 0));
    }

    public ScriptUIModel getScriptUIModel() {
        return this.scriptUIModel;
    }

    public DesignEditorFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public IFigure getFigureAtXY(int x, int y, int filter) {
        if (this.currentFrame == null) {
            return null;
        }
        return this.currentFrame.getFigureAtXY(x, y, filter);
    }

    public List getSourcesAtXY(int x, int y) {
        if (this.currentFrame == null) {
            return new ArrayList();
        }
        return this.currentFrame.getSourcesAtXY(x, y);
    }

    public IGraphicalSource getSourceAtXY(int x, int y) {
        return (IGraphicalSource)this.getFigureAtXY(x, y, 1);
    }

    public void dispose() {
        this.currentFrame.dispose();
        this.task.removeAllHandlers(this);
        this.design.removeAllHandlers(this);
        this.script.removeAllHandlers(this);
        super.dispose();
    }

    public boolean setCurrentFrame(IFrame frame) {
        if (frame != this.currentFrame.getFrame()) {
            if (this.currentFrame != null) {
                this.currentFrame.dispose();
            }
            this.currentFrame = new DesignEditorFrame(frame, 1.0, 21);
            return true;
        }
        return false;
    }

    public void setCurrentFrame(IScriptStep sa) {
        this.setCurrentFrame(this.script.getSourceFrame(sa));
    }
}

