/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.AResult;
import edu.cmu.cs.hcii.cogtool.model.GroupNature;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IPredictionResult;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.model.ITaskGroup;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.StandaloneAlgo;
import edu.cmu.cs.hcii.cogtool.uimodel.DefaultUIModel;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import java.text.NumberFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProjectUIModel
extends DefaultUIModel {
    protected static Color selectedTextColor = WindowUtil.globalDisplay.getSystemColor(27);
    protected static Color unselectedTextColor = WindowUtil.globalDisplay.getSystemColor(24);
    protected static Color selectedBackgroundColor = WindowUtil.globalDisplay.getSystemColor(26);
    protected static Color unselectedTaskBackgroundColor = WindowUtil.globalDisplay.getSystemColor(25);
    protected static Color unselectedGroupBackgroundColor = new Color((Device)WindowUtil.globalDisplay, 255, 255, 204);
    protected static final IPredictionAlgo ALGO = StandaloneAlgo.ONLY;
    protected Tree tree;
    protected TreeRowHook rowHook = null;
    protected TreeColumnHook columnHook = null;
    protected Map taskTreeItems = new HashMap();
    protected IAlertHandler taskApplicationResultHandler;
    protected final Listener onDisposeColumn = new Listener(){

        public void handleEvent(Event evt) {
            TreeColumn colToDelete = (TreeColumn)evt.widget;
            IDesign design = (IDesign)colToDelete.getData();
            design.removeAllHandlers(ProjectUIModel.this);
        }
    };
    protected final Listener onDisposeRow = new Listener(){

        public void handleEvent(Event evt) {
            TreeItem rowToDelete = (TreeItem)evt.widget;
            IUndertaking task = (IUndertaking)rowToDelete.getData();
            task.removeAllHandlers(ProjectUIModel.this);
        }
    };

    public ProjectUIModel(IProject proj, Tree projectTree, TreeRowHook rh, TreeColumnHook ch) {
        super(proj);
        this.tree = projectTree;
        this.tree.setBackground(unselectedTaskBackgroundColor);
        this.rowHook = rh;
        this.columnHook = ch;
        this.createTaskApplicationResultChangeHandler();
        this.tree.setData((Object)proj);
        this.installDesigns();
        this.installUndertakings();
        IAlertHandler designChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IProject.DesignChange chg = (IProject.DesignChange)alert;
                if (chg != null) {
                    if (chg.isAdd) {
                        if (chg.atIndex == -1) {
                            TreeColumn ignoreNewColumn = ProjectUIModel.this.addTreeColumn((IDesign)chg.element);
                        } else {
                            TreeColumn ignoreNewColumn = ProjectUIModel.this.addTreeColumn((IDesign)chg.element, chg.atIndex + 1);
                        }
                        ProjectUIModel.this.redisplayAllResults(ProjectUIModel.this.tree.getItems());
                        ProjectUIModel.this.tree.redraw();
                    } else {
                        TreeColumn colToDelete = ProjectUIModel.this.tree.getColumn(chg.atIndex + 1);
                        ProjectUIModel.this.recoverTreeColumn(colToDelete);
                    }
                }
            }
        };
        this.project.addHandler(this, IProject.DesignChange.class, designChangeHandler);
        IAlertHandler taskChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IProject.TaskChange chg = (IProject.TaskChange)alert;
                if (chg != null) {
                    if (chg.isAdd) {
                        TreeItem newRow = chg.atIndex == -1 ? new TreeItem(ProjectUIModel.this.tree, 0) : new TreeItem(ProjectUIModel.this.tree, 0, chg.atIndex);
                        ProjectUIModel.this.populateRow((IUndertaking)chg.element, newRow);
                    } else {
                        TreeItem rowToDelete = ProjectUIModel.this.findChildRow((IUndertaking)chg.element, ProjectUIModel.this.tree.getItems());
                        ProjectUIModel.this.recoverTreeItem(rowToDelete);
                    }
                }
            }
        };
        this.project.addHandler(this, IProject.TaskChange.class, taskChangeHandler);
    }

    public IPredictionAlgo getPredictionAlgo() {
        return ALGO;
    }

    public TreeItem getTaskTreeItem(IUndertaking undertaking) {
        return (TreeItem)this.taskTreeItems.get(undertaking);
    }

    public void dispose() {
        super.dispose();
    }

    protected void installTreeColumn(final TreeColumn designColumn, IDesign design) {
        designColumn.addListener(12, this.onDisposeColumn);
        designColumn.setText(design.getName());
        designColumn.setResizable(true);
        designColumn.setWidth(120);
        IAlertHandler handler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign design = (IDesign)designColumn.getData();
                designColumn.setText(design.getName());
            }
        };
        designColumn.setData((Object)design);
        design.addHandler(this, NameChangeAlert.class, handler);
        design.addHandler(this, ITaskApplication.TaskApplicationResultChange.class, this.taskApplicationResultHandler);
        if (this.columnHook != null) {
            this.columnHook.onColumnCreation(designColumn);
        }
    }

    protected void redisplayAllResults(TreeItem[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            IUndertaking task = (IUndertaking)rows[i].getData();
            if (task.isGroup()) {
                this.redisplayAllResults(rows[i].getItems());
            }
            rows[i].setText(this.getTaskRowStrings(task));
            this.setRowBackground(task, rows[i]);
        }
    }

    protected void redisplayResults(TreeItem row) {
        while (row != null) {
            IUndertaking task = (IUndertaking)row.getData();
            row.setText(this.getTaskRowStrings(task));
            this.setRowBackground(task, row);
            row = row.getParentItem();
        }
    }

    protected void createTaskApplicationResultChangeHandler() {
        this.taskApplicationResultHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign design;
                IUndertaking undertaking;
                ITaskApplication.TaskApplicationResultChange event = (ITaskApplication.TaskApplicationResultChange)alert;
                if (event != null && (undertaking = this.getTask(design = (IDesign)event.getSource(), event.taskApplication)) != null) {
                    TreeItem row = (TreeItem)ProjectUIModel.this.taskTreeItems.get(undertaking);
                    ProjectUIModel.this.redisplayResults(row);
                }
            }

            private IUndertaking getTask(IDesign design, ITaskApplication ta) {
                return this.getTaskRecursively(design, ProjectUIModel.this.project.getUndertakings(), ta);
            }

            private IUndertaking getTaskRecursively(IDesign design, List undertakings, ITaskApplication ta) {
                Iterator iter = undertakings.iterator();
                while (iter.hasNext()) {
                    IUndertaking r;
                    IUndertaking u = (IUndertaking)iter.next();
                    if (ta == ProjectUIModel.this.project.getTaskApplication(u, design)) {
                        return u;
                    }
                    if (!u.isGroup() || (r = this.getTaskRecursively(design, ((ITaskGroup)u).getUndertakings(), ta)) == null) continue;
                    return r;
                }
                return null;
            }
        };
    }

    protected TreeColumn addTreeColumn(IDesign design) {
        TreeColumn newColumn = new TreeColumn(this.tree, 131072);
        this.installTreeColumn(newColumn, design);
        return newColumn;
    }

    protected TreeColumn addTreeColumn(IDesign design, int atIndex) {
        TreeColumn newColumn = new TreeColumn(this.tree, 131072, atIndex);
        this.installTreeColumn(newColumn, design);
        return newColumn;
    }

    protected void installDesigns() {
        TreeColumn designColumn = new TreeColumn(this.tree, 16384);
        designColumn.setText(L10N.get("PM.Tasks", "Tasks"));
        designColumn.setResizable(true);
        designColumn.setWidth(400);
        if (this.columnHook != null) {
            this.columnHook.onColumnCreation(designColumn);
        }
        Iterator designs = this.project.getDesigns().iterator();
        while (designs.hasNext()) {
            IDesign nextDesign = (IDesign)designs.next();
            TreeColumn ignore = this.addTreeColumn(nextDesign);
        }
    }

    protected void addTasks(Iterator children, TreeItem parentRow) {
        while (children.hasNext()) {
            IUndertaking undertaking = (IUndertaking)children.next();
            TreeItem row = new TreeItem(parentRow, 0);
            this.populateRow(undertaking, row);
        }
    }

    protected Color setRowBackground(IUndertaking undertaking, TreeItem row) {
        row.setForeground(unselectedTextColor);
        if (undertaking.isGroup()) {
            row.setBackground(unselectedGroupBackgroundColor);
            return unselectedGroupBackgroundColor;
        }
        row.setBackground(unselectedTaskBackgroundColor);
        return unselectedTaskBackgroundColor;
    }

    protected void populateRow(IUndertaking undertaking, final TreeItem row) {
        this.taskTreeItems.put(undertaking, row);
        row.addListener(12, this.onDisposeRow);
        IAlertHandler handler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IUndertaking task = (IUndertaking)row.getData();
                row.setText(0, task.getName());
                ProjectUIModel.this.setRowBackground(task, row);
            }
        };
        row.setData((Object)undertaking);
        undertaking.addHandler(this, NameChangeAlert.class, handler);
        row.setText(this.getTaskRowStrings(undertaking));
        Color bkg = this.setRowBackground(undertaking, row);
        int numCols = this.tree.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            row.setBackground(i, bkg);
        }
        if (undertaking.isGroup()) {
            ITaskGroup group = (ITaskGroup)undertaking;
            this.setGroupAlertHandlers(group, row);
            this.addTasks(group.getUndertakings().iterator(), row);
        }
        row.setExpanded(true);
        if (this.rowHook != null) {
            this.rowHook.onRowCreation(row);
        }
    }

    protected String[] getTaskRowStrings(IUndertaking undertaking) {
        List projectList = this.project.getDesigns();
        String[] entries = new String[projectList.size() + 1];
        int index = 0;
        entries[index++] = undertaking.getName();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        Iterator iter = projectList.iterator();
        if (undertaking.isGroup()) {
            ITaskGroup group = (ITaskGroup)undertaking;
            while (iter.hasNext()) {
                IDesign d = (IDesign)iter.next();
                double result = this.computeGroup(group, d);
                String formattedResult = result == -1.0 ? "?" : nf.format(result) + " s";
                entries[index++] = group.getNature().toString() + ": " + formattedResult;
            }
        } else {
            IPredictionAlgo alg = ALGO;
            while (iter.hasNext()) {
                IDesign d = (IDesign)iter.next();
                ITaskApplication ta = this.project.getTaskApplication(undertaking, d);
                if (ta == null) {
                    entries[index++] = "";
                    continue;
                }
                if (ta.getScript(alg) == null) {
                    entries[index++] = "";
                    continue;
                }
                if (!ta.isResultCurrent(alg)) {
                    entries[index++] = "?";
                    continue;
                }
                double result = ComputeVisitor.fetchValue(ta, alg);
                entries[index++] = result != -1.0 ? nf.format(result) + " s" : "?";
            }
        }
        return entries;
    }

    protected double computeGroup(ITaskGroup group, IDesign d) {
        List children = group.getUndertakings();
        if (children.size() == 0) {
            return -1.0;
        }
        GroupNature nature = group.getNature();
        boolean validReturnValue = false;
        double returnValue = 0.0;
        double meanDivisor = 0.0;
        Iterator it = children.iterator();
        while (it.hasNext()) {
            IUndertaking child = (IUndertaking)it.next();
            double stepValue = -1.0;
            if (child.isGroup()) {
                stepValue = this.computeGroup((ITaskGroup)child, d);
            } else {
                ITaskApplication ta = this.project.getTaskApplication(child, d);
                if (ta != null) {
                    stepValue = ComputeVisitor.fetchValue(ta, ALGO);
                }
            }
            if (nature == GroupNature.SUM || nature == GroupNature.MEAN) {
                if (stepValue == -1.0) continue;
                returnValue += stepValue;
                meanDivisor += 1.0;
                validReturnValue = true;
                continue;
            }
            if (nature == GroupNature.MIN) {
                if (stepValue == -1.0 || !(stepValue < returnValue) && validReturnValue) continue;
                returnValue = stepValue;
                validReturnValue = true;
                continue;
            }
            if (nature != GroupNature.MAX || !(stepValue > returnValue)) continue;
            returnValue = stepValue;
            validReturnValue = true;
        }
        if (validReturnValue) {
            if (nature == GroupNature.MEAN && meanDivisor != 0.0) {
                returnValue /= meanDivisor;
            }
            return returnValue;
        }
        return -1.0;
    }

    protected void setGroupAlertHandlers(ITaskGroup group, final TreeItem row) {
        IAlertHandler handler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                ITaskGroup.TaskChange chg = (ITaskGroup.TaskChange)alert;
                if (chg != null) {
                    if (chg.isAdd) {
                        TreeItem newRow = chg.atIndex == -1 ? new TreeItem(row, 0) : new TreeItem(row, 0, chg.atIndex);
                        ProjectUIModel.this.populateRow((IUndertaking)chg.element, newRow);
                    } else {
                        TreeItem rowToDelete = ProjectUIModel.this.findChildRow((IUndertaking)chg.element, row.getItems());
                        ProjectUIModel.this.recoverTreeItem(rowToDelete);
                    }
                }
            }
        };
        group.addHandler(this, ITaskGroup.TaskChange.class, handler);
        handler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                ProjectUIModel.this.redisplayResults(row);
            }
        };
        group.addHandler(this, ITaskGroup.NatureChange.class, handler);
    }

    protected void installUndertakings() {
        Iterator undertakings = this.project.getUndertakings().iterator();
        while (undertakings.hasNext()) {
            IUndertaking undertaking = (IUndertaking)undertakings.next();
            TreeItem row = new TreeItem(this.tree, 0);
            this.populateRow(undertaking, row);
        }
    }

    protected TreeItem findChildRow(IUndertaking task, TreeItem[] children) {
        for (int i = 0; i < children.length; ++i) {
            if (children[i].getData() != task) continue;
            return children[i];
        }
        return null;
    }

    protected void recoverTreeColumn(TreeColumn colToDelete) {
        if (this.columnHook != null) {
            this.columnHook.onColumnDeletion(colToDelete);
        }
        colToDelete.dispose();
    }

    protected void recoverTreeItem(TreeItem rowToDelete) {
        if (this.rowHook != null) {
            this.rowHook.onRowDeletion(rowToDelete);
        }
        this.taskTreeItems.remove(rowToDelete.getData());
        rowToDelete.dispose();
    }

    public void recolorTree(int designColumn, boolean nowSelected) {
        TreeColumn col = this.tree.getColumn(designColumn);
        if (nowSelected) {
            col.setText(L10N.get("PM.DesignMark", "\u2022 ") + col.getText());
        } else {
            col.setText(((IDesign)col.getData()).getName());
        }
        this.recolorItems(this.tree.getItems(), designColumn, nowSelected);
    }

    protected void recolorItems(TreeItem[] items, int columnIndex, boolean nowSelected) {
        for (int i = 0; i < items.length; ++i) {
            TreeItem item = items[i];
            IUndertaking undertaking = (IUndertaking)item.getData();
            if (nowSelected) {
                item.setBackground(columnIndex, selectedBackgroundColor);
                item.setForeground(columnIndex, selectedTextColor);
            } else {
                item.setForeground(columnIndex, unselectedTextColor);
                if (undertaking.isGroup()) {
                    item.setBackground(columnIndex, unselectedGroupBackgroundColor);
                } else {
                    item.setBackground(columnIndex, unselectedTaskBackgroundColor);
                }
            }
            this.recolorItems(item.getItems(), columnIndex, nowSelected);
        }
    }

    private static class ComputeVisitor
    extends IPredictionResult.PredictionResultVisitorAdapter {
        public static final ComputeVisitor ONLY = new ComputeVisitor();
        public double resVal = -1.0;

        private ComputeVisitor() {
        }

        public void reset() {
            this.resVal = -1.0;
        }

        public void visit(StandaloneAlgo.StandaloneResult result) {
            if (result != null) {
                this.resVal = result.getTaskTime();
            }
        }

        public static double fetchValue(ITaskApplication ta, IPredictionAlgo alg) {
            if (ta.isResultCurrent(alg)) {
                AResult result = (AResult)ta.getResult(alg);
                ONLY.reset();
                if (result != null) {
                    result.accept(ONLY);
                }
                return ComputeVisitor.ONLY.resVal;
            }
            return -1.0;
        }
    }

    public static interface TreeColumnHook {
        public void onColumnCreation(TreeColumn var1);

        public void onColumnDeletion(TreeColumn var1);
    }

    public static interface TreeRowHook {
        public void onRowCreation(TreeItem var1);

        public void onRowDeletion(TreeItem var1);
    }
}

