/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.ResultStep;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchorBase;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class PERTChartOperatorBar
extends Figure {
    protected double startTime;
    protected double duration;
    protected int row;
    protected int endRow = -1;
    protected Color color = new Color(null, GraphicsUtil.getRGBFromColor(0x999999));
    protected Color selectedColor = new Color(null, GraphicsUtil.getRGBFromColor(52479));
    protected String name;
    protected ResultStep step = null;
    protected boolean selected = false;
    protected List dependencies = new ArrayList();
    protected DependencyAnchor leftAnchor = null;
    protected DependencyAnchor rightAnchor = null;

    public PERTChartOperatorBar(ResultStep step, List resourceLabels) {
        this(step, resourceLabels, 10);
    }

    public PERTChartOperatorBar(ResultStep step, List resourceLabels, int barHeight) {
        this.step = step;
        this.name = step.operation;
        this.startTime = step.startTime;
        this.duration = step.duration;
        this.row = resourceLabels.indexOf(step.resource);
        if (step.targetResource != null) {
            this.endRow = resourceLabels.indexOf(step.targetResource);
        }
        if (step.colorVal > -1) {
            this.color.dispose();
            this.color = new Color(null, GraphicsUtil.getRGBFromColor(step.colorVal));
        }
        this.setBounds(new Rectangle(0, 0, 10, barHeight));
        this.selected = false;
        this.dependencies = new ArrayList();
        this.setBackgroundColor(this.color);
        this.setToolTip((IFigure)new Label(step.toString()));
    }

    public void paint(Graphics g) {
        g.pushState();
        Color drawColor = this.selected ? this.selectedColor : this.color;
        Rectangle bounds = this.getBounds();
        g.setBackgroundColor(drawColor);
        g.setForegroundColor(ColorConstants.black);
        g.fillRectangle(bounds);
        if (!this.selected) {
            g.setForegroundColor(ColorConstants.white);
        }
        String minVisibleName = this.name;
        if (this.name.length() > 3) {
            minVisibleName = this.name.substring(0, 3);
        }
        Dimension textDim = FigureUtilities.getTextExtents((String)minVisibleName, (Font)g.getFont());
        if (textDim.width < bounds.width - 5 && textDim.height < bounds.height - 5) {
            g.drawText(this.name, bounds.x + 2, bounds.y + 2);
        }
        g.setForegroundColor(ColorConstants.black);
        if (!this.isCascade()) {
            g.drawRectangle(new Rectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1));
        }
        g.popState();
    }

    public void dispose() {
        this.color.dispose();
        this.selectedColor.dispose();
        this.getCursor().dispose();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setColor(int newColor) {
        this.color.dispose();
        this.color = new Color(null, GraphicsUtil.getRGBFromColor(newColor));
        this.setBackgroundColor(this.color);
    }

    public void setColorWithMap(Map colorMap) {
        if (colorMap.containsKey(this.step.resource)) {
            this.setColor((Integer)colorMap.get(this.step.resource));
        }
    }

    public void setBounds(Rectangle bnds) {
        super.setBounds(bnds);
        this.fireFigureMoved();
        if (this.leftAnchor != null) {
            this.leftAnchor.updateConnections();
        }
        if (this.rightAnchor != null) {
            this.rightAnchor.updateConnections();
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public ResultStep getStep() {
        return this.step;
    }

    public int getX() {
        return this.bounds.x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public int getRow() {
        return this.row;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public boolean isCascade() {
        return this.endRow > -1;
    }

    public PERTStepDependency addDependency(PERTChartOperatorBar dependentOnBar, ResultStep.ResultStepDependency rsDep) {
        PERTStepDependency dep = new PERTStepDependency(this, dependentOnBar, rsDep);
        this.dependencies.add(dep);
        return dep;
    }

    public ConnectionAnchor connectBarToRight(PERTChartOperatorBar otherBar) {
        this.rightAnchor = new DependencyAnchor(this, otherBar, true);
        return this.rightAnchor;
    }

    public ConnectionAnchor connectBarToLeft(PERTChartOperatorBar otherBar) {
        this.leftAnchor = new DependencyAnchor(this, otherBar, false);
        return this.leftAnchor;
    }

    public void addDependency(PERTStepDependency dep) {
        this.dependencies.add(dep);
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public static class PERTStepDependency
    extends PolylineConnection {
        public PERTChartOperatorBar dependency;
        public PERTChartOperatorBar parent;
        public ResultStep.ResultStepDependency rStepDep;

        public PERTStepDependency(PERTChartOperatorBar parentBar, PERTChartOperatorBar dependencyBar, ResultStep.ResultStepDependency rsDep) {
            this.rStepDep = rsDep;
            this.parent = parentBar;
            this.dependency = dependencyBar;
            this.setSourceAnchor(parentBar.connectBarToLeft(dependencyBar));
            this.setTargetAnchor(dependencyBar.connectBarToRight(parentBar));
            this.setForegroundColor(ColorConstants.black);
        }

        public int getDependencyType() {
            return this.rStepDep.dependencyType;
        }

        public double getDeltaTime() {
            return this.rStepDep.deltaTime;
        }
    }

    public class DependencyAnchor
    extends ConnectionAnchorBase {
        public PERTChartOperatorBar parentBar = null;
        public PERTChartOperatorBar otherBar = null;
        public boolean fromRight = true;

        public DependencyAnchor(PERTChartOperatorBar parent, PERTChartOperatorBar other, boolean connectionOnRight) {
            this.parentBar = parent;
            this.otherBar = other;
            this.fromRight = connectionOnRight;
        }

        protected void updateConnections() {
            this.fireAnchorMoved();
        }

        public Point getLocation(Point arg0) {
            int pointX = this.parentBar.getX();
            int pointY = this.parentBar.getY();
            if (this.parentBar.getWidth() <= 3) {
                pointX += (int)((double)this.parentBar.getWidth() / 2.0);
            } else if (this.fromRight) {
                pointX += this.parentBar.getWidth() - 1;
            }
            if (Math.abs(this.parentBar.getY() - this.otherBar.getY()) < this.parentBar.getHeight()) {
                pointY += this.parentBar.getHeight() / 2;
            } else if (this.parentBar.getY() + this.parentBar.getHeight() < this.otherBar.getY()) {
                pointY += this.parentBar.getHeight();
            }
            return new Point(pointX, pointY);
        }

        public IFigure getOwner() {
            return this.parentBar;
        }

        public Point getReferencePoint() {
            return this.parentBar.getLocation();
        }
    }
}

