/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.uimodel.AImageRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidgetRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class NinePartRenderer
extends AImageRenderer
implements GraphicalWidgetRenderer {
    protected static String NINE_PART_LOCATION = "edu/cmu/cs/hcii/cogtool/resources/widgets/9part/";
    protected Image[] imageParts;

    protected NinePartRenderer(IGraphicalWidget parent, String widgetName, String skinName, int labelStyle, int area) {
        super(parent, widgetName, skinName, labelStyle, area);
        this.imageParts = this.getNinePartImages(skinName, widgetName);
    }

    protected Image[] getNinePartImages(String skin, String name) {
        Image[] iAry = new Image[9];
        for (int i = 0; i < iAry.length; ++i) {
            iAry[i] = NinePartRenderer.getImage(NINE_PART_LOCATION + skin + "/" + name + "/" + i + "." + "png");
        }
        return iAry;
    }

    public void paintForeground(Graphics g) {
        int drawY;
        int drawX;
        int imgHeight;
        int imgWidth;
        g.pushState();
        Rectangle mainClip = this.getBounds();
        g.setClip(mainClip);
        Rectangle subClip = mainClip;
        int topOfImg = this.widgetBounds.x;
        int leftOfImg = this.widgetBounds.y;
        int leftSize = this.imageParts[0].getBounds().width;
        int rightSize = this.imageParts[2].getBounds().width;
        int topSize = this.imageParts[0].getBounds().height;
        int bottomSize = this.imageParts[6].getBounds().height;
        int rightOfCenter = leftOfImg + this.widgetBounds.width - rightSize;
        int leftOfCenter = leftOfImg + leftSize;
        int topOfCenter = topOfImg + topSize;
        int bottomOfCenter = topOfImg + this.widgetBounds.height - bottomSize;
        subClip = mainClip;
        subClip = subClip.getIntersection(new Rectangle(leftOfCenter, topOfCenter, rightOfCenter - leftOfCenter + 2, bottomOfCenter - topOfCenter + 2));
        g.setClip(subClip);
        if (this.imageParts[4] != null) {
            imgWidth = this.imageParts[4].getBounds().width;
            imgHeight = this.imageParts[4].getBounds().height;
            for (drawX = leftOfCenter; drawX < rightOfCenter; drawX += imgWidth) {
                for (drawY = topOfCenter; drawY < bottomOfCenter; drawY += imgHeight) {
                    g.drawImage(this.imageParts[4], drawX, drawY);
                }
            }
        }
        subClip = mainClip;
        subClip = subClip.getIntersection(new Rectangle(leftOfCenter, topOfImg, rightOfCenter - leftOfCenter + 2, this.widgetBounds.height));
        g.setClip(subClip);
        if (this.imageParts[1] != null) {
            imgWidth = this.imageParts[1].getBounds().width;
            for (drawX = leftOfCenter; drawX < rightOfCenter; drawX += imgWidth) {
                g.drawImage(this.imageParts[1], drawX, topOfImg);
            }
        }
        if (this.imageParts[7] != null) {
            imgWidth = this.imageParts[7].getBounds().width;
            for (drawX = leftOfCenter; drawX < rightOfCenter; drawX += imgWidth) {
                g.drawImage(this.imageParts[7], drawX, bottomOfCenter);
            }
        }
        subClip = mainClip;
        subClip = subClip.getIntersection(new Rectangle(leftOfImg, topOfCenter, this.widgetBounds.width, bottomOfCenter - topOfCenter + 2));
        g.setClip(subClip);
        if (this.imageParts[3] != null) {
            imgHeight = this.imageParts[3].getBounds().height;
            for (drawY = topOfCenter; drawY < bottomOfCenter; drawY += imgHeight) {
                g.drawImage(this.imageParts[3], leftOfImg, drawY);
            }
        }
        if (this.imageParts[5] != null) {
            imgHeight = this.imageParts[5].getBounds().height;
            for (drawY = topOfCenter; drawY < bottomOfCenter; drawY += imgHeight) {
                g.drawImage(this.imageParts[5], rightOfCenter, drawY);
            }
        }
        g.setClip(mainClip);
        if (this.imageParts[0] != null) {
            g.drawImage(this.imageParts[0], leftOfImg, topOfImg);
        }
        if (this.imageParts[2] != null) {
            g.drawImage(this.imageParts[2], rightOfCenter, topOfImg);
        }
        if (this.imageParts[6] != null) {
            g.drawImage(this.imageParts[6], leftOfImg, bottomOfCenter);
        }
        if (this.imageParts[8] != null) {
            g.drawImage(this.imageParts[8], rightOfCenter, bottomOfCenter);
        }
        if (this.label != null) {
            this.label.paint(g);
        }
        g.popState();
    }
}

