/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.uimodel.AWireRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidget;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;

public class ItemWireRenderer
extends AWireRenderer {
    protected static final int MARGIN = 5;
    protected int boxX = 1;
    protected int boxY = 1;
    protected int boxWidth;
    protected int boxHeight;
    protected Label titleLabel = null;
    protected boolean rightIconExists = false;

    public ItemWireRenderer(int labelStyle, GraphicalWidget parent) {
        this(labelStyle, parent, false);
    }

    public ItemWireRenderer(int labelStyle, GraphicalWidget parent, boolean rightIcon) {
        super(parent);
        this.rightIconExists = rightIcon;
        if (labelStyle != 0) {
            this.titleLabel = new Label();
            this.titleLabel.setLocation(new Point(6, 6));
            if (labelStyle == 2) {
                this.titleLabel.setTextPlacement(1);
                this.titleLabel.setTextAlignment(1);
            } else if (labelStyle == 3) {
                this.titleLabel.setTextPlacement(4);
                this.titleLabel.setTextAlignment(4);
            }
            this.add((IFigure)this.titleLabel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintForeground(Graphics g) {
        g.pushState();
        try {
            g.drawRectangle(this.boxX, this.boxY, this.boxWidth - 1, this.boxHeight - 1);
            if (this.titleLabel != null) {
                this.titleLabel.paint(g);
            }
            if (this.rightIconExists) {
                this.paintRightIcon(g);
            }
        }
        finally {
            g.popState();
        }
    }

    protected void paintRightIcon(Graphics g) {
    }

    public void setText(String text) {
        if (this.titleLabel != null) {
            this.titleLabel.setText(text);
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.boxWidth = width <= 2 ? 1 : width - 2;
        int n = this.boxHeight = height <= 2 ? 1 : height - 2;
        if (this.titleLabel != null) {
            int useWidth;
            if (width <= 12) {
                useWidth = 1;
            } else {
                useWidth = width - 12;
                if (this.rightIconExists) {
                    useWidth -= height;
                }
            }
            int useHeight = height <= 12 ? 1 : height - 12;
            this.titleLabel.setSize(useWidth, useHeight);
        }
    }
}

