/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.swt.graphics.Font;

public interface GraphicalWidgetRenderer {
    public static final int NO_LABEL = 0;
    public static final int LABEL_CENTER = 1;
    public static final int LABEL_LEFT = 2;
    public static final int LABEL_RIGHT = 3;

    public void paintForeground(Graphics var1);

    public void paintMidground(Graphics var1);

    public void setText(String var1);

    public void setSize(int var1, int var2);

    public Font getFont();

    public static class CompositeRenderer
    implements GraphicalWidgetRenderer {
        protected List renderers;
        protected int labelRenderer;

        public CompositeRenderer(GraphicalWidgetRenderer[] gwRenderers, int labelIndex) {
            this.renderers = Arrays.asList(gwRenderers);
            this.labelRenderer = labelIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintForeground(Graphics g) {
            Iterator i = this.renderers.iterator();
            while (i.hasNext()) {
                g.pushState();
                try {
                    ((GraphicalWidgetRenderer)i.next()).paintForeground(g);
                }
                finally {
                    g.popState();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintMidground(Graphics g) {
            Iterator i = this.renderers.iterator();
            while (i.hasNext()) {
                g.pushState();
                try {
                    ((GraphicalWidgetRenderer)i.next()).paintMidground(g);
                }
                finally {
                    g.popState();
                }
            }
        }

        public void setText(String text) {
            ((GraphicalWidgetRenderer)this.renderers.get(this.labelRenderer)).setText(text);
        }

        public void setSize(int width, int height) {
            Iterator i = this.renderers.iterator();
            while (i.hasNext()) {
                ((GraphicalWidgetRenderer)i.next()).setSize(width, height);
            }
        }

        public Font getFont() {
            return null;
        }
    }
}

