/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.ShapeRoundedRectangle;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public interface GraphicalWidgetClipper {
    public static final GraphicalWidgetClipper OVAL_CLIPPER = new TemplatedClipper(){

        public void fillShape(Graphics g, Rectangle bounds) {
            g.fillOval(bounds);
        }
    };
    public static final GraphicalWidgetClipper TRIVIAL_CLIPPER = new GraphicalWidgetClipper(){

        public Image clip(Image g) {
            return g;
        }

        public void fillShape(Graphics g, Rectangle bounds) {
            g.fillRectangle(bounds);
        }
    };

    public Image clip(Image var1);

    public void fillShape(Graphics var1, Rectangle var2);

    public static final class RoundedClipper
    extends TemplatedClipper {
        protected ShapeRoundedRectangle shape;

        public RoundedClipper(ShapeRoundedRectangle rect) {
            this.shape = rect;
        }

        public void fillShape(Graphics g, Rectangle bounds) {
            g.fillRoundRectangle(bounds, PrecisionUtilities.round(this.shape.getRoundWidth() * (double)bounds.width), PrecisionUtilities.round(this.shape.getRoundHeight() * (double)bounds.height));
        }

        public boolean equals(Object o) {
            return this.shape.equals(o);
        }
    }

    public static abstract class TemplatedClipper
    implements GraphicalWidgetClipper {
        public Image clip(Image g) {
            int i;
            Image mask = new Image(null, g.getBounds());
            GC gc = new GC((Drawable)mask);
            SWTGraphics template = new SWTGraphics(gc);
            Color maskColor = new Color(null, 255, 0, 0);
            gc.setBackground(maskColor);
            this.fillShape((Graphics)template, new Rectangle(g.getBounds().x, g.getBounds().y, g.getBounds().width, g.getBounds().height));
            int transPixel = mask.getImageData().getPixel(0, 0);
            int[] pixels = new int[mask.getBounds().width * mask.getBounds().height];
            mask.getImageData().getPixels(0, 0, pixels.length, pixels, 0);
            ImageData data = g.getImageData();
            byte[] alphas = new byte[pixels.length];
            data.getAlphas(0, 0, alphas.length, alphas, 0);
            if (OSUtils.WINDOWS) {
                for (i = 0; i < pixels.length; ++i) {
                    if (pixels[i] == transPixel) {
                        alphas[i] = 0;
                        continue;
                    }
                    if (data.alpha == -1) continue;
                    alphas[i] = (byte)data.alpha;
                }
            } else {
                for (i = 0; i < pixels.length; ++i) {
                    if (pixels[i] != transPixel) continue;
                    alphas[i] = 0;
                }
            }
            data.alpha = -1;
            data.setAlphas(0, 0, alphas.length, alphas, 0);
            Image clipped = new Image(null, data);
            g.dispose();
            gc.dispose();
            mask.dispose();
            maskColor.dispose();
            return clipped;
        }
    }
}

