/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.IShape;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.ShapeOval;
import edu.cmu.cs.hcii.cogtool.model.ShapeRoundedRectangle;
import edu.cmu.cs.hcii.cogtool.model.SkinType;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.uimodel.AGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.ChoiceWireRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidgetClipper;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidgetRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.ItemWireRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.NinePartRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.ZoomRenderer;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.view.AView;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidParameterException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class GraphicalWidget
extends AGraphicalSource
implements IGraphicalWidget {
    protected IWidget model;
    protected boolean selected;
    protected GraphicalWidgetClipper clipper;
    protected GraphicalWidgetRenderer renderer;
    protected boolean fast = true;
    protected Color widgetColor = new Color(null, GraphicsUtil.getRGBFromColor(GraphicsUtil.defaultWidgetColor));
    protected Color midgroundColor;
    protected Object flagLock = new Object();
    protected boolean cachedMidgroundDirty;
    protected boolean cachedBackgroundDirty;
    private Image cachedMidground = new Image(null, 1, 1);
    protected Image cachedBackground;
    protected int desiredRolloverCursor;

    protected static GraphicalWidgetClipper getClipperForShape(IShape shape) {
        if (shape instanceof ShapeRoundedRectangle) {
            return new GraphicalWidgetClipper.RoundedClipper((ShapeRoundedRectangle)shape);
        }
        if (shape instanceof ShapeOval) {
            return GraphicalWidgetClipper.OVAL_CLIPPER;
        }
        return GraphicalWidgetClipper.TRIVIAL_CLIPPER;
    }

    protected GraphicalWidgetRenderer getRendererForType(WidgetType type, SkinType skin) {
        if (type == WidgetType.Noninteractive || type == WidgetType.Text) {
            return new LabelRenderer();
        }
        if (skin == SkinType.WireFrame) {
            if (type == WidgetType.Button) {
                return new ItemWireRenderer(1, this);
            }
            if (type == WidgetType.Check) {
                return new ChoiceWireRenderer(true, this);
            }
            if (type == WidgetType.Radio) {
                return new ChoiceWireRenderer(false, this);
            }
            if (type == WidgetType.TextBox) {
                return new ItemWireRenderer(0, this);
            }
            if (type == WidgetType.Submenu) {
                return new SubmenuWireRenderer(this);
            }
            if (type == WidgetType.PullDownList) {
                return new PulldownListWireRenderer(this);
            }
            if (type == WidgetType.PullDownItem || type == WidgetType.ListBoxItem || type == WidgetType.Menu || type == WidgetType.MenuItem || type == WidgetType.Graffiti) {
                return new ItemWireRenderer(2, this);
            }
        }
        if (skin == SkinType.None) {
            if (type == WidgetType.TextBox) {
                return new LabelRenderer(0);
            }
            if (type == WidgetType.Button) {
                return new LabelRenderer();
            }
            if (type.equals(WidgetType.Submenu)) {
                return new SubmenuLabelRenderer();
            }
            return new LabelRenderer(2);
        }
        if (type == WidgetType.Button) {
            return new NinePartRenderer(this, type.getKeyName(), skin.getKeyName(), 1, 0);
        }
        if (type == WidgetType.Check) {
            return new NinePartRenderer(this, type.getKeyName(), skin.getKeyName(), 2, 1);
        }
        if (type == WidgetType.Radio) {
            return new ZoomRenderer(this, type.getKeyName(), skin.getKeyName(), 2, 1);
        }
        if (type == WidgetType.TextBox) {
            return new NinePartRenderer(this, type.getKeyName(), skin.getKeyName(), 0, 0);
        }
        if (skin == SkinType.MacOSX && type == WidgetType.PullDownList) {
            ZoomRenderer arrowRenderer = new ZoomRenderer(this, type.getKeyName(), skin.getKeyName(), 2, 2);
            NinePartRenderer leftRenderer = new NinePartRenderer(this, type.getKeyName() + "_left", skin.getKeyName(), 2, 3);
            NinePartRenderer rightRenderer = new NinePartRenderer(this, type.getKeyName() + "_right", skin.getKeyName(), 2, 2);
            GraphicalWidgetRenderer[] rendererArray = new GraphicalWidgetRenderer[]{leftRenderer, rightRenderer, arrowRenderer};
            return new GraphicalWidgetRenderer.CompositeRenderer(rendererArray, 1);
        }
        if (skin == SkinType.WinXP && type == WidgetType.PullDownList) {
            ZoomRenderer arrowRenderer = new ZoomRenderer(this, type.getKeyName(), skin.getKeyName(), 2, 2);
            NinePartRenderer leftRenderer = new NinePartRenderer(this, type.getKeyName() + "_left", skin.getKeyName(), 2, 3);
            NinePartRenderer rightRenderer = new NinePartRenderer(this, type.getKeyName() + "_right", skin.getKeyName(), 2, 2);
            GraphicalWidgetRenderer[] rendererArray = new GraphicalWidgetRenderer[]{leftRenderer, rightRenderer, arrowRenderer};
            return new GraphicalWidgetRenderer.CompositeRenderer(rendererArray, 1);
        }
        if (type == WidgetType.Submenu || type == WidgetType.PullDownList) {
            ZoomRenderer arrowRenderer = new ZoomRenderer(this, type.getKeyName(), skin.getKeyName(), 2, 2);
            NinePartRenderer backgroundRenderer = new NinePartRenderer(this, type.getKeyName(), skin.getKeyName(), 2, 0);
            GraphicalWidgetRenderer[] rendererArray = new GraphicalWidgetRenderer[]{backgroundRenderer, arrowRenderer};
            return new GraphicalWidgetRenderer.CompositeRenderer(rendererArray, 1);
        }
        return new NinePartRenderer(this, type.getKeyName(), skin.getKeyName(), 2, 0);
    }

    protected static int determineProperCursor(IWidget w, int rolloverCursor) {
        if (rolloverCursor == 2 && w.getWidgetType() == WidgetType.Noninteractive) {
            return 0;
        }
        return rolloverCursor;
    }

    public GraphicalWidget(IWidget m, int color, boolean supportToolTip, int rolloverCursor, IGraphicalSource.IDisplayAlpha displayComputer) {
        super(supportToolTip, GraphicalWidget.determineProperCursor(m, rolloverCursor), displayComputer);
        this.midgroundColor = this.widgetColor;
        this.desiredRolloverCursor = rolloverCursor;
        this.setSourceModel(m);
        if (color != GraphicsUtil.defaultWidgetColor) {
            this.setColor(color);
        }
        this.setFastMode(false);
    }

    protected String getTypeDescription() {
        return this.model.getWidgetType().toString();
    }

    public void addChangeHandler(IAlertHandler handler) {
        this.model.addHandler(this, IWidget.WidgetChange.class, handler);
    }

    public void removeChangeHandler(IAlertHandler handler) {
        this.model.removeHandler(IWidget.WidgetChange.class, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(boolean isSelected) {
        if (this.selected != isSelected) {
            this.selected = isSelected;
            if (OSUtils.WINDOWS) {
                Object object = this.flagLock;
                synchronized (object) {
                    this.cachedMidgroundDirty = true;
                }
                this.regenerateCaches();
            }
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    protected void updateAttributes() {
        this.updateType();
        this.updateShape();
        this.updateImage();
    }

    public void setModel(ITransitionSource m) {
        this.model = (IWidget)m;
    }

    public IWidget getWidgetModel() {
        return this.model;
    }

    public ITransitionSource getModel() {
        return this.getWidgetModel();
    }

    public Color getMidgroundColor() {
        return this.midgroundColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateTitle() {
        Object object = this.flagLock;
        synchronized (object) {
            this.cachedMidgroundDirty = true;
        }
        this.renderer.setText(this.getWidgetModel().getTitle());
        this.regenerateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateType() {
        Object object = this.flagLock;
        synchronized (object) {
            this.cachedMidgroundDirty = true;
        }
        IWidget w = this.getWidgetModel();
        this.renderer = this.getRendererForType(w.getWidgetType(), w.getFrame().getDesign().getSkin());
        Dimension widgetExtent = this.getSize();
        this.renderer.setSize(widgetExtent.width, widgetExtent.height);
        this.renderer.setText(w.getTitle());
        this.setCursor(GraphicalWidget.determineProperCursor(w, this.desiredRolloverCursor));
        this.regenerateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateShape() {
        Object object = this.flagLock;
        synchronized (object) {
            this.cachedMidgroundDirty = true;
            this.cachedBackgroundDirty = true;
        }
        Dimension oldSize = this.getSize();
        GraphicalWidgetClipper oldClipper = this.clipper;
        IShape s = this.model.getShape();
        DoubleRectangle shapeBds = s.getBounds();
        Rectangle figBds = PrecisionUtilities.getDraw2DRectangle(shapeBds);
        this.setBounds(figBds);
        if (figBds.width == 0 || figBds.height == 0) {
            if (figBds.width == 0) {
                figBds.width = 1;
            }
            if (figBds.height == 0) {
                figBds.height = 1;
            }
            super.setSize(figBds.width, figBds.height);
        }
        this.renderer.setSize(figBds.width, figBds.height);
        this.setPreferredSize(figBds.width, figBds.height);
        this.clipper = GraphicalWidget.getClipperForShape(s);
        if (this.clipper.equals(oldClipper) && this.getSize().equals((Object)oldSize)) {
            Object object2 = this.flagLock;
            synchronized (object2) {
                this.cachedMidgroundDirty = false;
                this.cachedBackgroundDirty = false;
            }
        }
        this.regenerateCaches(figBds.width, figBds.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateImage() {
        Object object = this.flagLock;
        synchronized (object) {
            this.cachedBackgroundDirty = true;
        }
        if (this.model.getImage() != null) {
            new ImageData((InputStream)new ByteArrayInputStream(this.model.getImage()));
        }
        this.regenerateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dynamicHighlight(boolean highlight) {
        boolean changed = false;
        if (highlight) {
            if (this.midgroundColor != ColorConstants.gray) {
                changed = true;
                this.midgroundColor = ColorConstants.gray;
            }
        } else if (this.midgroundColor != this.widgetColor) {
            changed = true;
            this.midgroundColor = this.widgetColor;
        }
        if (changed) {
            Object object = this.flagLock;
            synchronized (object) {
                this.cachedMidgroundDirty = true;
            }
            this.regenerateCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setColor(int color) {
        Object object = this.flagLock;
        synchronized (object) {
            this.cachedMidgroundDirty = true;
        }
        boolean changeMidground = this.midgroundColor == this.widgetColor;
        this.widgetColor.dispose();
        this.widgetColor = new Color(null, GraphicsUtil.getRGBFromColor(color));
        if (changeMidground) {
            this.midgroundColor = this.widgetColor;
        }
        this.regenerateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSize(int w, int h) {
        Object object = this.flagLock;
        synchronized (object) {
            this.cachedMidgroundDirty = true;
            this.cachedBackgroundDirty = true;
        }
        super.setSize(w, h);
        this.renderer.setSize(w, h);
        this.regenerateCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        g.pushState();
        try {
            boolean shortcut;
            Object object = this.flagLock;
            synchronized (object) {
                shortcut = this.fast || this.cachedMidgroundDirty || this.cachedBackgroundDirty;
            }
            if (shortcut) {
                g.setBackgroundColor(this.midgroundColor);
                g.setAlpha(this.displayAlpha.determineAlpha(this.isSelected()));
                this.clipper.fillShape(g, this.bounds);
            } else {
                object = this;
                synchronized (object) {
                    if (this.cachedBackground != null) {
                        g.drawImage(this.cachedBackground, this.bounds.getLocation());
                    }
                    if (OSUtils.WINDOWS) {
                        g.drawImage(this.cachedMidground, this.bounds.getLocation());
                    } else {
                        g.setAlpha(this.displayAlpha.determineAlpha(this.isSelected()));
                        g.drawImage(this.cachedMidground, this.bounds.getLocation());
                    }
                }
            }
            g.setAlpha(255);
            g.translate(this.bounds.x, this.bounds.y);
            this.renderer.paintForeground(g);
        }
        finally {
            g.popState();
        }
    }

    protected void regenerateCaches() {
        Dimension size = this.getSize();
        this.regenerateCaches(size.width, size.height);
    }

    protected void regenerateCaches(int width, int height) {
        if (!this.fast && AView.isDrawingOK()) {
            boolean needsRepaint = false;
            if (this.cachedMidgroundDirty) {
                needsRepaint = true;
                if (width == 0 || height == 0) {
                    throw new InvalidParameterException("Width or Height on a widget is 0. This should have been prevented in setShape Size");
                }
                Image img = new Image(null, width, height);
                GC gc = new GC((Drawable)img);
                SWTGraphics g = new SWTGraphics(gc);
                g.setAntialias(0);
                g.setBackgroundColor(this.midgroundColor);
                this.renderer.paintMidground((Graphics)g);
                if (OSUtils.WINDOWS) {
                    ImageData id = img.getImageData();
                    id.alpha = this.displayAlpha.determineAlpha(this.isSelected());
                    img.dispose();
                    img = new Image(null, id);
                }
                Image newFG = this.clipper.clip(img);
                this.cachedMidgroundDirty = false;
                this.cachedMidground.dispose();
                this.cachedMidground = newFG;
                g.dispose();
                gc.dispose();
            }
            if (this.cachedBackgroundDirty) {
                needsRepaint = true;
                Image newBG = null;
                byte[] bgImageData = this.model.getImage();
                if (bgImageData != null) {
                    ImageData bg = new ImageData((InputStream)new ByteArrayInputStream(bgImageData));
                    newBG = this.clipper.clip(new Image(null, bg.scaledTo(width, height)));
                }
                this.cachedBackgroundDirty = false;
                if (this.cachedBackground != null) {
                    this.cachedBackground.dispose();
                }
                this.cachedBackground = newBG;
            }
            if (needsRepaint && AView.isDrawingOK()) {
                this.repaint();
            }
        }
    }

    public synchronized void dispose() {
        this.widgetColor.dispose();
        this.cachedMidground.dispose();
        if (this.cachedBackground != null) {
            this.cachedBackground.dispose();
        }
        this.model.removeAllHandlers(this);
        super.dispose();
    }

    public void setFastMode(boolean on) {
        this.fast = on;
        this.regenerateCaches();
    }

    protected static class PulldownListWireRenderer
    extends ItemWireRenderer {
        public PulldownListWireRenderer(GraphicalWidget parent) {
            super(2, parent, true);
        }

        protected void paintRightIcon(Graphics g) {
            Rectangle bds = this.getBounds();
            int x = bds.width - bds.height - 2;
            int y = 4;
            int w = bds.height - 6;
            int h = bds.height - 8;
            if (x < 0) {
                x = 1;
            }
            if (y >= bds.height) {
                y = bds.height;
            }
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
            int[] triangle = new int[]{x, y, x + w, y, x + w / 2, y + h};
            g.drawPolygon(triangle);
        }
    }

    protected static class SubmenuWireRenderer
    extends ItemWireRenderer {
        public SubmenuWireRenderer(GraphicalWidget parent) {
            super(2, parent, true);
        }

        protected void paintRightIcon(Graphics g) {
            Rectangle bds = this.getBounds();
            int x = bds.width - bds.height - 2;
            int y = 4;
            int w = bds.height - 6;
            int h = bds.height - 8;
            if (x < 0) {
                x = 1;
            }
            if (y >= bds.height) {
                y = bds.height;
            }
            if (w <= 0) {
                w = 1;
            }
            if (h <= 0) {
                h = 1;
            }
            int[] triangle = new int[]{x, y, x + w, y + h / 2, x, y + h};
            g.drawPolygon(triangle);
        }
    }

    protected class SubmenuLabelRenderer
    extends LabelRenderer {
        protected static final String SUBMENU_INDICATOR = " >";

        public SubmenuLabelRenderer() {
            super(2);
        }

        public void setText(String text) {
            super.setText(text + SUBMENU_INDICATOR);
        }

        public String getText() {
            String text = super.getText();
            return text.substring(0, text.length() - SUBMENU_INDICATOR.length());
        }
    }

    protected class LabelRenderer
    extends Label
    implements GraphicalWidgetRenderer {
        protected static final String PADDING = " ";

        public LabelRenderer() {
            this(1);
        }

        public LabelRenderer(int labelStyle) {
            if (labelStyle == 0) {
                this.setVisible(false);
            } else if (labelStyle == 2) {
                this.setTextPlacement(1);
                this.setTextAlignment(1);
            } else if (labelStyle == 3) {
                this.setTextPlacement(4);
                this.setTextAlignment(4);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintForeground(Graphics g) {
            if (this.isVisible()) {
                g.pushState();
                try {
                    super.paintFigure(g);
                }
                finally {
                    g.popState();
                }
            }
        }

        public void paintMidground(Graphics g) {
            GraphicalWidget.this.clipper.fillShape(g, this.bounds);
        }

        public void setText(String text) {
            super.setText(PADDING + text);
        }

        public String getText() {
            return super.getText().substring(PADDING.length());
        }

        public IFigure getParent() {
            return GraphicalWidget.this;
        }
    }
}

