/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.uimodel.AGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalDevice;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Image;

public class GraphicalDevice
extends AGraphicalSource
implements IGraphicalDevice {
    protected CogButton button;
    protected IInputDevice model;

    public GraphicalDevice(IInputDevice m, int color, boolean supportToolTip, int rolloverCursor, IGraphicalSource.IDisplayAlpha displayComputer) {
        super(supportToolTip, rolloverCursor, displayComputer);
        this.setSize(new Dimension(80, 20));
        this.setPreferredSize(this.getSize());
        this.setLocation(new Point(0, 0));
        this.setSourceModel(m);
        this.setColor(color);
    }

    protected String getTypeDescription() {
        return this.model.getDeviceType().toString();
    }

    protected void setModel(ITransitionSource m) {
        this.model = (IInputDevice)m;
    }

    public ITransitionSource getModel() {
        return this.getDeviceModel();
    }

    public IInputDevice getDeviceModel() {
        return this.model;
    }

    public void updateTitle() {
        super.updateTitle();
        this.button = new CogButton(this.model.getName());
    }

    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        this.button.paintBorder(g);
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.button.paintChildren(g);
    }

    protected void paintClientArea(Graphics g) {
        super.paintClientArea(g);
        this.button.paintClientArea(g);
    }

    protected void paintFigure(Graphics g) {
        int height;
        int width = this.getSize().width;
        if (width == 0) {
            width = 1;
        }
        if ((height = this.getSize().height) == 0) {
            height = 1;
        }
        this.foreground.setAlpha(0, 0, this.displayAlpha.determineAlpha(false));
        Image scaled = new Image(null, this.foreground.scaledTo(width, height));
        g.drawImage(scaled, this.getLocation().x, this.getLocation().y);
        scaled.dispose();
        super.paintFigure(g);
        this.button.paintFigure(g);
    }

    public void paint(Graphics g) {
        this.button.setSize(this.getSize());
        this.button.setLocation(this.getLocation());
        super.paint(g);
    }

    protected class CogButton
    extends Label {
        public CogButton(String text) {
            super(text);
        }

        public IFigure getParent() {
            return GraphicalDevice.this;
        }

        public void paintBorder(Graphics g) {
            super.paintBorder(g);
        }

        public void paintChildren(Graphics g) {
            super.paintChildren(g);
        }

        public void paintClientArea(Graphics g) {
            super.paintClientArea(g);
        }

        public void paintFigure(Graphics g) {
            super.paintFigure(g);
        }
    }
}

