/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.ACogToolWorkThread;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IMenuHeader;
import edu.cmu.cs.hcii.cogtool.model.IMenuItem;
import edu.cmu.cs.hcii.cogtool.model.IMenuWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidgetGroup;
import edu.cmu.cs.hcii.cogtool.model.Widget;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalMenuHeader;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalMenuItem;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.IFrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuItem;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.ThreadManager;
import edu.cmu.cs.hcii.cogtool.view.IScalableFigure;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.ScalableFrameFigure;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class FrameUIModel
extends Alerter
implements IFrameUIModel,
IGraphicalSource.IDisplayAlpha {
    protected static final FigureFilterSearch figureFilter = new FigureFilterSearch(0);
    protected Map figureList;
    protected boolean showToolTips;
    protected int widgetRolloverCursor;
    protected IFrame frame;
    protected ImageFigure backgroundImage;
    protected ScalableFrameFigure contents;
    protected IFrameUIModel.WidgetRecovery widgetRecoveryEvent = new IFrameUIModel.WidgetRecovery(this);
    protected boolean lazyLoading = false;
    protected boolean isDisposed = false;
    protected int widgetNormalAlpha;
    protected int widgetSelectedAlpha;

    public FrameUIModel(IFrame model, boolean supportToolTips, int srcRolloverCursor, double scale, boolean lazyLoad) {
        this(model, supportToolTips, srcRolloverCursor, scale, lazyLoad, 128, 175);
    }

    public FrameUIModel(IFrame model, boolean supportToolTips, int srcRolloverCursor, double scale, boolean lazyLoad, int normalAlpha, int selectedAlpha) {
        this.lazyLoading = lazyLoad;
        this.widgetNormalAlpha = normalAlpha;
        this.widgetSelectedAlpha = selectedAlpha;
        if (model == null) {
            throw new IllegalArgumentException("Cannot create a FrameUIModel with a null IFrame model");
        }
        this.frame = model;
        this.showToolTips = supportToolTips;
        this.widgetRolloverCursor = srcRolloverCursor;
        this.setUpFrameContents(scale);
        this.addDesignChangeListeners();
        this.addFrameChangeListeners();
    }

    public IFrame getFrame() {
        return this.frame;
    }

    protected void setUpFrameContents(double scale) {
        this.contents = new ScalableFrameFigure(this.frame.getWidgetColor());
        this.contents.setScale(scale);
        this.contents.setLayoutManager((LayoutManager)new XYLayout());
        this.figureList = new HashMap();
        Iterator modelWidgets = this.frame.getWidgets().iterator();
        while (modelWidgets.hasNext()) {
            Widget w = (Widget)modelWidgets.next();
            this.createGraphicalWidget(w);
        }
        this.backgroundImage = new ImageFigure();
        final byte[] bgImg = this.frame.getBackgroundImage();
        if (bgImg != null) {
            if (this.lazyLoading) {
                ACogToolWorkThread imageLoadThread = new ACogToolWorkThread(){
                    protected Image img = null;

                    public void doWork() {
                        this.img = new Image(null, (InputStream)new ByteArrayInputStream(bgImg));
                    }

                    public void doneCallback() {
                        if (FrameUIModel.this.isDisposed) {
                            this.img.dispose();
                        } else {
                            FrameUIModel.this.backgroundImage.setImage(this.img);
                        }
                        if (this.thrownException != null) {
                            this.thrownException.printStackTrace(System.err);
                        }
                    }
                };
                ThreadManager.ONLY.startNewThread(imageLoadThread, 2);
            } else {
                Image img = null;
                if (img == null) {
                    img = new Image(null, (InputStream)new ByteArrayInputStream(bgImg));
                }
                this.backgroundImage.setImage(img);
            }
            this.backgroundImage.setBounds(PrecisionUtilities.getDraw2DRectangle(this.frame.getBackgroundBounds()));
        }
        this.backgroundImage.setAlignment(9);
        DoubleSize s = this.getPreferredSize();
        this.contents.setSize(PrecisionUtilities.round(s.width), PrecisionUtilities.round(s.height));
        this.drawWidgets();
    }

    public IScalableFigure getContents() {
        return this.contents;
    }

    protected void addDesignChangeListeners() {
        IAlertHandler designChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign.WidgetAppearanceChange chg = (IDesign.WidgetAppearanceChange)alert;
                if (chg != null) {
                    Iterator gws = FrameUIModel.this.figureList.values().iterator();
                    while (gws.hasNext()) {
                        IGraphicalWidget gw = (IGraphicalWidget)gws.next();
                        gw.updateType();
                    }
                }
            }
        };
        this.frame.getDesign().addHandler(this, IDesign.WidgetAppearanceChange.class, designChangeHandler);
    }

    protected void addFrameChangeListeners() {
        IAlertHandler frameChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IFrame.WidgetChange chg = (IFrame.WidgetChange)alert;
                if (chg != null) {
                    switch (chg.action) {
                        case 0: {
                            FrameUIModel.this.createGraphicalWidget(chg.widget);
                            FrameUIModel.this.raiseAlert(new IFrameUIModel.WidgetShapeImageChange(FrameUIModel.this, chg.widget));
                            break;
                        }
                        case 1: {
                            FrameUIModel.this.removeWidget(chg.widget);
                            FrameUIModel.this.raiseAlert(new IFrameUIModel.WidgetShapeImageChange(FrameUIModel.this, chg.widget));
                            break;
                        }
                        case 3: {
                            Iterator gws = FrameUIModel.this.figureList.values().iterator();
                            while (gws.hasNext()) {
                                IGraphicalWidget gw = (IGraphicalWidget)gws.next();
                                gw.setColor(FrameUIModel.this.frame.getWidgetColor());
                            }
                            FrameUIModel.this.contents.setWidgetColor(FrameUIModel.this.frame.getWidgetColor());
                        }
                    }
                }
                FrameUIModel.this.drawWidgets();
            }
        };
        this.frame.addHandler(this, IFrame.WidgetChange.class, frameChangeHandler);
        IAlertHandler frameBackgroundChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IFrame.BackgroundImageChange chg = (IFrame.BackgroundImageChange)alert;
                if (chg != null) {
                    byte[] bgImg;
                    if (FrameUIModel.this.backgroundImage.getImage() != null) {
                        FrameUIModel.this.backgroundImage.getImage().dispose();
                    }
                    if ((bgImg = FrameUIModel.this.frame.getBackgroundImage()) != null) {
                        Image img = new Image(null, (InputStream)new ByteArrayInputStream(bgImg));
                        FrameUIModel.this.backgroundImage.setImage(img);
                        org.eclipse.swt.graphics.Rectangle bounds = img.getBounds();
                        FrameUIModel.this.backgroundImage.setSize(bounds.width, bounds.height);
                    } else {
                        FrameUIModel.this.backgroundImage.setImage(null);
                        FrameUIModel.this.backgroundImage.setSize(0, 0);
                    }
                }
                FrameUIModel.this.drawWidgets();
                FrameUIModel.this.raiseAlert(new IFrameUIModel.WidgetShapeImageChange(FrameUIModel.this, null));
            }
        };
        this.frame.addHandler(this, IFrame.BackgroundImageChange.class, frameBackgroundChangeHandler);
    }

    protected void drawWidgets() {
        Object[] figureArray = this.figureList.values().toArray();
        Arrays.sort(figureArray, IGraphicalWidget.GraphicalWidgetLevelComparator.ONLY);
        if (this.backgroundImage != null) {
            this.contents.add((IFigure)this.backgroundImage, new Rectangle(this.backgroundImage.getBounds()), 0);
        }
        List contentChildren = this.contents.getChildren();
        for (int i = 0; i < figureArray.length; ++i) {
            IGraphicalWidget figureItem = (IGraphicalWidget)figureArray[i];
            int index = contentChildren.size();
            if (contentChildren.indexOf(figureItem) != -1) {
                --index;
            }
            DoubleRectangle shapeBounds = figureItem.getWidgetModel().getShape().getBounds();
            this.contents.add(figureItem, PrecisionUtilities.getDraw2DRectangle(shapeBounds), index);
        }
    }

    protected void removeWidget(IWidget w) {
        IGraphicalWidget gw = (IGraphicalWidget)this.figureList.remove(w);
        this.widgetRecoveryEvent.setWidgetFigure(gw);
        this.raiseAlert(this.widgetRecoveryEvent);
        if (gw == null) {
            throw new IllegalArgumentException("Cannot remove a widget which is not in the Figure List");
        }
        this.contents.remove(gw);
        gw.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createGraphicalWidget(IWidget w) {
        GraphicalWidget gw = null;
        if (w instanceof IMenuWidget) {
            if (w instanceof IMenuHeader) {
                gw = new GraphicalMenuHeader((IMenuHeader)w, this.frame.getWidgetColor(), this.showToolTips, this.widgetRolloverCursor, (IGraphicalSource.IDisplayAlpha)this, (IGraphicalWidget.WidgetFigureSupport)this);
            } else {
                if (!(w instanceof IMenuItem)) throw new IllegalStateException("Unknown menu widget type.");
                gw = new GraphicalMenuItem((IMenuItem)w, this.frame.getWidgetColor(), this.showToolTips, this.widgetRolloverCursor, (IGraphicalSource.IDisplayAlpha)this, (IGraphicalWidget.WidgetFigureSupport)this);
                gw.setVisible(false);
            }
        } else {
            gw = new GraphicalWidget(w, this.frame.getWidgetColor(), this.showToolTips, this.widgetRolloverCursor, this);
        }
        this.figureList.put(w, gw);
        gw.addChangeHandler(new WidgetChangeHandler(gw));
    }

    public void addWidgetChangeHandlerToAll(IAlertHandler handler) {
        Iterator widgetFigures = this.figureList.values().iterator();
        while (widgetFigures.hasNext()) {
            IGraphicalWidget gw = (IGraphicalWidget)widgetFigures.next();
            gw.addChangeHandler(handler);
        }
    }

    public void setGraphicalWidgetOrigin(double x, double y, IGraphicalWidget gw) {
        gw.setLocation(new Point(PrecisionUtilities.round(x), PrecisionUtilities.round(y)));
    }

    public void setGraphicalWidgetMove(double diffX, double diffY, IGraphicalWidget gw) {
        Rectangle r = gw.getBounds();
        this.setGraphicalWidgetOrigin((double)r.x + diffX, (double)r.y + diffY, gw);
    }

    public void setGraphicalWidgetBounds(double tempOriginX, double tempOriginY, double tempWidth, double tempHeight, IGraphicalWidget gw) {
        gw.setLocation(new Point(PrecisionUtilities.floor(tempOriginX), PrecisionUtilities.floor(tempOriginY)));
        int w = PrecisionUtilities.ceiling(tempWidth);
        int h = PrecisionUtilities.ceiling(tempHeight);
        gw.setSize(w > 0 ? w : 1, h > 0 ? h : 1);
    }

    public Iterator getFigureListIterator() {
        return this.figureList.values().iterator();
    }

    public IGraphicalWidget getWidgetFigure(IWidget widget) {
        if (widget != null) {
            return (IGraphicalWidget)this.figureList.get(widget);
        }
        return null;
    }

    public double getZoom() {
        return this.contents.getScale();
    }

    public void setZoom(double scale) {
        if (scale != this.getZoom()) {
            this.contents.setScale(scale);
        }
    }

    public DoubleSize getPreferredSize() {
        return this.getPreferredSize(this.contents.getScale());
    }

    public DoubleSize getPreferredSize(double scaleFactor) {
        Rectangle r = this.computeWidgetArea();
        r.union(this.backgroundImage.getBounds());
        return new DoubleSize((double)r.width * scaleFactor, (double)r.height * scaleFactor);
    }

    public Rectangle computeWidgetArea() {
        Rectangle r = null;
        Iterator iter = this.figureList.values().iterator();
        while (iter.hasNext()) {
            IGraphicalWidget gw = (IGraphicalWidget)iter.next();
            if (r == null) {
                r = new Rectangle(gw.getBounds());
                continue;
            }
            r.union(gw.getBounds());
        }
        return r == null ? new Rectangle(0, 0, 0, 0) : r;
    }

    public IGraphicalWidget getPrevInGroup(IGraphicalWidget fromWidgetFig) {
        int widgetIndex;
        IWidget modelWidget = fromWidgetFig.getWidgetModel();
        IWidgetGroup group = modelWidget.getParentGroup();
        if (group != null && (widgetIndex = group.indexOf(modelWidget)) > 0) {
            return this.getWidgetFigure(group.getWidget(widgetIndex - 1));
        }
        return null;
    }

    public IGraphicalWidget getNextInGroup(IGraphicalWidget fromWidgetFig) {
        int widgetIndex;
        IWidget modelWidget = fromWidgetFig.getWidgetModel();
        IWidgetGroup group = modelWidget.getParentGroup();
        if (group != null && (widgetIndex = group.indexOf(modelWidget)) < group.widgetCount() - 1) {
            return this.getWidgetFigure(group.getWidget(widgetIndex + 1));
        }
        return null;
    }

    protected IView getView() {
        return null;
    }

    public void dispose() {
        Image img = this.backgroundImage.getImage();
        if (img != null) {
            img.dispose();
        }
        Iterator gws = this.figureList.values().iterator();
        while (gws.hasNext()) {
            IGraphicalWidget gw = (IGraphicalWidget)gws.next();
            gw.dispose();
        }
        this.contents.dispose();
        this.frame.removeAllHandlers(this);
        this.frame.getDesign().removeAllHandlers(this);
        this.isDisposed = true;
    }

    public IWidget getWidgetAtPoint(int x, int y) {
        IGraphicalWidget gw = (IGraphicalWidget)this.getFigureAtXY(x, y, 1);
        if (gw != null) {
            return gw.getWidgetModel();
        }
        return null;
    }

    public IFigure getFigureAtXY(int x, int y, int filter) {
        figureFilter.setFilter(filter);
        return this.contents.findFigureAt(x, y, figureFilter);
    }

    public int determineAlpha(boolean selected) {
        return selected ? this.widgetSelectedAlpha : this.widgetNormalAlpha;
    }

    public void hideAllMenuItems() {
        IFrameUIModel.WidgetFigureIterator widgetFigures = new IFrameUIModel.WidgetFigureIterator(this);
        while (widgetFigures.hasNext()) {
            Object next = widgetFigures.next();
            if (!(next instanceof IGraphicalMenuItem)) continue;
            ((IGraphicalMenuItem)next).setVisible(false);
        }
    }

    protected static class FigureFilterSearch
    implements TreeSearch {
        protected int filter;

        public FigureFilterSearch(int figureFilter) {
            this.filter = figureFilter;
        }

        public void setFilter(int newFigureFilter) {
            this.filter = newFigureFilter;
        }

        public boolean accept(IFigure figure) {
            switch (this.filter) {
                case 1: {
                    return figure instanceof IGraphicalWidget;
                }
            }
            return true;
        }

        public boolean prune(IFigure figure) {
            return false;
        }
    }

    protected class WidgetChangeHandler
    implements IAlertHandler {
        protected IGraphicalWidget gw;

        public WidgetChangeHandler(IGraphicalWidget wid) {
            this.gw = wid;
        }

        public void handleAlert(EventObject alert) {
            IWidget.WidgetChange evt = (IWidget.WidgetChange)alert;
            switch (evt.getChangeType()) {
                case 4: {
                    this.gw.updateImage();
                    FrameUIModel.this.raiseAlert(new IFrameUIModel.WidgetShapeImageChange(FrameUIModel.this, (IWidget)evt.getSource()));
                    break;
                }
                case 1: {
                    this.gw.updateShape();
                    FrameUIModel.this.raiseAlert(new IFrameUIModel.WidgetShapeImageChange(FrameUIModel.this, (IWidget)evt.getSource()));
                    break;
                }
                case 3: {
                    this.gw.updateTitle();
                    break;
                }
                case 2: {
                    this.gw.updateType();
                    break;
                }
                case 101: {
                    break;
                }
            }
            FrameUIModel.this.drawWidgets();
        }
    }
}

