/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.uimodel.DefaultUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.FrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IFrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;

public class FrameEditorUIModel
extends DefaultUIModel {
    protected IFrame frame;
    protected IDesign design;
    protected IFrameUIModel frameUI;
    protected IAlertHandler widgetChangeHandler;

    public FrameEditorUIModel(IFrame modelFrame, IDesign modelDesign, IProject modelProject, double initialZoom, IAlertHandler widgetChgHandler) {
        super(modelProject);
        if (modelFrame == null) {
            throw new IllegalArgumentException("Cannot create a FrameEditorUIModel with a null IFrame");
        }
        this.frame = modelFrame;
        this.design = modelDesign;
        this.frameUI = new FrameUIModel(this.frame, true, 0, initialZoom, true);
        this.widgetChangeHandler = widgetChgHandler;
        this.frameUI.addWidgetChangeHandlerToAll(this.widgetChangeHandler);
    }

    public IFrame getFrame() {
        return this.frame;
    }

    public IDesign getDesign() {
        return this.design;
    }

    public IFrameUIModel getFrameUI() {
        return this.frameUI;
    }

    public void dispose() {
        this.frameUI.removeAllHandlers(this);
        this.frame.removeAllHandlers(this);
        this.design.removeAllHandlers(this);
        this.frameUI.dispose();
        super.dispose();
    }

    public IGraphicalWidget widgetLocatedAtXY(int x, int y) {
        return (IGraphicalWidget)this.frameUI.getFigureAtXY(x, y, 1);
    }
}

