/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.uimodel.BezierPolylineConnection;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.util.FontUtils;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.view.ResizeThumb;
import java.util.EventObject;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;

public class DesignEditorTransition
extends BezierPolylineConnection {
    protected ITransition transition;
    protected boolean showToolTip;
    protected IGraphicalSource source;
    protected DesignEditorFrame target;
    protected ResizeThumb sourceHandle = null;
    protected ResizeThumb targetHandle = null;

    public DesignEditorTransition(ITransition actionTransition, IGraphicalSource sourceFigure, DesignEditorFrame targetFigure, boolean supportToolTip) {
        this.transition = actionTransition;
        this.source = sourceFigure;
        this.target = targetFigure;
        this.showToolTip = supportToolTip;
        this.setSourceAnchor((ConnectionAnchor)new EllipseAnchor((IFigure)sourceFigure));
        this.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)targetFigure));
        PolygonDecoration endPtDecoration = new PolygonDecoration();
        endPtDecoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
        this.setTargetDecoration((RotatableDecoration)endPtDecoration);
        this.buildToolTip();
        this.transition.addHandler((Object)this, ITransition.ActionChange.class, new IAlertHandler(){

            public void handleAlert(EventObject evt) {
                DesignEditorTransition.this.buildToolTip();
            }
        });
        this.connections = this.transition.getCurveIndex();
    }

    public void addDestinationChangeHandler(IAlertHandler handler) {
        this.transition.addHandler((Object)this, ITransition.DestinationChange.class, handler);
    }

    public void addActionChangeHandler(IAlertHandler handler) {
        this.transition.addHandler((Object)this, ITransition.ActionChange.class, handler);
    }

    public void dispose() {
        this.transition.removeAllHandlers((Object)this);
    }

    public ITransition getTransition() {
        return this.transition;
    }

    public ITransitionSource getSourceModel() {
        return this.source.getModel();
    }

    public IGraphicalSource getSource() {
        return this.source;
    }

    public DesignEditorFrame getTarget() {
        return this.target;
    }

    public void changeTarget(DesignEditorFrame newTargetFigure) {
        this.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)newTargetFigure));
        this.connections = this.transition.getCurveIndex();
    }

    public void setHandles(ResizeThumb forSource, ResizeThumb forTarget) {
        this.sourceHandle = forSource;
        this.targetHandle = forTarget;
    }

    public boolean isSelected() {
        return this.sourceHandle != null;
    }

    public ResizeThumb getSourceHandle() {
        return this.sourceHandle;
    }

    public ResizeThumb getTargetHandle() {
        return this.targetHandle;
    }

    public void setVisible(boolean visible) {
        if (this.sourceHandle != null) {
            this.sourceHandle.setVisible(visible);
            this.targetHandle.setVisible(visible);
        }
        super.setVisible(visible);
    }

    protected void buildToolTip() {
        if (this.showToolTip) {
            String transitionAction = this.transition.getAction().getLocalizedString();
            String toolTipText = KeyDisplayUtil.convertActionToDisplay(transitionAction);
            Label toolTipLabel = new Label(" " + toolTipText + " ");
            toolTipLabel.setFont(FontUtils.SYMBOL_FONT);
            this.setToolTip((IFigure)toolTipLabel);
        }
    }
}

