/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.FrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalDevice;
import edu.cmu.cs.hcii.cogtool.uimodel.IFrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalDevice;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.util.FontUtils;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.IScalableFigure;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;

public class DesignEditorFrame
extends RectangleFigure
implements IScalableFigure {
    protected static final double DEFAULT_FRAME_SCALE = 0.25;
    public static final int MIN_HEIGHT = 40;
    public static final int MIN_WIDTH = 175;
    public static final int ALL_FIGURES = 0;
    public static final int ONLY_GRAPHICAL_SOURCE = 1;
    protected double scale;
    protected boolean showToolTips;
    protected int sourceRolloverCursor;
    protected IFrame frame;
    protected Label nameLabel;
    protected IFrameUIModel frameUIModel;
    protected IGraphicalSource.IDisplayAlpha displayAlpha;
    protected RectangleFigure inputDeviceBox;
    protected Figure frameWidgetBox;
    protected Map inputDevices = new HashMap();
    protected Color unselectedBackground;
    protected boolean selected = false;
    protected static final FigureFilterSearch figureFilter = new FigureFilterSearch(0);
    protected static final SourcesFilterSearch sourcesFilter = new SourcesFilterSearch();
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange;

    public int getWidth() {
        return this.getSize().width;
    }

    public int getLabelHeight() {
        return this.frameWidgetBox.getLocation().y - this.getLocation().y;
    }

    public Label getLabel() {
        return this.nameLabel;
    }

    public DesignEditorFrame(IFrame frameModel, boolean supportToolTips, int srcRolloverCursor) {
        this(frameModel, 0.25, supportToolTips, srcRolloverCursor, 0);
    }

    public DesignEditorFrame(IFrame frameModel, double initialScale, int srcRolloverCursor) {
        this(frameModel, initialScale, true, srcRolloverCursor, 0);
    }

    public DesignEditorFrame(IFrame frameModel, double initialScale, boolean supportToolTips, int srcRolloverCursor, int rolloverCursor) {
        this.frame = frameModel;
        this.scale = initialScale;
        this.showToolTips = supportToolTips;
        this.sourceRolloverCursor = srcRolloverCursor;
        this.setCursor(new Cursor((Device)WindowUtil.globalDisplay, rolloverCursor));
        DoublePoint frameOrigin = frameModel.getFrameOrigin();
        this.setLocation(PrecisionUtilities.getDraw2DPoint(frameOrigin));
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.setOpaque(true);
        this.nameLabel = new FrameLabel(this);
        this.nameLabel.setTextAlignment(2);
        this.nameLabel.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.add((IFigure)this.nameLabel);
        this.frameWidgetBox = new Figure(){

            protected boolean useLocalCoordinates() {
                return true;
            }
        };
        this.frameWidgetBox.setLayoutManager((LayoutManager)new FlowLayout());
        this.frameWidgetBox.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.add((IFigure)this.frameWidgetBox);
        FrameUIModel frameUIModelAlpha = new FrameUIModel(this.frame, this.showToolTips, this.sourceRolloverCursor, this.scale, true);
        this.frameUIModel = frameUIModelAlpha;
        this.displayAlpha = frameUIModelAlpha;
        this.frameWidgetBox.add((IFigure)this.frameUIModel.getContents());
        IAlertHandler renameHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                DesignEditorFrame.this.nameLabel.setText(((IFrame)alert.getSource()).getName());
            }
        };
        this.frame.addHandler(this, NameChangeAlert.class, renameHandler);
        this.inputDeviceBox = new RectangleFigure();
        this.inputDeviceBox.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        this.add((IFigure)this.inputDeviceBox);
        FlowLayout deviceBoxLayout = new FlowLayout(true);
        deviceBoxLayout.setMajorAlignment(0);
        deviceBoxLayout.setMinorSpacing(5);
        this.inputDeviceBox.setLayoutManager((LayoutManager)deviceBoxLayout);
        Iterator devices = this.frame.getInputDevices().iterator();
        while (devices.hasNext()) {
            IInputDevice d = (IInputDevice)devices.next();
            GraphicalDevice deviceFigure = new GraphicalDevice(d, this.frame.getWidgetColor(), this.showToolTips, this.sourceRolloverCursor, this.displayAlpha);
            this.inputDeviceBox.add((IFigure)deviceFigure);
            this.inputDevices.put(d, deviceFigure);
        }
        this.frameUIModel.addHandler(this, IFrameUIModel.WidgetShapeImageChange.class, new IAlertHandler(){

            public void handleAlert(EventObject e) {
                DesignEditorFrame.this.resetFrameSize();
            }
        });
        this.setFont(FontUtils.DEFAULT_FONT);
        this.resetFrameSize();
        this.unselectedBackground = this.getBackgroundColor();
    }

    public void dispose() {
        this.frameUIModel.removeAllHandlers(this);
        this.frameUIModel.dispose();
        Iterator sources = this.frame.getWidgets().iterator();
        while (sources.hasNext()) {
            IWidget widget = (IWidget)sources.next();
            widget.removeAllHandlers(this);
        }
        sources = this.frame.getInputDevices().iterator();
        while (sources.hasNext()) {
            IInputDevice device = (IInputDevice)sources.next();
            device.removeAllHandlers(this);
        }
        this.frame.removeAllHandlers(this);
        Iterator iter = this.inputDevices.values().iterator();
        while (iter.hasNext()) {
            GraphicalDevice d = (GraphicalDevice)iter.next();
            d.dispose();
        }
    }

    public IFrame getFrame() {
        return this.frame;
    }

    public IFrameUIModel getFrameUIModel() {
        return this.frameUIModel;
    }

    public void addOriginChangeHandler(IAlertHandler handler) {
        this.frame.addHandler(this, IFrame.OriginChange.class, handler);
    }

    public void addWidgetChangeHandler(IAlertHandler handler) {
        this.frame.addHandler(this, IFrame.WidgetChange.class, handler);
    }

    public void addWidgetRecoveryHandler(IAlertHandler handler) {
        this.frameUIModel.addHandler(this, IFrameUIModel.WidgetRecovery.class, handler);
    }

    public void addWidgetShapeChangeHandler(IAlertHandler handler) {
        this.frameUIModel.addHandler(this, IFrameUIModel.WidgetShapeImageChange.class, handler);
    }

    public void addTransitionChangeHandler(IAlertHandler handler) {
        Iterator sources = this.frame.getWidgets().iterator();
        while (sources.hasNext()) {
            IWidget widget = (IWidget)sources.next();
            widget.addHandler(this, class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange == null ? DesignEditorFrame.class$("edu.cmu.cs.hcii.cogtool.model.ITransitionSource$TransitionChange") : class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange, handler);
        }
        sources = this.frame.getInputDevices().iterator();
        while (sources.hasNext()) {
            IInputDevice device = (IInputDevice)sources.next();
            device.addHandler(this, class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange == null ? DesignEditorFrame.class$("edu.cmu.cs.hcii.cogtool.model.ITransitionSource$TransitionChange") : class$edu$cmu$cs$hcii$cogtool$model$ITransitionSource$TransitionChange, handler);
        }
    }

    public Iterator getSourceFigureIterator() {
        return new SourceFigureIterator(this);
    }

    public IGraphicalWidget getWidgetFigure(IWidget widget) {
        return this.frameUIModel.getWidgetFigure(widget);
    }

    public IGraphicalDevice getDeviceFigure(IInputDevice device) {
        return (IGraphicalDevice)this.inputDevices.get(device);
    }

    public IGraphicalSource getSourceFigure(ITransitionSource source) {
        IGraphicalSource widgetFigure = (IGraphicalSource)this.inputDevices.get(source);
        if (widgetFigure != null) {
            return widgetFigure;
        }
        IWidget widget = (IWidget)source;
        if (widget != null) {
            return this.getWidgetFigure(widget);
        }
        return null;
    }

    protected void resetFrameSize() {
        DoubleSize size = this.computeFrameSize(this.getScale());
        int width = PrecisionUtilities.round(size.width);
        int height = PrecisionUtilities.round(size.height);
        super.setSize(width, height);
        super.setPreferredSize(width, height);
        height -= this.inputDeviceBox.getPreferredSize().height + this.inputDeviceBox.getInsets().getHeight();
        this.frameWidgetBox.setSize(width, height -= this.nameLabel.getPreferredSize().height);
        this.frameWidgetBox.setPreferredSize(width, height);
    }

    protected DoubleSize computeFrameSize(double zoom) {
        double minScale = this.scale > 1.0 ? this.scale : 1.0;
        double width = 175.0 * minScale;
        double height = 40.0 * minScale;
        DoubleSize frameSize = this.frameUIModel.getPreferredSize(zoom);
        if (frameSize.width > width) {
            width = frameSize.width;
        }
        if (frameSize.height > height) {
            height = frameSize.height;
        }
        height += (double)(this.inputDeviceBox.getPreferredSize().height + this.inputDeviceBox.getInsets().getHeight());
        return new DoubleSize(width, height += (double)this.nameLabel.getPreferredSize().height);
    }

    public void paint(Graphics gc) {
        super.paint(gc);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void paintSelected() {
        if (this.selected) {
            this.setBackgroundColor(ColorConstants.lightBlue);
        } else {
            this.setBackgroundColor(this.unselectedBackground);
        }
        this.repaint();
    }

    public void setSelected(boolean select) {
        if (this.selected != select) {
            this.selected = select;
            this.paintSelected();
        }
    }

    public void dynamicHighlight() {
        this.setBackgroundColor(ColorConstants.gray);
        this.repaint();
    }

    public void setScale(double s) {
        if (s <= 0.0) {
            throw new InvalidParameterException("Cannot set a non-positive scale");
        }
        this.scale = s;
        this.frameUIModel.setZoom(this.scale);
        this.resetFrameSize();
    }

    public double getScale() {
        return this.scale;
    }

    public void setSize(int width, int height) {
        this.resetFrameSize();
    }

    public IFigure getFigureAtXY(int x, int y, int filter) {
        figureFilter.setFilter(filter);
        return this.findFigureAt(x, y, figureFilter);
    }

    public List getSourcesAtXY(int x, int y) {
        sourcesFilter.resetSearch();
        this.findFigureAt(x, y, sourcesFilter);
        return sourcesFilter.getSources();
    }

    public Rectangle getChildrenUtilizedAreaScaled() {
        return this.getClientArea();
    }

    public Rectangle getChildrenUtilizedAreaUnscaled() {
        DoubleSize size = this.computeFrameSize(1.0);
        int width = PrecisionUtilities.round(size.width);
        int height = PrecisionUtilities.round(size.height);
        return new Rectangle(0, 0, width, height);
    }

    public void hideAllMenuItems() {
        this.frameUIModel.hideAllMenuItems();
    }

    public static class SourceFigureIterator
    extends IFrameUIModel.WidgetFigureIterator {
        Iterator deviceFigures;

        public SourceFigureIterator(DesignEditorFrame frameFigure) {
            super(frameFigure.getFrameUIModel());
            this.deviceFigures = frameFigure.inputDevices.values().iterator();
        }

        public boolean hasNext() {
            if (super.hasNext()) {
                return true;
            }
            if (this.deviceFigures != null) {
                if (this.deviceFigures.hasNext()) {
                    return true;
                }
                this.deviceFigures = null;
            }
            return false;
        }

        public Object next() {
            try {
                return super.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (this.deviceFigures != null) {
                    if (this.deviceFigures.hasNext()) {
                        return this.deviceFigures.next();
                    }
                    this.deviceFigures = null;
                }
                throw new NoSuchElementException();
            }
        }
    }

    protected static class SourcesFilterSearch
    implements TreeSearch {
        protected List sources = new ArrayList();

        protected SourcesFilterSearch() {
        }

        public void resetSearch() {
            this.sources.clear();
        }

        public List getSources() {
            return this.sources;
        }

        public boolean accept(IFigure figure) {
            if (figure instanceof IGraphicalSource) {
                this.sources.add(figure);
            }
            return false;
        }

        public boolean prune(IFigure figure) {
            return false;
        }
    }

    protected static class FigureFilterSearch
    implements TreeSearch {
        protected int filter;

        public FigureFilterSearch(int figureFilter) {
            this.filter = figureFilter;
        }

        public void setFilter(int newFigureFilter) {
            this.filter = newFigureFilter;
        }

        public boolean accept(IFigure figure) {
            switch (this.filter) {
                case 1: {
                    return figure instanceof IGraphicalSource;
                }
            }
            return true;
        }

        public boolean prune(IFigure figure) {
            return false;
        }
    }

    public class FrameLabel
    extends Label {
        DesignEditorFrame frameFigure;

        public FrameLabel(DesignEditorFrame frameFig) {
            super(frameFig.getFrame().getName());
            this.frameFigure = frameFig;
        }

        public DesignEditorFrame getFrameFigure() {
            return this.frameFigure;
        }

        public IFrame getFrame() {
            return this.frameFigure.getFrame();
        }
    }
}

