/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.uimodel.AWireRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidget;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;

public class ChoiceWireRenderer
extends AWireRenderer {
    public static final boolean RADIO = false;
    public static final boolean CHECK = true;
    protected static final int MARGIN = 2;
    protected boolean kind;
    protected int choiceX = 1;
    protected int choiceY = 1;
    protected int choiceWidth;
    protected int choiceHeight;
    protected Label choiceLabel;

    public ChoiceWireRenderer(boolean choiceKind, GraphicalWidget parent) {
        super(parent);
        this.kind = choiceKind;
        this.choiceLabel = new Label();
        this.choiceLabel.setTextPlacement(1);
        this.choiceLabel.setTextAlignment(1);
        this.add((IFigure)this.choiceLabel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintForeground(Graphics g) {
        g.pushState();
        try {
            if (this.kind) {
                g.drawRectangle(this.choiceX, this.choiceY, this.choiceWidth - 1, this.choiceHeight - 1);
            } else {
                g.drawOval(this.choiceX, this.choiceY, this.choiceWidth - 1, this.choiceHeight - 1);
            }
            this.choiceLabel.paint(g);
        }
        finally {
            g.popState();
        }
    }

    public void setText(String text) {
        this.choiceLabel.setText(text);
    }

    public void setSize(int width, int height) {
        int labelHeight;
        int labelWidth;
        int labelY;
        int labelX;
        super.setSize(width, height);
        if (height < width) {
            this.choiceWidth = height - 2;
            this.choiceHeight = height - 2;
            labelX = height + 2;
            labelY = 1;
            labelWidth = width - labelX - 1;
            labelHeight = height - 2;
        } else {
            this.choiceWidth = width - 2;
            this.choiceHeight = width - 2;
            labelX = 1;
            labelY = width + 2;
            labelWidth = width - 2;
            labelHeight = height - labelY - 1;
        }
        if (this.choiceWidth < 0) {
            this.choiceWidth = 1;
        }
        if (this.choiceHeight < 0) {
            this.choiceHeight = 1;
        }
        if (labelWidth < 0) {
            labelWidth = 1;
        }
        if (labelHeight < 0) {
            labelHeight = 1;
        }
        this.choiceLabel.setLocation(new Point(labelX, labelY));
        this.choiceLabel.setSize(labelWidth, labelHeight);
    }
}

