/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;

public abstract class BezierPolylineConnection
extends PolylineConnection {
    protected int connections = 0;
    protected int previousStartX = -1;
    protected int previousStartY = -1;
    protected int previousEndX = -1;
    protected int previousEndY = -1;

    public void paintFigure(Graphics g) {
        this.updateBezier();
        super.paintFigure(g);
    }

    protected void updateBezier() {
        if (this.connections > 1 && this.getPoints().size() >= 2) {
            Point start = this.getStart();
            Point end = this.getEnd();
            if (start != null && end != null) {
                if (this.getStart().x != this.previousStartX || this.getStart().y != this.previousStartY || this.getEnd().x != this.previousEndX || this.getEnd().y != this.previousEndY) {
                    this.previousStartX = start.x;
                    this.previousStartY = start.y;
                    this.previousEndX = end.x;
                    this.previousEndY = end.y;
                    this.generateBezierPoints(start, end, this.connections);
                } else if (this.getPoints().size() == 2) {
                    this.generateBezierPoints(start, end, this.connections);
                }
            }
        }
    }

    public void generateBezierPoints(Point start, Point end, int connections) {
        double k;
        PointList newPoints = new PointList();
        int spacing = 25;
        Point[] bezierPoints = new Point[4];
        int position = 0;
        if (start.x <= end.x && start.y > end.y) {
            position = 1;
        } else if (start.x > end.x && start.y > end.y) {
            position = 2;
        } else if (start.x > end.x && start.y <= end.y) {
            position = 3;
        } else if (start.x <= end.x && start.y <= end.y) {
            position = 4;
        }
        bezierPoints[0] = start;
        bezierPoints[3] = end;
        double Mh = 0.0;
        double Mx = 0.0;
        double My = 0.0;
        double Ma = 0.0;
        double P1h = 0.0;
        double P1x = 0.0;
        double P1y = 0.0;
        double B1h = 0.0;
        double B1x = 0.0;
        double B1y = 0.0;
        double P2h = 0.0;
        double P2x = 0.0;
        double P2y = 0.0;
        double B2h = 0.0;
        double B2x = 0.0;
        double B2y = 0.0;
        Mx = Math.abs(end.x - start.x);
        My = Math.abs(end.y - start.y);
        Mh = Math.sqrt(Math.pow(Mx, 2.0) + Math.pow(My, 2.0));
        Ma = Math.atan(My / Mx);
        P1h = 0.25 * Mh;
        P2h = 0.75 * Mh;
        if (position == 1) {
            P1x = (double)start.x + Math.cos(Ma) * P1h;
            P1y = (double)start.y - Math.sin(Ma) * P1h;
            P2x = (double)start.x + Math.cos(Ma) * P2h;
            P2y = (double)start.y - Math.sin(Ma) * P2h;
        } else if (position == 2) {
            P1x = (double)start.x - Math.cos(Ma) * P1h;
            P1y = (double)start.y - Math.sin(Ma) * P1h;
            P2x = (double)start.x - Math.cos(Ma) * P2h;
            P2y = (double)start.y - Math.sin(Ma) * P2h;
        } else if (position == 3) {
            P1x = (double)start.x - Math.cos(Ma) * P1h;
            P1y = (double)start.y + Math.sin(Ma) * P1h;
            P2x = (double)start.x - Math.cos(Ma) * P2h;
            P2y = (double)start.y + Math.sin(Ma) * P2h;
        } else if (position == 4) {
            P1x = (double)start.x + Math.cos(Ma) * P1h;
            P1y = (double)start.y + Math.sin(Ma) * P1h;
            P2x = (double)start.x + Math.cos(Ma) * P2h;
            P2y = (double)start.y + Math.sin(Ma) * P2h;
        }
        boolean above = connections % 2 == 0;
        B1h = spacing * (connections / 2);
        B2h = spacing * (connections / 2);
        B1x = Math.sin(Ma) * B1h;
        B1y = Math.cos(Ma) * B1h;
        B2x = Math.sin(Ma) * B2h;
        B2y = Math.cos(Ma) * B2h;
        if (position == 1) {
            if (above) {
                bezierPoints[1] = new Point((int)(P1x - B1x), (int)(P1y - B1y));
                bezierPoints[2] = new Point((int)(P2x - B2x), (int)(P2y - B2y));
            } else {
                bezierPoints[1] = new Point((int)(P1x + B1x), (int)(P1y + B1y));
                bezierPoints[2] = new Point((int)(P2x + B2x), (int)(P2y + B2y));
            }
        } else if (position == 2) {
            if (above) {
                bezierPoints[1] = new Point((int)(P1x - B1x), (int)(P1y + B1y));
                bezierPoints[2] = new Point((int)(P2x - B2x), (int)(P2y + B2y));
            } else {
                bezierPoints[1] = new Point((int)(P1x + B1x), (int)(P1y - B1y));
                bezierPoints[2] = new Point((int)(P2x + B2x), (int)(P2y - B2y));
            }
        } else if (position == 3) {
            if (above) {
                bezierPoints[1] = new Point((int)(P1x + B1x), (int)(P1y + B1y));
                bezierPoints[2] = new Point((int)(P2x + B2x), (int)(P2y + B2y));
            } else {
                bezierPoints[1] = new Point((int)(P1x - B1x), (int)(P1y - B1y));
                bezierPoints[2] = new Point((int)(P2x - B2x), (int)(P2y - B2y));
            }
        } else if (position == 4) {
            if (above) {
                bezierPoints[1] = new Point((int)(P1x + B1x), (int)(P1y - B1y));
                bezierPoints[2] = new Point((int)(P2x + B2x), (int)(P2y - B2y));
            } else {
                bezierPoints[1] = new Point((int)(P1x - B1x), (int)(P1y + B1y));
                bezierPoints[2] = new Point((int)(P2x - B2x), (int)(P2y + B2y));
            }
        }
        double x1 = bezierPoints[0].x;
        double y1 = bezierPoints[0].y;
        double t = 0.0;
        for (t = k = 0.025; t <= 1.0 + k; t += k) {
            double x2 = (double)bezierPoints[0].x + t * ((double)(-bezierPoints[0].x * 3) + t * ((double)(3 * bezierPoints[0].x) - (double)bezierPoints[0].x * t)) + t * ((double)(3 * bezierPoints[1].x) + t * ((double)(-6 * bezierPoints[1].x) + (double)(bezierPoints[1].x * 3) * t)) + t * t * ((double)(bezierPoints[2].x * 3) - (double)(bezierPoints[2].x * 3) * t) + (double)bezierPoints[3].x * t * t * t;
            double y2 = (double)bezierPoints[0].y + t * ((double)(-bezierPoints[0].y * 3) + t * ((double)(3 * bezierPoints[0].y) - (double)bezierPoints[0].y * t)) + t * ((double)(3 * bezierPoints[1].y) + t * ((double)(-6 * bezierPoints[1].y) + (double)(bezierPoints[1].y * 3) * t)) + t * t * ((double)(bezierPoints[2].y * 3) - (double)(bezierPoints[2].y * 3) * t) + (double)bezierPoints[3].y * t * t * t;
            newPoints.addPoint(new Point((int)x1, (int)y1));
            x1 = x2;
            y1 = y2;
        }
        newPoints.addPoint(bezierPoints[3]);
        this.setPoints(newPoints);
    }
}

