/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.GraphicalWidgetRenderer;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public abstract class AImageRenderer
extends Figure
implements GraphicalWidgetRenderer {
    protected static final int RENDER_FULL = 0;
    protected static final int RENDER_LEFT_SQUARE = 1;
    protected static final int RENDER_RIGHT_SQUARE = 2;
    protected static final int RENDER_LEFT_FILL = 3;
    protected static final int RENDER_RIGHT_FILL = 4;
    protected static final String FILETYPE = "png";
    protected static final int MARGIN = 5;
    protected Label label;
    protected int renderedArea = 0;
    protected Rectangle widgetBounds;
    protected static Map imageRegistry = new HashMap();

    protected AImageRenderer(IGraphicalWidget parent, String widgetName, String skinName, int labelStyle, int area) {
        this.setParent(parent);
        this.setOpaque(false);
        this.renderedArea = 0;
        this.widgetBounds = new Rectangle(this.getBounds());
        this.renderedArea = area;
        if (labelStyle != 0) {
            this.label = new Label();
            this.label.setLocation(new Point(6, 6));
            if (labelStyle == 2) {
                this.label.setTextPlacement(1);
                this.label.setTextAlignment(1);
            } else if (labelStyle == 3) {
                this.label.setTextPlacement(4);
                this.label.setTextAlignment(4);
            } else if (labelStyle == 1) {
                this.label.setTextPlacement(2);
                this.label.setTextAlignment(2);
            }
            this.add((IFigure)this.label);
        }
    }

    public abstract void paintForeground(Graphics var1);

    public void paintMidground(Graphics g) {
        ((GraphicalWidget)this.getParent()).clipper.fillShape(g, this.getBounds());
    }

    public void setText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    public static Image getImage(String path) {
        Image pic = (Image)imageRegistry.get(path);
        if (pic == null) {
            pic = GraphicsUtil.getImageFromResource(path);
            imageRegistry.put(path, pic);
        }
        return pic;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        int labelX = 0;
        int labelY = 0;
        int labelWidth = width;
        int labelHeight = height;
        if (this.renderedArea == 0) {
            this.widgetBounds.setSize(width, height);
            if (this.label != null) {
                labelX = 5;
                labelWidth = width - 12;
                labelHeight = height;
            }
        } else if (this.renderedArea == 1) {
            if (height < width) {
                this.widgetBounds.setSize(height, height);
                if (this.label != null) {
                    labelX = height + 5;
                    labelWidth = width - labelX - 5;
                    labelHeight = height;
                }
            } else {
                this.widgetBounds.setSize(width, width);
                if (this.label != null) {
                    labelX = 5;
                    labelY = width;
                    labelWidth = width - 5;
                    labelHeight = height - labelY;
                }
            }
        } else if (this.renderedArea == 2) {
            if (height < width) {
                this.widgetBounds.setLocation(0, width - height);
                this.widgetBounds.setSize(height, height);
                if (this.label != null) {
                    labelX = 5;
                    labelWidth = width - height - 5;
                    labelHeight = height;
                }
            } else {
                this.widgetBounds.setLocation(height - width, 0);
                this.widgetBounds.setSize(width, width);
                if (this.label != null) {
                    labelX = 5;
                    labelWidth = width - 5;
                    labelHeight = height - width;
                }
            }
        } else if (this.renderedArea == 3) {
            if (height < width) {
                this.widgetBounds.setSize(width - height, height);
                if (this.label != null) {
                    labelX = 5;
                    labelWidth = width - height - 5;
                    labelHeight = height;
                }
            } else {
                this.widgetBounds.setSize(width, height - width);
                if (this.label != null) {
                    labelX = 5;
                    labelWidth = width - 5;
                    labelHeight = height - width;
                }
            }
        } else if (this.renderedArea == 4) {
            if (height < width) {
                this.widgetBounds.setLocation(0, height);
                this.widgetBounds.setSize(width - height, height);
                if (this.label != null) {
                    labelX = height + 5;
                    labelWidth = width - labelX - 5;
                    labelHeight = height;
                }
            } else {
                this.widgetBounds.setLocation(width, 0);
                this.widgetBounds.setSize(width, height - width);
                if (this.label != null) {
                    labelX = 5;
                    labelY = width;
                    labelWidth = width - 5;
                    labelHeight = height - labelY;
                }
            }
        }
        if (this.label != null) {
            if (labelWidth < 0) {
                labelWidth = 1;
            }
            if (labelHeight < 0) {
                labelHeight = 1;
            }
            this.label.setLocation(new Point(labelX, labelY));
            this.label.setSize(labelWidth, labelHeight);
        }
    }
}

