/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.uimodel;

import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.util.FontUtils;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public abstract class AGraphicalSource
extends Figure
implements IGraphicalSource {
    protected Map transitions = new HashMap();
    protected boolean showToolTip;
    protected ImageData foreground;
    protected IGraphicalSource.IDisplayAlpha displayAlpha;
    protected IAlertHandler changeHandler = new IAlertHandler(){

        public void handleAlert(EventObject alert) {
            AGraphicalSource.this.buildToolTip();
        }
    };
    protected IAlertHandler transitionChangeHandler = new IAlertHandler(){

        public void handleAlert(EventObject alert) {
            AGraphicalSource.this.buildToolTip();
            ITransitionSource.TransitionChange chg = (ITransitionSource.TransitionChange)alert;
            ITransition transitionChg = (ITransition)chg.element;
            if (chg.isAdd) {
                transitionChg.addHandler(this, class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange == null ? (class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange = AGraphicalSource.class$("edu.cmu.cs.hcii.cogtool.model.ITransition$ActionChange")) : class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange, AGraphicalSource.this.changeHandler);
            } else {
                transitionChg.removeHandler(class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange == null ? (class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange = AGraphicalSource.class$("edu.cmu.cs.hcii.cogtool.model.ITransition$ActionChange")) : class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange, AGraphicalSource.this.changeHandler);
            }
        }
    };

    public AGraphicalSource(boolean supportToolTip, int rolloverCursor, IGraphicalSource.IDisplayAlpha alphaComputer) {
        this.setOpaque(false);
        this.showToolTip = supportToolTip;
        this.displayAlpha = alphaComputer;
        this.setCursor(rolloverCursor);
    }

    protected void setCursor(int rolloverCursor) {
        this.setCursor(new Cursor((Device)WindowUtil.globalDisplay, rolloverCursor));
    }

    protected void setSourceModel(ITransitionSource m) {
        if (m == null) {
            throw new IllegalArgumentException("Cannot set the model of a graphical source to null");
        }
        ITransitionSource oldModel = this.getModel();
        if (oldModel != m) {
            if (oldModel != null) {
                oldModel.removeAllHandlers(this);
            }
            this.setModel(m);
            this.buildToolTip();
            this.getModel().addHandler(this, IWidget.WidgetChange.class, this.changeHandler);
            this.getModel().addHandler(this, ITransitionSource.TransitionChange.class, this.transitionChangeHandler);
            Iterator transitions = this.getModel().getTransitions().values().iterator();
            while (transitions.hasNext()) {
                ITransition t = (ITransition)transitions.next();
                t.addHandler(this, class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange == null ? AGraphicalSource.class$("edu.cmu.cs.hcii.cogtool.model.ITransition$ActionChange") : class$edu$cmu$cs$hcii$cogtool$model$ITransition$ActionChange, this.changeHandler);
            }
            this.updateAttributes();
        }
    }

    protected abstract void setModel(ITransitionSource var1);

    protected void updateAttributes() {
        this.updateTitle();
    }

    public void dispose() {
        Iterator transitions = this.getModel().getTransitions().values().iterator();
        while (transitions.hasNext()) {
            ITransition t = (ITransition)transitions.next();
            t.removeAllHandlers(this);
        }
        this.getModel().removeAllHandlers(this);
    }

    public Iterator getTransitionsIterator() {
        return new TransitionIterator();
    }

    public IFigure getTransition(ITransition transition) {
        return (IFigure)this.transitions.get(transition);
    }

    public void addTransition(ITransition t, IFigure f) {
        this.transitions.put(t, f);
        t.addHandler(this, ITransition.ActionChange.class, this.changeHandler);
    }

    public IFigure removeTransition(ITransition t) {
        t.removeAllHandlers(this);
        return (IFigure)this.transitions.remove(t);
    }

    public void setColor(int color) {
        this.foreground = new ImageData(1, 1, 1, new PaletteData(new RGB[]{GraphicsUtil.getRGBFromColor(color)}));
    }

    public void updateTitle() {
    }

    protected String buildToolTipText() {
        ITransitionSource source = this.getModel();
        StringBuffer strBuffer = new StringBuffer(source.getName() + " (" + this.getTypeDescription() + ")");
        Iterator transIter = source.getTransitions().values().iterator();
        while (transIter.hasNext()) {
            ITransition transition = (ITransition)transIter.next();
            strBuffer.append("\n    ");
            strBuffer.append(transition.getAction().getLocalizedString());
            strBuffer.append(": ");
            strBuffer.append(transition.getDestination().getName());
        }
        return strBuffer.toString();
    }

    protected abstract String getTypeDescription();

    public void buildToolTip() {
        if (this.showToolTip) {
            String toolTipText = KeyDisplayUtil.convertActionToDisplay(this.buildToolTipText());
            Label toolTipLabel = new Label(" " + toolTipText + " ");
            toolTipLabel.setFont(FontUtils.SYMBOL_FONT);
            this.setToolTip((IFigure)toolTipLabel);
        }
    }

    private class TransitionIterator
    implements Iterator {
        Iterator inner;
        Map.Entry item;

        private TransitionIterator() {
            this.inner = AGraphicalSource.this.transitions.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.inner.hasNext();
        }

        public Object next() {
            this.item = (Map.Entry)this.inner.next();
            return this.item.getValue();
        }

        public void remove() {
            ITransition trans = (ITransition)this.item.getKey();
            trans.removeAllHandlers(AGraphicalSource.this);
            this.inner.remove();
        }
    }
}

