/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.ui.DefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.IZoomableUI;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;

public abstract class ZoomableUI
extends DefaultUI
implements IZoomableUI {
    public static final double ZOOM_FACTOR = 1.15;
    protected InteractionDrawingEditor zoomEditor;

    public ZoomableUI(IProject proj, String windowMenuLabel, MenuUtil.MenuItemDefinition[] leadItems) {
        super(proj, windowMenuLabel, leadItems);
    }

    protected void setZoomEditor(InteractionDrawingEditor zoomableEditor) {
        this.zoomEditor = zoomableEditor;
    }

    protected double getZoomingFactor() {
        return 1.15;
    }

    public void performZoom(double z) {
        this.performAction((ListenerIdentifier)CogToolLID.SetZoom, new Double(z));
    }

    public double getZoom() {
        return this.zoomEditor.getZoomSetting();
    }

    public double computeZoomToFit() {
        return this.zoomEditor.computeZoomToFit();
    }

    public void zoomToActual() {
        this.setZoom(1.0);
    }

    public void zoomToFit() {
        this.setZoom(this.zoomEditor.computeZoomToFit());
    }

    public void zoomIn() {
        this.setZoom(this.getZoom() * this.getZoomingFactor());
    }

    public void zoomOut() {
        this.setZoom(this.getZoom() / this.getZoomingFactor());
    }

    public void setZoom(double scale) {
        this.zoomEditor.setZoomSetting(scale);
        this.saveWindowZoom(this.getModelObject(), scale);
    }
}

