/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.ui.DefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISEFrameChooserInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISEFrameChooserUI;
import edu.cmu.cs.hcii.cogtool.ui.SEDefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.SEFrameChooserInteraction;
import edu.cmu.cs.hcii.cogtool.ui.SEFrameChooserLID;
import edu.cmu.cs.hcii.cogtool.ui.SEFrameChooserMouseState;
import edu.cmu.cs.hcii.cogtool.ui.SEFrameChooserSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.IStructureViewUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.SEFrameChooserUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.StructureViewUIModel;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import edu.cmu.cs.hcii.cogtool.view.IScalableInteractiveFigure;
import edu.cmu.cs.hcii.cogtool.view.IScriptView;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.SEFrameChooserView;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableItem;

public class SEFrameChooserUI
extends SEDefaultUI
implements ISEFrameChooserUI {
    protected static final String seChooseFrameWindowTitle = L10N.get("SE.ChooseFrameWindowTitle", "Choose Start Frame - ");
    protected SEFrameChooserView view;
    protected SEFrameChooserSelectionState selection;
    protected ISEFrameChooserInteraction interaction;
    protected SEFrameChooserUIModel uiModel;
    protected IStructureViewUIModel structureView;
    protected IAlertHandler frameNameChangeHandler = new IAlertHandler(){

        public void handleAlert(EventObject alert) {
            SEFrameChooserUI.this.updateViewContents();
        }
    };
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert;

    public SEFrameChooserUI(IScript modelScript, ITask scriptTask, IDesign scriptDesign, IProject scriptProject, UndoManager undoMgr) {
        super(modelScript, scriptTask, scriptDesign, scriptProject, undoMgr);
        this.selection = new SEFrameChooserSelectionState();
        this.uiModel = new SEFrameChooserUIModel(modelScript, scriptTask, scriptDesign, scriptProject);
        this.structureView = this.uiModel.getStructureView();
        IAlertHandler frameOriginChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IStructureViewUIModel.FrameShapeChange evt = (IStructureViewUIModel.FrameShapeChange)alert;
                IFrame frame = evt.getFrameFigure().getFrame();
                if (frame == SEFrameChooserUI.this.selection.selectedFrame) {
                    SEFrameChooserUI.this.updateSelection(frame);
                }
            }
        };
        this.structureView.addHandler(this, StructureViewUIModel.OriginChangeHandler.class, frameOriginChangeHandler);
        int deviceTypes = DeviceType.buildDeviceSet(scriptDesign.getDeviceTypes());
        this.view = new SEFrameChooserView(deviceTypes, this.lIDMap, this, this.menuData, this.structureView.getContents(), null, new SEFrameChooserMouseState(this), this.uiModel, this, this.getWindowLocation());
        this.setZoomEditor(this.view.getEditor());
        this.view.setHandStartsOnMouse(modelScript.getHandStartsOnMouse());
        this.interaction = new SEFrameChooserInteraction(this.getView());
        this.updateTitle();
        IAlertHandler designFrameChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign.FrameChange evt = (IDesign.FrameChange)alert;
                IFrame frame = (IFrame)evt.element;
                SEFrameChooserUI.this.updateViewContents();
                if (!evt.isAdd) {
                    if (frame == SEFrameChooserUI.this.selection.selectedFrame) {
                        SEFrameChooserUI.this.selection.deselectAll();
                    }
                    frame.removeHandler(class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert == null ? (class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert = SEFrameChooserUI.class$("edu.cmu.cs.hcii.cogtool.util.NameChangeAlert")) : class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert, SEFrameChooserUI.this.frameNameChangeHandler);
                } else {
                    frame.addHandler(this, class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert == null ? (class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert = SEFrameChooserUI.class$("edu.cmu.cs.hcii.cogtool.util.NameChangeAlert")) : class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert, SEFrameChooserUI.this.frameNameChangeHandler);
                }
            }
        };
        this.design.addHandler(this, IDesign.FrameChange.class, designFrameChangeHandler);
        Iterator iter = this.design.getFrames().iterator();
        while (iter.hasNext()) {
            IFrame frame = (IFrame)iter.next();
            frame.addHandler(this, class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert == null ? SEFrameChooserUI.class$("edu.cmu.cs.hcii.cogtool.util.NameChangeAlert") : class$edu$cmu$cs$hcii$cogtool$util$NameChangeAlert, this.frameNameChangeHandler);
        }
        this.updateViewContents();
        this.view.addSwtListSelectionHandler(new SelectionListener(){

            public void widgetSelected(SelectionEvent evt) {
                TableItem i = (TableItem)evt.item;
                IFrame f = (IFrame)i.getData();
                SEFrameChooserUI.this.selection.setSelectedFrame(f);
            }

            public void widgetDefaultSelected(SelectionEvent evt) {
                SEFrameChooserUI.this.performAction(SEFrameChooserLID.OpenScriptDemonstrator);
            }
        });
        IAlertHandler selectionChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                SEFrameChooserSelectionState.SelectionChange change = (SEFrameChooserSelectionState.SelectionChange)alert;
                SEFrameChooserUI.this.updateSelection(change.selected);
            }
        };
        this.selection.addHandler(this, SEFrameChooserSelectionState.SelectionChange.class, selectionChangeHandler);
        this.updateView(ListenerIdentifierMap.NORMAL);
        this.setZoom(this.getWindowZoom(scriptDesign));
        this.setInitiallyEnabled();
    }

    public void dispose() {
        Iterator iter = this.design.getFrames().iterator();
        while (iter.hasNext()) {
            IFrame frame = (IFrame)iter.next();
            frame.removeAllHandlers(this);
        }
        this.structureView.removeAllHandlers(this);
        this.selection.removeAllHandlers(this);
        super.dispose();
    }

    public ISEFrameChooserInteraction getInteraction() {
        return this.interaction;
    }

    public IInteraction getStandardInteraction() {
        return this.interaction;
    }

    public IView getView() {
        return this.view;
    }

    protected IScriptView getScriptView() {
        return this.view;
    }

    protected void updateViewContents() {
        this.view.getFrameList().setListContents(this.uiModel.getFramesSorted());
    }

    public void resizeContents(int width, int height, boolean resizeMin) {
        this.view.getEditor().resizeContents(width, height, resizeMin);
    }

    protected void setInitiallyEnabled() {
        super.setInitiallyEnabled();
        this.setEnabled(CogToolLID.ZoomIn, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomOut, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomNormal, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomToFit, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.Paste, ListenerIdentifierMap.ALL, false);
    }

    public void setZoom(double zoom) {
        this.view.getEditor().setZoomSetting(zoom);
        this.saveWindowZoom(this.design, zoom);
    }

    public Object getParameters(ListenerIdentifier originalLID, ListenerIdentifier transmutedLID, boolean isContextSelection) {
        if (originalLID instanceof DefaultUI.RestoreParentControllerLID) {
            return super.getParameters(originalLID, transmutedLID, isContextSelection);
        }
        if (transmutedLID == SEFrameChooserLID.OpenScriptDemonstrator) {
            return new ISEFrameChooserUI.OpenScriptParameters(this.view.getHandStartsOnMouse(), this.selection);
        }
        return isContextSelection ? null : this.selection;
    }

    public void showContextMenu(int x, int y) {
        DesignEditorFrame f = this.structureView.getFrameAtXY(x, y);
        if (f != null) {
            this.selection.setSelectedFrame(f.getFrame());
            this.updateView(ListenerIdentifierMap.ALL);
            this.view.showPositionalMenu();
        } else {
            this.view.showStandardMenu();
        }
    }

    public void showContextMenu() {
        this.updateView(ListenerIdentifierMap.CONTEXT);
        if (this.selection.getSelectedFrame() != null) {
            this.view.showPositionalMenu();
        } else {
            this.view.showStandardMenu();
        }
    }

    protected void updateSelection(IFrame f) {
        IScalableInteractiveFigure contents = this.structureView.getContents();
        if (f == null) {
            this.view.getFrameList().deselectAll();
            contents.stopDrawingTemporaryFigure();
        } else {
            this.view.getFrameList().setListItemHighlighted(f);
            DesignEditorFrame frame = this.structureView.getFrameFigure(f);
            Rectangle bds = frame.getBounds();
            contents.setTemporaryFigure(bds.x, bds.y, bds.width, bds.height);
        }
        this.updateView(ListenerIdentifierMap.ALL);
    }

    protected void updateView(Boolean availability) {
        this.setEnabled(SEFrameChooserLID.OpenScriptDemonstrator, availability, this.selection.getSelectedFrame() != null);
    }
}

