/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.AAction;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.GraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IDelayScriptStep;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.model.IThinkScriptStep;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.KeyAction;
import edu.cmu.cs.hcii.cogtool.model.TransitionSourceType;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.DefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoUI;
import edu.cmu.cs.hcii.cogtool.ui.SEDefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoContextSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoInteraction;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoLID;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoMouseState;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.uimodel.SEDemoUIModel;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.IAttributed;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.MenuUtil;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import edu.cmu.cs.hcii.cogtool.view.ISEDemoView;
import edu.cmu.cs.hcii.cogtool.view.IScriptView;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.SEDemoView;
import edu.cmu.cs.hcii.cogtool.view.SWTListMultiColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SEDemoUI
extends SEDefaultUI
implements ISEDemoUI {
    protected IScript script;
    protected ITask task;
    protected IDesign design;
    protected ISEDemoView view;
    protected SEDemoMouseState seMouseState;
    protected SEDemoSelectionState selection;
    protected SEDemoContextSelectionState contextSelection;
    protected SEDemoInteraction interaction;
    protected SelectionListener lookAtHandler;
    protected SelectionListener handOnMouseHandler;
    protected SelectionListener SWTselectionChangeHandler;
    protected SEDemoUIModel uiModel;

    public SEDemoUI(IScript modelScript, ITask scriptTask, IDesign scriptDesign, IProject scriptProject, UndoManager undoMgr) {
        super(modelScript, scriptTask, scriptDesign, scriptProject, undoMgr);
        this.uiModel = new SEDemoUIModel(modelScript, scriptTask, scriptDesign, scriptProject);
        this.script = modelScript;
        this.task = scriptTask;
        this.design = scriptDesign;
        this.seMouseState = new SEDemoMouseState(this);
        int deviceTypes = DeviceType.buildDeviceSet(this.design.getDeviceTypes());
        this.view = new SEDemoView(deviceTypes, this.lIDMap, this, this.menuData, this.uiModel.getCurrentFrame(), null, this.seMouseState, this, this.getWindowLocation(), this.getUIModel().getScriptUIModel());
        this.setZoomEditor(this.view.getEditor());
        this.view.setHandStartsOnMouse(modelScript.getHandStartsOnMouse());
        Table historyTable = this.view.getHistoryTable();
        this.selection = new SEDemoSelectionState(this.view.getScriptEditorList(), historyTable);
        this.contextSelection = new SEDemoContextSelectionState();
        this.interaction = new SEDemoInteraction(this.getView());
        this.updateTitle();
        historyTable.addListener(35, new Listener(){

            public void handleEvent(Event evt) {
                SEDemoUI.this.showSelectionContextMenu(evt.x, evt.y);
            }
        });
        this.addSelectionChangeListeners();
        this.script.addHandler(this, IScript.ScriptStepChange.class, this.createScriptChangeAlert());
        this.refilterScriptStepList();
        this.selectLastHistoryItem();
        this.setZoom(this.getWindowZoom(this.script));
        this.setInitiallyEnabled();
    }

    public void dispose() {
        this.uiModel.dispose();
        this.task.removeAllHandlers(this);
        this.design.removeAllHandlers(this);
        this.script.removeAllHandlers(this);
        this.selection.removeAllHandlers(this);
        this.view.removeSWTListSelectionHandler(this.SWTselectionChangeHandler);
        this.view.removeLookAtSelectionHandler(this.lookAtHandler);
        this.view.removeHandOnMouseSelectionHandler(this.handOnMouseHandler);
        super.dispose();
    }

    public ISEDemoInteraction getInteraction() {
        return this.interaction;
    }

    public IInteraction getStandardInteraction() {
        return this.interaction;
    }

    public ISEDemoSelectionState getSelection() {
        return this.selection;
    }

    protected void selectLastHistoryItem() {
        this.selection.setSelection(null);
    }

    public IView getView() {
        return this.view;
    }

    protected IScriptView getScriptView() {
        return this.view;
    }

    public SEDemoUIModel getUIModel() {
        return this.uiModel;
    }

    public IGraphicalSource getSourceAtXY(int x, int y) {
        return this.uiModel.getSourceAtXY(x, y);
    }

    public void setLookAtSelected(boolean lookAt) {
        this.view.setLookAtSelected(lookAt);
        this.seMouseState.setLookAt(lookAt);
    }

    public void setCurrentFrame(IFrame frame) {
        if (this.uiModel.setCurrentFrame(frame)) {
            this.view.getEditor().setContents(this.uiModel.getCurrentFrame());
        }
    }

    protected void addSelectionChangeListeners() {
        this.SWTselectionChangeHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SWTListMultiColumn swtList = SEDemoUI.this.view.getScriptEditorList();
                TableItem[] selectedItems = swtList.getSelectionObject();
                for (int i = 0; i < selectedItems.length; ++i) {
                    Object data = selectedItems[i].getData();
                    if (data instanceof IFrame) {
                        SEDemoUI.this.selection.setSelection(null);
                        continue;
                    }
                    IScriptStep sa = (IScriptStep)data;
                    SEDemoUI.this.selection.setSelection(sa);
                }
            }
        };
        this.view.addSWTListSelectionHandler(this.SWTselectionChangeHandler);
        IAlertHandler selectionChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                SEDemoSelectionState.ScriptStepSelectionChange event = (SEDemoSelectionState.ScriptStepSelectionChange)alert;
                if (event != null) {
                    if (event.selected) {
                        IScriptStep sa = event.changedSA;
                        IFrame resultFrame = null;
                        resultFrame = sa != null ? sa.getCurrentFrame() : SEDemoUI.this.script.getResult();
                        SEDemoUI.this.setCurrentFrame(resultFrame);
                    }
                    SEDemoUI.this.setViewEnabledState(SEDemoUI.this.selection, ListenerIdentifierMap.NORMAL);
                }
            }
        };
        this.selection.addHandler(this, SEDemoSelectionState.ScriptStepSelectionChange.class, selectionChangeHandler);
        this.lookAtHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                boolean lookAtSelected = ((Button)evt.getSource()).getSelection();
                SEDemoUI.this.seMouseState.setLookAt(lookAtSelected);
            }
        };
        this.view.addLookAtSelectionHandler(this.lookAtHandler);
        this.handOnMouseHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                SEDemoUI.this.script.setHandStartsOnMouse(SEDemoUI.this.view.getHandStartsOnMouse());
            }
        };
        this.view.addHandOnMouseSelectionHandler(this.handOnMouseHandler);
    }

    protected IAlertHandler createScriptChangeAlert() {
        return new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IScript.ScriptStepChange evt = (IScript.ScriptStepChange)alert;
                switch (evt.action) {
                    case 1: 
                    case 4: {
                        SEDemoUI.this.refilterScriptStepList();
                        int indexOfResult = SEDemoUI.this.script.getScriptSteps().size();
                        int index = evt.index;
                        if (index >= indexOfResult) {
                            SEDemoUI.this.selection.setSelection(null);
                            break;
                        }
                        IScriptStep ss = SEDemoUI.this.script.getScriptStep(index);
                        SEDemoUI.this.selection.setSelection(ss);
                        break;
                    }
                    case 0: 
                    case 3: {
                        SEDemoUI.this.refilterScriptStepList();
                        int indexOfResult = SEDemoUI.this.script.getScriptSteps().size();
                        int index = evt.index + 1;
                        if (index >= indexOfResult) {
                            SEDemoUI.this.selection.setSelection(null);
                            break;
                        }
                        IScriptStep ss = SEDemoUI.this.script.getScriptStep(index);
                        SEDemoUI.this.selection.setSelection(ss);
                        break;
                    }
                    case 2: 
                    case 5: {
                        SEDemoUI.this.script.rebuildScript(false);
                    }
                }
            }
        };
    }

    public void showContextMenu() {
        this.view.showStandardMenu();
    }

    protected void setInitiallyEnabled() {
        super.setInitiallyEnabled();
        this.setEnabled(CogToolLID.ZoomIn, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomOut, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomNormal, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomToFit, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.RecomputeScript, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.Delete, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.Paste, ListenerIdentifierMap.ALL, false);
        this.setEnabled(CogToolLID.ExportScriptToCSV, ListenerIdentifierMap.ALL, true);
    }

    protected void setViewEnabledState(ISEDemoSelectionState selection, Boolean availability) {
        IScriptStep selectedStep = selection.getSelectedStep();
        if (selectedStep != null) {
            if (selectedStep instanceof IThinkScriptStep) {
                this.setEnabled(SEDemoLID.ChangeThinkDuration, availability, true);
            } else {
                this.setEnabled(SEDemoLID.ChangeThinkDuration, availability, false);
            }
            if (selectedStep instanceof IDelayScriptStep) {
                this.setEnabled(SEDemoLID.ChangeWaitDuration, availability, true);
            } else {
                this.setEnabled(SEDemoLID.ChangeWaitDuration, availability, false);
            }
        } else {
            this.setEnabled(SEDemoLID.ChangeWaitDuration, availability, false);
            this.setEnabled(SEDemoLID.ChangeThinkDuration, availability, false);
        }
        this.setEnabled(SEDemoLID.Delete, availability, true);
    }

    public ListenerIdentifier transmute(ListenerIdentifier id, boolean isContextSelection) {
        ListenerIdentifier specificLID = super.transmute(id, isContextSelection);
        if (specificLID != id) {
            return specificLID;
        }
        if (id instanceof SEDemoLID.SEDemoTransitionLID) {
            SEDemoLID.SEDemoTransitionLID demoLID = (SEDemoLID.SEDemoTransitionLID)id;
            if (demoLID.transition instanceof ISEDemoUI.LookAtTransition) {
                return SEDemoLID.InsertLookAt;
            }
            if (demoLID.transition instanceof ISEDemoUI.FreeFormTextTransition) {
                return SEDemoLID.PerformFreeformTextTransition;
            }
            return SEDemoLID.PerformTransition;
        }
        return id;
    }

    public Object getParameters(ListenerIdentifier originalLID, ListenerIdentifier transmutedLID, boolean isContextSelection) {
        if (originalLID instanceof DefaultUI.RestoreParentControllerLID) {
            return super.getParameters(originalLID, transmutedLID, isContextSelection);
        }
        if (originalLID instanceof SEDemoLID.SEDemoTransitionLID) {
            SEDemoLID.SEDemoTransitionLID demoLID = (SEDemoLID.SEDemoTransitionLID)originalLID;
            return demoLID.transition;
        }
        if (isContextSelection) {
            return this.contextSelection;
        }
        return this.selection;
    }

    protected void updateView(ArrayList list) {
        SWTListMultiColumn swtList = this.view.getScriptEditorList();
        swtList.setListContents(list);
    }

    protected void refilterScriptStepList() {
        ArrayList<IAttributed> itemList = new ArrayList<IAttributed>();
        Iterator iter = this.script.getScriptSteps().iterator();
        while (iter.hasNext()) {
            IScriptStep sa = (IScriptStep)iter.next();
            itemList.add(sa);
        }
        itemList.add(this.script.getResult());
        this.updateView(itemList);
    }

    public void showSelectionContextMenu(int x, int y) {
        this.contextSelection.deselectAll();
        Table historyTable = this.view.getHistoryTable();
        Point atPoint = historyTable.toControl(x, y);
        TableItem ti = historyTable.getItem(atPoint);
        if (ti != null && ti.getData() instanceof IScriptStep) {
            this.contextSelection.setSelectedStep((IScriptStep)ti.getData());
        } else {
            historyTable.select(historyTable.getItemCount() - 1);
        }
        this.showContextMenu(this.contextSelection, true);
    }

    protected void showContextMenu(ISEDemoSelectionState selection, boolean context) {
        this.setViewEnabledState(selection, context ? ListenerIdentifierMap.CONTEXT : ListenerIdentifierMap.NORMAL);
        this.view.showScriptStepSelectionMenu();
    }

    protected List populateContextMenu(List graphicalSources) {
        ArrayList<MenuUtil.SimpleMenuItemDefinition> menuItems = new ArrayList<MenuUtil.SimpleMenuItemDefinition>();
        Iterator sources = graphicalSources.iterator();
        if (sources.hasNext()) {
            IGraphicalSource graphicalSource = (IGraphicalSource)sources.next();
            this.populateContextMenu(graphicalSource.getModel(), menuItems);
            while (sources.hasNext()) {
                menuItems.add(MenuUtil.SEPARATOR);
                menuItems.add(MenuUtil.SEPARATOR);
                graphicalSource = (IGraphicalSource)sources.next();
                this.populateContextMenu(graphicalSource.getModel(), menuItems);
            }
        }
        return menuItems;
    }

    protected void populateContextMenu(ITransitionSource source, List menuItems) {
        Collection values = source.getTransitions().values();
        Iterator iter = values.iterator();
        int fakePersistenceValue = 1;
        while (iter.hasNext()) {
            ITransition trans = (ITransition)iter.next();
            ISEDemoUI.FollowTransition ftrans = new ISEDemoUI.FollowTransition(this.selection, source, trans.getAction());
            SEDemoLID.SEDemoTransitionLID itemLID = new SEDemoLID.SEDemoTransitionLID("performDemoTransition", ftrans, fakePersistenceValue++);
            String transitionStr = KeyDisplayUtil.convertActionToMenuText(((ISEDemoUI.DemoTransition)ftrans).getLocalizedString());
            MenuUtil.SimpleMenuItemDefinition mItem = new MenuUtil.SimpleMenuItemDefinition(transitionStr, (ListenerIdentifier)itemLID, true);
            menuItems.add(mItem);
        }
        if (values.size() == 0) {
            MenuUtil.SimpleMenuItemDefinition mItem = new MenuUtil.SimpleMenuItemDefinition(L10N.get("SE.DemoNoPredefinedTransitions", "No defined transitions for ") + source.getName(), null);
            menuItems.add(mItem);
        }
        if (source.getTransitionSourceType() == TransitionSourceType.Widget) {
            IWidget widget = (IWidget)source;
            menuItems.add(MenuUtil.SEPARATOR);
            ISEDemoUI.LookAtTransition lookAtTrans = new ISEDemoUI.LookAtTransition(this.selection, widget);
            String itemLabel = L10N.get("SE.DemoLookAt", "Look at") + " " + widget.getName();
            SEDemoLID.SEDemoTransitionLID itemLID = new SEDemoLID.SEDemoTransitionLID("performDemoLookAtTransition", lookAtTrans, fakePersistenceValue++);
            menuItems.add(new MenuUtil.SimpleMenuItemDefinition(itemLabel, (ListenerIdentifier)itemLID, true));
            if (widget.getWidgetType() == WidgetType.Graffiti || (widget.getWidgetType() == WidgetType.TextBox || widget.getWidgetType() == WidgetType.Text) && this.design.getDeviceTypes().contains(DeviceType.Keyboard)) {
                AAction action = null;
                if (widget.getWidgetType() == WidgetType.Graffiti) {
                    GraffitiAction ga = new GraffitiAction("", false);
                    ga.setIsCommand(false);
                    action = ga;
                } else {
                    action = new KeyAction("", false, 0);
                }
                menuItems.add(MenuUtil.SEPARATOR);
                ISEDemoUI.FreeFormTextTransition freeform = null;
                String freeFormMenuText = "";
                if (widget.getWidgetType() == WidgetType.Graffiti) {
                    freeform = new ISEDemoUI.FreeFormTextTransition(this.selection, widget, action);
                    freeFormMenuText = L10N.get("SE.EnterNewGraffitiText", "Enter New Graffiti\u00ae Text");
                } else if (widget.getWidgetType() == WidgetType.TextBox || widget.getWidgetType() == WidgetType.TextBox) {
                    IFrame currentFrame = this.uiModel.getCurrentFrame().getFrame();
                    IInputDevice d = currentFrame.getInputDevice(DeviceType.Keyboard);
                    freeform = new ISEDemoUI.FreeFormTextTransition(this.selection, d, action);
                    freeFormMenuText = L10N.get("SE.TypeNewText", "Type New Text");
                }
                if (freeform != null) {
                    itemLID = new SEDemoLID.SEDemoTransitionLID("performDemoFreeFormTransition", freeform, fakePersistenceValue++);
                    MenuUtil.SimpleMenuItemDefinition mItem = new MenuUtil.SimpleMenuItemDefinition(freeFormMenuText, (ListenerIdentifier)itemLID, true);
                    menuItems.add(mItem);
                }
            }
        }
    }

    public void showContextMenu(int x, int y) {
        if (this.uiModel.getCurrentFrame() != null) {
            List sources = this.uiModel.getSourcesAtXY(x, y);
            if (sources == null || sources.size() == 0) {
                this.view.showStandardMenu();
            } else {
                List menuItems = this.populateContextMenu(sources);
                this.view.showDynamicMenu(menuItems);
            }
        }
    }

    public void hideAllMenuItems() {
        DesignEditorFrame frameFig = this.uiModel.getCurrentFrame();
        if (frameFig != null) {
            frameFig.hideAllMenuItems();
        }
    }
}

