/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IScriptStep;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoSelectionState;
import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.view.SWTListMultiColumn;
import java.util.EventObject;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SEDemoSelectionState
extends Alerter
implements ISEDemoSelectionState {
    protected ScriptStepSelectionChange scriptChangeAlert = new ScriptStepSelectionChange(this, false);
    protected SWTListMultiColumn swtList;
    protected Table table;

    public SEDemoSelectionState(SWTListMultiColumn demoSWTList, Table t) {
        this.swtList = demoSWTList;
        this.table = t;
    }

    public void setSelection(IScriptStep sa) {
        if (sa == null) {
            this.swtList.setListItemHighlighted(this.table.getItemCount() - 1);
        } else {
            this.swtList.setListItemHighlighted(sa);
        }
        this.scriptChangeAlert.changedSA = sa;
        this.scriptChangeAlert.selected = true;
        this.raiseAlert(this.scriptChangeAlert);
    }

    public IScriptStep getSelectedStep() {
        Object result;
        TableItem[] items = this.table.getSelection();
        if (items.length > 1) {
            throw new UnsupportedOperationException("Cannot support multi-selection of ScriptSteps");
        }
        if (items.length == 1 && (result = items[0].getData()) instanceof IScriptStep) {
            return (IScriptStep)result;
        }
        return null;
    }

    public boolean isSelected(IScriptStep sa) {
        TableItem[] items = this.table.getSelection();
        for (int i = 0; i < items.length; ++i) {
            IScriptStep saItem = (IScriptStep)items[i].getData();
            if (!saItem.equals(sa)) continue;
            return true;
        }
        return false;
    }

    public boolean isResultFrameSelected() {
        int itemCount = this.table.getItemCount() - 1;
        return itemCount == this.table.getSelectionIndex();
    }

    public void deselectAll() {
        this.scriptChangeAlert.changedSA = this.getSelectedStep();
        this.scriptChangeAlert.selected = false;
        this.table.deselectAll();
        this.raiseAlert(this.scriptChangeAlert);
    }

    public static class ScriptStepSelectionChange
    extends EventObject {
        public boolean selected;
        public IScriptStep changedSA = null;

        public ScriptStepSelectionChange(SEDemoSelectionState source, boolean sel) {
            super(source);
            this.selected = sel;
        }

        public ScriptStepSelectionChange(SEDemoSelectionState source, IScriptStep step, boolean sel) {
            this(source, sel);
            this.changedSA = step;
        }
    }
}

