/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.AAction;
import edu.cmu.cs.hcii.cogtool.model.ActionType;
import edu.cmu.cs.hcii.cogtool.model.ButtonAction;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.TapAction;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.ui.ADraw2DMouseState;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoUI;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoLID;
import edu.cmu.cs.hcii.cogtool.ui.SEDemoUI;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuHeader;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuItem;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalSource;
import edu.cmu.cs.hcii.cogtool.util.Draw2DContextMenuUtil;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.draw2d.IFigure;

public class SEDemoMouseState
extends ADraw2DMouseState {
    public static final int MouseUp = 0;
    public static final int PotentialFollowTransition = 0;
    protected static final int DOWN = 0;
    protected static final int UP = 1;
    protected static final int CLICK = 2;
    protected static final int DOUBLE = 3;
    protected boolean mouseDown = false;
    protected int mouseDownX = 0;
    protected int mouseDownY = 0;
    protected double scaledMouseDownX = 0.0;
    protected double scaledMouseDownY = 0.0;
    protected int mouseListenerState = 0;
    protected boolean lookAt = false;
    protected IGraphicalSource transitionSourceFig = null;
    protected SEDemoUI ui;

    public SEDemoMouseState(SEDemoUI seDemoUI) {
        super(seDemoUI);
        this.ui = seDemoUI;
    }

    public void mousePressed(IFigure figure, int button, int x, int y, int state) {
        super.mousePressed(figure, button, x, y, state);
        if (button == 1) {
            this.setMouseDown(x, y);
            IGraphicalSource sourceFig = this.ui.getSourceAtXY(x, y);
            switch (this.getMouseState()) {
                case 0: {
                    if (sourceFig != null) {
                        this.transitionSourceFig = sourceFig;
                        this.setMouseState(0);
                        this.doTransitionAction(this.transitionSourceFig.getModel(), button, state, 0);
                        break;
                    }
                    this.transitionSourceFig = null;
                    break;
                }
            }
        }
    }

    public void mouseReleased(IFigure figure, int button, int x, int y, int state) {
        block12: {
            IGraphicalSource sourceFig;
            block11: {
                super.mouseReleased(figure, button, x, y, state);
                sourceFig = this.ui.getSourceAtXY(x, y);
                if (!Draw2DContextMenuUtil.isContextMenu(button, state)) {
                    this.ui.hideAllMenuItems();
                }
                if (Math.abs(x - this.mouseDownX) > 1 || Math.abs(y - this.mouseDownY) > 1) break block11;
                switch (this.getMouseState()) {
                    case 0: {
                        if (sourceFig instanceof IGraphicalMenuHeader || sourceFig instanceof IGraphicalMenuItem && ((IGraphicalMenuItem)sourceFig).isSubmenu()) {
                            ((IGraphicalMenuWidget)sourceFig).openMenu();
                            break;
                        }
                        if (this.transitionSourceFig == null) {
                            this.transitionSourceFig = this.ui.getSourceAtXY(x, y);
                            if (this.transitionSourceFig != null) {
                                ITransitionSource source = this.transitionSourceFig.getModel();
                                this.doTransitionAction(source, button, state, 1);
                                break;
                            }
                        } else if (this.transitionSourceFig != null) {
                            ITransitionSource source = this.transitionSourceFig.getModel();
                            this.doTransitionAction(source, button, state, 1);
                            if (this.lookAt) {
                                this.doLookAtAction(source);
                                break;
                            }
                            this.doTransitionAction(source, button, state, 2);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block12;
            }
            if (sourceFig != null) {
                this.doTransitionAction(sourceFig.getModel(), button, state, 1);
            }
        }
        this.setMouseState(0);
        this.mouseDown = false;
    }

    public void mouseDoubleClicked(IFigure figure, int button, int x, int y, int state) {
        block6: {
            block5: {
                if (Math.abs(x - this.mouseDownX) > 1 || Math.abs(y - this.mouseDownY) > 1) break block5;
                switch (this.getMouseState()) {
                    case 0: {
                        if (this.transitionSourceFig != null) {
                            this.doTransitionAction(this.transitionSourceFig.getModel(), button, state, 3);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block6;
            }
            IGraphicalSource sourceFig = this.ui.getSourceAtXY(x, y);
            if (sourceFig != null) {
                this.doTransitionAction(sourceFig.getModel(), button, state, 3);
            }
        }
        this.mouseDown = false;
        this.setMouseState(0);
    }

    protected void doLookAtAction(ITransitionSource source) {
        ISEDemoUI.LookAtTransition prms = new ISEDemoUI.LookAtTransition(this.ui.selection, source);
        this.ui.performAction((ListenerIdentifier)SEDemoLID.InsertLookAt, prms);
    }

    protected void doTransitionAction(ITransitionSource source, int button, int state, int clickState) {
        AAction action = null;
        Set deviceTypes = this.ui.design.getDeviceTypes();
        if (deviceTypes.contains(DeviceType.Mouse)) {
            MousePressType pt = null;
            switch (clickState) {
                case 1: {
                    pt = MousePressType.Up;
                    break;
                }
                case 0: {
                    pt = MousePressType.Down;
                    break;
                }
                case 2: {
                    pt = MousePressType.Click;
                    break;
                }
                case 3: {
                    pt = MousePressType.Double;
                    break;
                }
                default: {
                    throw new InvalidParameterException("Invalid click state recieved");
                }
            }
            action = new ButtonAction(this.getActionButtonButton(button), pt, this.getActionButtonModifier(state));
        } else if (deviceTypes.contains(DeviceType.Touchscreen)) {
            TapPressType tt = null;
            switch (clickState) {
                case 1: {
                    tt = TapPressType.Up;
                    break;
                }
                case 0: {
                    tt = TapPressType.Down;
                    break;
                }
                case 2: {
                    tt = TapPressType.Tap;
                    break;
                }
                case 3: {
                    tt = TapPressType.DoubleTap;
                    break;
                }
                default: {
                    throw new InvalidParameterException("Invalid ClickState recieved");
                }
            }
            action = new TapAction(tt);
        }
        if (clickState == 2 && source.getTransition(action) == null) {
            Set keys = source.getTransitions().keySet();
            Iterator iter = keys.iterator();
            ArrayList<IAction> actions = new ArrayList<IAction>();
            boolean hasDouble = false;
            while (iter.hasNext()) {
                IAction act = (IAction)iter.next();
                actions.add(act);
                if (act.getType() == ActionType.ButtonPress && deviceTypes.contains(DeviceType.Mouse)) {
                    hasDouble = true;
                    continue;
                }
                if (act.getType() != ActionType.Tap || !deviceTypes.contains(DeviceType.Touchscreen)) continue;
                hasDouble = true;
            }
            if (!hasDouble) {
                this.ui.interaction.informUserOfAvailableActions(actions);
            }
        }
        this.doTransitionAction(source, action);
    }

    protected void doTransitionAction(ITransitionSource source, IAction action) {
        ISEDemoUI.FollowTransition prms = new ISEDemoUI.FollowTransition(this.ui.selection, source, action);
        this.ui.performAction((ListenerIdentifier)SEDemoLID.PerformTransition, prms);
    }

    protected void setMouseDown(int x, int y) {
        this.mouseDown = true;
        this.mouseDownX = x;
        this.mouseDownY = y;
        double zoom = this.ui.getZoom();
        this.scaledMouseDownX = (double)x / zoom;
        this.scaledMouseDownY = (double)y / zoom;
    }

    public void setMouseState(int newState) {
        this.mouseListenerState = newState;
    }

    public int getMouseState() {
        return this.mouseListenerState;
    }

    protected MouseButtonState getActionButtonButton(int mouseEventButton) {
        if (mouseEventButton == 1) {
            return MouseButtonState.Left;
        }
        if (mouseEventButton == 2) {
            return MouseButtonState.Middle;
        }
        if (mouseEventButton == 3) {
            return MouseButtonState.Right;
        }
        throw new UnsupportedOperationException("Unsupported mouse button");
    }

    protected int getActionButtonModifier(int mouseEventModifier) {
        int result = 0;
        if ((mouseEventModifier & 0x20000) > 0) {
            result |= 1;
        }
        if ((mouseEventModifier & 0x10000) > 0) {
            result |= 4;
        }
        if ((mouseEventModifier & 0x40000) > 0) {
            result |= 2;
        }
        return result;
    }

    protected void setLookAt(boolean look) {
        this.lookAt = look;
    }

    protected boolean getLookAt() {
        return this.lookAt;
    }
}

