/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.ui.DefaultInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ISEDemoInteraction;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.IView;
import java.util.ArrayList;
import java.util.Iterator;

public class SEDemoInteraction
extends DefaultInteraction
implements ISEDemoInteraction {
    protected static final String confirmDeleteScriptStepMsg = L10N.get("SED.confirmDeleteScriptStep", "Deleting this step, will cause all subsequent steps to be deleted");
    protected static final String confirmDestructiveInsertScriptStepMsg = L10N.get("SED.confirmDestructiveInsertScriptStep", "Inserting this Script Step after the currently selected history step will delete all subsequent steps.");
    protected static final String confirmDeletionTitle = L10N.get("SED.ConfirmDeletionTitle", "Confirm Deletion");
    protected static final String confirmInsertionTitle = L10N.get("SED.ConfirmInsertionTitle", "Confirm Insertion");
    protected static final String emptyThinkDurationMsg = L10N.get("SED.protestEmptyThinkDuration", "A non empty think duration is required.");
    protected static final String nonNumericThinkDurationMsg = L10N.get("SED.protestNonNumericThinkDuration", "A numeric think duration is required.");
    protected static final String invalidLookAtTargetMsg = L10N.get("SED.invalidLookAtTargetMsg", "A Widget is required as a target for a look-at operation.");
    protected static final String emptyDelayDurationMsg = L10N.get("SED.protestEmptyDelayDuration", "A non empty delay duration is required.");
    protected static final String nonNumericDelayDurationMsg = L10N.get("SED.protestNonNumericDelayDuration", "A numeric delay duration is required.");
    protected static final String negativeZeroThinkDurationMsg = L10N.get("SED.protestNegativeZeroThinkDuration", "A numeric think duration greater then zero is required.");
    protected static final String negativeZeroDelayDurationMsg = L10N.get("SED.protestNegativeZeroDelayDuration", "A numeric delay duration greater then zero is required.");
    protected static final String invalidAttemptedAction = L10N.get("SED.invalidAttemptedAction", "The action you attempted is not in the list defined by this widget.");
    protected static final String errorTitle = L10N.get("SED.ErrorTitle", "Script Demo Error");
    protected static final String autoRepositionDelayTitle = L10N.get("SED.AutomaticRepositionDelay", "Automatic Reposition of Inserted Delay");
    protected static final String autoRepositionDelayDetails = L10N.get("SED.AutomaticRepositionDelayDetails", "You have asked for a system delay to be inserted after a Think step. This will cause the underlying cognitive engine to do the complete the Think step before starting to implement the system delay. Since people can think while they are waiting for a long system delay, this is usually an invalid model, but there may be obscure circumstances under which this ordering is indeed correct. \n\nIf you select 'yes' to the question below, the system delay will be repositioned to before the Think step, so thinking can be done while waiting. (Recommended)\nIf you select 'no', the system delay will remain after the Think step and thinking and waiting will be done in sequence. (Not recommended)\nIf you select Cancel, the delay will not be inserted at all.\n\nDo you want CogTool to reposition the Wait for System Delay to be before the Think step, so thinking can be done in parallel with waiting?");
    protected static final String autoRepositionThinkTitle = L10N.get("SED.AutomaticRepositionThink", "Automatic Reposition of Inserted Think");
    protected static final String autoRepositionThinkDetails = L10N.get("SED.AutomaticRepositionThinkDetails", "You have asked for a Think step to be inserted after a system delay. This will cause the underlying cognitive engine to do the complete the Think step before starting to implement the system delay. Since people can think while they are waiting for a long system delay, this is usually an invalid model, but there may be obscure circumstances under which this ordering is indeed correct. \n\nIf you select 'yes' to the question below, the think step will be repositioned to after the system delay, so thinking can be done while waiting. (Recommended)\nIf you select 'no', the Think step will remain before the system delay and thinking and waiting will be done in sequence. (Not recommended)\nIf you select Cancel, the Think step will not be inserted at all.\n\nDo you want CogTool to reposition the Think step to be after the Wait for System Delay, so thinking can be done in parallel with waiting?");
    protected static final String noAvailableActions = L10N.get("SED.NoAvailableActions", "No available actions.");
    protected static final String availableActionsAre = L10N.get("SED.AvailableActionsAre", "The list of available actions are:");
    protected static final String useContextMenu = L10N.get("SED.UseContextMenu", "To access these actions, use the context menu.");

    public SEDemoInteraction(IView view) {
        super(view);
    }

    public boolean confirmDeleteScriptStep() {
        String msg = confirmDeleteScriptStepMsg;
        return 32 == WindowUtil.presentConfirmDialog(this.window, confirmDeletionTitle, msg);
    }

    public boolean confirmDestructiveInsert() {
        String msg = confirmDestructiveInsertScriptStepMsg;
        return 32 == WindowUtil.presentConfirmDialog(this.window, confirmInsertionTitle, msg);
    }

    public String requestNewThinkDuration(String defaultThinkTime) {
        WindowUtil.PromptDialog askName = new WindowUtil.PromptDialog(this.window, L10N.get("SED.NewThinkDuration", "Think Duration"), 32768, L10N.get("SED.ThinkDuration", "Think Duration (seconds): "), L10N.get("SED.AskNewThinkDuration", "What is the duration of this thinking time?"), defaultThinkTime);
        Object response = askName.open();
        return response != null && response.equals("OK") ? askName.getPromptResponse() : null;
    }

    public boolean protestNonNumericThinkDuration() {
        return this.reportAndRetry(errorTitle, nonNumericThinkDurationMsg);
    }

    public boolean protestEmptyThinkDuration() {
        return this.reportAndRetry(errorTitle, emptyThinkDurationMsg);
    }

    public String requestNewDelayDuration(String defaultDelayTime) {
        WindowUtil.PromptDialog delayTime = new WindowUtil.PromptDialog(this.window, L10N.get("SED.WaitForSystemTitle", "Wait Duration"), 32768, L10N.get("SED.WaitForSystemLabel", "Wait Duration (seconds): "), L10N.get("SED.WaitForSystemDesc", "How long will the user wait for the system?"), defaultDelayTime);
        Object response = delayTime.open();
        return response != null && response.equals("OK") ? delayTime.getPromptResponse() : null;
    }

    public boolean protestZeroNegativeThinkDuration() {
        return this.reportAndRetry(errorTitle, negativeZeroThinkDurationMsg);
    }

    public boolean protestZeroNegativeDelayDuration() {
        return this.reportAndRetry(errorTitle, negativeZeroDelayDurationMsg);
    }

    public boolean protestEmptyDelayDuration() {
        return this.reportAndRetry(errorTitle, emptyDelayDurationMsg);
    }

    public boolean protestInvalidLookAtTarget() {
        return this.reportAndRetry(errorTitle, invalidLookAtTargetMsg);
    }

    public boolean protestNonNumericDelayDuration() {
        return this.reportAndRetry(errorTitle, nonNumericDelayDurationMsg);
    }

    public String requestFreeFormGraffiti() {
        WindowUtil.PromptDialog askName = new WindowUtil.PromptDialog(this.window, L10N.get("SED.GraffitiTextTitle", "Graffiti\u00ae Text"), 32768, L10N.get("SED.GraffitiTextLabel", "Graffiti\u00ae Text:"), L10N.get("SED.GraffitiTextDesc", "What text will the user enter via Graffiti\u00ae?"), "");
        Object response = askName.open();
        return response != null && response.equals("OK") ? askName.getPromptResponse() : null;
    }

    public String requestFreeFormText() {
        WindowUtil.PromptDialog askName = new WindowUtil.PromptDialog(this.window, L10N.get("SED.KeyboardTextTitle", "Keyboard Text"), 32768, L10N.get("SED.KeyboardTextLabel", "Keyboard Text:"), L10N.get("SED.KeyboardTextDesc", "What text will the user type?"), "");
        Object response = askName.open();
        return response != null && response.equals("OK") ? askName.getPromptResponse() : null;
    }

    public void informUserOfAvailableActions(ArrayList actions) {
        String msg = invalidAttemptedAction;
        if (actions.size() == 0) {
            msg = msg + "\n" + noAvailableActions;
        } else {
            msg = msg + "\n\n" + availableActionsAre;
            Iterator iter = actions.iterator();
            while (iter.hasNext()) {
                String actionStr = ((IAction)iter.next()).getLocalizedString();
                msg = msg + "\n" + KeyDisplayUtil.convertActionToMenuText(actionStr);
            }
            msg = msg + "\n\n" + useContextMenu;
        }
        this.reportProblem(errorTitle, msg);
    }

    public Boolean confirmNewDelayLocation() {
        int result = WindowUtil.presentYesNoCancelDialog(this.window, autoRepositionDelayTitle, autoRepositionDelayDetails);
        switch (result) {
            case 64: {
                return Boolean.TRUE;
            }
            case 128: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Boolean confirmNewThinkLocation() {
        int result = WindowUtil.presentYesNoCancelDialog(this.window, autoRepositionThinkTitle, autoRepositionThinkDetails);
        switch (result) {
            case 64: {
                return Boolean.TRUE;
            }
            case 128: {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

