/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.model.ITaskGroup;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.ListChange;
import edu.cmu.cs.hcii.cogtool.ui.ZoomableUI;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import edu.cmu.cs.hcii.cogtool.view.UndoManagerView;
import java.util.EventObject;
import java.util.Iterator;

public abstract class SEDefaultUI
extends ZoomableUI {
    protected UndoManager undoManager;
    protected IScript script;
    protected ITask task;
    protected IDesign design;
    protected static final String SCRIPT_PREFIX = L10N.get("WT.ScriptPrefix", "Script");
    static /* synthetic */ Class class$edu$cmu$cs$hcii$cogtool$model$ITaskGroup$TaskChange;

    protected static String buildWindowMenuLabel(IDesign design, ITask task) {
        return SCRIPT_PREFIX + ": " + design.getName() + " > " + task.getName();
    }

    public SEDefaultUI(IScript modelScript, ITask scriptTask, IDesign scriptDesign, IProject scriptProject, UndoManager undoMgr) {
        super(scriptProject, SEDefaultUI.buildWindowMenuLabel(scriptDesign, scriptTask), SEDefaultUI.buildLeadItems(scriptProject, scriptDesign));
        if (undoMgr == null) {
            throw new IllegalArgumentException("Cannot create a SEFrameChooserUI with a null Undo Manager");
        }
        this.script = modelScript;
        this.task = scriptTask;
        this.design = scriptDesign;
        this.task.addHandler(this, NameChangeAlert.class, this.renameHandler);
        this.design.addHandler(this, NameChangeAlert.class, this.renameHandler);
        this.undoManager = undoMgr;
        UndoManagerView.UndoAlertHandler undoMgrViewHandler = new UndoManagerView.UndoAlertHandler(this.undoManager, this.lIDMap, CogToolLID.Undo, CogToolLID.Redo);
        undoMgr.addHandler(this, EventObject.class, undoMgrViewHandler);
        IAlertHandler closeIfContextRemovedHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                ListChange chg = (ListChange)alert;
                if (!(chg.isAdd || chg.element != SEDefaultUI.this.design && chg.element != SEDefaultUI.this.task)) {
                    SEDefaultUI.this.closeOpenController();
                }
            }
        };
        this.project.addHandler(this, IProject.DesignChange.class, closeIfContextRemovedHandler);
        this.project.addHandler(this, IProject.TaskChange.class, closeIfContextRemovedHandler);
        this.addCloseIfTaskRemoved(this.project.getUndertakings().iterator(), closeIfContextRemovedHandler);
    }

    protected void addCloseIfTaskRemoved(Iterator undertakings, IAlertHandler closeIfTaskRemovedHandler) {
        while (undertakings.hasNext()) {
            IUndertaking undertaking = (IUndertaking)undertakings.next();
            if (!undertaking.isGroup()) continue;
            ITaskGroup taskGroup = (ITaskGroup)undertaking;
            taskGroup.addHandler(this, class$edu$cmu$cs$hcii$cogtool$model$ITaskGroup$TaskChange == null ? SEDefaultUI.class$("edu.cmu.cs.hcii.cogtool.model.ITaskGroup$TaskChange") : class$edu$cmu$cs$hcii$cogtool$model$ITaskGroup$TaskChange, closeIfTaskRemovedHandler);
            Iterator childUndertakings = taskGroup.getUndertakings().iterator();
            this.addCloseIfTaskRemoved(childUndertakings, closeIfTaskRemovedHandler);
        }
    }

    protected void updateTitle() {
        this.getView().setWindowTitle(this.modificationFlag + SCRIPT_PREFIX + ": " + this.project.getName() + " > " + this.design.getName() + " > " + this.task.getName() + (OSUtils.MACOSX ? "" : WINDOW_TITLE));
    }

    protected String buildWindowMenuLabel() {
        return SEDefaultUI.buildWindowMenuLabel(this.design, this.task);
    }

    protected Object getModelObject() {
        return this.script;
    }

    protected void removeTaskGroupHandlers(Iterator undertakings) {
        while (undertakings.hasNext()) {
            IUndertaking undertaking = (IUndertaking)undertakings.next();
            if (!undertaking.isGroup()) continue;
            ((ITaskGroup)undertaking).removeAllHandlers(this);
        }
    }

    public void dispose() {
        this.removeTaskGroupHandlers(this.project.getUndertakings().iterator());
        this.task.removeAllHandlers(this);
        this.design.removeAllHandlers(this);
        this.undoManager.removeAllHandlers(this);
        super.dispose();
    }
}

