/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.RcvrCogModelException;
import edu.cmu.cs.hcii.cogtool.util.RcvrComputationException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOLoadException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOSaveException;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOTempException;
import edu.cmu.cs.hcii.cogtool.util.RcvrImageException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import edu.cmu.cs.hcii.cogtool.util.RcvrUnimplementedFnException;
import edu.cmu.cs.hcii.cogtool.util.RcvrWorkThreadException;
import edu.cmu.cs.hcii.cogtool.util.RecoverableException;

public class RcvrExceptionHandler {
    public static String IO_SAVE_EXC_TITLE = L10N.get("ERR.IOSaveExcTitle", "File Error");
    public static String IO_SAVE_EXC_DESC = L10N.get("ERR.IOSaveExcDesc", "CogTool could not save the file to the location you specfied.  Please choose a different file name or try again.");
    public static String IO_LOAD_EXC_TITLE = L10N.get("ERR.IOLoadExcTitle", "File Error");
    public static String IO_LOAD_EXC_DESC = L10N.get("ERR.IOLoadExcDesc", "CogTool could not read the file you specified.  The file could be  unavailable, corrupt, or simply not a type of file that CogTool supports. Please choose a different file or try again.");
    public static String IO_TEMP_EXC_TITLE = L10N.get("ERR.IOTempExcTitle", "File Error");
    public static String IO_TEMP_EXC_DESC = L10N.get("ERR.IOTempExcDesc", "CogTool occasionally has to create temporary files on your hard drive in order to function properly.  We encountered an error while working with these temporary files.  Please check your file system for problems.");
    public static String IO_EXC_TITLE = L10N.get("ERR.IOExcTitle", "File Error");
    public static String IO_EXC_DESC = L10N.get("ERR.IOExcDesc", "CogTool could not read or write to the file or directory you specified.  The  file could be mising, busy or corrupted. Please choose a different file or try again.");
    public static String UI_EXC_TITLE = L10N.get("ERR.UIExcTitle", "User Interface Error");
    public static String UI_EXC_DESC = L10N.get("ERR.UIExcDesc", "CogTool's user interface components did not respond as expected.  Please save your work if possible and restart CogTool immediately.  If you encounter this problem more than once, contact the CogTool development team.");
    public static String UNIMP_EXC_TITLE = L10N.get("ERR.UnimpExcTitle", "Unimplemented Functionality");
    public static String UNIMP_EXC_DESC = L10N.get("ERR.UnimpExcDesc", "You have attempted an action that CogTool does not currently support, although we may in the future.  Please bear with us as we extend CogTool's capabilities.");
    public static String COMPUTE_EXC_TITLE = L10N.get("ERR.ComputeExcTitle", "Computation Error");
    public static String COMPUTE_EXC_DESC = L10N.get("ERR.ComputeExcDesc", "CogTool encountered an error while attempting to compute a task time prediction.  This could be due to communication problems between CogTool and the currently selected cognitive model, or it could be the result of problems in your script.  Try redemonstrating your script and then recomputing.  Contact the CogTool developers if this problem persists.");
    public static String COG_MOD_EXC_TITLE = L10N.get("ERR.CogModExcTitle", "Impossible Model Error");
    public static String COG_MOD_EXC_DESC = L10N.get("ERR.CogModExcDesc", "You have just specified an action that CogTool does not allow.  This could be due to requirements specified by the underlying cognitive model.  For example, in many cases a Menu Item cannot be clicked on unless a Menu Header has been clicked on first. Please specify a different action. ");
    public static String IMG_EXC_TITLE = L10N.get("ERR.ImageExcTitle", "Image Error");
    public static String IMG_EXC_DESC = L10N.get("ERR.ImageExcDesc", "CogTool has encountered an image error.");
    public static String THREAD_EXC_TITLE = L10N.get("ERR.ThreadExcTitle", "Thread Error");
    public static String THREAD_EXC_DESC = L10N.get("ERR.ThreadExcDesc", "CogTool has encountered an error while executing your requested operation in a child thread.  Your data should be unaffected.  Try saving your data, restarting CogTool,and attempting the operation again.  If this also fails, please contact the CogTool development team.");
    public static String RCVR_EXC_TITLE = L10N.get("ERR.ImageExcTitle", "Recoverable Error");
    public static String RCVR_EXC_DESC = L10N.get("ERR.ImageExcDesc", "CogTool has encountered an error that caused the requested operation to fail. Your data should be unaffected.  Try saving your data, restarting CogTool, and attempting the operation again. If this fails, please contact the CogTool development team.");

    private void RCVRExceptionHandler() {
    }

    public static void recover(RecoverableException ex, IInteraction interaction) {
        ex.printStackTrace();
        if (ex instanceof RcvrIOSaveException) {
            interaction.reportException(IO_SAVE_EXC_TITLE, IO_SAVE_EXC_DESC, ex);
        } else if (ex instanceof RcvrIOLoadException) {
            interaction.reportException(IO_LOAD_EXC_TITLE, IO_LOAD_EXC_DESC, ex);
        } else if (ex instanceof RcvrIOTempException) {
            interaction.reportException(IO_TEMP_EXC_TITLE, IO_TEMP_EXC_DESC, ex);
        } else if (ex instanceof RcvrIOException) {
            interaction.reportException(IO_EXC_TITLE, IO_EXC_DESC, ex);
        } else if (ex instanceof RcvrUIException) {
            interaction.reportException(UI_EXC_TITLE, UI_EXC_DESC, ex);
        } else if (ex instanceof RcvrUnimplementedFnException) {
            interaction.reportException(UNIMP_EXC_TITLE, UNIMP_EXC_DESC, ex);
        } else if (ex instanceof RcvrComputationException) {
            interaction.reportException(COMPUTE_EXC_TITLE, COG_MOD_EXC_DESC, ex);
        } else if (ex instanceof RcvrCogModelException) {
            interaction.reportException(COG_MOD_EXC_TITLE, COG_MOD_EXC_DESC, ex);
        } else if (ex instanceof RcvrImageException) {
            interaction.reportException(IMG_EXC_TITLE, IMG_EXC_DESC, ex);
        } else if (ex instanceof RcvrWorkThreadException) {
            interaction.reportException(THREAD_EXC_TITLE, THREAD_EXC_DESC, ex);
        } else {
            interaction.reportException(RCVR_EXC_TITLE, RCVR_EXC_DESC, ex);
        }
    }
}

