/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.GroupNature;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IPredictionResult;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.model.ITaskGroup;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.model.StandaloneAlgo;
import edu.cmu.cs.hcii.cogtool.ui.DefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.DelayedSelection;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IProjectInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IProjectUI;
import edu.cmu.cs.hcii.cogtool.ui.ProjectContextSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ProjectInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ProjectLID;
import edu.cmu.cs.hcii.cogtool.ui.ProjectMouseState;
import edu.cmu.cs.hcii.cogtool.ui.ProjectSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.SingleDesignSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.ProjectUIModel;
import edu.cmu.cs.hcii.cogtool.util.GraphicsUtil;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.SWTContextMenuUtil;
import edu.cmu.cs.hcii.cogtool.util.TextWithEnableFix;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.IProjectView;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.ProjectView;
import edu.cmu.cs.hcii.cogtool.view.UndoManagerView;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProjectUI
extends DefaultUI
implements IProjectUI,
ProjectUIModel.TreeRowHook,
ProjectUIModel.TreeColumnHook {
    protected int treeOperationOccurred = 0;
    protected Tree tree;
    protected Rectangle overBox = null;
    static ImageData grayTransparent = new ImageData(1, 1, 1, new PaletteData(new RGB[]{new RGB(120, 120, 150)}));
    protected IProjectInteraction interaction;
    protected IProjectView view;
    protected ProjectSelectionState selection;
    protected ProjectContextSelectionState contextSelection;
    protected TreeEditor editor;
    protected SelectionListener taskSelectListener = null;
    protected UndoManager undoManager;
    protected ProjectUIModel uiModel;
    protected Listener columnSelectionListener = new Listener(){

        public void handleEvent(Event evt) {
            if (evt.widget.getData() == null) {
                ProjectUI.this.selection.selectAllTasks();
            } else {
                ProjectUI.this.selection.setSelectedColumn((TreeColumn)evt.widget);
            }
        }
    };
    protected Listener columnDefaultSelectionListener = new Listener(){

        public void handleEvent(Event evt) {
            TreeColumn col = (TreeColumn)evt.widget;
            if (col.getData() != null) {
                SingleDesignSelectionState seln = new SingleDesignSelectionState((IDesign)col.getData());
                ProjectUI.this.performAction((ListenerIdentifier)ProjectLID.EditDesign, seln);
            }
        }
    };
    protected ControlAdapter onResizeColumn = new ControlAdapter(){

        public void controlResized(ControlEvent arg0) {
        }
    };
    protected DelayedSelection delayedTaskSelection;
    protected DelayedSelection delayedDesignSelection;
    protected static final String PROJECT_PREFIX = L10N.get("WT.ProjectPrefix", "Project");

    protected static String buildWindowMenuLabel(IProject project) {
        return PROJECT_PREFIX + ": " + project.getName();
    }

    public ProjectUI(IProject proj, UndoManager undoMgr) {
        super(proj, ProjectUI.buildWindowMenuLabel(proj), ProjectUI.buildLeadItems());
        TreeItem showItem;
        this.view = new ProjectView(this.lIDMap, this, this.menuData, this.getWindowLocation());
        this.tree = this.view.getTree();
        this.selection = new ProjectSelectionState(this.tree);
        this.contextSelection = new ProjectContextSelectionState();
        this.delayedTaskSelection = new DelayedSelection(this.selection){

            protected void selectItem(Object item) {
                ProjectUI.this.selection.addSelectedItem((TreeItem)item);
            }
        };
        this.delayedDesignSelection = new DelayedSelection(this.selection){

            protected void selectItem(Object item) {
                ProjectUI.this.selection.addSelectedColumn((TreeColumn)item);
            }
        };
        CogTool.selectionPhase.addDelayedWork(this.delayedTaskSelection);
        CogTool.selectionPhase.addDelayedWork(this.delayedDesignSelection);
        this.uiModel = new ProjectUIModel(proj, this.tree, this, this);
        this.updateTitle();
        this.editor = new TreeEditor(this.tree);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.tree.addTreeListener(new TreeListener(){

            private void setTimer() {
                ++ProjectUI.this.treeOperationOccurred;
                WindowUtil.globalDisplay.timerExec(500, (Runnable)new TreeOpTimer());
            }

            public void treeCollapsed(TreeEvent evt) {
                this.setTimer();
            }

            public void treeExpanded(TreeEvent evt) {
                this.setTimer();
            }
        });
        IAlertHandler selectionChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject evt) {
                ProjectSelectionState.ProjectSelectionChange chg = (ProjectSelectionState.ProjectSelectionChange)evt;
                if (ProjectUI.this.editor.getEditor() != null) {
                    ProjectUI.this.commitRenameTask();
                }
                if (chg.designColumn != -1) {
                    ProjectUI.this.uiModel.recolorTree(chg.designColumn, chg.selected);
                }
                ProjectUI.this.tree.redraw();
                ProjectUI.this.setViewEnabledState(ProjectUI.this.selection, ListenerIdentifierMap.NORMAL);
            }
        };
        this.selection.addHandler(this, ProjectSelectionState.ProjectSelectionChange.class, selectionChangeHandler);
        this.tree.addListener(9, this.createHighlightColumnPaintListener());
        this.taskSelectListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int i;
                TreeItem[] sel = ProjectUI.this.tree.getSelection();
                if (sel.length == 0 && ProjectUI.this.selection.getSelectedTaskCount() == 0) {
                    return;
                }
                boolean selectionChanged = false;
                if (sel.length != ProjectUI.this.selection.getSelectedTaskCount()) {
                    selectionChanged = true;
                } else {
                    for (i = 0; i < sel.length; ++i) {
                        IUndertaking task = (IUndertaking)sel[i].getData();
                        if (ProjectUI.this.selection.isTaskSelected(task)) continue;
                        selectionChanged = true;
                        break;
                    }
                }
                if (selectionChanged) {
                    ProjectUI.this.selection.deselectAll();
                    for (i = 0; i < sel.length; ++i) {
                        ProjectUI.this.selection.addSelectedItem(sel[i]);
                    }
                    ProjectUI.this.setViewEnabledState(ProjectUI.this.selection, ListenerIdentifierMap.NORMAL);
                }
            }
        };
        this.tree.addSelectionListener(this.taskSelectListener);
        this.tree.deselectAll();
        TreeColumn col = this.tree.getColumn(0);
        col.setWidth(250);
        this.interaction = new ProjectInteraction(this.view);
        grayTransparent.setAlpha(0, 0, 90);
        this.tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.character == '\r') {
                    if (ProjectUI.this.selection.getSelectedTaskCount() == 1) {
                        ProjectUI.this.performAction((ListenerIdentifier)ProjectLID.InitiateTaskRename, ProjectUI.this.selection);
                    } else if (ProjectUI.this.selection.getSelectedDesign() != null) {
                        ProjectUI.this.performAction((ListenerIdentifier)ProjectLID.EditDesign, ProjectUI.this.selection);
                    }
                }
            }
        });
        this.undoManager = undoMgr;
        UndoManagerView.UndoAlertHandler undoMgrViewHandler = new UndoManagerView.UndoAlertHandler(this.undoManager, this.lIDMap, CogToolLID.Undo, CogToolLID.Redo);
        this.undoManager.addHandler(this, EventObject.class, undoMgrViewHandler);
        if (this.tree.getItemCount() > 0 && (showItem = this.tree.getItems()[0]) != null) {
            this.tree.showItem(showItem);
        }
        ProjectMouseState mouseState = new ProjectMouseState(this);
        SWTContextMenuUtil.addMenuListener((Control)this.tree, mouseState);
        this.setInitiallyEnabled();
    }

    protected Object getModelObject() {
        return this.project;
    }

    public IProject getProject() {
        return this.project;
    }

    public IProjectSelectionState getSelectionState() {
        return this.selection;
    }

    public IProjectInteraction getInteraction() {
        return this.interaction;
    }

    public IInteraction getStandardInteraction() {
        return this.interaction;
    }

    public IView getView() {
        return this.view;
    }

    protected String buildWindowMenuLabel() {
        return ProjectUI.buildWindowMenuLabel(this.project);
    }

    protected void updateTitle() {
        this.view.setWindowTitle(this.modificationFlag + PROJECT_PREFIX + ": " + this.project.getName() + (OSUtils.MACOSX ? "" : WINDOW_TITLE));
    }

    protected void updateWindowMenus() {
        this.menuData.setNexusLabel(this.project.getName());
        super.updateWindowMenus();
    }

    public void dispose() {
        CogTool.selectionPhase.removeDelayedWork(this.delayedTaskSelection);
        CogTool.selectionPhase.removeDelayedWork(this.delayedDesignSelection);
        this.uiModel.dispose();
        this.undoManager.removeAllHandlers(this);
        this.selection.removeAllHandlers(this);
        if (this.taskSelectListener != null) {
            this.tree.removeSelectionListener(this.taskSelectListener);
            this.taskSelectListener = null;
        }
        super.dispose();
    }

    protected boolean taskHasComputableScripts(IProjectSelectionState sel, IPredictionAlgo alg) {
        block7: {
            IUndertaking[] tasks;
            block6: {
                IDesign design = sel.getSelectedDesign();
                tasks = sel.getSelectedTasks();
                if (design == null) break block6;
                if (tasks != null && tasks.length > 0) {
                    for (int i = 0; i < tasks.length; ++i) {
                        if (!this.taskHasComputableScripts(tasks[i], design, alg)) continue;
                        return true;
                    }
                } else {
                    Iterator allTasks = this.project.getUndertakings().iterator();
                    while (allTasks.hasNext()) {
                        if (!this.taskHasComputableScripts((IUndertaking)allTasks.next(), design, alg)) continue;
                        return true;
                    }
                }
                break block7;
            }
            if (tasks == null || tasks.length <= 0) break block7;
            for (int i = 0; i < tasks.length; ++i) {
                Iterator allDesigns = this.project.getDesigns().iterator();
                while (allDesigns.hasNext()) {
                    if (!this.taskHasComputableScripts(tasks[i], (IDesign)allDesigns.next(), alg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean taskHasComputableScripts(IUndertaking task, IDesign design, IPredictionAlgo alg) {
        if (task.isGroup()) {
            Iterator allTasks = ((ITaskGroup)task).getUndertakings().iterator();
            while (allTasks.hasNext()) {
                if (!this.taskHasComputableScripts((IUndertaking)allTasks.next(), design, alg)) continue;
                return true;
            }
            return false;
        }
        ITaskApplication taskApp = this.project.getTaskApplication(task, design);
        return taskApp != null && taskApp.getScript(alg) != null && taskApp.getScript(alg).getStartFrame() != null;
    }

    protected boolean taskHasInvalidScripts(IUndertaking task, IDesign design, IPredictionAlgo alg) {
        if (task.isGroup()) {
            Iterator allTasks = ((ITaskGroup)task).getUndertakings().iterator();
            while (allTasks.hasNext()) {
                if (!this.taskHasInvalidScripts((IUndertaking)allTasks.next(), design, alg)) continue;
                return true;
            }
            return false;
        }
        ITaskApplication taskApp = this.project.getTaskApplication(task, design);
        return taskApp != null && !taskApp.isResultCurrent(alg);
    }

    protected boolean selectionHasInvalidScripts(IProjectSelectionState sel, IPredictionAlgo alg) {
        block7: {
            IUndertaking[] tasks;
            block6: {
                IDesign design = sel.getSelectedDesign();
                tasks = sel.getSelectedTasks();
                if (design == null) break block6;
                if (tasks != null && tasks.length > 0) {
                    for (int i = 0; i < tasks.length; ++i) {
                        if (!this.taskHasInvalidScripts(tasks[i], design, alg)) continue;
                        return true;
                    }
                } else {
                    Iterator allTasks = this.project.getUndertakings().iterator();
                    while (allTasks.hasNext()) {
                        if (!this.taskHasInvalidScripts((IUndertaking)allTasks.next(), design, alg)) continue;
                        return true;
                    }
                }
                break block7;
            }
            if (tasks == null || tasks.length <= 0) break block7;
            for (int i = 0; i < tasks.length; ++i) {
                Iterator allDesigns = this.project.getDesigns().iterator();
                while (allDesigns.hasNext()) {
                    if (!this.taskHasInvalidScripts(tasks[i], (IDesign)allDesigns.next(), alg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean taskHasTraces(IUndertaking task, IDesign design, IPredictionAlgo alg) {
        if (task.isGroup()) {
            Iterator allTasks = ((ITaskGroup)task).getUndertakings().iterator();
            while (allTasks.hasNext()) {
                if (!this.taskHasTraces((IUndertaking)allTasks.next(), design, alg)) continue;
                return true;
            }
            return false;
        }
        ITaskApplication taskApp = this.project.getTaskApplication(task, design);
        if (taskApp != null && taskApp.isResultCurrent(alg)) {
            IPredictionResult result = taskApp.getResult(alg);
            final ArrayList results = new ArrayList();
            if (result != null) {
                IPredictionResult.PredictionResultVisitorAdapter vistor = new IPredictionResult.PredictionResultVisitorAdapter(){

                    public void visit(StandaloneAlgo.StandaloneResult result) {
                        results.addAll(result.getTraceLines());
                        results.addAll(result.getErrorLines());
                    }
                };
                result.accept(vistor);
            }
            return !results.isEmpty();
        }
        return false;
    }

    protected boolean taskHasResultSteps(IUndertaking task, IDesign design, IPredictionAlgo alg) {
        if (task.isGroup()) {
            Iterator allTasks = ((ITaskGroup)task).getUndertakings().iterator();
            while (allTasks.hasNext()) {
                if (!this.taskHasResultSteps((IUndertaking)allTasks.next(), design, alg)) continue;
                return true;
            }
            return false;
        }
        ITaskApplication taskApp = this.project.getTaskApplication(task, design);
        if (taskApp != null && taskApp.isResultCurrent(alg)) {
            IPredictionResult result = taskApp.getResult(alg);
            final ArrayList results = new ArrayList();
            if (result != null) {
                IPredictionResult.PredictionResultVisitorAdapter vistor = new IPredictionResult.PredictionResultVisitorAdapter(){

                    public void visit(StandaloneAlgo.StandaloneResult result) {
                        results.addAll(result.getModelSteps());
                    }
                };
                result.accept(vistor);
            }
            return !results.isEmpty();
        }
        return false;
    }

    protected boolean selectionHasResultSteps(IProjectSelectionState sel, IPredictionAlgo alg) {
        block7: {
            IUndertaking[] tasks;
            block6: {
                IDesign design = sel.getSelectedDesign();
                tasks = sel.getSelectedTasks();
                if (design == null) break block6;
                if (tasks != null && tasks.length > 0) {
                    for (int i = 0; i < tasks.length; ++i) {
                        if (!this.taskHasResultSteps(tasks[i], design, alg)) continue;
                        return true;
                    }
                } else {
                    Iterator allTasks = this.project.getUndertakings().iterator();
                    while (allTasks.hasNext()) {
                        if (!this.taskHasResultSteps((IUndertaking)allTasks.next(), design, alg)) continue;
                        return true;
                    }
                }
                break block7;
            }
            if (tasks == null || tasks.length <= 0) break block7;
            for (int i = 0; i < tasks.length; ++i) {
                Iterator allDesigns = this.project.getDesigns().iterator();
                while (allDesigns.hasNext()) {
                    if (!this.taskHasResultSteps(tasks[i], (IDesign)allDesigns.next(), alg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean selectionHasScripts(IProjectSelectionState sel, IPredictionAlgo alg) {
        block7: {
            IUndertaking[] tasks;
            block6: {
                IDesign design = sel.getSelectedDesign();
                tasks = sel.getSelectedTasks();
                if (design == null) break block6;
                if (tasks != null && tasks.length > 0) {
                    for (int i = 0; i < tasks.length; ++i) {
                        if (!this.taskHasScripts(tasks[i], design, alg)) continue;
                        return true;
                    }
                } else {
                    Iterator allTasks = this.project.getUndertakings().iterator();
                    while (allTasks.hasNext()) {
                        if (!this.taskHasScripts((IUndertaking)allTasks.next(), design, alg)) continue;
                        return true;
                    }
                }
                break block7;
            }
            if (tasks == null || tasks.length <= 0) break block7;
            for (int i = 0; i < tasks.length; ++i) {
                Iterator allDesigns = this.project.getDesigns().iterator();
                while (allDesigns.hasNext()) {
                    if (!this.taskHasScripts(tasks[i], (IDesign)allDesigns.next(), alg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean taskHasScripts(IUndertaking task, IDesign design, IPredictionAlgo alg) {
        if (task.isGroup()) {
            Iterator allTasks = ((ITaskGroup)task).getUndertakings().iterator();
            while (allTasks.hasNext()) {
                if (!this.taskHasScripts((IUndertaking)allTasks.next(), design, alg)) continue;
                return true;
            }
            return false;
        }
        ITaskApplication taskApp = this.project.getTaskApplication(task, design);
        return taskApp != null && taskApp.getScript(alg) != null;
    }

    protected boolean selectionHasTraces(IProjectSelectionState sel, IPredictionAlgo alg) {
        block7: {
            IUndertaking[] tasks;
            block6: {
                IDesign design = sel.getSelectedDesign();
                tasks = sel.getSelectedTasks();
                if (design == null) break block6;
                if (tasks != null && tasks.length > 0) {
                    for (int i = 0; i < tasks.length; ++i) {
                        if (!this.taskHasTraces(tasks[i], design, alg)) continue;
                        return true;
                    }
                } else {
                    Iterator allTasks = this.project.getUndertakings().iterator();
                    while (allTasks.hasNext()) {
                        if (!this.taskHasTraces((IUndertaking)allTasks.next(), design, alg)) continue;
                        return true;
                    }
                }
                break block7;
            }
            if (tasks == null || tasks.length <= 0) break block7;
            for (int i = 0; i < tasks.length; ++i) {
                Iterator allDesigns = this.project.getDesigns().iterator();
                while (allDesigns.hasNext()) {
                    if (!this.taskHasTraces(tasks[i], (IDesign)allDesigns.next(), alg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void setInitiallyEnabled() {
        super.setInitiallyEnabled();
        this.setEnabled(CogToolLID.SelectAll, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.NewDesign, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.NewTask, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.NewTaskGroup, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.NewDesign, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ImportXML, ListenerIdentifierMap.ALL, true);
    }

    protected void setViewEnabledState(IProjectSelectionState sel, Boolean availability) {
        boolean hasDesign = sel.getSelectedDesign() != null;
        int selectionCount = sel.getSelectedTaskCount();
        this.setEnabled(CogToolLID.Duplicate, availability, hasDesign);
        this.setEnabled(CogToolLID.Edit, availability, hasDesign);
        boolean enabled = hasDesign || selectionCount == 1;
        this.setEnabled(CogToolLID.Rename, availability, enabled);
        this.setEnabled(CogToolLID.ExportDesignToHTML, availability, hasDesign);
        this.setEnabled(CogToolLID.CaptureBehavior, availability, true);
        enabled = hasDesign || selectionCount > 0;
        this.setEnabled(CogToolLID.Cut, availability, enabled);
        this.setEnabled(CogToolLID.Copy, availability, enabled);
        this.setEnabled(CogToolLID.Delete, availability, enabled);
        this.setEnabled(CogToolLID.DeselectAll, availability, enabled);
        IPredictionAlgo ALGO = this.uiModel.getPredictionAlgo();
        boolean showRecompute = enabled && this.taskHasComputableScripts(sel, ALGO);
        this.setEnabled(CogToolLID.RecomputeScript, availability, showRecompute);
        this.setEnabled(ProjectLID.ExportCoreCSVFile, availability, showRecompute);
        boolean showExport = enabled && !this.selectionHasInvalidScripts(sel, ALGO) && this.selectionHasTraces(sel, ALGO);
        this.setEnabled(ProjectLID.ExportACTRTrace, availability, showExport);
        boolean showVis = enabled && !this.selectionHasInvalidScripts(sel, ALGO) && this.selectionHasResultSteps(sel, ALGO);
        this.setEnabled(ProjectLID.ShowModelVisualization, availability, showVis);
        boolean showExportFiles = enabled && this.selectionHasScripts(sel, ALGO) && !this.selectionHasInvalidScripts(sel, ALGO);
        this.setEnabled(ProjectLID.ExportActrModelFile, availability, showExportFiles);
        boolean canExport = false;
        if (hasDesign) {
            IDesign design = sel.getSelectedDesign();
            IUndertaking[] tasks = sel.getSelectedTasks();
            for (int i = 0; i < tasks.length; ++i) {
                IUndertaking task = tasks[i];
                if (!this.taskHasScripts(task, design, ALGO)) continue;
                canExport = true;
            }
        }
        this.setEnabled(CogToolLID.ExportScriptToCSV, availability, canExport);
        enabled = false;
        int numTaskGroups = 0;
        ITaskGroup group = null;
        IUndertaking[] tasks = sel.getSelectedTasks();
        for (int i = 0; i < tasks.length; ++i) {
            IUndertaking task = tasks[i];
            if (!task.isGroup()) continue;
            enabled = true;
            ++numTaskGroups;
            group = (ITaskGroup)task;
        }
        this.setEnabled(CogToolLID.ShowSum, availability, enabled);
        this.setEnabled(CogToolLID.ShowMean, availability, enabled);
        this.setEnabled(CogToolLID.ShowMin, availability, enabled);
        this.setEnabled(CogToolLID.ShowMax, availability, enabled);
        this.setSelected(CogToolLID.ShowSum, availability, false);
        this.setSelected(CogToolLID.ShowMean, availability, false);
        this.setSelected(CogToolLID.ShowMin, availability, false);
        this.setSelected(CogToolLID.ShowMax, availability, false);
        if (enabled && numTaskGroups == 1) {
            GroupNature nature = group.getNature();
            CogToolLID id = null;
            if (nature == GroupNature.SUM) {
                id = CogToolLID.ShowSum;
            } else if (nature == GroupNature.MEAN) {
                id = CogToolLID.ShowMean;
            } else if (nature == GroupNature.MIN) {
                id = CogToolLID.ShowMin;
            } else if (nature == GroupNature.MAX) {
                id = CogToolLID.ShowMax;
            }
            this.setSelected(id, availability, true);
        }
    }

    public ListenerIdentifier transmute(ListenerIdentifier id, boolean isContextSelection) {
        ListenerIdentifier specificLID = super.transmute(id, isContextSelection);
        if (specificLID != id) {
            return specificLID;
        }
        ProjectContextSelectionState sel = isContextSelection ? this.contextSelection : this.selection;
        specificLID = sel.getSelectedDesign() != null ? (ListenerIdentifier)ProjectLID.designLIDs.get(id) : (ListenerIdentifier)ProjectLID.taskLIDs.get(id);
        return specificLID != null ? specificLID : id;
    }

    protected void setUpPerformAction(ListenerIdentifier id) {
        int selectionMask = ProjectUI.canCauseSelection(id, this.undoManager);
        if (ProjectUI.isSelectionFlagSet(selectionMask, 1)) {
            this.delayedTaskSelection.setActive(true);
        }
        if (ProjectUI.isSelectionFlagSet(selectionMask, 2)) {
            this.delayedDesignSelection.setActive(true);
        }
    }

    public Object getParameters(ListenerIdentifier originalLID, ListenerIdentifier transmutedLID, boolean isContextSelection) {
        if (originalLID instanceof DefaultUI.RestoreParentControllerLID) {
            return super.getParameters(originalLID, transmutedLID, isContextSelection);
        }
        this.setUpPerformAction(transmutedLID);
        return isContextSelection ? this.contextSelection : this.selection;
    }

    public void cleanup(boolean okToContinue, boolean menuHidden) {
        if (this.overBox != null) {
            this.overBox = null;
            this.tree.redraw();
        }
        super.cleanup(okToContinue, menuHidden);
    }

    public void selectAllTasks() {
        this.selection.selectAllTasks();
    }

    public void initiateTaskRename(IUndertaking undertaking) {
        TreeItem taskToRenameItem = this.uiModel.getTaskTreeItem(undertaking);
        this.initiateTaskRename(taskToRenameItem);
    }

    public void initiateTaskRename(TreeItem taskToRenameItem) {
        if (this.editor.getEditor() == null && taskToRenameItem != null) {
            this.selection.setSelectedItem(taskToRenameItem);
            IUndertaking task = (IUndertaking)taskToRenameItem.getData();
            this.editor.horizontalAlignment = 16384;
            this.editor.grabHorizontal = true;
            TextWithEnableFix newEditor = new TextWithEnableFix((Composite)this.tree, 16388);
            newEditor.setText(task.getName());
            newEditor.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 10 || e.keyCode == 13 || e.keyCode == 9) {
                        ProjectUI.this.commitRenameTask();
                    } else if (e.keyCode == 27) {
                        ProjectUI.this.cleanupTaskEditor();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            newEditor.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    ProjectUI.this.commitRenameTask();
                }
            });
            newEditor.selectAll();
            newEditor.setFocus();
            this.editor.setEditor((Control)newEditor, taskToRenameItem);
        }
    }

    protected void commitRenameTask() {
        if (this.editor.getEditor() != null) {
            Text text = (Text)this.editor.getEditor();
            String newName = text.getText();
            TreeItem item = this.editor.getItem();
            IUndertaking taskToRename = (IUndertaking)item.getData();
            TreeItem parentItem = item.getParentItem();
            ITaskGroup parentGroup = (ITaskGroup)(parentItem != null ? parentItem.getData() : null);
            this.cleanupTaskEditor();
            this.performAction(ProjectLID.RenameTask, new IProjectUI.TaskRenameEvent(taskToRename, newName, parentGroup), false);
        }
    }

    protected void cleanupTaskEditor() {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
            this.editor.setEditor(null);
        }
    }

    protected int numExpandedLevels(TreeItem[] items) {
        if (items == null) {
            return 0;
        }
        int max = 0;
        for (int i = 0; i < items.length; ++i) {
            int val;
            if (!items[i].getExpanded() || (val = this.numExpandedLevels(items[i].getItems())) <= max) continue;
            max = val;
        }
        return max + 1;
    }

    protected TreeColumn findColumn(int x) {
        int initialOffset = 0;
        if (OSUtils.MACOSX) {
            initialOffset = (this.numExpandedLevels(this.tree.getItems()) - 1) * 24;
            x += this.tree.getHorizontalBar().getSelection();
        }
        TreeColumn[] allCols = this.tree.getColumns();
        int numCols = this.tree.getColumnCount();
        for (int i = 0; i < numCols; ++i) {
            int w = allCols[i].getWidth();
            if (i == 0) {
                x -= initialOffset;
            }
            if (x < w) {
                return allCols[i];
            }
            x -= w;
        }
        return null;
    }

    protected Listener createSetToolTipListener() {
        return new Listener(){

            public void handleEvent(Event evt) {
                IUndertaking rowData;
                TreeItem row;
                IDesign colData;
                String toolTipText = null;
                TreeColumn col = ProjectUI.this.findColumn(evt.x);
                if (col != null && (colData = (IDesign)col.getData()) != null) {
                    toolTipText = colData.getName();
                }
                if ((row = ProjectUI.this.tree.getItem(new Point(evt.x, evt.y))) != null && (rowData = (IUndertaking)row.getData()) != null) {
                    toolTipText = toolTipText != null ? toolTipText + '@' + rowData.getName() : rowData.getName();
                }
                ProjectUI.this.tree.setToolTipText(toolTipText);
            }
        };
    }

    protected Listener createHighlightColumnPaintListener() {
        return new Listener(){

            public void handleEvent(Event evt) {
                if (ProjectUI.this.overBox != null) {
                    GraphicsUtil.drawOverlay(evt.gc, grayTransparent, ProjectUI.this.overBox);
                }
            }
        };
    }

    protected Rectangle computeSelectedColumnArea() {
        return this.computeColumnArea(this.selection.getSelectedColumn());
    }

    protected Rectangle computeColumnArea(TreeColumn column) {
        if (column != null) {
            Point size = this.tree.getSize();
            Rectangle treeArea = new Rectangle(0, 0, size.x, size.y);
            int i = 0;
            TreeColumn nextCol = this.tree.getColumn(i++);
            while (nextCol != column) {
                treeArea.x += nextCol.getWidth();
                nextCol = this.tree.getColumn(i++);
            }
            treeArea.width = column.getWidth();
            if (OSUtils.MACOSX) {
                int off = (this.numExpandedLevels(this.tree.getItems()) - 1) * 24;
                treeArea.x += off;
                ++treeArea.y;
                treeArea.height -= 16;
                treeArea.x += 4;
            }
            return treeArea;
        }
        return null;
    }

    protected void showContextMenu(IProjectSelectionState seln, boolean context) {
        this.setViewEnabledState(seln, ListenerIdentifierMap.CONTEXT);
        if (seln.getSelectedDesign() != null) {
            this.view.showContextMenuForDesign(context);
        } else {
            int selectedTaskCount = seln.getSelectedTaskCount();
            if (selectedTaskCount > 0) {
                boolean isTaskGroup = selectedTaskCount == 1 ? seln.getSelectedTasks()[0].isGroup() : false;
                this.view.showContextMenuForUndertaking(isTaskGroup, context);
            } else {
                this.view.showContextMenuForBlankSpace();
            }
        }
    }

    protected void highlightCell(int x, int y) {
        TreeItem newRow = this.tree.getItem(new Point(x, y));
        TreeColumn newColumn = this.findColumn(x);
        if (newColumn != null && newColumn.getData() == null) {
            newColumn = null;
        }
        if (newColumn != null && newRow != null) {
            this.overBox = newRow.getBounds(this.tree.indexOf(newColumn));
            this.tree.redraw();
        } else if (this.overBox != null) {
            this.overBox = null;
            this.tree.redraw();
        }
    }

    public void showContextMenu() {
        this.showContextMenu(this.selection, false);
    }

    public void showContextMenu(int x, int y) {
        this.contextSelection.deselectAll();
        TreeItem item = this.tree.getItem(new Point(x, y));
        TreeColumn column = this.findColumn(x);
        if (column == null) {
            if (item == null) {
                this.showContextMenu();
            } else {
                this.overBox = item.getBounds();
                this.tree.redraw();
                this.contextSelection.addSelectedItem(item);
                this.showContextMenu(this.contextSelection, true);
            }
        } else {
            IDesign design = (IDesign)column.getData();
            if (item == null) {
                if (design == null) {
                    this.showContextMenu();
                } else {
                    this.overBox = this.computeColumnArea(column);
                    this.tree.redraw();
                    this.contextSelection.setSelectedColumn(column);
                    this.showContextMenu(this.contextSelection, true);
                }
            } else {
                IUndertaking undertaking = (IUndertaking)item.getData();
                if (design == null) {
                    if (this.selection.isTaskSelected(undertaking)) {
                        this.showContextMenu();
                    } else {
                        this.overBox = item.getBounds();
                        this.tree.redraw();
                        this.contextSelection.addSelectedItem(item);
                        this.showContextMenu(this.contextSelection, true);
                    }
                } else {
                    this.overBox = item.getBounds(this.tree.indexOf(column));
                    if (OSUtils.MACOSX) {
                        --this.overBox.y;
                        ++this.overBox.height;
                    }
                    this.tree.redraw();
                    this.contextSelection.addSelectedItem(item);
                    this.contextSelection.addSelectedColumn(column);
                    this.setViewEnabledState(this.contextSelection, ListenerIdentifierMap.CONTEXT);
                    this.view.showContextMenuForIntersection(undertaking.isGroup());
                }
            }
        }
    }

    public void onRowCreation(TreeItem row) {
        this.delayedTaskSelection.addToSelection(row.getData(), row);
    }

    public void onRowDeletion(TreeItem row) {
        this.cleanupTaskEditor();
    }

    public void onColumnCreation(TreeColumn column) {
        column.addControlListener((ControlListener)this.onResizeColumn);
        column.addListener(13, this.columnSelectionListener);
        if (column.getData() != null) {
            column.addListener(14, this.columnDefaultSelectionListener);
            this.delayedDesignSelection.addToSelection(column.getData(), column);
        }
    }

    public void onColumnDeletion(TreeColumn column) {
        if (this.selection.getSelectedColumn() == column) {
            this.selection.deselectColumn(column);
        }
    }

    protected class TreeOpTimer
    implements Runnable {
        protected TreeOpTimer() {
        }

        public void run() {
            --ProjectUI.this.treeOperationOccurred;
        }
    }
}

