/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.ui.ProjectContextSelectionState;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProjectSelectionState
extends ProjectContextSelectionState {
    protected Tree tree;

    public ProjectSelectionState(Tree viewTree) {
        if (viewTree == null) {
            throw new IllegalArgumentException("Must be bound to an SWT Tree");
        }
        this.tree = viewTree;
        this.tree.addSelectionListener((SelectionListener)new TreeSelectionUpdater());
    }

    public void selectAllTasks() {
        this.deselectAll();
        this.selectItems(this.tree.getItems());
    }

    private void selectItems(TreeItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            TreeItem item = items[i];
            this.addSelectedItem(item);
            this.selectItems(item.getItems());
        }
    }

    public void deselectAll() {
        List selCols = (List)this.selectedColumns.clone();
        Iterator it = selCols.iterator();
        while (it.hasNext()) {
            TreeColumn column = (TreeColumn)it.next();
            this.deselectColumn(column);
        }
        super.deselectAll();
        this.sync(null);
    }

    public void addSelectedColumn(TreeColumn column) {
        super.addSelectedColumn(column);
        this.sync(new ProjectSelectionChange(this, this.tree.indexOf(column), true));
    }

    public void deselectColumn(TreeColumn column) {
        super.deselectColumn(column);
        this.sync(new ProjectSelectionChange(this, this.tree.indexOf(column), false));
    }

    public void deselectRow(TreeItem row) {
        super.deselectRow(row);
        this.sync(new ProjectSelectionChange(this));
    }

    public void addSelectedItem(TreeItem row) {
        List selCols = (List)this.selectedColumns.clone();
        Iterator it = selCols.iterator();
        while (it.hasNext()) {
            TreeColumn column = (TreeColumn)it.next();
            this.deselectColumn(column);
        }
        super.addSelectedItem(row);
        this.sync(new ProjectSelectionChange(this));
    }

    protected void sync(ProjectSelectionChange alertEvent) {
        if (this.tree != null) {
            this.tree.setSelection(this.getSelectedTaskItems());
            this.tree.showSelection();
        }
        if (alertEvent != null) {
            this.raiseAlert(alertEvent);
        }
    }

    protected class TreeSelectionUpdater
    extends SelectionAdapter {
        boolean first = true;

        protected TreeSelectionUpdater() {
        }

        public void widgetSelected(SelectionEvent evt) {
            if (this.first) {
                ProjectSelectionState.this.tree.deselectAll();
                this.first = false;
            }
        }
    }

    public static class ProjectSelectionChange
    extends EventObject {
        public int designColumn = -1;
        public boolean selected = false;

        public ProjectSelectionChange(ProjectSelectionState state) {
            super(state);
        }

        public ProjectSelectionChange(ProjectSelectionState state, int column, boolean nowSelected) {
            super(state);
            this.designColumn = column;
            this.selected = nowSelected;
        }
    }
}

