/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.Design;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.GroupNature;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.ui.DefaultInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IProjectInteraction;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.TextWithEnableFix;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.AboutView;
import edu.cmu.cs.hcii.cogtool.view.IView;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectInteraction
extends DefaultInteraction
implements IProjectInteraction {
    protected static final String needSelectionMsg = L10N.get("PM.NeedSelection", "You must select a design or task first; click on a design's column header or a task's row.");
    protected static final String confirmDeleteDesignMsg = L10N.get("PM.ConfirmDeleteDesign", "Please confirm the deletion of the following Design:");
    protected static final String designNotUniqueMsg = L10N.get("PM.NotUniqueDesignName", "Design names must be unique; would you like to try again?");
    protected static final String designEmptyNameMsg = L10N.get("PM.EmptyDesignName", "Design names must not be empty; would you like to try again?");
    protected static final String noDeviceTypesMsg = L10N.get("PM.NoDeviceTypes", "At least one device type must be chosen; would you like to try again?");
    protected static final String confirmDeleteTasksMsg = L10N.get("PM.ConfirmDeleteTask", "Please confirm the deletion of the following Task(s):");
    protected static final String confirmDeleteTasksChildrenMsg = L10N.get("PM.ConfirmDeleteTask", "Please confirm the deletion of the following Task(s) and Task Group(s), plus any group members:");
    protected static final String taskNotUniqueMsg = L10N.get("PM.NotUniqueTaskName", "Task names must be unique within the containing group; would you like to try again?");
    protected static final String taskEmptyNameMsg = L10N.get("PM.EmptyTaskName", "Task names must not be empty; would you like to try again?");
    protected static final String errorTitle = L10N.get("PM.ErrorTitle", "Project Error");
    protected static final String confirmTitle = L10N.get("PM.ConfirmTitle", "Confirm Deletion");

    public ProjectInteraction(IView view) {
        super(view);
    }

    public void protestNoSelection() {
        this.reportProblem(errorTitle, needSelectionMsg);
    }

    public boolean requestNewDesignName(IProjectInteraction.DesignRequestData requestData, boolean newProjectMode, IProject project) {
        NewDesignDialog askName = new NewDesignDialog(this.window, requestData, newProjectMode, project);
        Object response = askName.open();
        if (response != null && response.equals("OK")) {
            requestData.designName = askName.getPromptResponse();
            return true;
        }
        return false;
    }

    public String requestDesignRename(String oldDesignName) {
        WindowUtil.PromptDialog askName = new WindowUtil.PromptDialog(this.window, L10N.get("PM.RenameDesignTitle", "Rename Design"), 32768, L10N.get("CT.DesignNameLabel", "Design name:"), L10N.get("PM.AskNewDesignName", "What is the design's new name?"), oldDesignName);
        Object response = askName.open();
        return response != null && response.equals("OK") ? askName.getPromptResponse() : null;
    }

    public boolean protestNotUniqueDesignName() {
        return this.reportAndRetry(errorTitle, designNotUniqueMsg);
    }

    public boolean protestEmptyDesignName() {
        return this.reportAndRetry(errorTitle, designEmptyNameMsg);
    }

    public boolean protestNoDeviceTypes() {
        return this.reportAndRetry(errorTitle, noDeviceTypesMsg);
    }

    public boolean confirmDeleteDesign(IDesign design) {
        String msg = confirmDeleteDesignMsg + "\n    " + design.getName();
        return 32 == WindowUtil.presentConfirmDialog(this.window, confirmTitle, msg);
    }

    public boolean requestNewTaskName(IProjectInteraction.TaskRequestData requestData) {
        NewTaskDialog askName = new NewTaskDialog(this.window, requestData);
        Object response = askName.open();
        if (response != null && response.equals("OK")) {
            requestData.taskName = askName.getPromptResponse();
            return true;
        }
        return false;
    }

    public boolean confirmDeleteTasks(IUndertaking[] selectedTasks) {
        String msg = confirmDeleteTasksMsg;
        for (int i = 0; i < selectedTasks.length; ++i) {
            if (!selectedTasks[i].isGroup()) continue;
            msg = confirmDeleteTasksChildrenMsg;
            break;
        }
        return 32 == WindowUtil.presentConfirmItemsDialog(this.window, confirmTitle, msg, selectedTasks);
    }

    public boolean protestNotUniqueTaskName() {
        return this.reportAndRetry(errorTitle, taskNotUniqueMsg);
    }

    public boolean protestEmptyTaskName() {
        return this.reportAndRetry(errorTitle, taskEmptyNameMsg);
    }

    public File selectExportLocation(String defaultFilename, String defaultExtension) {
        return this.persistView.selectFileDest(defaultFilename, defaultExtension);
    }

    public String createNewOrOpenExisting() {
        StartUpDialog dialog = new StartUpDialog(this.window);
        return (String)dialog.open();
    }

    public static class StartUpDialog
    extends WindowUtil.SimpleDialog {
        protected Button createButton;
        protected Button openButton;

        public StartUpDialog(Shell parent) {
            super(parent, L10N.get("CGTL.StartUp", "CogTool Start-up"), 32768, 2144);
        }

        protected void buildDialog() {
            GridLayout layout = new GridLayout(4, false);
            if (OSUtils.MACOSX) {
                layout.marginLeft = 19;
                layout.marginRight = 13;
                layout.marginTop = 7;
                layout.marginBottom = 12;
            }
            this.dialog.setLayout((Layout)layout);
            Label logo = new Label((Composite)this.dialog, 0x1000000);
            logo.setImage(AboutView.logoImg);
            GridData imgLayout = new GridData();
            imgLayout.horizontalSpan = 4;
            imgLayout.horizontalAlignment = 4;
            imgLayout.grabExcessHorizontalSpace = true;
            logo.setLayoutData((Object)imgLayout);
            Label msgCell = new Label((Composite)this.dialog, 0);
            msgCell.setText(L10N.get("CGTL.CreateOrOpen", "Create a new project or open an existing project?"));
            GridData msgCellLayout = new GridData();
            msgCellLayout.horizontalSpan = 4;
            msgCellLayout.grabExcessHorizontalSpace = true;
            msgCell.setLayoutData((Object)msgCellLayout);
            Label emptyCell = new Label((Composite)this.dialog, 0);
            GridData emptyCellLayout = new GridData();
            emptyCellLayout.grabExcessHorizontalSpace = true;
            emptyCell.setLayoutData((Object)emptyCellLayout);
            this.createButton = new Button((Composite)this.dialog, 8);
            this.openButton = new Button((Composite)this.dialog, 8);
            if (this.buttonFont != null) {
                this.createButton.setFont(this.buttonFont);
                this.openButton.setFont(this.buttonFont);
            }
            this.createButton.setText(L10N.get("B.CREATE", "Create"));
            this.openButton.setText(L10N.get("B.OPEN", "Open"));
            this.dialog.setDefaultButton(this.createButton);
            GridData okLayout = new GridData(128);
            GridData cancelLayout = new GridData(128);
            this.createButton.setLayoutData((Object)okLayout);
            this.openButton.setLayoutData((Object)cancelLayout);
            emptyCell = new Label((Composite)this.dialog, 0);
            emptyCellLayout = new GridData();
            emptyCellLayout.grabExcessHorizontalSpace = true;
            emptyCell.setLayoutData((Object)emptyCellLayout);
            if (OSUtils.MACOSX) {
                okLayout.widthHint = 82;
                cancelLayout.widthHint = 82;
            }
            this.createButton.addListener(13, new Listener(this){
                private final /* synthetic */ StartUpDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event e) {
                    StartUpDialog.access$002(this.this$0, "CREATE");
                    StartUpDialog.access$100(this.this$0).close();
                }
            });
            this.openButton.addListener(13, new Listener(this){
                private final /* synthetic */ StartUpDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event e) {
                    StartUpDialog.access$202(this.this$0, "OPEN");
                    StartUpDialog.access$300(this.this$0).close();
                }
            });
        }

        static /* synthetic */ Object access$002(StartUpDialog x0, Object x1) {
            x0.userResponse = x1;
            return x0.userResponse;
        }

        static /* synthetic */ Shell access$100(StartUpDialog x0) {
            return x0.dialog;
        }

        static /* synthetic */ Object access$202(StartUpDialog x0, Object x1) {
            x0.userResponse = x1;
            return x0.userResponse;
        }

        static /* synthetic */ Shell access$300(StartUpDialog x0) {
            return x0.dialog;
        }
    }

    public static class NewTaskDialog
    extends WindowUtil.PromptDialog {
        protected IProjectInteraction.TaskRequestData requestData;
        protected Button meanOption;
        protected Button sumOption;
        protected Button maxOption;
        protected Button minOption;

        public NewTaskDialog(Shell parent, IProjectInteraction.TaskRequestData data) {
            super(parent, L10N.get("PM.NewTaskTitle", "New Task"), 32768, L10N.get("CT.TaskNameLabel", "Task name:"), L10N.get("PM.AskNewTaskName", "What is the new task's name?"), data.taskName);
            this.requestData = data;
        }

        protected Composite addRadioSet() {
            Composite radioSet = new Composite((Composite)this.dialog, 0);
            radioSet.setLayout((Layout)new FillLayout());
            GridData radioSetLayout = new GridData();
            radioSetLayout.horizontalSpan = 2;
            radioSet.setLayoutData((Object)radioSetLayout);
            return radioSet;
        }

        protected Button addOption(Composite radioSet, String optionText, boolean isSelected, boolean isEnabled, Listener optionListener) {
            Button option = new Button(radioSet, 16);
            option.setSelection(isSelected);
            option.setEnabled(isEnabled);
            option.setText(optionText);
            option.addListener(13, optionListener);
            return option;
        }

        protected Label addLabel(String lblText) {
            Label lbl = new Label((Composite)this.dialog, 0);
            lbl.setText(lblText);
            GridData lblLayout = new GridData(128);
            lbl.setLayoutData((Object)lblLayout);
            return lbl;
        }

        protected void addEmptyCell() {
            Label emptyCell = new Label((Composite)this.dialog, 0);
            GridData emptyCellLayout = new GridData();
            emptyCellLayout.grabExcessHorizontalSpace = true;
            emptyCell.setLayoutData((Object)emptyCellLayout);
        }

        protected void addMoreFields() {
            Label ignoreLbl;
            Button ignoreBtn;
            Composite radioSet;
            super.addMoreFields();
            if ((this.requestData.flags & 4) != 0) {
                Label ignore = this.addLabel(L10N.get("PM.PlaceNewTask", "Place:"));
                radioSet = this.addRadioSet();
                ignoreBtn = this.addOption(radioSet, L10N.get("RADIO.After", "after"), this.requestData.addAfter, true, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.addAfter = true;
                    }
                });
                ignoreBtn = this.addOption(radioSet, L10N.get("RADIO.Before", "before"), !this.requestData.addAfter, true, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.addAfter = false;
                    }
                });
                this.addEmptyCell();
            }
            if ((this.requestData.flags & 3) == 3) {
                ignoreLbl = this.addLabel(L10N.get("PM.IsNewTaskGroup", "As a group:"));
                radioSet = this.addRadioSet();
                ignoreBtn = this.addOption(radioSet, L10N.get("RADIO.SingleTask", "a single task"), this.requestData.addAsTask, true, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.addAsTask = true;
                        this.this$0.meanOption.setEnabled(false);
                        this.this$0.sumOption.setEnabled(false);
                        this.this$0.maxOption.setEnabled(false);
                        this.this$0.minOption.setEnabled(false);
                    }
                });
                ignoreBtn = this.addOption(radioSet, L10N.get("RADIO.TaskGroup", "groups other tasks"), !this.requestData.addAsTask, true, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.addAsTask = false;
                        this.this$0.meanOption.setEnabled(true);
                        this.this$0.sumOption.setEnabled(true);
                        this.this$0.maxOption.setEnabled(true);
                        this.this$0.minOption.setEnabled(true);
                    }
                });
                this.addEmptyCell();
            }
            if ((this.requestData.flags & 1) != 0) {
                ignoreLbl = this.addLabel(L10N.get("PM.NewTaskNature", "Nature:"));
                radioSet = this.addRadioSet();
                boolean isEnabled = !this.requestData.addAsTask || (this.requestData.flags & 3) != 3;
                this.meanOption = this.addOption(radioSet, L10N.get("RADIO.MEAN", "MEAN"), this.requestData.nature == GroupNature.MEAN, isEnabled, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.nature = GroupNature.MEAN;
                    }
                });
                this.sumOption = this.addOption(radioSet, L10N.get("RADIO.SUM", "SUM"), this.requestData.nature == GroupNature.SUM, isEnabled, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.nature = GroupNature.SUM;
                    }
                });
                this.maxOption = this.addOption(radioSet, L10N.get("RADIO.MAX", "MAX"), this.requestData.nature == GroupNature.MAX, isEnabled, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.nature = GroupNature.MAX;
                    }
                });
                this.minOption = this.addOption(radioSet, L10N.get("RADIO.MIN", "MIN"), this.requestData.nature == GroupNature.MIN, isEnabled, new Listener(this){
                    private final /* synthetic */ NewTaskDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void handleEvent(Event evt) {
                        this.this$0.requestData.nature = GroupNature.MIN;
                    }
                });
                this.addEmptyCell();
            }
        }
    }

    public static class NewDesignDialog
    extends WindowUtil.CustomDialog {
        protected IProjectInteraction.DesignRequestData requestData;
        protected boolean newProject;
        protected IProject userProject;
        protected Text designNameInput;
        protected Composite deviceComposite;
        protected String promptResponse;

        public NewDesignDialog(Shell parent, IProjectInteraction.DesignRequestData data, boolean newProjectMode, IProject project) {
            super(parent, newProjectMode ? L10N.get("PM.NewDesignForTitle", "New Design for ") + project.getName() : L10N.get("PM.NewDesignTitle", "New Design"), 32768);
            this.newProject = newProjectMode;
            this.userProject = project;
            this.requestData = data;
        }

        public String getPromptResponse() {
            return this.promptResponse;
        }

        protected void onOK() {
            this.requestData.designName = this.promptResponse = this.designNameInput.getText();
            super.onOK();
        }

        protected Composite createUI() {
            Composite newDesignUI;
            Composite userInterface = new Composite((Composite)this.dialog, 0);
            userInterface.setLayout((Layout)new FormLayout());
            if (this.newProject) {
                Composite newProjectUI = new Composite(userInterface, 0);
                FormData formData_1 = new FormData();
                formData_1.right = new FormAttachment(100, 0);
                formData_1.left = new FormAttachment(0, 0);
                newProjectUI.setLayoutData((Object)formData_1);
                newProjectUI.setLayout((Layout)new FillLayout(512));
                Label initialDesignLabel = new Label(newProjectUI, 64);
                initialDesignLabel.setText("The new project will be called '" + this.userProject.getName() + "' until you save it.");
                newDesignUI = new Composite(userInterface, 0);
                newDesignUI.setLayout((Layout)new FormLayout());
                FormData formData = new FormData();
                formData.bottom = new FormAttachment(100, 0);
                formData.right = new FormAttachment(100, 0);
                formData.left = new FormAttachment(0, 0);
                formData.top = new FormAttachment((Control)newProjectUI, 30, 128);
                newDesignUI.setLayoutData((Object)formData);
            } else {
                newDesignUI = new Composite(userInterface, 0);
                newDesignUI.setLayout((Layout)new FormLayout());
                FormData formData = new FormData();
                formData.bottom = new FormAttachment(100, 0);
                formData.right = new FormAttachment(100, 0);
                formData.left = new FormAttachment(0, 0);
                newDesignUI.setLayoutData((Object)formData);
            }
            Label designNameLabel = new Label(newDesignUI, 0);
            FormData formData_3 = new FormData();
            formData_3.top = new FormAttachment(0, 0);
            formData_3.left = new FormAttachment(0, 0);
            designNameLabel.setLayoutData((Object)formData_3);
            if (this.newProject) {
                designNameLabel.setText("Because each project must have at least one design,\nplease enter the name of an initial design:");
            } else {
                designNameLabel.setText("Name for the new design:");
            }
            this.designNameInput = new TextWithEnableFix(newDesignUI, 2048);
            FormData formData_4 = new FormData();
            formData_4.right = new FormAttachment(100, -20);
            formData_4.top = new FormAttachment((Control)designNameLabel, 10, -1);
            formData_4.left = new FormAttachment(0, 20);
            formData_4.width = 200;
            this.designNameInput.setLayoutData((Object)formData_4);
            Label devicesLabel = new Label(newDesignUI, 0);
            FormData formData_5 = new FormData();
            formData_5.top = new FormAttachment((Control)this.designNameInput, 32, -1);
            formData_5.left = new FormAttachment(0, 0);
            devicesLabel.setLayoutData((Object)formData_5);
            devicesLabel.setText("Devices used in this design:");
            this.deviceComposite = new Composite(newDesignUI, 2048);
            this.deviceComposite.setLayout((Layout)new GridLayout());
            FormData formData_2 = new FormData();
            formData_2.bottom = new FormAttachment(100, -10);
            formData_2.right = new FormAttachment(100, -20);
            formData_2.top = new FormAttachment((Control)devicesLabel, 10, -1);
            formData_2.left = new FormAttachment(0, 20);
            this.deviceComposite.setLayoutData((Object)formData_2);
            GridData g = new GridData();
            g.horizontalSpan = 4;
            userInterface.setLayoutData((Object)g);
            this.designNameInput.addListener(2, new Listener(this){
                private final /* synthetic */ NewDesignDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event evt) {
                    this.this$0.enableOKButtonCheck();
                }
            });
            int designCount = this.userProject.getDesigns().size() + 1;
            this.designNameInput.setText("Design " + designCount);
            List designs = this.userProject.getDesigns();
            HashSet initialDevices = new HashSet();
            boolean defaultDevices = true;
            for (int i = 0; i < designs.size(); ++i) {
                Design design = (Design)designs.get(i);
                Set devices = design.getDeviceTypes();
                if (i == 0) {
                    initialDevices = new HashSet(devices);
                    continue;
                }
                if (((Object)devices).equals(initialDevices)) continue;
                defaultDevices = false;
            }
            if (defaultDevices) {
                this.requestData.deviceTypes = initialDevices;
            }
            this.designNameInput.selectAll();
            return userInterface;
        }

        protected void addDevice(DeviceType dt, boolean isSelected, Listener action) {
            Button button = new Button(this.deviceComposite, 32);
            button.setSelection(isSelected);
            button.setData((Object)dt);
            button.setText(dt.toString());
            button.addListener(13, action);
        }

        protected void toggleDeviceType(DeviceType devType) {
            if (this.requestData.deviceTypes.contains(devType)) {
                this.requestData.deviceTypes.remove(devType);
            } else {
                this.requestData.deviceTypes.add(devType);
            }
            this.enableOKButtonCheck();
        }

        protected void addMoreFields() {
            super.addMoreFields();
            this.createUI();
            this.addDevice(DeviceType.Keyboard, this.requestData.deviceTypes.contains(DeviceType.Keyboard), new Listener(this){
                private final /* synthetic */ NewDesignDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event evt) {
                    this.this$0.toggleDeviceType(DeviceType.Keyboard);
                }
            });
            this.addDevice(DeviceType.Mouse, this.requestData.deviceTypes.contains(DeviceType.Mouse), new Listener(this){
                private final /* synthetic */ NewDesignDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event evt) {
                    this.this$0.toggleDeviceType(DeviceType.Mouse);
                }
            });
            this.addDevice(DeviceType.Touchscreen, this.requestData.deviceTypes.contains(DeviceType.Touchscreen), new Listener(this){
                private final /* synthetic */ NewDesignDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleEvent(Event evt) {
                    this.this$0.toggleDeviceType(DeviceType.Touchscreen);
                }
            });
        }

        protected void addMoreButtons() {
            super.addMoreButtons();
            this.enableOKButtonCheck();
        }

        protected void enableOKButtonCheck() {
            boolean enableOk = false;
            if (this.designNameInput.getText().length() > 0 && this.requestData.deviceTypes.size() > 0) {
                enableOk = true;
            }
            this.okButton.setEnabled(enableOk);
        }
    }
}

