/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.ITaskGroup;
import edu.cmu.cs.hcii.cogtool.model.IUndertaking;
import edu.cmu.cs.hcii.cogtool.ui.IProjectSelectionState;
import edu.cmu.cs.hcii.cogtool.util.Alerter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class ProjectContextSelectionState
extends Alerter
implements IProjectSelectionState {
    protected Map selectedItems = new HashMap();
    protected ArrayList selectedColumns = new ArrayList();

    public void deselectAll() {
        this.selectedItems.clear();
        this.selectedColumns.clear();
    }

    public IDesign getSelectedDesign() {
        TreeColumn column = this.getSelectedColumn();
        return column == null ? null : (IDesign)column.getData();
    }

    public TreeColumn getSelectedColumn() {
        return this.selectedColumns.size() > 0 ? (TreeColumn)this.selectedColumns.get(0) : null;
    }

    public IUndertaking[] getSelectedTasks() {
        IUndertaking[] selection = new IUndertaking[this.getSelectedTaskCount()];
        for (int i = 0; i < this.getSelectedTaskCount(); ++i) {
            selection[i] = (IUndertaking)this.getSelectedTaskItems()[i].getData();
        }
        return selection;
    }

    public int getSelectedTaskCount() {
        return this.selectedItems.size();
    }

    public TreeItem[] getSelectedTaskItems() {
        TreeItem[] sel = new TreeItem[this.selectedItems.size()];
        this.selectedItems.values().toArray(sel);
        return sel;
    }

    public ITaskGroup getSelectedTaskParent() {
        boolean first = true;
        TreeItem allParent = null;
        Iterator itemIt = this.selectedItems.values().iterator();
        while (itemIt.hasNext()) {
            TreeItem item = (TreeItem)itemIt.next();
            TreeItem parentOfItem = item.getParentItem();
            if (parentOfItem == null) {
                return null;
            }
            if (first) {
                first = false;
                allParent = parentOfItem;
                continue;
            }
            if (parentOfItem == allParent) continue;
            return null;
        }
        if (allParent == null) {
            return null;
        }
        return (ITaskGroup)allParent.getData();
    }

    public ITaskGroup[] getSelectedTaskParents() {
        int selectedItemCount = this.selectedItems.size();
        ITaskGroup[] parents = new ITaskGroup[selectedItemCount];
        Iterator itemIt = this.selectedItems.values().iterator();
        int i = 0;
        while (itemIt.hasNext()) {
            TreeItem item = (TreeItem)itemIt.next();
            TreeItem itemParent = item.getParentItem();
            if (itemParent == null) {
                parents[i++] = null;
                continue;
            }
            parents[i++] = (ITaskGroup)itemParent.getData();
        }
        return parents;
    }

    public boolean isTaskSelected(IUndertaking task) {
        return this.selectedItems.containsKey(task);
    }

    public void setSelectedColumn(TreeColumn column) {
        this.deselectAll();
        this.addSelectedColumn(column);
    }

    public void setSelectedItem(TreeItem row) {
        this.deselectAll();
        this.addSelectedItem(row);
    }

    public void addSelectedColumn(TreeColumn column) {
        this.selectedColumns.add(column);
    }

    public void deselectColumn(TreeColumn column) {
        int columnIndex = this.selectedColumns.indexOf(column);
        if (columnIndex != -1) {
            this.selectedColumns.remove(columnIndex);
        }
    }

    public void deselectRow(TreeItem row) {
        this.selectedItems.remove(row.getData());
    }

    public void addSelectedItem(TreeItem row) {
        this.selectedItems.put(row.getData(), row);
    }
}

