/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IPredictionAlgo;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IScript;
import edu.cmu.cs.hcii.cogtool.model.ITask;
import edu.cmu.cs.hcii.cogtool.model.ITaskApplication;
import edu.cmu.cs.hcii.cogtool.model.StandaloneAlgo;
import edu.cmu.cs.hcii.cogtool.ui.DefaultInteraction;
import edu.cmu.cs.hcii.cogtool.ui.DefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IVisualizationUI;
import edu.cmu.cs.hcii.cogtool.ui.PERTChartMouseState;
import edu.cmu.cs.hcii.cogtool.ui.PERTChartScrollBarMouseState;
import edu.cmu.cs.hcii.cogtool.ui.PERTChartSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.PERTTraceMouseState;
import edu.cmu.cs.hcii.cogtool.uimodel.PERTChartUIModel;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.PERTChartView;
import org.eclipse.swt.events.MouseListener;

public class PERTChartUI
extends DefaultUI
implements IVisualizationUI {
    protected StandaloneAlgo.StandaloneResult model;
    protected ITask task;
    protected IScript script;
    protected IDesign design;
    protected PERTChartView view;
    protected PERTChartSelectionState selection;
    protected PERTChartMouseState pertMouseState;
    protected PERTTraceMouseState traceMouseState;
    protected PERTChartScrollBarMouseState pertScrollBarMouseState;
    protected IInteraction interaction;
    protected PERTChartUIModel pertUIModel;
    protected static final String VISUALIZATION_PREFIX = L10N.get("WT.VisualizationPrefix", "Visualization");

    protected static String buildWindowMenuLabel(IDesign design, ITask task) {
        return VISUALIZATION_PREFIX + ": " + design.getName() + " > " + task.getName();
    }

    public PERTChartUI(ITask task, IDesign design, IPredictionAlgo algorithm, IProject project) {
        super(project, PERTChartUI.buildWindowMenuLabel(design, task), PERTChartUI.buildLeadItems(project));
        ITaskApplication taskApplication = project.getTaskApplication(task, design);
        this.model = (StandaloneAlgo.StandaloneResult)taskApplication.getResult(algorithm);
        this.task = task;
        this.script = taskApplication.getScript(StandaloneAlgo.ONLY);
        this.design = design;
        this.pertUIModel = new PERTChartUIModel(this.script, this.task, this.design, this.project);
        this.view = new PERTChartView(this.model, this.script, this.lIDMap, this, this.menuData, this.pertUIModel, null);
        this.selection = new PERTChartSelectionState();
        this.view.observeSelectionState(this.selection);
        this.pertMouseState = new PERTChartMouseState(this.view.getVisPanel(), this.selection);
        this.traceMouseState = new PERTTraceMouseState(this.view.getTextCtrl(), this.model, this.selection);
        this.view.getTextCtrl().addMouseListener((MouseListener)this.traceMouseState);
        this.view.getVisPanel().addMouseHandler(this.pertMouseState, this.pertMouseState);
        this.pertScrollBarMouseState = new PERTChartScrollBarMouseState(this.view.getVisScrollBar());
        this.view.getVisScrollBar().addMouseHandler(this.pertScrollBarMouseState, this.pertScrollBarMouseState);
        this.interaction = new DefaultInteraction(this.view);
        this.view.setWindowTitle(this.buildWindowMenuLabel());
        this.setInitiallyEnabled();
    }

    protected Object getModelObject() {
        return this.model;
    }

    protected String buildWindowMenuLabel() {
        return PERTChartUI.buildWindowMenuLabel(this.design, this.task);
    }

    public IView getView() {
        return this.view;
    }

    public IInteraction getStandardInteraction() {
        return this.interaction;
    }

    public PERTChartUIModel getUIModel() {
        return this.pertUIModel;
    }
}

