/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.util.SWTContextMenuUtil;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.PERTScrollBar;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;

public class PERTChartScrollBarMouseState
extends SWTContextMenuUtil.MenuListenerAdapter
implements MouseMoveListener {
    static final int NOT_SCROLLING = 0;
    static final int LEFT_SCROLLING = 1;
    static final int RIGHT_SCROLLING = 2;
    static final int INACTIVE = 0;
    static final int MOVING = 1;
    static final int RESIZING_START = 2;
    static final int RESIZING_END = 3;
    static final int POTENTIAL_DRAWING = 4;
    protected double lastStart;
    protected double lastEnd;
    protected int mouseState;
    protected int mouseDownX;
    protected int mouseOffset;
    protected PERTScrollBar scrollBar;

    public PERTChartScrollBarMouseState(PERTScrollBar visScrollBar) {
        this.scrollBar = visScrollBar;
        this.mouseState = 0;
        this.mouseDownX = -1;
        this.lastStart = 0.0;
        this.lastEnd = this.scrollBar.getTotalTime();
    }

    public void mouseMove(MouseEvent e) {
        double start = this.scrollBar.getStart();
        double end = this.scrollBar.getEnd();
        if (this.mouseDownX > -1) {
            int lMargin = this.scrollBar.getLeftMargin();
            double visWidth = this.scrollBar.getVisualizationWidth();
            double tTime = this.scrollBar.getTotalTime();
            switch (this.mouseState) {
                case 3: {
                    double newEnd = (double)(e.x - lMargin) / visWidth * tTime;
                    newEnd = Math.min(newEnd, tTime);
                    if (newEnd < start) {
                        this.mouseState = 2;
                        this.scrollBar.changeRegion(newEnd, start, true);
                        break;
                    }
                    this.scrollBar.changeRegion(start, newEnd, true);
                    break;
                }
                case 2: {
                    double newStart = (double)(e.x - lMargin) / visWidth * tTime;
                    newStart = Math.max(0.0, newStart);
                    if (newStart > end) {
                        this.mouseState = 3;
                        this.scrollBar.changeRegion(end, newStart, true);
                        break;
                    }
                    this.scrollBar.changeRegion(newStart, end, true);
                    break;
                }
                case 1: {
                    double newStart = ((double)(e.x - lMargin) - (double)this.mouseOffset) / visWidth * tTime;
                    this.scrollBar.changeRegion(newStart, newStart + (end - start));
                    break;
                }
                case 4: {
                    if (Math.abs(this.mouseDownX - e.x) <= 3) break;
                    this.mouseState = this.mouseDownX < e.x ? 3 : 2;
                    double newStart = (double)(this.mouseDownX - lMargin) / visWidth * tTime;
                    double newEnd = (double)(e.x - lMargin) / visWidth * tTime;
                    this.scrollBar.changeRegion(newStart, newEnd, true);
                }
            }
        }
        this.setCursor(e);
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1) {
            double start = this.scrollBar.getStart();
            double end = this.scrollBar.getEnd();
            this.mouseDownX = e.x;
            double sbVisWidth = this.scrollBar.getVisualizationWidth();
            double tTime = this.scrollBar.getTotalTime();
            int lMargin = this.scrollBar.getLeftMargin();
            this.mouseOffset = (int)((double)e.x - (sbVisWidth * start / tTime + (double)lMargin));
            int startX = lMargin + (int)(sbVisWidth * (start / tTime));
            int endX = lMargin + (int)(sbVisWidth * (end / tTime));
            this.mouseState = e.x >= startX && e.x < startX + 5 ? 2 : (e.x <= endX && e.x > endX - 5 ? 3 : (e.x > endX || e.x < startX ? 4 : 1));
            this.setCursor(e);
        }
    }

    public void mouseUp(MouseEvent e) {
        double start = this.scrollBar.getStart();
        double end = this.scrollBar.getEnd();
        double sbVisWidth = this.scrollBar.getVisualizationWidth();
        double tTime = this.scrollBar.getTotalTime();
        double lMargin = this.scrollBar.getLeftMargin();
        double clickTime = ((double)e.x - lMargin) / sbVisWidth * tTime;
        if (this.mouseState == 4) {
            double visibleDistance = end - start;
            double newStart = clickTime - visibleDistance * 0.5;
            newStart = Math.max(0.0, newStart);
            newStart = Math.min(newStart, tTime - visibleDistance);
            this.scrollBar.changeRegion(newStart, newStart + visibleDistance);
        } else if (this.mouseState == 3) {
            this.scrollBar.changeRegion(start, Math.min(clickTime, tTime));
        } else if (this.mouseState == 2) {
            this.scrollBar.changeRegion(Math.max(clickTime, 0.0), end);
        }
        this.mouseDownX = -1;
        this.mouseState = 0;
        this.setCursor(e);
    }

    public void mouseDoubleClick(MouseEvent e) {
        double start = this.scrollBar.getStart();
        double end = this.scrollBar.getEnd();
        if (end == this.scrollBar.getTotalTime() && start == 0.0) {
            end = this.lastEnd;
            start = this.lastStart;
        } else {
            this.lastEnd = end;
            this.lastStart = start;
            end = this.scrollBar.getTotalTime();
            start = 0.0;
        }
        this.scrollBar.changeRegion(start, end);
    }

    protected void setCursor(MouseEvent e) {
        double start = this.scrollBar.getStart();
        double end = this.scrollBar.getEnd();
        int lMargin = this.scrollBar.getLeftMargin();
        double visWidth = this.scrollBar.getVisualizationWidth();
        double tTime = this.scrollBar.getTotalTime();
        int startLoc = lMargin + (int)(visWidth * (start / tTime));
        int endLoc = lMargin + (int)(visWidth * (end / tTime));
        if (this.mouseState == 1) {
            this.scrollBar.setCursor(this.scrollBar.getClosedHandCursor());
        } else if (e.x >= startLoc + 5 && e.x <= endLoc - 5 && this.mouseDownX == -1) {
            this.scrollBar.setCursor(this.scrollBar.getOpenHandCursor());
        } else {
            int cursor = 0;
            if (this.mouseState == 2) {
                cursor = 13;
            } else if (this.mouseState == 3) {
                cursor = 12;
            } else if (e.x >= startLoc && e.x < startLoc + 5) {
                cursor = 13;
            } else if (e.x <= endLoc && e.x > endLoc - 5) {
                cursor = 12;
            }
            this.scrollBar.setCursor(new Cursor((Device)WindowUtil.globalDisplay, cursor));
        }
    }
}

