/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.KeyPressType;
import edu.cmu.cs.hcii.cogtool.model.MouseButtonState;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.TapPressType;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.ITransitionSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IZoomableUI;

public interface IDesignEditorUI
extends IZoomableUI {
    public static final DeviceType BASE_ACTION_ON_SOURCE = null;

    public void selectAllFrames();

    public IDesignEditorInteraction getInteraction();

    public DeviceType getCurrentDeviceType();

    public int determineChangeActionMode(ITransitionSource var1);

    public void updateActionProperties(ITransitionSource var1, IAction var2, ActionProperties var3);

    public void initiateFrameRename(IFrame var1);

    public void initiateFrameRename(IFrameSelectionState var1);

    public void getDefaultProperties(ITransitionSource var1, ActionProperties var2);

    public static class FrameRenameEvent {
        public IFrame frame;
        public String newName;
        public IFrameSelectionState selection;

        public FrameRenameEvent(IFrame frameToRename, String newFrameName, IFrameSelectionState seln) {
            this.frame = frameToRename;
            this.newName = newFrameName;
            this.selection = seln;
        }
    }

    public static class ChangeActionParameters {
        public ITransitionSelectionState selection;
        public ActionProperties properties;

        public ChangeActionParameters(ActionProperties p, ITransitionSelectionState s) {
            this.properties = p;
            this.selection = s;
        }
    }

    public static class ActionProperties {
        public static final int UNSET = -1;
        public static final int USE_MOUSE = 0;
        public static final int USE_VOICE = 1;
        public static final int USE_KEYBOARD = 2;
        public static final int USE_GRAFFITI_WIDGET = 3;
        public static final int USE_TOUCHSCREEN = 4;
        public int useWhichParts = -1;
        public MouseButtonState mouseButton = MouseButtonState.Left;
        public MousePressType buttonAction = MousePressType.Click;
        public TapPressType tapAction = TapPressType.Tap;
        public int buttonState = 0;
        public String graffitiString = "";
        public boolean graffitiIsCmd = false;
        public String keyboardString = "";
        public boolean keyboardIsCmd = false;
        public KeyPressType keyboardAction = KeyPressType.Stroke;
        public String voiceString = "";
        public boolean voiceIsCmd = false;

        public ActionProperties(int whichParts) {
            this.useWhichParts = whichParts;
        }

        public void copyValues(ActionProperties fromProperties) {
            this.useWhichParts = fromProperties.useWhichParts;
            this.mouseButton = fromProperties.mouseButton;
            this.buttonAction = fromProperties.buttonAction;
            this.tapAction = fromProperties.tapAction;
            this.buttonState = fromProperties.buttonState;
            this.graffitiString = fromProperties.graffitiString;
            this.graffitiIsCmd = fromProperties.graffitiIsCmd;
            this.keyboardString = fromProperties.keyboardString;
            this.keyboardIsCmd = fromProperties.keyboardIsCmd;
            this.keyboardAction = fromProperties.keyboardAction;
            this.voiceString = fromProperties.voiceString;
            this.voiceIsCmd = fromProperties.voiceIsCmd;
        }
    }

    public static class ChangeSourceParameters {
        public ITransition transition;
        public ITransitionSource newSource;

        public ChangeSourceParameters(ITransition t, ITransitionSource s) {
            this.transition = t;
            this.newSource = s;
        }
    }

    public static class ChangeTargetParameters {
        public ITransition transition;
        public IFrame newDestination;

        public ChangeTargetParameters(ITransition t, IFrame f) {
            this.transition = t;
            this.newDestination = f;
        }
    }

    public static class NewTransitionParameters {
        public ITransitionSource source;
        public IFrame target;
        public double x;
        public double y;

        public NewTransitionParameters(ITransitionSource transitionSource, IFrame targetFrame, double atX, double atY) {
            this.source = transitionSource;
            this.target = targetFrame;
            this.x = atX;
            this.y = atY;
        }
    }

    public static class MoveParameters {
        public double dx;
        public double dy;
        public IDesignEditorSelectionState selection;

        public MoveParameters(double deltaX, double deltaY, IDesignEditorSelectionState selnState) {
            this.dx = deltaX;
            this.dy = deltaY;
            this.selection = selnState;
        }
    }
}

