/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IMenuHeader;
import edu.cmu.cs.hcii.cogtool.model.IMenuItem;
import edu.cmu.cs.hcii.cogtool.model.IMenuWidget;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidgetGroup;
import edu.cmu.cs.hcii.cogtool.model.SkinType;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.AUI;
import edu.cmu.cs.hcii.cogtool.ui.DefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.DelayedRepaint;
import edu.cmu.cs.hcii.cogtool.ui.DelayedSelection;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorMouseState;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.ZoomableUI;
import edu.cmu.cs.hcii.cogtool.uimodel.FrameEditorUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IFrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuHeader;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuItem;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.SWTTextEditor;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import edu.cmu.cs.hcii.cogtool.view.FrameEditorView;
import edu.cmu.cs.hcii.cogtool.view.IFrameEditorView;
import edu.cmu.cs.hcii.cogtool.view.IScalableFigure;
import edu.cmu.cs.hcii.cogtool.view.IScalableInteractiveFigure;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;
import edu.cmu.cs.hcii.cogtool.view.InteractionFigure;
import edu.cmu.cs.hcii.cogtool.view.PotentialMenuFigure;
import edu.cmu.cs.hcii.cogtool.view.ResizeThumb;
import edu.cmu.cs.hcii.cogtool.view.UndoManagerView;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FrameEditorUI
extends ZoomableUI
implements IFrameEditorUI {
    public static final int LABEL_HEIGHT = 15;
    protected IFrameEditorView view;
    protected IFrameEditorInteraction interaction;
    protected IAlertHandler widgetChangeHandler = new IAlertHandler(){

        public void handleAlert(EventObject alert) {
            IWidget widget = (IWidget)alert.getSource();
            if (FrameEditorUI.this.selection.isWidgetSelected(widget)) {
                FrameEditorUI.this.updateView();
            }
        }
    };
    protected UndoManager undoManager;
    protected FrameEditorSelectionState selection;
    protected FrameEditorSelectionState contextSelection;
    protected boolean anchorTopLeft = false;
    protected ResizeThumb topLeftResize;
    protected ResizeThumb bottomLeftResize = null;
    protected ResizeThumb topRightResize = null;
    protected ResizeThumb bottomRightResize = null;
    protected PotentialMenuFigure rightPotentialMenu = new PotentialMenuFigure();
    protected PotentialMenuFigure bottomPotentialMenu = new PotentialMenuFigure();
    protected IGraphicalMenuWidget potentialMenuOwner = null;
    protected WidgetTitleEditor editor = null;
    protected FrameEditorUIModel uiModel;
    protected IFrame frame;
    protected IDesign design;
    protected IFrameUIModel frameUI;
    protected DelayedSelection delayedWidgetSelection;
    protected static final int REPAINT_SELECT_HANDLES = 1;
    protected static final int PERFORM_LWS_UPDATE = 2;
    protected static final int REPAINT_EDITOR = 4;
    protected static final int RESET_VISIBLE_AREA = 8;
    protected static final int ZOOM_REPAINT = 5;
    protected static final int SHAPE_CHANGE_REPAINT = 9;
    protected static final int REPAINT_ALL = -1;
    protected DelayedRepaint delayedRepainting;
    protected static final String FRAME_PREFIX = L10N.get("WT.FramePrefix", "Frame");

    protected static String buildWindowMenuLabel(IDesign design, IFrame frame) {
        return FRAME_PREFIX + ": " + design.getName() + " > " + frame.getName();
    }

    public FrameEditorUI(IFrame modelFrame, IDesign modelDesign, IProject modelProject, UndoManager undoMgr) {
        super(modelProject, FrameEditorUI.buildWindowMenuLabel(modelDesign, modelFrame), FrameEditorUI.buildLeadItems(modelProject, modelDesign));
        if (undoMgr == null) {
            throw new IllegalArgumentException("Cannot create a FrameEditorUIModel with a null Undo Manager");
        }
        this.selection = new FrameEditorSelectionState();
        this.contextSelection = new FrameEditorSelectionState();
        this.delayedWidgetSelection = new DelayedSelection(this.selection){

            protected void selectItem(Object item) {
                IGraphicalMenuWidget mw;
                FrameEditorUI.this.selection.selectWidget((IGraphicalWidget)item);
                if (item instanceof IGraphicalMenuWidget && (mw = (IGraphicalMenuWidget)item).getWidgetModel().getTitle() == "") {
                    FrameEditorUI.this.initiateRenameMenu(mw);
                }
            }
        };
        this.delayedRepainting = new DelayedRepaint(){

            protected void performRepaint() {
                InteractionDrawingEditor viewEditor = FrameEditorUI.this.view.getEditor();
                if (this.isRepaintNeeded(2)) {
                    viewEditor.getLWS().getUpdateManager().performUpdate();
                }
                if (this.isRepaintNeeded(1)) {
                    FrameEditorUI.this.drawResizeHandles();
                    FrameEditorUI.this.redrawMenuSelection();
                }
                if (this.isRepaintNeeded(4)) {
                    FrameEditorUI.this.repaintEditor();
                }
                FrameEditorUI.this.resetVisibleArea();
                if (!FrameEditorUI.this.view.isDisposed()) {
                    FrameEditorUI.this.updateView();
                }
            }

            public void doWork() {
                super.doWork();
                FrameEditorUI.this.setViewEnabledState(FrameEditorUI.this.selection, ListenerIdentifierMap.NORMAL);
            }
        };
        CogTool.selectionPhase.addDelayedWork(this.delayedWidgetSelection);
        CogTool.repaintPhase.addDelayedWork(this.delayedRepainting);
        this.uiModel = new FrameEditorUIModel(modelFrame, modelDesign, modelProject, this.getWindowZoom(modelFrame), this.widgetChangeHandler);
        this.frame = modelFrame;
        this.design = modelDesign;
        this.frameUI = this.uiModel.getFrameUI();
        FrameEditorMouseState mouseState = new FrameEditorMouseState(this);
        int deviceTypes = DeviceType.buildDeviceSet(this.design.getDeviceTypes());
        IScalableFigure contents = this.frameUI.getContents();
        this.view = new FrameEditorView(deviceTypes, this.lIDMap, this, this.menuData, contents, mouseState, mouseState, this.selection, this, this.getWindowLocation());
        InteractionDrawingEditor drawingEditor = this.view.getEditor();
        this.setZoomEditor(drawingEditor);
        Canvas editorSubstrate = drawingEditor.getSWTEditorSubstrate();
        editorSubstrate.addListener(35, (Listener)mouseState);
        this.updateTitle();
        this.interaction = new FrameEditorInteraction(this.view);
        this.undoManager = undoMgr;
        UndoManagerView.UndoAlertHandler undoMgrViewHandler = new UndoManagerView.UndoAlertHandler(this.undoManager, this.lIDMap, CogToolLID.Undo, CogToolLID.Redo);
        undoMgr.addHandler(this, EventObject.class, undoMgrViewHandler);
        this.init(modelFrame, modelDesign, mouseState);
    }

    protected void addEventListeners(FrameEditorMouseState mouseState) {
        InteractionFigure interactionLayer = this.view.getEditor().getInteractionFigure();
        interactionLayer.addKeyListener(mouseState);
    }

    protected void setFigureBounds(PotentialMenuFigure figure) {
        if (figure.isVisible()) {
            DoubleRectangle shapeBds = this.potentialMenuOwner.getWidgetModel().getShape().getBounds();
            Rectangle bounds = PrecisionUtilities.getDraw2DRectangle(shapeBds);
            if (figure == this.bottomPotentialMenu) {
                if (this.potentialMenuOwner instanceof IGraphicalMenuHeader) {
                    bounds.width = (int)Math.round((double)bounds.width * 1.3);
                }
                bounds.y += bounds.height;
            } else {
                bounds.x += bounds.width;
            }
            figure.setBounds(bounds);
        }
    }

    protected void setUpFigure(PotentialMenuFigure figure) {
        this.frameUI.getContents().add((IFigure)figure);
        figure.setVisible(true);
        this.setFigureBounds(figure);
    }

    protected void updateMenuFigures() {
        if (this.potentialMenuOwner != null) {
            this.setFigureBounds(this.bottomPotentialMenu);
            this.setFigureBounds(this.rightPotentialMenu);
        }
    }

    public void redrawMenuSelection() {
        IGraphicalMenuWidget selectedParent;
        if (this.selection.getWidgetSelectionCount() == 1 && (selectedParent = this.getSelectedMenuWidget()) != null) {
            this.redrawMenuChildren(selectedParent);
        }
    }

    protected void redrawMenuChildren(IGraphicalMenuWidget gmw) {
        this.potentialMenuOwner = gmw;
        if (gmw instanceof IGraphicalMenuHeader) {
            IGraphicalMenuHeader gmh = (IGraphicalMenuHeader)gmw;
            IMenuHeader header = (IMenuHeader)gmw.getWidgetModel();
            IWidgetGroup hdrGroup = header.getParentGroup();
            if (hdrGroup.indexOf(header) == hdrGroup.widgetCount() - 1) {
                this.setUpFigure(this.rightPotentialMenu);
            }
            if (header.itemCount() == 0) {
                this.setUpFigure(this.bottomPotentialMenu);
            } else {
                gmh.openMenu();
            }
        } else if (gmw instanceof IGraphicalMenuItem) {
            IMenuItem item = (IMenuItem)gmw.getWidgetModel();
            IMenuWidget itemParent = item.getParent();
            if (itemParent.indexOf(item) == itemParent.itemCount() - 1) {
                this.setUpFigure(this.bottomPotentialMenu);
            }
            if (item.isSubmenu()) {
                if (item.itemCount() == 0) {
                    this.setUpFigure(this.rightPotentialMenu);
                } else {
                    ((IGraphicalMenuItem)gmw).openMenu();
                }
            } else {
                this.setUpFigure(this.rightPotentialMenu);
            }
            IGraphicalMenuWidget header = ((IGraphicalMenuItem)gmw).getParentHeader();
            if (header != null) {
                header.openMenu();
            }
        }
    }

    protected void redrawMenuFigures(IGraphicalMenuWidget gmw) {
        this.hidePotentialMenuFigures();
        this.deselectPotentialMenuFigures();
        this.cleanupMenuLabelEditor();
        if (this.selection.getWidgetSelectionCount() == 1 && this.selection.isWidgetFigureSelected(gmw)) {
            this.redrawMenuChildren(gmw);
        }
    }

    protected void addSelectionChangeListeners() {
        IAlertHandler widgetSelectionHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                FrameEditorSelectionState.SelectionChange event = (FrameEditorSelectionState.SelectionChange)alert;
                if (event != null) {
                    if (event.changedWidget != null) {
                        IGraphicalWidget gw = event.changedWidget;
                        IWidget w = gw.getWidgetModel();
                        if (FrameEditorUI.this.frame.getWidgets().contains(w)) {
                            gw.setSelected(event.selected);
                        }
                        if (gw instanceof IGraphicalMenuWidget) {
                            IGraphicalMenuWidget gmw = (IGraphicalMenuWidget)gw;
                            if (!event.selected) {
                                FrameEditorUI.this.hideAllMenuItems();
                            }
                            FrameEditorUI.this.redrawMenuFigures(gmw);
                        }
                        gw.repaint();
                    } else {
                        if (!event.selected) {
                            FrameEditorUI.this.hideAllMenuItems();
                        }
                        Iterator widgets = ((FrameEditorSelectionState)event.getSource()).getSelectedWidgetFigures();
                        while (widgets.hasNext()) {
                            IGraphicalWidget gw = (IGraphicalWidget)widgets.next();
                            gw.setSelected(event.selected);
                            gw.repaint();
                        }
                    }
                    FrameEditorUI.this.delayedRepainting.requestRepaint(-1);
                }
            }
        };
        this.selection.addHandler(this, FrameEditorSelectionState.SelectionChange.class, widgetSelectionHandler);
    }

    protected void addBackgroundImageHandler() {
        IAlertHandler backgroundEnabler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                boolean enable = FrameEditorUI.this.frame.getBackgroundImage() != null;
                FrameEditorUI.this.setEnabled(CogToolLID.RemoveBackgroundImage, ListenerIdentifierMap.ALL, enable);
                FrameEditorUI.this.view.setIsBackgroundAvailable(enable);
            }
        };
        this.frame.addHandler(this, IFrame.BackgroundImageChange.class, backgroundEnabler);
    }

    protected void addFrameWidgetHandler() {
        IAlertHandler frameWidgetHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IFrame.WidgetChange chg = (IFrame.WidgetChange)alert;
                if (chg != null) {
                    switch (chg.action) {
                        case 0: {
                            IGraphicalWidget gw = FrameEditorUI.this.frameUI.getWidgetFigure(chg.widget);
                            gw.addChangeHandler(FrameEditorUI.this.widgetChangeHandler);
                            FrameEditorUI.this.delayedWidgetSelection.addToSelection(chg.widget, gw);
                            FrameEditorUI.this.view.requestRename();
                            break;
                        }
                        case 1: {
                            IGraphicalWidget gw = FrameEditorUI.this.selection.deselectWidget(chg.widget);
                            if (gw == null) {
                                gw = FrameEditorUI.this.frameUI.getWidgetFigure(chg.widget);
                            }
                            if (gw != null) {
                                gw.removeChangeHandler(FrameEditorUI.this.widgetChangeHandler);
                            }
                            FrameEditorUI.this.delayedRepainting.requestRepaint(1);
                            break;
                        }
                    }
                }
            }
        };
        this.frame.addHandler(this, IFrame.WidgetChange.class, frameWidgetHandler);
    }

    public void resetVisibleArea() {
        InteractionDrawingEditor e = this.view.getEditor();
        e.getLWS().getUpdateManager().performUpdate();
        DoubleSize extent = this.frameUI.getPreferredSize();
        e.setMinVisibleArea(PrecisionUtilities.round(extent.width), PrecisionUtilities.round(extent.height), false);
    }

    protected void addWidgetShapeChangeHandler() {
        IAlertHandler widgetShapeChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                FrameEditorUI.this.delayedRepainting.requestRepaint(9);
            }
        };
        this.frameUI.addHandler(this, IFrameUIModel.WidgetShapeImageChange.class, widgetShapeChangeHandler);
    }

    private void init(final IFrame frame, final IDesign design, FrameEditorMouseState mouseState) {
        this.addEventListeners(mouseState);
        this.addSelectionChangeListeners();
        this.addBackgroundImageHandler();
        this.addFrameWidgetHandler();
        this.addWidgetShapeChangeHandler();
        this.project.addHandler(this, IProject.DesignChange.class, new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IProject.DesignChange chg = (IProject.DesignChange)alert;
                if (!chg.isAdd && chg.element == design) {
                    FrameEditorUI.this.closeOpenController();
                }
            }
        });
        this.design.addHandler(this, IDesign.FrameChange.class, new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign.FrameChange chg = (IDesign.FrameChange)alert;
                if (!chg.isAdd && chg.element == frame) {
                    FrameEditorUI.this.closeOpenController();
                }
            }
        });
        this.frame.addHandler(this, NameChangeAlert.class, this.renameHandler);
        this.design.addHandler(this, NameChangeAlert.class, this.renameHandler);
        this.setInitiallyEnabled();
    }

    protected void updateTitle() {
        this.view.setWindowTitle(this.modificationFlag + FRAME_PREFIX + ": " + this.project.getName() + " > " + this.design.getName() + " > " + this.frame.getName() + (OSUtils.MACOSX ? "" : WINDOW_TITLE));
    }

    protected String buildWindowMenuLabel() {
        return FrameEditorUI.buildWindowMenuLabel(this.design, this.frame);
    }

    public void dispose() {
        super.dispose();
        CogTool.selectionPhase.removeDelayedWork(this.delayedWidgetSelection);
        CogTool.repaintPhase.removeDelayedWork(this.delayedRepainting);
        this.uiModel.dispose();
        this.frameUI.removeAllHandlers(this);
        this.frame.removeAllHandlers(this);
        this.design.removeAllHandlers(this);
        this.undoManager.removeAllHandlers(this);
        this.selection.removeAllHandlers(this);
    }

    protected Object getModelObject() {
        return this.frame;
    }

    public IFrameEditorInteraction getInteraction() {
        return this.interaction;
    }

    public IInteraction getStandardInteraction() {
        return this.interaction;
    }

    public IFrameEditorSelectionState getSelectionState() {
        return this.selection;
    }

    public IFrameUIModel getFrameUI() {
        return this.uiModel.getFrameUI();
    }

    public IGraphicalWidget widgetLocatedAtXY(int x, int y) {
        return this.uiModel.widgetLocatedAtXY(x, y);
    }

    public void selectAllWidgets() {
        Iterator widgetFigures = this.frameUI.getFigureListIterator();
        while (widgetFigures.hasNext()) {
            IGraphicalWidget widgetFigure = (IGraphicalWidget)widgetFigures.next();
            this.selection.selectWidget(widgetFigure);
        }
    }

    protected Rectangle getGroupFigureBounds(IWidgetGroup group) {
        Rectangle r = null;
        Iterator iter = group.getAllWidgets();
        while (iter.hasNext()) {
            IWidget w = (IWidget)iter.next();
            IGraphicalWidget gw = this.frameUI.getWidgetFigure(w);
            Rectangle bds = gw.getBounds();
            if (r == null) {
                r = new Rectangle(bds);
                continue;
            }
            r.union(bds);
        }
        return r;
    }

    protected Rectangle getSelectedWidgetFigureArea() {
        this.anchorTopLeft = false;
        Rectangle r = null;
        Iterator iter = this.selection.getSelectedWidgetFigures();
        while (iter.hasNext()) {
            Rectangle bds;
            IGraphicalWidget gw = (IGraphicalWidget)iter.next();
            IWidget w = gw.getWidgetModel();
            IWidgetGroup wg = w.getParentGroup();
            if (wg != null) {
                bds = this.getGroupFigureBounds(wg);
                this.anchorTopLeft = this.anchorTopLeft || w instanceof IMenuItem;
            } else {
                bds = gw.getBounds();
            }
            if (r == null) {
                r = new Rectangle(bds);
                continue;
            }
            r.union(bds);
        }
        return r;
    }

    public DoubleRectangle getSelectedWidgetArea() {
        DoubleRectangle r = null;
        IWidget[] selectedWidgets = this.selection.getSelectedIWidgets();
        for (int i = 0; i < selectedWidgets.length; ++i) {
            IWidget w = selectedWidgets[i];
            IWidgetGroup wg = w.getParentGroup();
            DoubleRectangle bds = wg != null ? wg.getGroupBounds() : w.getShape().getBounds();
            r = r == null ? new DoubleRectangle(bds) : r.union(bds);
        }
        return r;
    }

    public IView getView() {
        return this.view;
    }

    protected InteractionDrawingEditor getViewEditor() {
        return this.view.getEditor();
    }

    public void setZoom(double zoom) {
        super.setZoom(zoom);
        this.delayedRepainting.requestRepaint(5);
    }

    protected void setInitiallyEnabled() {
        super.setInitiallyEnabled();
        this.setEnabled(CogToolLID.NewWidget, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomToFit, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomNormal, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomIn, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomOut, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SetBackgroundImage, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SetWidgetColor, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinNone, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinWireFrame, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinWinXP, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinMacOSX, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinPalm, ListenerIdentifierMap.ALL, true);
        boolean enable = this.frame.getBackgroundImage() != null;
        this.setEnabled(CogToolLID.RemoveBackgroundImage, ListenerIdentifierMap.ALL, enable);
        this.view.setIsBackgroundAvailable(enable);
        this.setViewEnabledState(this.selection, ListenerIdentifierMap.NORMAL);
    }

    protected void setViewEnabledState(IFrameEditorSelectionState sel, Boolean availability) {
        boolean enabled = sel.getWidgetSelectionCount() == 1;
        this.setEnabled(CogToolLID.Rename, availability, enabled);
        enabled = sel.getWidgetSelectionCount() > 0;
        this.setEnabled(CogToolLID.Cut, availability, enabled);
        this.setEnabled(CogToolLID.Copy, availability, enabled);
        this.setEnabled(CogToolLID.Delete, availability, enabled);
        this.setEnabled(CogToolLID.Duplicate, availability, enabled);
        this.setEnabled(CogToolLID.NudgeLeft, availability, enabled);
        this.setEnabled(CogToolLID.NudgeRight, availability, enabled);
        this.setEnabled(CogToolLID.NudgeDown, availability, enabled);
        this.setEnabled(CogToolLID.NudgeUp, availability, enabled);
        this.setEnabled(CogToolLID.BringToFront, availability, enabled);
        this.setEnabled(CogToolLID.BringForward, availability, enabled);
        this.setEnabled(CogToolLID.SendBackward, availability, enabled);
        this.setEnabled(CogToolLID.SendToBack, availability, enabled);
        enabled = sel.getWidgetSelectionCount() > 1;
        this.setEnabled(CogToolLID.AlignTop, availability, enabled);
        this.setEnabled(CogToolLID.AlignBottom, availability, enabled);
        this.setEnabled(CogToolLID.AlignLeft, availability, enabled);
        this.setEnabled(CogToolLID.AlignRight, availability, enabled);
        enabled = sel.getWidgetSelectionCount() >= 3;
        this.setEnabled(CogToolLID.SpaceVertically, availability, enabled);
        this.setEnabled(CogToolLID.SpaceHorizontally, availability, enabled);
        enabled = this.frame.getWidgets().size() > 0;
        this.setEnabled(CogToolLID.SelectAll, availability, enabled);
        this.setSelected(CogToolLID.SkinNone, availability, false);
        this.setSelected(CogToolLID.SkinWireFrame, availability, false);
        this.setSelected(CogToolLID.SkinMacOSX, availability, false);
        this.setSelected(CogToolLID.SkinWinXP, availability, false);
        this.setSelected(CogToolLID.SkinPalm, availability, false);
        SkinType skin = this.design.getSkin();
        CogToolLID id = null;
        if (skin == SkinType.None) {
            id = CogToolLID.SkinNone;
        } else if (skin == SkinType.WireFrame) {
            id = CogToolLID.SkinWireFrame;
        } else if (skin == SkinType.MacOSX) {
            id = CogToolLID.SkinMacOSX;
        } else if (skin == SkinType.WinXP) {
            id = CogToolLID.SkinWinXP;
        } else if (skin == SkinType.Palm) {
            id = CogToolLID.SkinPalm;
        }
        this.setSelected(id, availability, true);
    }

    protected void setUpPerformAction(ListenerIdentifier id) {
        int selectionMask = FrameEditorUI.canCauseSelection(id, this.undoManager);
        if (FrameEditorUI.isSelectionFlagSet(selectionMask, 16)) {
            this.delayedWidgetSelection.setActive(true);
        }
    }

    public Object getParameters(ListenerIdentifier originalLID, ListenerIdentifier transmutedLID, boolean isContextSelection) {
        if (originalLID instanceof DefaultUI.RestoreParentControllerLID) {
            return super.getParameters(originalLID, transmutedLID, isContextSelection);
        }
        this.setUpPerformAction(transmutedLID);
        if (transmutedLID == FrameEditorLID.ChangeShapeProperty) {
            return new IFrameEditorUI.ShapeChangeParameters(this.view.getWidgetShape(), this.selection);
        }
        if (transmutedLID == FrameEditorLID.ChangeTypeProperty) {
            return new IFrameEditorUI.TypeChangeParameters(this.view.getWidgetType(), this.selection);
        }
        if (transmutedLID == FrameEditorLID.ChangeTitleProperty) {
            return new IFrameEditorUI.ActionStringParameters(this.view.getWidgetTitle(), this.selection);
        }
        if (transmutedLID == FrameEditorLID.ChangeNameProperty) {
            return new IFrameEditorUI.ActionStringParameters(this.view.getWidgetName(), this.selection);
        }
        return isContextSelection ? this.contextSelection : this.selection;
    }

    public void cleanup(boolean okToContinue, boolean menuHidden) {
        if (menuHidden) {
            IGraphicalWidget gwFig;
            Iterator widgets;
            if (this.contextSelection.getWidgetSelectionCount() > 0) {
                widgets = this.contextSelection.getSelectedWidgetFigures();
                while (widgets.hasNext()) {
                    gwFig = (IGraphicalWidget)widgets.next();
                    gwFig.dynamicHighlight(false);
                }
            }
            if (this.selection.getWidgetSelectionCount() > 0) {
                widgets = this.selection.getSelectedWidgetFigures();
                while (widgets.hasNext()) {
                    gwFig = (IGraphicalWidget)widgets.next();
                    gwFig.dynamicHighlight(false);
                }
            }
        }
        super.cleanup(okToContinue, menuHidden);
    }

    public void initiateWidgetRename(IWidget w) {
        this.view.setWidgetName(w.getName());
        this.view.requestRename();
    }

    public void drawResizeHandles() {
        Rectangle r = this.getSelectedWidgetFigureArea();
        InteractionDrawingEditor drawingEditor = this.view.getEditor();
        if (this.selection.getWidgetSelectionCount() == 1) {
            if (this.topLeftResize == null) {
                this.topLeftResize = new ResizeThumb(0);
                this.topRightResize = new ResizeThumb(2);
                this.bottomLeftResize = new ResizeThumb(1);
                this.bottomRightResize = new ResizeThumb(3);
                drawingEditor.addInteractionFigure((IFigure)this.topLeftResize);
                drawingEditor.addInteractionFigure((IFigure)this.bottomLeftResize);
                drawingEditor.addInteractionFigure((IFigure)this.topRightResize);
                drawingEditor.addInteractionFigure((IFigure)this.bottomRightResize);
            } else if (!this.bottomRightResize.isVisible()) {
                this.topRightResize.setVisible(true);
                this.bottomLeftResize.setVisible(true);
                this.bottomRightResize.setVisible(true);
            }
            this.topLeftResize.setVisible(!this.anchorTopLeft);
            if (r != null) {
                double scale = this.frameUI.getZoom();
                r.x = PrecisionUtilities.round((double)r.x * scale);
                r.y = PrecisionUtilities.round((double)r.y * scale);
                r.width = PrecisionUtilities.round((double)r.width * scale);
                r.height = PrecisionUtilities.round((double)r.height * scale);
                this.topLeftResize.centerAt(r.x, r.y);
                this.bottomLeftResize.centerAt(r.x, r.y + r.height);
                this.topRightResize.centerAt(r.x + r.width, r.y);
                this.bottomRightResize.centerAt(r.x + r.width, r.y + r.height);
                this.topLeftResize.repaint();
                this.bottomLeftResize.repaint();
                this.topRightResize.repaint();
                this.bottomRightResize.repaint();
            }
        } else if (this.topLeftResize != null) {
            this.topLeftResize.setVisible(false);
            this.topRightResize.setVisible(false);
            this.bottomLeftResize.setVisible(false);
            this.bottomRightResize.setVisible(false);
        }
    }

    protected void figureRepaint() {
        this.drawResizeHandles();
        this.updateMenuFigures();
        this.view.getEditor().getLWS().getUpdateManager().performUpdate();
    }

    public void setGraphicalWidgetBounds(double tempOriginX, double tempOriginY, double tempWidth, double tempHeight, IGraphicalWidget gw) {
        this.frameUI.setGraphicalWidgetBounds(tempOriginX, tempOriginY, tempWidth, tempHeight, gw);
        this.figureRepaint();
    }

    public void setGraphicalWidgetOrigin(double x, double y, IGraphicalWidget gw) {
        this.frameUI.setGraphicalWidgetOrigin(x, y, gw);
        this.figureRepaint();
    }

    public void moveMenuGroup(double offsetX, double offsetY, IGraphicalMenuWidget gw) {
        this.hideAllMenuItems();
        this.hidePotentialMenuFigures();
        IMenuHeader menuHeader = ((IMenuWidget)gw.getModel()).getTopHeader();
        IWidgetGroup headerGroup = menuHeader.getParentGroup();
        menuHeader = (IMenuHeader)headerGroup.getWidget(0);
        DoublePoint p = menuHeader.getShape().getOrigin();
        if (offsetX + p.x < 0.0) {
            offsetX = -p.x;
        }
        if (offsetY + p.y < 0.0) {
            offsetY = -p.y;
        }
        Point newOrigin = new Point(0, 0);
        int index = 1;
        int headerCount = headerGroup.widgetCount();
        while (true) {
            newOrigin.setLocation(PrecisionUtilities.round(p.x + offsetX), PrecisionUtilities.round(p.y + offsetY));
            this.frameUI.getWidgetFigure(menuHeader).setLocation(newOrigin);
            if (index >= headerCount) break;
            menuHeader = (IMenuHeader)headerGroup.getWidget(index++);
            p = menuHeader.getShape().getOrigin();
        }
        this.figureRepaint();
    }

    public void selectFigure(IFigure figure) {
        if (figure instanceof PotentialMenuFigure) {
            this.initiateRenameMenu(figure);
        } else if (figure instanceof IGraphicalMenuWidget) {
            this.selection.selectWidget((IGraphicalWidget)figure);
        }
    }

    public void setGraphicalWidgetMove(double diffX, double diffY, IGraphicalWidget gw) {
        this.frameUI.setGraphicalWidgetMove(diffX, diffY, gw);
        this.figureRepaint();
    }

    public void setTemporaryWidget(double x, double y, double w, double h, boolean outline) {
        IScalableFigure editorContents = this.view.getEditor().getContents();
        if (!(editorContents instanceof IScalableInteractiveFigure)) {
            throw new IllegalStateException("Attempted to call setTemporaryFigure on a IScalableFigure which does not support it.");
        }
        IScalableInteractiveFigure contents = (IScalableInteractiveFigure)editorContents;
        contents.setTemporaryFigure(PrecisionUtilities.round(x), PrecisionUtilities.round(y), PrecisionUtilities.round(w), PrecisionUtilities.round(h));
        contents.setOutlineDrawing(outline);
        this.figureRepaint();
    }

    protected void repaint() {
        this.figureRepaint();
        this.view.getEditor().getInteractionFigure().repaint();
    }

    public ResizeThumb widgetResizeUnderXY(int x, int y) {
        IFigure f = this.view.getEditor().getInteractionFigure().findFigureAt(x, y);
        if (f instanceof ResizeThumb) {
            return (ResizeThumb)f;
        }
        return null;
    }

    public PotentialMenuFigure potentialWidgetUnderXY(int x, int y) {
        IFigure f = this.view.getEditor().getInteractionFigure().findFigureAt(x, y);
        if (f instanceof PotentialMenuFigure) {
            return (PotentialMenuFigure)f;
        }
        return null;
    }

    protected void showContextMenu(IFrameEditorSelectionState seln, boolean context) {
        this.setViewEnabledState(seln, ListenerIdentifierMap.CONTEXT);
        if (seln.getWidgetSelectionCount() > 0) {
            this.view.showSelectionMenu(context);
        } else {
            this.view.showBlankSpaceMenu();
        }
    }

    public void showContextMenu() {
        this.showContextMenu(this.selection, false);
    }

    public void showContextMenu(int x, int y) {
        IGraphicalWidget w = (IGraphicalWidget)this.frameUI.getFigureAtXY(x, y, 1);
        if (w == null) {
            this.contextSelection.deselectAll();
            this.showContextMenu(this.contextSelection, true);
        } else if (w.isSelected()) {
            this.showContextMenu();
            Iterator wfs = this.selection.getSelectedWidgetFigures();
            while (wfs.hasNext()) {
                IGraphicalWidget wf = (IGraphicalWidget)wfs.next();
                wf.dynamicHighlight(true);
            }
            if (OSUtils.MACOSX) {
                this.figureRepaint();
            }
        } else {
            w.dynamicHighlight(true);
            this.contextSelection.setSelectedWidget(w);
            this.showContextMenu(this.contextSelection, true);
            if (OSUtils.MACOSX) {
                this.figureRepaint();
            }
        }
    }

    public void updateView() {
        int selectionCount = this.selection.getWidgetSelectionCount();
        if (selectionCount == 1) {
            Text text = AUI.getFocusedText();
            boolean restoreSel = false;
            if (text != null && text.getSelectionCount() == text.getCharCount()) {
                restoreSel = true;
            }
            Iterator iter = this.selection.getSelectedWidgetsIterator();
            while (iter.hasNext()) {
                IWidget widget = (IWidget)iter.next();
                this.view.setWidgetName(widget.getName());
                this.view.setWidgetTitle(widget.getTitle());
                this.view.setWidgetType(widget.getWidgetType());
                this.view.setWidgetShape(widget.getShape().getShapeType());
                this.view.setWidgetImage(widget.getImage());
            }
            this.view.useParameters(1);
            if (restoreSel) {
                text.selectAll();
            }
        } else if (selectionCount > 1) {
            this.view.useParameters(2);
        } else {
            this.view.useParameters(0);
        }
    }

    public void stopDrawingTemporaryFigure() {
        IScalableFigure editorContents = this.view.getEditor().getContents();
        if (!(editorContents instanceof IScalableInteractiveFigure)) {
            throw new IllegalStateException("Attempted to call StopDrawingTemporaryFigure on an IScalableFigure which does not support it.");
        }
        IScalableInteractiveFigure contents = (IScalableInteractiveFigure)editorContents;
        contents.stopDrawingTemporaryFigure();
    }

    public WidgetType getCurrentWidgetType() {
        return this.view.getWidgetType();
    }

    public void initiateRenameMenu(IFigure widgetFigure) {
        if (this.editor == null) {
            this.editor = new WidgetTitleEditor();
        }
        this.cleanupMenuLabelEditor();
        this.deselectPotentialMenuFigures();
        if (widgetFigure != null) {
            this.editor.editTitle(widgetFigure);
        }
    }

    protected IGraphicalMenuWidget getSelectedMenuWidget() {
        IGraphicalWidget selectedFigure;
        Iterator selectedParent = this.selection.getSelectedWidgetFigures();
        if (selectedParent.hasNext() && (selectedFigure = (IGraphicalWidget)selectedParent.next()) instanceof IGraphicalMenuWidget) {
            return (IGraphicalMenuWidget)selectedFigure;
        }
        return null;
    }

    protected void confirmRenameMenu() {
        if (this.editor != null && this.editor.inUse()) {
            String newTitle = this.editor.getText();
            this.editor.cleanup();
            IFigure figure = (IFigure)this.editor.getData();
            if (figure instanceof PotentialMenuFigure) {
                if ("".equals(newTitle)) {
                    return;
                }
                IGraphicalMenuWidget parent = this.getSelectedMenuWidget();
                IMenuWidget parentModel = (IMenuWidget)parent.getModel();
                boolean isRightPotentialMenu = figure == this.rightPotentialMenu;
                boolean isNewHeader = false;
                IMenuWidget header = null;
                if (parentModel instanceof IMenuItem) {
                    IMenuItem parentItem = (IMenuItem)parentModel;
                    if (isRightPotentialMenu) {
                        parentItem.setSubmenu(true);
                        header = parentModel;
                    } else {
                        header = parentItem.getParent();
                        parent.closeMenu();
                    }
                } else {
                    header = parentModel;
                    if (isRightPotentialMenu) {
                        isNewHeader = true;
                        parent.closeMenu();
                    }
                }
                this.hidePotentialMenuFigures();
                Rectangle r = figure.getBounds();
                DoubleRectangle bounds = new DoubleRectangle(r.x, r.y, r.width, r.height);
                this.performAction((ListenerIdentifier)FrameEditorLID.NewWidget, new IFrameEditorUI.NewWidgetParameters(bounds, header, isNewHeader, newTitle));
            } else {
                this.performAction(FrameEditorLID.ChangeTitleProperty, new IFrameEditorUI.ActionStringParameters(newTitle, this.selection), false);
            }
        }
    }

    protected void cleanupMenuLabelEditor() {
        if (this.editor != null) {
            this.editor.cleanup();
        }
    }

    protected void repaintEditor() {
        if (this.editor != null) {
            this.editor.repaintTextEditor(this.frameUI.getZoom());
        }
    }

    public void hidePotentialMenuFigures() {
        this.potentialMenuOwner = null;
        if (this.bottomPotentialMenu != null) {
            this.bottomPotentialMenu.setVisible(false);
        }
        if (this.rightPotentialMenu != null) {
            this.rightPotentialMenu.setVisible(false);
        }
    }

    protected void deselectPotentialMenuFigures() {
        if (this.bottomPotentialMenu != null) {
            this.bottomPotentialMenu.setBackgroundColor(ColorConstants.white);
        }
        if (this.rightPotentialMenu != null) {
            this.rightPotentialMenu.setBackgroundColor(ColorConstants.white);
        }
    }

    public void hideAllMenuItems() {
        this.frameUI.hideAllMenuItems();
    }

    protected class WidgetTitleEditor
    extends SWTTextEditor {
        public WidgetTitleEditor() {
            super((Composite)FrameEditorUI.this.view.getEditor().getSWTEditorSubstrate(), 16384);
        }

        protected void confirmRename(int focusRule) {
            FrameEditorUI.this.confirmRenameMenu();
            if (focusRule == 0 && FrameEditorUI.this.bottomPotentialMenu.isVisible()) {
                FrameEditorUI.this.initiateRenameMenu((IFigure)FrameEditorUI.this.bottomPotentialMenu);
            } else {
                this.cleanup();
            }
        }

        public void cleanup() {
            super.cleanup();
            FrameEditorUI.this.deselectPotentialMenuFigures();
        }

        protected SWTTextEditor.TextKeyListener getKeyListener() {
            return new SWTTextEditor.TextKeyListener(this){
                private final /* synthetic */ WidgetTitleEditor this$1;
                {
                    this.this$1 = this$1;
                    super(this$1);
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x1000003) {
                        IFigure figure = (IFigure)this.this$1.getData();
                        if (figure == WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).rightPotentialMenu && "".equals(this.this$1.getText())) {
                            this.this$1.cleanup();
                        }
                    } else if (e.keyCode != 0x1000004) {
                        if (e.keyCode == 0x1000002) {
                            IGraphicalMenuWidget menuFigure;
                            Object toSelect;
                            IFigure figure = (IFigure)this.this$1.getData();
                            if (figure != WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).rightPotentialMenu) {
                                this.this$1.confirmRename(0);
                            }
                            if (figure instanceof IGraphicalMenuWidget && (toSelect = (menuFigure = (IGraphicalMenuWidget)figure).selectDown()) != menuFigure) {
                                if (toSelect == null) {
                                    toSelect = WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).bottomPotentialMenu;
                                } else {
                                    WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).selection.deselectWidget(menuFigure);
                                }
                                WidgetTitleEditor.access$000(this.this$1).selectFigure((IFigure)toSelect);
                            }
                        } else if (e.keyCode == 0x1000001) {
                            IGraphicalMenuWidget menuFigure;
                            IGraphicalWidget toSelect;
                            IFigure figure = (IFigure)this.this$1.getData();
                            if (figure != WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).rightPotentialMenu) {
                                this.this$1.confirmRename(0);
                            }
                            if (figure == WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).bottomPotentialMenu) {
                                WidgetTitleEditor.access$000(this.this$1).selectFigure(WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).potentialMenuOwner);
                            } else if (figure instanceof IGraphicalMenuWidget && (toSelect = (menuFigure = (IGraphicalMenuWidget)figure).selectUp()) != null && toSelect != menuFigure) {
                                WidgetTitleEditor.access$000((WidgetTitleEditor)this.this$1).selection.deselectWidget(menuFigure);
                                WidgetTitleEditor.access$000(this.this$1).selectFigure(toSelect);
                            }
                        } else {
                            super.keyPressed(e);
                        }
                    }
                }
            };
        }

        public void editTitle(IFigure widgetFigure) {
            String text = "";
            if (widgetFigure instanceof IGraphicalMenuWidget) {
                IGraphicalMenuWidget menuWidget = (IGraphicalMenuWidget)widgetFigure;
                text = menuWidget.getWidgetModel().getTitle();
            } else {
                widgetFigure.setBackgroundColor(ColorConstants.cyan);
            }
            this.editText(text, widgetFigure, FrameEditorUI.this.frameUI.getZoom());
        }

        protected int computeY(Rectangle bounds, double scale, int offset) {
            double o = (double)(bounds.height - 15) * scale / 2.0;
            return PrecisionUtilities.round((double)bounds.y * scale + o);
        }

        protected int computeHeight(Rectangle bounds, double scale, int offset) {
            return PrecisionUtilities.round(17.0 * scale);
        }

        protected Font getFontToUse() {
            IFigure widgetFigure = (IFigure)this.getData();
            if (widgetFigure instanceof IGraphicalWidget) {
                return widgetFigure.getFont();
            }
            return widgetFigure.getFont();
        }

        static /* synthetic */ FrameEditorUI access$000(WidgetTitleEditor x0) {
            return x0.FrameEditorUI.this;
        }
    }
}

