/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.util.Alerter;
import edu.cmu.cs.hcii.cogtool.util.RecoverableException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class FrameEditorSelectionState
extends Alerter
implements IFrameEditorSelectionState {
    protected LinkedHashMap selectedWidgets = new LinkedHashMap();
    protected EventObject offSelectionChangeAlert = new SelectionChange(this, false);

    public void deselectAll() {
        this.raiseAlert(this.offSelectionChangeAlert);
        this.selectedWidgets.clear();
        this.raiseAlert(this.offSelectionChangeAlert);
    }

    public int getWidgetSelectionCount() {
        return this.selectedWidgets.size();
    }

    public Iterator getSelectedWidgetFigures() {
        return this.selectedWidgets.values().iterator();
    }

    public Iterator getSelectedWidgetsIterator() {
        return new Iterator(){
            Iterator selected;
            {
                this.selected = FrameEditorSelectionState.this.getSelectedWidgetFigures();
            }

            public boolean hasNext() {
                return this.selected.hasNext();
            }

            public Object next() {
                IGraphicalWidget gw = (IGraphicalWidget)this.selected.next();
                return gw.getWidgetModel();
            }

            public void remove() {
                this.selected.remove();
            }
        };
    }

    public boolean isWidgetFigureSelected(IGraphicalWidget gw) {
        Object selectedWidget = this.selectedWidgets.get(gw.getWidgetModel());
        return selectedWidget != null;
    }

    public boolean isWidgetSelected(IWidget widget) {
        return this.selectedWidgets.get(widget) != null;
    }

    public void setSelectedWidget(IGraphicalWidget gw) {
        this.deselectAll();
        this.selectWidget(gw);
    }

    public void deselectWidget(IGraphicalWidget gw) {
        this.selectedWidgets.remove(gw.getWidgetModel());
        this.raiseAlert(new SelectionChange(this, gw, false));
    }

    public IGraphicalWidget deselectWidget(IWidget widget) {
        IGraphicalWidget gw = (IGraphicalWidget)this.selectedWidgets.remove(widget);
        this.raiseAlert(new SelectionChange(this, gw, false));
        return gw;
    }

    public void selectWidget(IGraphicalWidget gw) {
        if (this.selectedWidgets == null || gw == null) {
            throw new FrameEditorSelectionStateBugException(this.selectedWidgets, gw);
        }
        this.selectedWidgets.put(gw.getWidgetModel(), gw);
        this.raiseAlert(new SelectionChange(this, gw, true));
    }

    public IWidget[] getSelectedIWidgets() {
        IWidget[] widgets = new IWidget[this.selectedWidgets.size()];
        this.selectedWidgets.keySet().toArray(widgets);
        return widgets;
    }

    protected static class FrameEditorSelectionStateBugException
    extends RecoverableException {
        protected final Map selectedWidgetsValue;
        protected final IGraphicalWidget gwValue;

        protected FrameEditorSelectionStateBugException(Map sw, IGraphicalWidget gw) {
            super("Unexpected null value");
            this.selectedWidgetsValue = sw;
            this.gwValue = gw;
        }
    }

    public static class SelectionChange
    extends EventObject {
        public boolean selected;
        public IGraphicalWidget changedWidget = null;

        public SelectionChange(IFrameEditorSelectionState source, boolean isSelection) {
            super(source);
            this.selected = isSelection;
        }

        public SelectionChange(IFrameEditorSelectionState source, IGraphicalWidget widget, boolean isSelection) {
            this(source, isSelection);
            this.changedWidget = widget;
        }
    }
}

