/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.DoublePoint;
import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.IMenuWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.IWidgetGroup;
import edu.cmu.cs.hcii.cogtool.ui.ADraw2DMouseState;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.FrameEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorUI;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuHeader;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuItem;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalMenuWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.IGraphicalWidget;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.RcvrUIException;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;
import edu.cmu.cs.hcii.cogtool.view.PotentialMenuFigure;
import edu.cmu.cs.hcii.cogtool.view.ResizeThumb;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Point;

public class FrameEditorMouseState
extends ADraw2DMouseState {
    public static final int MouseUp = 0;
    public static final int PotentialMovingWidget = 1;
    public static final int PotentialMovingSelection = 2;
    public static final int MovingWidgets = 3;
    public static final int PotentialCreatingWidget = 4;
    public static final int CreatingWidget = 5;
    public static final int PotentialTogglingSelection = 6;
    public static final int TogglingSelection = 7;
    public static final int PotentialResizingWidget = 8;
    public static final int ResizingWidget = 9;
    protected int mouseListenerState = 0;
    protected FrameEditorUI ui;
    protected FrameEditorSelectionState selection;
    protected boolean stopMouseDragTimer = true;
    protected MouseDragTimerTask mouseDragTask = new MouseDragTimerTask();
    protected IFigure rootFigure = null;
    protected double scaledMouseDownX;
    protected double scaledMouseDownY;
    protected int mouseDownX;
    protected int mouseDownY;
    protected boolean isMouseDownValid = false;
    protected boolean cancelDynamic = false;
    protected double mouseFixedResizeX;
    protected double mouseFixedResizeY;
    protected int currentResizeHandleType = 0;
    protected DoubleRectangle initialResizeArea;
    protected final int HYSTERESIS = 3;
    protected Point updateDelta = new Point(0, 0);

    public FrameEditorMouseState(FrameEditorUI frameUI) {
        super(frameUI);
        this.ui = frameUI;
        this.selection = this.ui.selection;
    }

    protected double setMouseDown(int x, int y) {
        this.mouseDownX = x;
        this.mouseDownY = y;
        double zoom = this.ui.getZoom();
        this.scaledMouseDownX = (double)x / zoom;
        this.scaledMouseDownY = (double)y / zoom;
        this.isMouseDownValid = true;
        return zoom;
    }

    protected void setMouseState(int newState) {
        this.ui.getViewEditor().captureMouseEvents(newState != 0);
        this.mouseListenerState = newState;
    }

    public int getMouseState() {
        return this.mouseListenerState;
    }

    public void mouseDoubleClicked(IFigure figure, int button, int x, int y, int state) {
        this.ui.confirmRenameMenu();
        IGraphicalWidget target = this.ui.widgetLocatedAtXY(x, y);
        if (target instanceof IGraphicalMenuWidget) {
            this.ui.initiateRenameMenu(target);
        }
        this.setMouseState(0);
        this.cleanup();
    }

    protected void handleMousePressed(int x, int y, int state) {
        this.ui.view.getEditor().getSWTEditorSubstrate().setFocus();
        ResizeThumb resize = this.ui.widgetResizeUnderXY(x, y);
        PotentialMenuFigure pWidget = this.ui.potentialWidgetUnderXY(x, y);
        if (resize != null) {
            this.initialResizeArea = this.ui.getSelectedWidgetArea();
            double fixedX = 0.0;
            double fixedY = 0.0;
            this.currentResizeHandleType = resize.thumbType;
            switch (resize.thumbType) {
                case 0: {
                    fixedX = this.initialResizeArea.x + this.initialResizeArea.width;
                    fixedY = this.initialResizeArea.y + this.initialResizeArea.height;
                    break;
                }
                case 1: {
                    fixedX = this.initialResizeArea.x + this.initialResizeArea.width;
                    fixedY = this.initialResizeArea.y;
                    break;
                }
                case 2: {
                    fixedX = this.initialResizeArea.x;
                    fixedY = this.initialResizeArea.y + this.initialResizeArea.height;
                    break;
                }
                case 3: {
                    fixedX = this.initialResizeArea.x;
                    fixedY = this.initialResizeArea.y;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown type of Resize Thumb selected");
                }
            }
            this.mouseFixedResizeX = fixedX;
            this.mouseFixedResizeY = fixedY;
            int nextState = 8;
            this.setMouseState(nextState);
            this.setWidgetFastRenderMode(true);
            Iterator selectedWFs = this.selection.getSelectedWidgetFigures();
            while (selectedWFs.hasNext()) {
                IGraphicalWidget gw = (IGraphicalWidget)selectedWFs.next();
                if (!(gw instanceof IGraphicalMenuWidget)) continue;
                this.ui.hidePotentialMenuFigures();
                this.ui.hideAllMenuItems();
                if (!(gw instanceof IGraphicalMenuItem)) continue;
                ((IGraphicalMenuItem)gw).getParentHeader().openMenu();
            }
        } else if (pWidget != null) {
            this.ui.initiateRenameMenu((IFigure)pWidget);
        } else {
            IGraphicalWidget wf = this.ui.widgetLocatedAtXY(x, y);
            IGraphicalMenuWidget currentHeader = null;
            if ((state & 0x20000) != 0) {
                this.setMouseState(6);
            } else if (wf != null) {
                if (this.selection.isWidgetFigureSelected(wf)) {
                    this.setMouseState(2);
                } else {
                    this.selection.setSelectedWidget(wf);
                    this.setMouseState(1);
                }
                if (wf instanceof IGraphicalMenuWidget) {
                    IGraphicalMenuWidget menuWidget = (IGraphicalMenuWidget)wf;
                    if (menuWidget.getWidgetModel().getTitle() == "") {
                        this.ui.initiateRenameMenu(menuWidget);
                    }
                    if (menuWidget instanceof IGraphicalMenuHeader) {
                        currentHeader = menuWidget;
                    } else if (menuWidget instanceof IGraphicalMenuItem) {
                        IGraphicalMenuItem menuItemFig = (IGraphicalMenuItem)menuWidget;
                        currentHeader = menuItemFig.isSubmenu() ? menuWidget : menuItemFig.getParentHeader();
                    }
                } else {
                    this.ui.hidePotentialMenuFigures();
                }
            } else {
                this.ui.hidePotentialMenuFigures();
                this.ui.cleanupMenuLabelEditor();
                this.selection.deselectAll();
                this.setMouseState(4);
            }
            this.ui.hideAllMenuItems();
            if (currentHeader != null) {
                currentHeader.openMenu();
                this.ui.resetVisibleArea();
            }
        }
    }

    public void mousePressed(IFigure figure, int button, int x, int y, int state) {
        super.mousePressed(figure, button, x, y, state);
        this.ui.confirmRenameMenu();
        if (this.cancelDynamic) {
            this.cancelDynamicOperation();
            return;
        }
        if (button != 1) {
            return;
        }
        this.setMouseDown(x, y);
        switch (this.getMouseState()) {
            case 0: {
                this.handleMousePressed(x, y, state);
                break;
            }
        }
        this.cleanup();
    }

    public void mouseReleased(IFigure figure, int button, int x, int y, int state) {
        super.mouseReleased(figure, button, x, y, state);
        this.stopMouseDragTimer = true;
        if (this.isMouseDownValid) {
            double zoom = this.ui.getZoom();
            double currentScaledX = (double)x / zoom;
            double currentScaledY = (double)y / zoom;
            switch (this.getMouseState()) {
                case 1: 
                case 4: 
                case 8: {
                    break;
                }
                case 2: {
                    IGraphicalWidget wf = this.ui.widgetLocatedAtXY(this.mouseDownX, this.mouseDownY);
                    try {
                        this.selection.setSelectedWidget(wf);
                    }
                    catch (FrameEditorSelectionState.FrameEditorSelectionStateBugException e) {
                        StringBuffer msg = new StringBuffer();
                        msg.append("Mystery bug encountered. Please bring ");
                        msg.append("this to the attention of the Cogtool\n");
                        msg.append("developers, including as much information ");
                        msg.append("as you can about how you triggered this.\n");
                        msg.append("selectedWidgets = " + e.selectedWidgetsValue + "\n");
                        msg.append("gw = " + e.gwValue + "\n");
                        msg.append("wf = " + wf + "\n");
                        msg.append("mouseDownX = " + this.mouseDownX + "\n");
                        msg.append("mouseDownY = " + this.mouseDownY + "\n");
                        msg.append("figure = " + figure + "\n");
                        msg.append("button = " + button + "\n");
                        msg.append("x = " + x + "\n");
                        msg.append("y = " + y + "\n");
                        msg.append("state = " + state + "\n");
                        msg.append("zoom = " + zoom + "\n");
                        throw new RcvrUIException(msg.toString(), e);
                    }
                    if (!(wf instanceof IGraphicalMenuWidget) || wf.getWidgetModel().getTitle() != "") break;
                    this.ui.initiateRenameMenu((IGraphicalMenuWidget)wf);
                    break;
                }
                case 6: {
                    IGraphicalWidget wf = this.ui.widgetLocatedAtXY(this.mouseDownX, this.mouseDownY);
                    if (wf == null) break;
                    if (this.selection.isWidgetFigureSelected(wf)) {
                        this.selection.deselectWidget(wf);
                        break;
                    }
                    this.selection.selectWidget(wf);
                    break;
                }
                case 3: {
                    DoublePoint moveBy = new DoublePoint(currentScaledX - this.scaledMouseDownX, currentScaledY - this.scaledMouseDownY);
                    IFrameEditorUI.MoveParameters prms = new IFrameEditorUI.MoveParameters(moveBy, this.selection);
                    this.ui.performAction((ListenerIdentifier)CogToolLID.MoveWidgets, prms);
                    break;
                }
                case 9: {
                    this.setWidgetFastRenderMode(false);
                    if (currentScaledX < 0.0) {
                        currentScaledX = 0.0;
                    }
                    if (currentScaledY < 0.0) {
                        currentScaledY = 0.0;
                    }
                    if (this.ui.anchorTopLeft) {
                        switch (this.currentResizeHandleType) {
                            case 2: {
                                currentScaledY = this.initialResizeArea.y;
                                break;
                            }
                            case 1: {
                                currentScaledX = this.initialResizeArea.x;
                                break;
                            }
                        }
                        if (currentScaledX < this.initialResizeArea.x) {
                            currentScaledX = this.initialResizeArea.x;
                        }
                        if (currentScaledY < this.initialResizeArea.y) {
                            currentScaledY = this.initialResizeArea.y;
                        }
                    }
                    double width = Math.abs(currentScaledX - this.mouseFixedResizeX);
                    double height = Math.abs(currentScaledY - this.mouseFixedResizeY);
                    IFrameEditorUI.ResizeParameters prms = new IFrameEditorUI.ResizeParameters(this.initialResizeArea.x, this.initialResizeArea.y, Math.min(currentScaledX, this.mouseFixedResizeX), Math.min(currentScaledY, this.mouseFixedResizeY), width / this.initialResizeArea.width, height / this.initialResizeArea.height, this.selection);
                    this.ui.performAction((ListenerIdentifier)CogToolLID.ResizeWidgets, prms);
                    break;
                }
                case 5: {
                    double width = Math.abs(this.scaledMouseDownX - currentScaledX);
                    double height = Math.abs(this.scaledMouseDownY - currentScaledY);
                    double leftX = this.scaledMouseDownX > currentScaledX ? currentScaledX : this.scaledMouseDownX;
                    double topY = this.scaledMouseDownY > currentScaledY ? currentScaledY : this.scaledMouseDownY;
                    this.ui.stopDrawingTemporaryFigure();
                    DoubleRectangle region = new DoubleRectangle(leftX, topY, width, height);
                    if (region.width == 0.0 || region.height == 0.0) break;
                    this.ui.performAction((ListenerIdentifier)CogToolLID.NewWidget, new IFrameEditorUI.NewWidgetParameters(region));
                    break;
                }
                case 7: {
                    double width = Math.abs(this.scaledMouseDownX - currentScaledX);
                    double height = Math.abs(this.scaledMouseDownY - currentScaledY);
                    double leftX = this.scaledMouseDownX > currentScaledX ? currentScaledX : this.scaledMouseDownX;
                    double topY = this.scaledMouseDownY > currentScaledY ? currentScaledY : this.scaledMouseDownY;
                    this.ui.stopDrawingTemporaryFigure();
                    DoubleRectangle region = new DoubleRectangle(leftX, topY, width, height);
                    Iterator gwFigures = this.ui.getFrameUI().getFigureListIterator();
                    while (gwFigures.hasNext()) {
                        IGraphicalWidget gw = (IGraphicalWidget)gwFigures.next();
                        Rectangle bounds = gw.getBounds();
                        if (!region.intersects(bounds.x, bounds.y, bounds.width, bounds.height)) continue;
                        if (this.selection.isWidgetFigureSelected(gw)) {
                            this.selection.deselectWidget(gw);
                            continue;
                        }
                        this.selection.selectWidget(gw);
                    }
                    break;
                }
            }
            this.isMouseDownValid = false;
            this.setMouseState(0);
        }
        this.cleanup();
    }

    protected boolean withinHysteresis(int eventX, int eventY) {
        return Math.abs(eventX - this.mouseDownX) < 3 && Math.abs(eventY - this.mouseDownY) < 3;
    }

    protected void redrawTemporaryWidget(double currentScaledX, double currentScaledY, boolean asOutline) {
        double originDownX = this.scaledMouseDownX;
        double originDownY = this.scaledMouseDownY;
        if (currentScaledX < 0.0) {
            currentScaledX = 0.0;
        }
        if (currentScaledY < 0.0) {
            currentScaledY = 0.0;
        }
        double width = Math.abs(originDownX - currentScaledX);
        double height = Math.abs(originDownY - currentScaledY);
        if (currentScaledX < originDownX) {
            originDownX = currentScaledX;
        }
        if (currentScaledY < originDownY) {
            originDownY = currentScaledY;
        }
        this.ui.setTemporaryWidget(originDownX, originDownY, width, height, asOutline);
    }

    protected void dynamicMoveWidgets(Iterator selectedWFs, double currentScaledX, double currentScaledY) {
        while (selectedWFs.hasNext()) {
            IGraphicalWidget gw = (IGraphicalWidget)selectedWFs.next();
            double offsetX = currentScaledX - this.scaledMouseDownX;
            double offsetY = currentScaledY - this.scaledMouseDownY;
            if (gw instanceof IGraphicalMenuHeader) {
                this.ui.moveMenuGroup(offsetX, offsetY, (IGraphicalMenuWidget)gw);
                continue;
            }
            if (gw instanceof IGraphicalMenuItem) {
                return;
            }
            DoublePoint p = gw.getWidgetModel().getShape().getOrigin();
            double tempX = offsetX + p.x;
            double tempY = offsetY + p.y;
            if (tempX < 0.0) {
                tempX = 0.0;
            }
            if (tempY < 0.0) {
                tempY = 0.0;
            }
            this.ui.setGraphicalWidgetOrigin(tempX, tempY, gw);
        }
    }

    protected void dynamicResizeWidget(IWidget widget, IGraphicalWidget gw, double ratioX, double ratioY, double newLeft, double newTop) {
        DoubleRectangle bds = widget.getShape().getBounds();
        double newX = ratioX * (bds.x - this.initialResizeArea.x) + newLeft;
        double newY = ratioY * (bds.y - this.initialResizeArea.y) + newTop;
        this.ui.setGraphicalWidgetBounds(newX, newY, ratioX * bds.width, ratioY * bds.height, gw);
    }

    protected void dynamicResizeGroup(IWidgetGroup group, double ratioX, double ratioY, double newLeft, double newTop) {
        Iterator groupWidgets = group.getAllWidgets();
        while (groupWidgets.hasNext()) {
            IWidget w = (IWidget)groupWidgets.next();
            IGraphicalWidget gw = this.ui.frameUI.getWidgetFigure(w);
            this.dynamicResizeWidget(w, gw, ratioX, ratioY, newLeft, newTop);
        }
    }

    protected void dynamicResizeWidgets(Iterator selectedWFs, double currentScaledX, double currentScaledY) {
        if (currentScaledX < 0.0) {
            currentScaledX = 0.0;
        }
        if (currentScaledY < 0.0) {
            currentScaledY = 0.0;
        }
        if (this.ui.anchorTopLeft) {
            switch (this.currentResizeHandleType) {
                case 2: {
                    currentScaledY = this.initialResizeArea.y;
                    break;
                }
                case 1: {
                    currentScaledX = this.initialResizeArea.x;
                    break;
                }
            }
            if (currentScaledX < this.initialResizeArea.x) {
                currentScaledX = this.initialResizeArea.x;
            }
            if (currentScaledY < this.initialResizeArea.y) {
                currentScaledY = this.initialResizeArea.y;
            }
        }
        double newWidth = Math.abs(currentScaledX - this.mouseFixedResizeX);
        double newHeight = Math.abs(currentScaledY - this.mouseFixedResizeY);
        double newLeft = Math.min(currentScaledX, this.mouseFixedResizeX);
        double newTop = Math.min(currentScaledY, this.mouseFixedResizeY);
        double ratioX = newWidth / this.initialResizeArea.width;
        double ratioY = newHeight / this.initialResizeArea.height;
        while (selectedWFs.hasNext()) {
            IGraphicalWidget gw = (IGraphicalWidget)selectedWFs.next();
            IWidget w = gw.getWidgetModel();
            if (w instanceof IMenuWidget) {
                this.dynamicResizeGroup(w.getParentGroup(), ratioX, ratioY, newLeft, newTop);
                continue;
            }
            this.dynamicResizeWidget(w, gw, ratioX, ratioY, newLeft, newTop);
        }
    }

    public void mouseDragged(IFigure figure, int button, int mouseX, int mouseY, int state) {
        if (this.isMouseDownValid) {
            InteractionDrawingEditor editor = this.ui.getViewEditor();
            this.stopMouseDragTimer = true;
            this.cancelDynamic = editor.movePointNearEdge(mouseX, mouseY, this.updateDelta);
            double zoom = this.ui.getZoom();
            double currentScaledX = (double)mouseX / zoom;
            double currentScaledY = (double)mouseY / zoom;
            Iterator selectedWFs = this.selection.getSelectedWidgetFigures();
            switch (this.getMouseState()) {
                case 1: 
                case 2: {
                    if (this.withinHysteresis(mouseX, mouseY)) break;
                    this.setMouseState(3);
                }
                case 3: {
                    this.dynamicMoveWidgets(selectedWFs, currentScaledX, currentScaledY);
                    this.ui.repaintEditor();
                    break;
                }
                case 8: {
                    if (this.withinHysteresis(mouseX, mouseY)) break;
                    this.setMouseState(9);
                }
                case 9: {
                    this.dynamicResizeWidgets(selectedWFs, currentScaledX, currentScaledY);
                    this.ui.repaintEditor();
                    break;
                }
                case 4: {
                    if (this.withinHysteresis(mouseX, mouseY)) break;
                    this.setMouseState(5);
                }
                case 5: {
                    this.redrawTemporaryWidget(currentScaledX, currentScaledY, false);
                    break;
                }
                case 6: {
                    if (this.withinHysteresis(mouseX, mouseY)) break;
                    this.setMouseState(7);
                }
                case 7: {
                    this.redrawTemporaryWidget(currentScaledX, currentScaledY, true);
                }
            }
            if (this.updateDelta.x != 0 || this.updateDelta.y != 0) {
                if (this.rootFigure == null) {
                    this.rootFigure = this.ui.getViewEditor().getInteractionFigure();
                }
                this.stopMouseDragTimer = false;
                this.mouseDragTask.setNextMousePosition(mouseX + this.updateDelta.x, mouseY + this.updateDelta.y, button, state);
                WindowUtil.globalDisplay.timerExec(100, (Runnable)this.mouseDragTask);
            }
        }
        this.cleanup();
    }

    public void mouseExited(IFigure figure, int x, int y, int state) {
        this.stopMouseDragTimer = true;
        this.cancelDynamic = true;
    }

    public void mouseEntered(IFigure figure, int x, int y, int state) {
        this.cancelDynamic = false;
    }

    protected void cancelDynamicOperation() {
        this.cancelDynamic = false;
        switch (this.getMouseState()) {
            case 3: {
                Iterator selectedWFs = this.selection.getSelectedWidgetFigures();
                this.dynamicMoveWidgets(selectedWFs, this.scaledMouseDownX, this.scaledMouseDownY);
                this.ui.redrawMenuSelection();
                break;
            }
            case 5: {
                this.ui.stopDrawingTemporaryFigure();
                break;
            }
            case 7: {
                this.ui.stopDrawingTemporaryFigure();
                break;
            }
            case 9: {
                this.setWidgetFastRenderMode(false);
                Iterator selectedWFs = this.selection.getSelectedWidgetFigures();
                this.dynamicResizeWidgets(selectedWFs, this.scaledMouseDownX, this.scaledMouseDownY);
                this.ui.redrawMenuSelection();
                break;
            }
        }
        this.setMouseState(0);
        this.ui.resetVisibleArea();
    }

    public void keyPressed(KeyEvent ke) {
        IGraphicalWidget gw;
        IGraphicalMenuWidget figure = null;
        boolean nudge = true;
        if (this.selection.getWidgetSelectionCount() == 1 && (gw = (IGraphicalWidget)this.selection.getSelectedWidgetFigures().next()) instanceof IGraphicalMenuWidget) {
            figure = (IGraphicalMenuWidget)gw;
            nudge = false;
        }
        switch (ke.keycode) {
            case 27: {
                this.cancelDynamicOperation();
                break;
            }
            case 0x1000001: {
                if (nudge) {
                    this.ui.performAction(CogToolLID.NudgeUp);
                    break;
                }
                this.changeSelection(figure, figure.selectUp());
                break;
            }
            case 0x1000002: {
                if (nudge) {
                    this.ui.performAction(CogToolLID.NudgeDown);
                    break;
                }
                Object toSelect = figure.selectDown();
                if (toSelect == null) {
                    toSelect = this.ui.bottomPotentialMenu;
                }
                this.changeSelection(figure, (IFigure)toSelect);
                break;
            }
            case 0x1000003: {
                if (nudge) {
                    this.ui.performAction(CogToolLID.NudgeLeft);
                    break;
                }
                this.changeSelection(figure, figure.selectLeft());
                break;
            }
            case 0x1000004: {
                if (nudge) {
                    this.ui.performAction(CogToolLID.NudgeRight);
                    break;
                }
                Object toSelect = figure.selectRight();
                if (toSelect == null && figure == this.ui.potentialMenuOwner) {
                    toSelect = this.ui.rightPotentialMenu;
                }
                this.changeSelection(figure, (IFigure)toSelect);
                break;
            }
            case 13: {
                Iterator figs;
                IGraphicalWidget widget;
                if (this.selection.getWidgetSelectionCount() != 1 || !((widget = (IGraphicalWidget)(figs = this.selection.getSelectedWidgetFigures()).next()) instanceof IGraphicalMenuWidget)) break;
                this.ui.initiateRenameMenu(widget);
                break;
            }
            case 8: 
            case 127: {
                this.ui.performAction(CogToolLID.Delete);
            }
        }
    }

    protected void changeSelection(IGraphicalWidget wasSelected, IFigure nowSelected) {
        if (nowSelected != null && nowSelected != wasSelected) {
            if (nowSelected instanceof IGraphicalMenuWidget) {
                this.selection.deselectWidget(wasSelected);
                this.selection.selectWidget((IGraphicalWidget)nowSelected);
                this.cleanup();
            } else {
                this.ui.initiateRenameMenu(nowSelected);
            }
        }
    }

    private void setWidgetFastRenderMode(boolean fast) {
        Iterator widgets = this.selection.getSelectedWidgetsIterator();
        while (widgets.hasNext()) {
            IWidget widget = (IWidget)widgets.next();
            IWidget.WidgetChange chgAlert = fast ? new IWidget.WidgetChange(widget, 101) : new IWidget.WidgetChange(widget, 102);
            widget.raiseAlert(chgAlert);
        }
    }

    protected class MouseDragTimerTask
    implements Runnable {
        protected int mouseLocX;
        protected int mouseLocY;
        protected int mouseButton;
        protected int mouseState;

        protected MouseDragTimerTask() {
        }

        public void run() {
            if (!FrameEditorMouseState.this.stopMouseDragTimer) {
                FrameEditorMouseState.this.mouseDragged(FrameEditorMouseState.this.rootFigure, this.mouseButton, this.mouseLocX, this.mouseLocY, this.mouseState);
            }
        }

        public void setNextMousePosition(int mousePosX, int mousePosY, int button, int state) {
            this.mouseLocX = mousePosX;
            this.mouseLocY = mousePosY;
            this.mouseButton = button;
            this.mouseState = state;
        }
    }
}

