/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.ui.DefaultInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IFrameEditorInteraction;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.WindowUtil;
import edu.cmu.cs.hcii.cogtool.view.IView;

public class FrameEditorInteraction
extends DefaultInteraction
implements IFrameEditorInteraction {
    protected static final String needSelectionMsg = L10N.get("FE.NeedSelection", "You must select a widget.");
    protected static final String tooManyWidgetsMsg = L10N.get("FE.TooManyWidgets", "This operation only works on a single widget.");
    protected static final String errorTitle = L10N.get("FE.Error", "Frame Editor Error");
    protected static final String confirmTitle = L10N.get("FE.ConfirmTitle", "Confirm Deletion");
    protected static final String widgetNameCollisionMsg = L10N.get("FE.WidgetNameCollision", "The name you have chosen is already in use by another widget.\nPlease choose a different name.");
    protected static final String widgetNameEmptyMsg = L10N.get("FE.WidgetNameEmpty", "A widget's name cannot be empty.\nPlease provide a name.");
    protected static final String widgetNameChangeMsg = L10N.get("FE.WidgetNameChange", "The widget with the following name cannot be added due to a name collison.\nPlease enter a different name");
    protected static final String confirmDeleteWidgetsMsg = L10N.get("FE.confirmDeleteWidgetsMsg", "Please confirm the deletion of the selected Widgets.");
    protected static final String confirmDeleteWidgetMsg = L10N.get("FE.confirmDeleteWidgetMsg", "Please confirm the deletion of the selected Widget.");

    public FrameEditorInteraction(IView view) {
        super(view);
    }

    public void protestNoSelection() {
        this.reportProblem(errorTitle, needSelectionMsg);
    }

    public void protestTooManyWidgets() {
        this.reportProblem(errorTitle, tooManyWidgetsMsg);
    }

    public String protestWidgetNameCollision() {
        WindowUtil.PromptDialog dialog = new WindowUtil.PromptDialog(this.window, errorTitle, 32768, L10N.get("CT.WidgetNameLabel", "Widget name:"), widgetNameCollisionMsg);
        Object response = dialog.open();
        return response != null && response.equals("OK") ? dialog.getPromptResponse() : null;
    }

    public String protestWidgetCannotBeEmpty() {
        WindowUtil.PromptDialog dialog = new WindowUtil.PromptDialog(this.window, errorTitle, 32768, L10N.get("CT.WidgetNameLabel", "Widget name:"), widgetNameEmptyMsg);
        Object response = dialog.open();
        return response != null && response.equals("OK") ? dialog.getPromptResponse() : null;
    }

    public String askWidgetName(String name, String suggestion) {
        WindowUtil.PromptDialog dialog = new WindowUtil.PromptDialog(this.window, errorTitle, 32768, widgetNameChangeMsg, name, suggestion, 0);
        Object result = dialog.open();
        if (result != null && result.equals("OK")) {
            return dialog.getPromptResponse();
        }
        return name;
    }

    public boolean confirmDeleteWidgets(IWidget[] widgets) {
        String msg = "";
        msg = widgets.length > 1 ? confirmDeleteWidgetsMsg : confirmDeleteWidgetMsg;
        return 32 == WindowUtil.presentConfirmItemsDialog(this.window, confirmTitle, msg, widgets);
    }
}

