/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.DoubleRectangle;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.IShape;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.uimodel.FrameUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.KeyDisplayUtil;
import edu.cmu.cs.hcii.cogtool.util.ICancelable;
import edu.cmu.cs.hcii.cogtool.util.IProgressCallback;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.RcvrIOException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class DesignExportToHTML {
    protected static final Comparator frameAlphabetizer = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            String name0 = ((IFrame)arg0).getName();
            String name1 = ((IFrame)arg1).getName();
            return name0.compareTo(name1);
        }
    };
    protected HashMap frameLookUp = new HashMap();
    protected IDesign design;
    protected String destDirectory;
    static /* synthetic */ Class class$org$eclipse$draw2d$ColorConstants;

    public DesignExportToHTML() {
        EnsureGC.mustInitializeInMainThread();
    }

    protected String getFramePageURL(IFrame frame) {
        return this.frameLookUp.get(frame) + ".html";
    }

    protected String getFrameImageURL(IFrame frame) {
        return this.frameLookUp.get(frame) + ".jpg";
    }

    protected static String performActionString(IAction action, ITransitionSource source) {
        String actionStr = KeyDisplayUtil.convertActionToMenuText(action.getLocalizedString());
        return StringEscapeUtils.escapeJavaScript((String)(L10N.get("SE.Perform", "Perform") + " " + actionStr + " " + L10N.get("SE.On", "On") + " " + source.getName()));
    }

    protected void buildFrameList() {
        this.frameLookUp.clear();
        HashSet<String> usedNames = new HashSet<String>();
        Iterator iter = this.design.getFrames().iterator();
        Random rand = new Random();
        while (iter.hasNext()) {
            IFrame frame = (IFrame)iter.next();
            String name = DesignExportToHTML.cleanStringForFS(frame.getName());
            while (usedNames.contains(name)) {
                name = name.concat("+" + rand.nextInt(50));
            }
            this.frameLookUp.put(frame, name);
            usedNames.add(name);
        }
    }

    public void exportToHTML(IDesign d, String dir, ICancelable cancelState, IProgressCallback progressState) {
        this.design = d.duplicate(d.getName());
        this.destDirectory = dir;
        File parentDir = new File(this.destDirectory);
        if (!parentDir.isDirectory()) {
            throw new IllegalArgumentException("Create Web pages called without a directory");
        }
        Set frameSet = this.design.getFrames();
        int frameCount = frameSet.size();
        double progressCount = 0.0;
        this.buildFrameList();
        Iterator iter = frameSet.iterator();
        ImageLoader imageLoader = new ImageLoader();
        String html = null;
        Image img = null;
        while (!cancelState.isCanceled() && iter.hasNext()) {
            IFrame frame = (IFrame)iter.next();
            img = DesignExportToHTML.buildFrameImage(frame);
            imageLoader.data = new ImageData[]{img.getImageData()};
            String imageName = this.getFrameImageURL(frame);
            File imageFile = new File(parentDir, imageName);
            try {
                imageLoader.save(imageFile.getCanonicalPath(), 4);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            img.dispose();
            try {
                html = this.buildFrameHTML(frame, imageName);
                File htmlFile = new File(parentDir, this.getFramePageURL(frame));
                FileWriter fileOut = new FileWriter(htmlFile);
                BufferedWriter writer = new BufferedWriter(fileOut);
                writer.write(html);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            progressState.updateProgress((progressCount += 1.0) / (double)frameCount, frame.getName());
        }
        if (!cancelState.isCanceled()) {
            Writer writer;
            try {
                html = this.buildIndexPage();
                File htmlFile = new File(parentDir, "index.html");
                FileWriter fileOut = new FileWriter(htmlFile);
                writer = new BufferedWriter(fileOut);
                writer.write(html);
                ((BufferedWriter)writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InputStream stream = ClassLoader.getSystemResourceAsStream("edu/cmu/cs/hcii/cogtool/resources/overlib.js");
            File overlibFile = new File(parentDir, "overlib.js");
            try {
                writer = new FileWriter(overlibFile);
                while (stream.available() > 0) {
                    ((OutputStreamWriter)writer).write(stream.read());
                }
                ((OutputStreamWriter)writer).close();
            }
            catch (IOException e) {
                throw new RcvrIOException("Resource InputStreams failed: " + e.getMessage(), e);
            }
        }
        this.frameLookUp.clear();
        this.frameLookUp = null;
    }

    protected static Image buildFrameImage(IFrame frame) {
        FrameUIModel frameUI = new FrameUIModel(frame, false, 0, 1.0, false, 0, 0);
        DoubleSize size = frameUI.getPreferredSize();
        if (size.height < 100.0) {
            size.height = 100.0;
        }
        if (size.width < 100.0) {
            size.width = 100.0;
        }
        Image image = new Image(null, PrecisionUtilities.ceiling(size.width), PrecisionUtilities.ceiling(size.height));
        GC gc = new GC((Drawable)image);
        SWTGraphics g = new SWTGraphics(gc);
        frameUI.getContents().setFont(gc.getFont());
        frameUI.getContents().paint((Graphics)g);
        frameUI.dispose();
        g.dispose();
        gc.dispose();
        return image;
    }

    protected String buildFrameHTML(IFrame frame, String frameImageName) {
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        html.append("<html>\n");
        html.append("<head>\n");
        html.append("<STYLE TYPE='text/css'><!--a {font-size: 9pt;}--></STYLE>");
        html.append("<script type='text/javascript' ");
        html.append(" src='overlib.js' ");
        html.append(" language='JavaScript'></script>");
        html.append("<title>");
        html.append(frame.getName());
        html.append("</title>\n");
        html.append("<script language='JavaScript'>\n");
        html.append("</script>\n");
        html.append("</head>\n");
        html.append("<body>\n");
        html.append("<div id='overDiv' ");
        html.append(" style='position:absolute; visibility:hidden; z-index:1000;'>");
        html.append("</div>\n");
        html.append("<table border=1>\n");
        html.append("<tr>\n");
        html.append("<td align='center'>\n");
        html.append(frame.getName());
        html.append("</td>\n");
        html.append("</tr>\n");
        html.append("<tr>\n");
        html.append("<td>\n");
        html.append("<img usemap=#map1 align=center src='");
        html.append(frameImageName);
        html.append("' onclick=\"return overlib('");
        html.append(L10N.get("DXH.NotAccomplishGoal", "This object/item will not help accomplish your goal"));
        html.append("', MOUSEOFF, STICKY, CENTER, CLOSETEXT, '');\" />\n");
        html.append("<map name=map1>\n");
        Iterator widgetIterator = frame.getWidgets().iterator();
        while (widgetIterator.hasNext()) {
            IWidget widget = (IWidget)widgetIterator.next();
            IShape shape = widget.getShape();
            html.append("<area alt='");
            html.append(widget.getName());
            html.append("' shape=");
            html.append("'rect'");
            html.append(" coords='");
            DoubleRectangle rect = shape.getBounds();
            html.append(rect.getX() + rect.getWidth() + "," + rect.getY() + ",");
            html.append(rect.getX() + "," + (rect.getY() + rect.getHeight()));
            html.append("'");
            html.append(" onclick=");
            html.append(this.buildMouseOver(widget));
            html.append(" onmouseout='return nd();' />\n");
        }
        html.append("</map>\n");
        html.append("</td>\n");
        html.append("</tr>\n");
        html.append("<tr>\n");
        html.append("<td align='center'>\n");
        Iterator devicesIterator = frame.getInputDevices().iterator();
        html.append("<table><tr>\n");
        while (devicesIterator.hasNext()) {
            IInputDevice device = (IInputDevice)devicesIterator.next();
            html.append("<td align='center'>\n");
            html.append("<a href='javascript:void(0);' onclick=");
            html.append(this.buildMouseOver(device));
            html.append(" onmouseout='return nd();'>");
            html.append(device.getName());
            html.append("</td>\n");
        }
        html.append("</tr></table>\n");
        html.append("</td>\n");
        html.append("</tr>\n");
        html.append("</table>\n");
        html.append("</body>\n");
        html.append("</html>\n");
        return html.toString();
    }

    protected static String cleanStringForFS(String name) {
        name = name.replaceAll(":", "_");
        name = name.replaceAll("\\\\", "_");
        name = name.replaceAll("/", "_");
        name = name.replaceAll(" ", "_");
        name = name.replaceAll("'", "_");
        name = name.replaceAll("\"", "_");
        return name;
    }

    protected String buildMouseOver(ITransitionSource source) {
        StringBuffer mouseOver = new StringBuffer();
        mouseOver.append("\"return overlib(");
        Collection sourceTransitions = source.getTransitions().values();
        if (sourceTransitions.size() == 0) {
            mouseOver.append("''");
        } else {
            mouseOver.append("'<table>");
            Iterator iter = sourceTransitions.iterator();
            while (iter.hasNext()) {
                ITransition transition = (ITransition)iter.next();
                IAction action = transition.getAction();
                mouseOver.append("<tr><td>");
                mouseOver.append("<a href=\\'");
                mouseOver.append(this.getFramePageURL(transition.getDestination()));
                mouseOver.append("\\'>");
                mouseOver.append(DesignExportToHTML.performActionString(action, source));
                mouseOver.append("</a>");
                mouseOver.append("</td></tr>");
            }
            mouseOver.append("</table>'");
        }
        mouseOver.append(", MOUSEOFF, WIDTH, 200, STICKY");
        if (source instanceof IWidget) {
            IWidget widget = (IWidget)source;
            mouseOver.append(", FIXX, ");
            DoubleRectangle rect = widget.getShape().getBounds();
            mouseOver.append(PrecisionUtilities.round(rect.x + rect.width / 2.0));
            mouseOver.append(", FIXY, ");
            mouseOver.append(PrecisionUtilities.round(rect.y + rect.height / 2.0));
        } else {
            mouseOver.append(", ABOVE");
        }
        mouseOver.append(", CLOSETEXT, '', ");
        mouseOver.append("CAPTION, '");
        if (sourceTransitions.size() == 0) {
            mouseOver.append(L10N.get("DXH.NoTransitions", "No available Transitions"));
        } else {
            mouseOver.append(L10N.get("DXH.SelectTransition", "Select an available Transition"));
        }
        mouseOver.append("');\"");
        return mouseOver.toString();
    }

    protected String buildIndexPage() {
        TreeSet sortedFrames = new TreeSet(frameAlphabetizer);
        sortedFrames.addAll(this.design.getFrames());
        Iterator iter = sortedFrames.iterator();
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        html.append("<html>\n");
        html.append("<head>\n");
        html.append("<title>");
        html.append(this.design.getName());
        html.append("</title>\n");
        html.append("</head>\n");
        html.append("<body>\n");
        html.append("<h3>");
        html.append("<div align=center>");
        html.append(L10N.get("WB.Instructions", "Instructions: "));
        html.append(L10N.get("WB.Instructions", "Select a start frame from the list of options. To interact with image, clickon the designated target. If possible this will make the transition, if not a pop up will be display the transition options."));
        html.append("</h3>");
        html.append("</div>");
        html.append("<table border=1>\n");
        int i = 0;
        while (iter.hasNext()) {
            IFrame frame = (IFrame)iter.next();
            if (i % 3 == 0) {
                if (i != 0) {
                    html.append("</tr>\n");
                }
                html.append("<tr>\n");
            }
            html.append("<td>\n");
            html.append("<a href='" + this.getFramePageURL(frame) + "'>");
            html.append("<div>");
            html.append(frame.getName());
            html.append("</div><div align=right>");
            DoubleRectangle rect = frame.getBackgroundBounds();
            double scale = 1.0;
            if (rect != null) {
                scale = rect.width > rect.height ? 100.0 / rect.width : 100.0 / rect.height;
                html.append("<img src='" + this.getFrameImageURL(frame) + "' width=");
                html.append(rect.width * scale);
                html.append(" height=");
                html.append(rect.height * scale);
                html.append("/>");
            } else {
                html.append("<img src='" + this.getFrameImageURL(frame) + "' />");
            }
            html.append("</a>");
            html.append("</div>");
            html.append("</td>");
            ++i;
        }
        html.append("</tr>\n");
        html.append("</table>\n");
        html.append("</body>\n");
        html.append("</html>\n");
        return html.toString();
    }

    private static class EnsureGC
    extends FigureUtilities {
        private EnsureGC() {
        }

        public static void mustInitializeInMainThread() {
            GC ignoreGCValue = FigureUtilities.getGC();
            Class ignoreClassValue = class$org$eclipse$draw2d$ColorConstants == null ? (class$org$eclipse$draw2d$ColorConstants = DesignExportToHTML.class$("org.eclipse.draw2d.ColorConstants")) : class$org$eclipse$draw2d$ColorConstants;
        }
    }
}

