/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.CogTool;
import edu.cmu.cs.hcii.cogtool.CogToolLID;
import edu.cmu.cs.hcii.cogtool.model.DeviceType;
import edu.cmu.cs.hcii.cogtool.model.DoubleSize;
import edu.cmu.cs.hcii.cogtool.model.IAction;
import edu.cmu.cs.hcii.cogtool.model.IButtonAction;
import edu.cmu.cs.hcii.cogtool.model.IDesign;
import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.IGraffitiAction;
import edu.cmu.cs.hcii.cogtool.model.IInputDevice;
import edu.cmu.cs.hcii.cogtool.model.IKeyAction;
import edu.cmu.cs.hcii.cogtool.model.IProject;
import edu.cmu.cs.hcii.cogtool.model.ITapAction;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.model.ITransitionSource;
import edu.cmu.cs.hcii.cogtool.model.IVoiceAction;
import edu.cmu.cs.hcii.cogtool.model.IWidget;
import edu.cmu.cs.hcii.cogtool.model.MousePressType;
import edu.cmu.cs.hcii.cogtool.model.SkinType;
import edu.cmu.cs.hcii.cogtool.model.WidgetType;
import edu.cmu.cs.hcii.cogtool.ui.DefaultUI;
import edu.cmu.cs.hcii.cogtool.ui.DelayedRepaint;
import edu.cmu.cs.hcii.cogtool.ui.DelayedSelection;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorLID;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorMouseState;
import edu.cmu.cs.hcii.cogtool.ui.DesignEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorInteraction;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorUI;
import edu.cmu.cs.hcii.cogtool.ui.IFrameSelectionState;
import edu.cmu.cs.hcii.cogtool.ui.IInteraction;
import edu.cmu.cs.hcii.cogtool.ui.SingleFrameSelection;
import edu.cmu.cs.hcii.cogtool.ui.ZoomableUI;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorTransition;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorUIModel;
import edu.cmu.cs.hcii.cogtool.uimodel.IStructureViewUIModel;
import edu.cmu.cs.hcii.cogtool.util.IAlertHandler;
import edu.cmu.cs.hcii.cogtool.util.L10N;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifier;
import edu.cmu.cs.hcii.cogtool.util.ListenerIdentifierMap;
import edu.cmu.cs.hcii.cogtool.util.NameChangeAlert;
import edu.cmu.cs.hcii.cogtool.util.OSUtils;
import edu.cmu.cs.hcii.cogtool.util.PrecisionUtilities;
import edu.cmu.cs.hcii.cogtool.util.SWTTextEditor;
import edu.cmu.cs.hcii.cogtool.util.UndoManager;
import edu.cmu.cs.hcii.cogtool.view.DesignEditorView;
import edu.cmu.cs.hcii.cogtool.view.IActionPropertySet;
import edu.cmu.cs.hcii.cogtool.view.IDesignEditorView;
import edu.cmu.cs.hcii.cogtool.view.IView;
import edu.cmu.cs.hcii.cogtool.view.InteractionDrawingEditor;
import edu.cmu.cs.hcii.cogtool.view.ResizeThumb;
import edu.cmu.cs.hcii.cogtool.view.UndoManagerView;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;

public class DesignEditorUI
extends ZoomableUI
implements IDesignEditorUI {
    public static final int SOURCE = 0;
    public static final int TARGET = 1;
    protected IDesignEditorView view;
    protected DesignEditorSelectionState selection = new DesignEditorSelectionState();
    protected DesignEditorSelectionState contextSelection = new DesignEditorSelectionState();
    protected static final DesignEditorSelectionState emptySelection = new DesignEditorSelectionState();
    protected IDesignEditorInteraction interaction;
    protected UndoManager undoManager;
    protected FrameNameEditor editor = null;
    protected boolean editingInProgress = false;
    protected DesignEditorUIModel uiModel;
    protected IStructureViewUIModel structureView;
    protected DelayedSelection delayedFrameSelection = new DelayedSelection(this.selection){

        protected void selectItem(Object item) {
            DesignEditorUI.this.selection.selectFrame((DesignEditorFrame)item);
        }
    };
    protected DelayedSelection delayedTransitionSelection = new DelayedSelection(this.selection){

        protected void selectItem(Object item) {
            DesignEditorUI.this.selection.selectTransition((DesignEditorTransition)((Object)item));
        }
    };
    protected static final int REPAINT_SELECT_HANDLES = 1;
    protected static final int REPAINT_EDITOR = 2;
    protected static final int PERFORM_LWS_UPDATE = 4;
    protected static final int ZOOM_REPAINT = 3;
    protected static final int UPDATE_REPAINT = 5;
    protected static final int REPAINT_ALL = -1;
    protected DelayedRepaint delayedRepainting = new DelayedRepaint(){

        protected void performRepaint() {
            InteractionDrawingEditor viewEditor = DesignEditorUI.this.view.getEditor();
            if (this.isRepaintNeeded(2)) {
                DesignEditorUI.this.repaintEditor();
            }
            if (this.isRepaintNeeded(4)) {
                viewEditor.getLWS().getUpdateManager().performUpdate();
            }
            if (this.isRepaintNeeded(1)) {
                DesignEditorUI.this.repaintSelectHandles();
            }
        }

        public void doWork() {
            super.doWork();
            DesignEditorUI.this.setViewEnabledState(DesignEditorUI.this.selection, ListenerIdentifierMap.NORMAL);
        }
    };
    protected static final String DESIGN_PREFIX = L10N.get("WT.DesignPrefix", "Design");

    protected static String buildWindowMenuLabel(IDesign design) {
        return DESIGN_PREFIX + ": " + design.getName();
    }

    public DesignEditorUI(final IDesign designToEdit, IProject designProject, UndoManager undoMgr) {
        super(designProject, DesignEditorUI.buildWindowMenuLabel(designToEdit), DesignEditorUI.buildLeadItems(designProject));
        CogTool.selectionPhase.addDelayedWork(this.delayedFrameSelection);
        CogTool.selectionPhase.addDelayedWork(this.delayedTransitionSelection);
        CogTool.repaintPhase.addDelayedWork(this.delayedRepainting);
        this.uiModel = new DesignEditorUIModel(designToEdit, designProject, new IAlertHandler(){

            public void handleAlert(EventObject a) {
                DesignEditorUI.this.delayedRepainting.requestRepaint(5);
            }
        }, new IAlertHandler(){

            public void handleAlert(EventObject a) {
                DesignEditorUI.this.updateView(false);
            }
        });
        this.structureView = this.uiModel.getStructureView();
        DesignEditorMouseState mouseState = new DesignEditorMouseState(this);
        int deviceTypes = DeviceType.buildDeviceSet(designToEdit.getDeviceTypes());
        this.view = new DesignEditorView(deviceTypes, this.lIDMap, this, this.menuData, this.structureView.getContents(), mouseState, mouseState, this, this.getWindowLocation());
        InteractionDrawingEditor drawingEditor = this.view.getEditor();
        this.setZoomEditor(drawingEditor);
        drawingEditor.getInteractionFigure().addKeyListener(mouseState);
        Canvas editorSubstrate = drawingEditor.getSWTEditorSubstrate();
        editorSubstrate.addListener(35, (Listener)mouseState);
        this.updateTitle();
        this.interaction = new DesignEditorInteraction(this.view, deviceTypes);
        this.undoManager = undoMgr;
        UndoManagerView.UndoAlertHandler undoMgrViewHandler = new UndoManagerView.UndoAlertHandler(this.undoManager, this.lIDMap, CogToolLID.Undo, CogToolLID.Redo);
        undoMgr.addHandler(this, EventObject.class, undoMgrViewHandler);
        editorSubstrate.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (DesignEditorUI.this.editingInProgress) {
                    DesignEditorUI.this.confirmRenameFrame();
                } else {
                    DesignEditorUI.this.editingInProgress = true;
                }
            }

            public void mouseDown(MouseEvent e) {
                if (DesignEditorUI.this.editingInProgress) {
                    DesignEditorUI.this.confirmRenameFrame();
                } else {
                    DesignEditorUI.this.editingInProgress = true;
                }
            }
        });
        this.setZoom(this.getWindowZoom(designToEdit));
        this.selection.addHandler(this, DesignEditorSelectionState.FrameSelectionChange.class, this.createFrameSelectionHandler());
        this.selection.addHandler(this, DesignEditorSelectionState.TransitionSelectionChange.class, this.createTransitionSelectionHandler());
        this.structureView.addHandler(this, IStructureViewUIModel.FrameAdd.class, this.createFrameAddHandler());
        this.structureView.addHandler(this, IStructureViewUIModel.FrameShapeChange.class, this.createFrameShapeChangeHandler());
        this.structureView.addHandler(this, IStructureViewUIModel.FrameRecovery.class, this.createFrameRecoveryHandler());
        this.structureView.addHandler(this, IStructureViewUIModel.TransitionAddRemove.class, this.createTransitionAddRemoveHandler());
        this.project.addHandler(this, IProject.DesignChange.class, new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IProject.DesignChange chg = (IProject.DesignChange)alert;
                if (!chg.isAdd && chg.element == designToEdit) {
                    DesignEditorUI.this.closeOpenController();
                }
            }
        });
        this.setFrameChangeHandlers(designToEdit);
        this.setInitiallyEnabled();
    }

    protected void updateTitle() {
        this.view.setWindowTitle(this.modificationFlag + DESIGN_PREFIX + ": " + this.project.getName() + " > " + this.uiModel.getDesign().getName() + (OSUtils.MACOSX ? "" : WINDOW_TITLE));
    }

    protected String buildWindowMenuLabel() {
        return DesignEditorUI.buildWindowMenuLabel(this.uiModel.getDesign());
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.dispose();
        }
        CogTool.selectionPhase.removeDelayedWork(this.delayedFrameSelection);
        CogTool.selectionPhase.removeDelayedWork(this.delayedTransitionSelection);
        CogTool.repaintPhase.removeDelayedWork(this.delayedRepainting);
        this.structureView.removeAllHandlers(this);
        this.uiModel.getDesign().removeAllHandlers(this);
        this.uiModel.dispose();
        this.selection.removeAllHandlers(this);
        this.undoManager.removeAllHandlers(this);
        super.dispose();
    }

    protected Object getModelObject() {
        return this.uiModel.getDesign();
    }

    public IDesignEditorInteraction getInteraction() {
        return this.interaction;
    }

    public IInteraction getStandardInteraction() {
        return this.interaction;
    }

    public IDesignEditorSelectionState getSelection() {
        return this.selection;
    }

    public void selectAllFrames() {
        Iterator frameFigures = this.structureView.getAllFrameFigures();
        while (frameFigures.hasNext()) {
            DesignEditorFrame frameFigure = (DesignEditorFrame)frameFigures.next();
            this.selection.selectFrame(frameFigure);
        }
    }

    public IView getView() {
        return this.view;
    }

    protected InteractionDrawingEditor getViewEditor() {
        return this.view.getEditor();
    }

    public DesignEditorUIModel getUIModel() {
        return this.uiModel;
    }

    protected IAlertHandler createFrameSelectionHandler() {
        return new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                DesignEditorSelectionState.FrameSelectionChange evt = (DesignEditorSelectionState.FrameSelectionChange)alert;
                IActionPropertySet actionProps = DesignEditorUI.this.view.getActionPropertySet();
                if (evt != null) {
                    if (evt.changedFrameFigure != null) {
                        evt.changedFrameFigure.setSelected(evt.selected);
                        IFrame[] selectedFrames = DesignEditorUI.this.selection.getSelectedFrames();
                        int selectedFrameCount = selectedFrames.length;
                        if (selectedFrameCount > 0) {
                            actionProps.setComposite(7);
                            if (selectedFrameCount == 1) {
                                actionProps.setFrameName(selectedFrames[0]);
                            }
                        } else {
                            actionProps.setComposite(5);
                        }
                        actionProps.enableFrameName(selectedFrameCount == 1);
                        boolean canRemoveImage = true;
                        for (int i = 0; i < selectedFrames.length; ++i) {
                            if (selectedFrames[i].getBackgroundImage() != null) continue;
                            canRemoveImage = false;
                        }
                        actionProps.enableRemoveImage(canRemoveImage);
                    } else {
                        actionProps.setComposite(5);
                        Iterator frameFigures = DesignEditorUI.this.selection.getSelectedFrameFigures();
                        while (frameFigures.hasNext()) {
                            DesignEditorFrame frameFigure = (DesignEditorFrame)frameFigures.next();
                            frameFigure.setSelected(evt.selected);
                        }
                    }
                    DesignEditorUI.this.delayedRepainting.requestRepaint(-1);
                }
            }
        };
    }

    protected void setTransitionSelection(DesignEditorTransition transitionFig, boolean select) {
        InteractionDrawingEditor e = this.view.getEditor();
        if (select) {
            ResizeThumb sourceBox = new ResizeThumb(0);
            ResizeThumb targetBox = new ResizeThumb(1);
            sourceBox.setData((Object)transitionFig);
            targetBox.setData((Object)transitionFig);
            transitionFig.setHandles(sourceBox, targetBox);
            this.repaintSelectedTransition(transitionFig);
            e.addInteractionFigure((IFigure)sourceBox);
            e.addInteractionFigure((IFigure)targetBox);
        } else {
            e.removeInteractionFigure((IFigure)transitionFig.getSourceHandle());
            e.removeInteractionFigure((IFigure)transitionFig.getTargetHandle());
            transitionFig.setHandles(null, null);
        }
    }

    protected IAlertHandler createTransitionSelectionHandler() {
        return new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                DesignEditorSelectionState.TransitionSelectionChange evt = (DesignEditorSelectionState.TransitionSelectionChange)alert;
                if (evt != null) {
                    if (evt.changedTransitionFigure != null) {
                        DesignEditorUI.this.setTransitionSelection(evt.changedTransitionFigure, evt.selected);
                    } else {
                        Iterator transitionFigures = DesignEditorUI.this.selection.getSelectedTransitionFigures();
                        while (transitionFigures.hasNext()) {
                            DesignEditorTransition transitionFigure = (DesignEditorTransition)((Object)transitionFigures.next());
                            DesignEditorUI.this.setTransitionSelection(transitionFigure, evt.selected);
                        }
                    }
                    DesignEditorUI.this.delayedRepainting.requestRepaint(-1);
                    DesignEditorUI.this.updateView(evt.changedTransitionFigure == null);
                }
            }
        };
    }

    public void resetVisibleArea() {
        InteractionDrawingEditor e = this.view.getEditor();
        e.getLWS().getUpdateManager().performUpdate();
        DoubleSize extent = this.structureView.getPreferredSize();
        e.setMinVisibleArea(PrecisionUtilities.round(extent.width), PrecisionUtilities.round(extent.height), false);
    }

    protected void ensureRectIsVisible(Rectangle frameBounds) {
        int newOriginY;
        int newOriginX;
        this.resetVisibleArea();
        InteractionDrawingEditor e = this.view.getEditor();
        org.eclipse.swt.graphics.Rectangle visibleBounds = e.getVisibleBounds();
        double scale = this.structureView.getZoom();
        int frameX = PrecisionUtilities.round((double)frameBounds.x * scale);
        int frameY = PrecisionUtilities.round((double)frameBounds.y * scale);
        int frameWidth = PrecisionUtilities.round((double)frameBounds.width * scale);
        int frameHeight = PrecisionUtilities.round((double)frameBounds.height * scale);
        if (visibleBounds.width >= frameWidth) {
            if (frameX < visibleBounds.x) {
                newOriginX = frameX;
            } else {
                newOriginX = visibleBounds.x;
                int frameRight = frameX + frameWidth;
                int visibleRight = visibleBounds.x + visibleBounds.width;
                if (frameRight > visibleRight) {
                    newOriginX += frameRight - visibleRight;
                }
            }
        } else {
            newOriginX = frameX + frameWidth / 2 - visibleBounds.width / 2;
        }
        if (visibleBounds.height >= frameHeight) {
            if (frameY < visibleBounds.y) {
                newOriginY = frameY;
            } else {
                newOriginY = visibleBounds.y;
                int frameBottom = frameY + frameHeight;
                int visibleBottom = visibleBounds.y + visibleBounds.height;
                if (frameBottom > visibleBottom) {
                    newOriginY += frameBottom - visibleBottom;
                }
            }
        } else {
            newOriginY = frameY;
        }
        e.setScrollOrigin(newOriginX, newOriginY);
    }

    protected IAlertHandler createFrameAddHandler() {
        return new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IStructureViewUIModel.FrameAdd evt = (IStructureViewUIModel.FrameAdd)alert;
                DesignEditorUI.this.ensureRectIsVisible(evt.frameFigure.getBounds());
            }
        };
    }

    protected IAlertHandler createFrameShapeChangeHandler() {
        return new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IStructureViewUIModel.FrameShapeChange evt = (IStructureViewUIModel.FrameShapeChange)alert;
                DesignEditorUI.this.resetVisibleArea();
                if (DesignEditorUI.this.editor != null && DesignEditorUI.this.editor.getVisible() && evt.getFrameFigure() == (DesignEditorFrame)DesignEditorUI.this.editor.getData()) {
                    DesignEditorUI.this.delayedRepainting.requestRepaint(2);
                }
                DesignEditorUI.this.delayedRepainting.requestRepaint(1);
                DesignEditorUI.this.ensureRectIsVisible(evt.getFrameFigure().getBounds());
            }
        };
    }

    protected IAlertHandler createFrameRecoveryHandler() {
        return new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IStructureViewUIModel.FrameRecovery evt = (IStructureViewUIModel.FrameRecovery)alert;
                if (evt != null) {
                    DesignEditorFrame frameFigure = evt.getFrameFigure();
                    DesignEditorUI.this.selection.deselectFrame(frameFigure);
                    DesignEditorUI.this.cleanupFrameEditor(frameFigure);
                }
            }
        };
    }

    protected IAlertHandler createTransitionAddRemoveHandler() {
        return new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IStructureViewUIModel.TransitionAddRemove evt = (IStructureViewUIModel.TransitionAddRemove)alert;
                if (evt != null) {
                    DesignEditorTransition transitionFigure = evt.getTransitionFigure();
                    if (evt.isAdd) {
                        DesignEditorUI.this.delayedTransitionSelection.addToSelection(transitionFigure.getTransition(), (Object)transitionFigure);
                    } else if (transitionFigure.isSelected()) {
                        DesignEditorUI.this.selection.deselectTransition(transitionFigure);
                    }
                }
            }
        };
    }

    protected void setFrameChangeHandlers(IDesign design) {
        design.addHandler(this, NameChangeAlert.class, this.renameHandler);
        IAlertHandler frameChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign.FrameChange chg = (IDesign.FrameChange)alert;
                if (chg != null) {
                    DesignEditorFrame frameFigure = DesignEditorUI.this.structureView.getFrameFigure((IFrame)chg.element);
                    if (chg.isAdd) {
                        DesignEditorUI.this.delayedFrameSelection.addToSelection((IFrame)chg.element, frameFigure);
                        DesignEditorUI.this.delayedRepainting.requestRepaint(-1);
                    }
                }
            }
        };
        design.addHandler(this, IDesign.FrameChange.class, frameChangeHandler);
        frameChangeHandler = new IAlertHandler(){

            public void handleAlert(EventObject alert) {
                IDesign.FrameSetChange chg = (IDesign.FrameSetChange)alert;
                if (chg != null && chg.isAdd) {
                    for (int i = 0; i < chg.frames.length; ++i) {
                        DesignEditorFrame frameFigure = DesignEditorUI.this.structureView.getFrameFigure(chg.frames[i]);
                        DesignEditorUI.this.delayedFrameSelection.addToSelection(frameFigure.getFrame(), frameFigure);
                    }
                    DesignEditorUI.this.delayedRepainting.requestRepaint(-1);
                }
            }
        };
        design.addHandler(this, IDesign.FrameSetChange.class, frameChangeHandler);
    }

    public void setZoom(double scale) {
        super.setZoom(scale);
        this.delayedRepainting.requestRepaint(3);
    }

    public int determineChangeActionMode(ITransitionSource transitionSource) {
        if (transitionSource instanceof IInputDevice) {
            IInputDevice device = (IInputDevice)transitionSource;
            if (device.getDeviceType() == DeviceType.Keyboard) {
                return 2;
            }
            if (device.getDeviceType() == DeviceType.Voice) {
                return 1;
            }
        }
        return 6;
    }

    public void updateActionProperties(ITransitionSource transitionSource, IAction action, final IDesignEditorUI.ActionProperties props) {
        this.view.getDefaultProperties(props);
        if (transitionSource instanceof IWidget) {
            IAction.ActionVisitorAdapter widgetActionVisitor = new IAction.ActionVisitorAdapter(){

                public void visit(IButtonAction but) {
                    props.mouseButton = but.getButton();
                    props.buttonAction = but.getPressType();
                    if (props.buttonAction == MousePressType.Hover) {
                        props.mouseButton = null;
                    }
                    props.buttonState = but.getModifiers();
                    props.useWhichParts = 0;
                }

                public void visit(ITapAction tap) {
                    props.tapAction = tap.getTapPressType();
                    props.useWhichParts = 4;
                }

                public void visit(IKeyAction key) {
                    props.keyboardString = key.getText();
                    props.keyboardIsCmd = key.isCommand();
                    props.keyboardAction = key.getPressType();
                    props.useWhichParts = 2;
                }

                public void visit(IGraffitiAction graffiti) {
                    props.graffitiString = graffiti.getText();
                    props.graffitiIsCmd = graffiti.isCommand();
                    props.useWhichParts = 3;
                }

                public void visit(IVoiceAction voice) {
                    props.voiceString = voice.getText();
                    props.voiceIsCmd = voice.isCommand();
                    props.useWhichParts = 1;
                }
            };
            action.accept(widgetActionVisitor);
        } else {
            IInputDevice deviceSource = (IInputDevice)transitionSource;
            DeviceType type = deviceSource.getDeviceType();
            if (type == DeviceType.Voice) {
                IVoiceAction voiceAction = (IVoiceAction)action;
                props.voiceString = voiceAction.getText();
                props.voiceIsCmd = voiceAction.isCommand();
                props.useWhichParts = 1;
            } else {
                IKeyAction keyAction = (IKeyAction)action;
                props.keyboardString = keyAction.getText();
                props.keyboardAction = keyAction.getPressType();
                props.keyboardIsCmd = keyAction.isCommand();
                props.useWhichParts = 2;
            }
        }
    }

    protected void setInitiallyEnabled() {
        super.setInitiallyEnabled();
        this.setEnabled(CogToolLID.NewFrame, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomNormal, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomIn, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomOut, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ZoomToFit, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinNone, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinWireFrame, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinWinXP, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinMacOSX, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.SkinPalm, ListenerIdentifierMap.ALL, true);
        this.setEnabled(CogToolLID.ExportDesignToHTML, ListenerIdentifierMap.ALL, true);
        this.setEnabled(DesignEditorLID.ImportImageDirectory, ListenerIdentifierMap.ALL, true);
        this.setViewEnabledState(this.selection, ListenerIdentifierMap.NORMAL);
    }

    protected void setViewEnabledState(IDesignEditorSelectionState sel, Boolean availability) {
        boolean enabled = sel.getSelectedFrameCount() > 0 || sel.getSelectedTransitionCount() == 1;
        this.setEnabled(CogToolLID.Edit, availability, enabled);
        enabled = sel.getSelectedFrameCount() > 0 || sel.getSelectedTransitionCount() > 0;
        this.setEnabled(CogToolLID.Delete, availability, enabled);
        enabled = sel.getSelectedFrameCount() > 0;
        this.setEnabled(CogToolLID.Cut, availability, enabled);
        this.setEnabled(CogToolLID.Copy, availability, enabled);
        this.setEnabled(CogToolLID.NudgeLeft, availability, enabled);
        this.setEnabled(CogToolLID.NudgeRight, availability, enabled);
        this.setEnabled(CogToolLID.NudgeDown, availability, enabled);
        this.setEnabled(CogToolLID.NudgeUp, availability, enabled);
        this.setEnabled(CogToolLID.Duplicate, availability, enabled);
        this.setEnabled(CogToolLID.SetBackgroundImage, availability, enabled);
        this.setEnabled(CogToolLID.SetWidgetColor, availability, enabled);
        if (enabled) {
            boolean foundBackgroundImage = false;
            IFrame[] selFrames = sel.getSelectedFrames();
            for (int i = 0; i < selFrames.length; ++i) {
                if (selFrames[i].getBackgroundImage() == null) continue;
                foundBackgroundImage = true;
                break;
            }
            this.setEnabled(CogToolLID.RemoveBackgroundImage, availability, foundBackgroundImage);
        } else {
            this.setEnabled(CogToolLID.RemoveBackgroundImage, availability, enabled);
        }
        enabled = sel.getSelectedFrameCount() > 1;
        enabled = sel.getSelectedFrameCount() >= 3;
        enabled = sel.getSelectedFrameCount() == 1;
        this.setEnabled(CogToolLID.Rename, availability, enabled);
        enabled = this.uiModel.getDesign().getFrames().size() > 0;
        this.setEnabled(CogToolLID.SelectAll, availability, enabled);
        this.setSelected(CogToolLID.SkinNone, availability, false);
        this.setSelected(CogToolLID.SkinWireFrame, availability, false);
        this.setSelected(CogToolLID.SkinMacOSX, availability, false);
        this.setSelected(CogToolLID.SkinWinXP, availability, false);
        this.setSelected(CogToolLID.SkinPalm, availability, false);
        SkinType skin = this.uiModel.getDesign().getSkin();
        CogToolLID id = null;
        if (skin == SkinType.None) {
            id = CogToolLID.SkinNone;
        } else if (skin == SkinType.WireFrame) {
            id = CogToolLID.SkinWireFrame;
        } else if (skin == SkinType.MacOSX) {
            id = CogToolLID.SkinMacOSX;
        } else if (skin == SkinType.WinXP) {
            id = CogToolLID.SkinWinXP;
        } else if (skin == SkinType.Palm) {
            id = CogToolLID.SkinPalm;
        }
        this.setSelected(id, availability, true);
    }

    public ListenerIdentifier transmute(ListenerIdentifier id, boolean isContextSelection) {
        ListenerIdentifier specificLID = super.transmute(id, isContextSelection);
        if (specificLID != id) {
            return specificLID;
        }
        DesignEditorSelectionState seln = isContextSelection ? this.contextSelection : this.selection;
        specificLID = seln.getSelectedFrameCount() > 0 ? (ListenerIdentifier)DesignEditorLID.frameLIDs.get(id) : (ListenerIdentifier)DesignEditorLID.transitionLIDs.get(id);
        return specificLID != null ? specificLID : id;
    }

    protected void setUpPerformAction(ListenerIdentifier id) {
        int selectionMask = DesignEditorUI.canCauseSelection(id, this.undoManager);
        if (DesignEditorUI.isSelectionFlagSet(selectionMask, 4)) {
            this.delayedFrameSelection.setActive(true);
        }
        if (DesignEditorUI.isSelectionFlagSet(selectionMask, 8)) {
            this.delayedTransitionSelection.setActive(true);
        }
    }

    public Object getParameters(ListenerIdentifier originalLID, ListenerIdentifier transmutedLID, boolean isContextSelection) {
        if (originalLID instanceof DefaultUI.RestoreParentControllerLID) {
            return super.getParameters(originalLID, transmutedLID, isContextSelection);
        }
        this.setUpPerformAction(transmutedLID);
        if (transmutedLID == DesignEditorLID.ChangeWidgetAction || transmutedLID == DesignEditorLID.ChangeDeviceAction) {
            return new IDesignEditorUI.ChangeActionParameters(this.view.getActionProperties(), this.selection);
        }
        return isContextSelection ? this.contextSelection : this.selection;
    }

    public void cleanup(boolean okToContinue, boolean menuHidden) {
        if (menuHidden) {
            DesignEditorFrame fig;
            Iterator frameFigs;
            if (this.selection.getSelectedFrameCount() > 0) {
                frameFigs = this.selection.getSelectedFrameFigures();
                while (frameFigs.hasNext()) {
                    fig = (DesignEditorFrame)frameFigs.next();
                    fig.paintSelected();
                }
            }
            if (this.contextSelection.getSelectedFrameCount() > 0) {
                frameFigs = this.contextSelection.getSelectedFrameFigures();
                while (frameFigs.hasNext()) {
                    fig = (DesignEditorFrame)frameFigs.next();
                    fig.paintSelected();
                }
            }
        }
        this.updateView(false);
        super.cleanup(okToContinue, menuHidden);
    }

    public void initiateFrameRename(IFrame frameToRename) {
        DesignEditorFrame renameFrameFigure = this.structureView.getFrameFigure(frameToRename);
        this.initiateFrameRename(renameFrameFigure);
    }

    public void initiateFrameRename(IFrameSelectionState frameToRename) {
        if (frameToRename.getSelectedFrameCount() == 1) {
            IFrame frame = frameToRename.getSelectedFrames()[0];
            DesignEditorFrame renameFrameFigure = this.structureView.getFrameFigure(frame);
            this.initiateFrameRename(renameFrameFigure);
        }
    }

    public void initiateFrameRename(DesignEditorFrame frameFigure) {
        if (this.editor == null) {
            this.editor = new FrameNameEditor();
        }
        if (frameFigure != null) {
            this.editor.editFrameName(frameFigure);
        }
    }

    protected void repaintEditor() {
        if (this.editor != null) {
            this.editor.repaintTextEditor(this.structureView.getZoom());
        }
    }

    protected void confirmRenameFrame() {
        if (this.editor != null && this.editor.inUse()) {
            String newName = this.editor.getText();
            DesignEditorFrame frameFigure = (DesignEditorFrame)this.editor.getData();
            IFrame frameToRename = frameFigure.getFrame();
            SingleFrameSelection renameSelection = new SingleFrameSelection(frameToRename);
            this.editor.cleanup();
            this.performAction(DesignEditorLID.RenameFrame, new IDesignEditorUI.FrameRenameEvent(frameToRename, newName, renameSelection), false);
            this.view.getActionPropertySet().setFrameName(frameToRename);
        }
    }

    protected void cleanupFrameEditor(DesignEditorFrame frameFig) {
        if (this.editor != null && this.editor.inUse() && frameFig == this.editor.getData()) {
            this.editor.cleanup();
        }
    }

    protected void cleanupFrameEditor() {
        if (this.editor != null) {
            this.editor.cleanup();
        }
    }

    protected void showContextMenu(IDesignEditorSelectionState seln, boolean context) {
        this.setViewEnabledState(seln, ListenerIdentifierMap.CONTEXT);
        if (seln.getSelectedFrameCount() > 0) {
            this.view.showFrameMenu(context);
        } else if (seln.getSelectedTransitionCount() > 0) {
            this.view.showTransitionMenu(context);
        } else {
            this.view.showStandardMenu();
        }
    }

    public void showContextMenu() {
        this.showContextMenu(this.selection, false);
    }

    public void showContextMenu(int x, int y) {
        IFigure fig = this.structureView.getFigureAtXY(x, y, 6);
        if (fig == null) {
            this.contextSelection.deselectAll();
            this.showContextMenu(this.contextSelection, true);
        } else if (fig instanceof DesignEditorTransition) {
            DesignEditorTransition transitionFig = (DesignEditorTransition)fig;
            if (transitionFig.isSelected()) {
                this.showContextMenu();
            } else {
                this.contextSelection.setSelectedTransition(transitionFig);
                this.showContextMenu(this.contextSelection, true);
            }
        } else {
            DesignEditorFrame frameFig = (DesignEditorFrame)fig;
            if (frameFig.isSelected()) {
                Iterator figs = this.selection.getSelectedFrameFigures();
                while (figs.hasNext()) {
                    frameFig = (DesignEditorFrame)figs.next();
                    frameFig.dynamicHighlight();
                }
                this.showContextMenu();
            } else {
                frameFig.dynamicHighlight();
                this.contextSelection.setSelectedFrame(frameFig);
                this.showContextMenu(this.contextSelection, true);
            }
            this.view.getEditor().getLWS().getUpdateManager().performUpdate();
        }
    }

    protected void setFigureOrigin(IFigure f, double x, double y) {
        f.setLocation(new Point(PrecisionUtilities.round(x), PrecisionUtilities.round(y)));
    }

    protected void repaintSelectedTransition(DesignEditorTransition transFig) {
        ResizeThumb sourceBox = transFig.getSourceHandle();
        ResizeThumb targetBox = transFig.getTargetHandle();
        double zoom = this.getZoom();
        Point pt = transFig.getStart();
        sourceBox.centerAt(PrecisionUtilities.round((double)pt.x * zoom), PrecisionUtilities.round((double)pt.y * zoom));
        pt = transFig.getEnd();
        targetBox.centerAt(PrecisionUtilities.round((double)pt.x * zoom), PrecisionUtilities.round((double)pt.y * zoom));
        sourceBox.repaint();
        targetBox.repaint();
    }

    public void repaintSelectHandles() {
        Iterator selectedTransitions = this.selection.getSelectedTransitionFigures();
        while (selectedTransitions.hasNext()) {
            DesignEditorTransition selectedTransition = (DesignEditorTransition)((Object)selectedTransitions.next());
            if (!selectedTransition.isSelected()) continue;
            this.repaintSelectedTransition(selectedTransition);
        }
    }

    protected void performRepaintUpdates() {
        this.view.getEditor().getLWS().getUpdateManager().performUpdate();
        this.repaintSelectHandles();
    }

    protected void updateView(boolean deselectAll) {
        if (this.view.isDisposed()) {
            return;
        }
        IActionPropertySet actionProps = this.view.getActionPropertySet();
        int selectedTransitionCount = this.selection.getSelectedTransitionCount();
        int selectedFrameCount = this.selection.getSelectedFrameCount();
        if (deselectAll || selectedFrameCount + selectedTransitionCount == 0) {
            actionProps.useParameters(5);
        } else if (selectedTransitionCount == 1) {
            ITransition transition = this.selection.getSelectedTransitions()[0];
            IAction action = transition.getAction();
            DeviceType type = action.getDefaultDeviceType();
            int device = 5;
            if (action instanceof IGraffitiAction) {
                device = 3;
            } else if (type == DeviceType.Mouse) {
                device = 0;
            } else if (type == DeviceType.Touchscreen) {
                device = 4;
            } else if (type == DeviceType.Keyboard) {
                device = 2;
            } else if (type == DeviceType.Voice) {
                device = 1;
            } else if (type == null) {
                if (actionProps.isMouseSelected()) {
                    device = 0;
                } else if (actionProps.isTouchSelected()) {
                    device = 4;
                }
            }
            actionProps.setComposite(device);
            IDesignEditorUI.ActionProperties properties = this.view.getActionProperties();
            ITransitionSource source = transition.getSource();
            this.updateActionProperties(source, transition.getAction(), properties);
            actionProps.setLimitMode(this.determineChangeActionMode(source), properties.useWhichParts);
            actionProps.setProperties(properties, properties.useWhichParts);
        } else if (selectedTransitionCount > 1) {
            actionProps.useParameters(8);
        }
    }

    public ResizeThumb getResizeAtXY(int x, int y) {
        IFigure f = this.view.getEditor().getInteractionFigure().findFigureAt(x, y);
        if (f instanceof ResizeThumb) {
            return (ResizeThumb)f;
        }
        return null;
    }

    public DeviceType getCurrentDeviceType() {
        return this.view.getDeviceType();
    }

    public void getDefaultProperties(ITransitionSource source, IDesignEditorUI.ActionProperties properties) {
        this.view.getDefaultProperties(properties);
        DeviceType device = this.getCurrentDeviceType();
        properties.useWhichParts = device == BASE_ACTION_ON_SOURCE && source instanceof IWidget && ((IWidget)source).getWidgetType() == WidgetType.Graffiti ? 3 : (device == DeviceType.Keyboard ? 2 : (device == DeviceType.Touchscreen ? 4 : (device == DeviceType.Voice ? 1 : 0)));
    }

    protected class FrameNameEditor
    extends SWTTextEditor {
        public FrameNameEditor() {
            super((Composite)DesignEditorUI.this.view.getEditor().getSWTEditorSubstrate(), 0x1000000);
        }

        protected void confirmRename(int focusRule) {
            DesignEditorUI.this.confirmRenameFrame();
        }

        protected int computeHeight(Rectangle bounds, double scale, int offset) {
            DesignEditorFrame frameFig = (DesignEditorFrame)this.getData();
            return PrecisionUtilities.round((double)frameFig.getLabelHeight() * scale);
        }

        public void editFrameName(DesignEditorFrame frameFigure) {
            IFrame frame = frameFigure.getFrame();
            DesignEditorUI.this.editingInProgress = false;
            this.editText(frame.getName(), (IFigure)frameFigure, DesignEditorUI.this.structureView.getZoom());
        }

        protected Font getFontToUse() {
            return ((DesignEditorFrame)this.getData()).getLabel().getFont();
        }
    }
}

