/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.hcii.cogtool.ui;

import edu.cmu.cs.hcii.cogtool.model.IFrame;
import edu.cmu.cs.hcii.cogtool.model.ITransition;
import edu.cmu.cs.hcii.cogtool.ui.IDesignEditorSelectionState;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorFrame;
import edu.cmu.cs.hcii.cogtool.uimodel.DesignEditorTransition;
import edu.cmu.cs.hcii.cogtool.util.Alerter;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DesignEditorSelectionState
extends Alerter
implements IDesignEditorSelectionState {
    protected Map selectedFrames = new HashMap();
    protected Map selectedTransitions = new HashMap();
    protected FrameSelectionChange frameChangeAlert = new FrameSelectionChange(this, false);
    protected TransitionSelectionChange transitionChangeAlert = new TransitionSelectionChange(this, false);

    public void deselectAll() {
        if (this.getSelectedFrameCount() > 0) {
            this.frameChangeAlert.selected = false;
            this.frameChangeAlert.changedFrameFigure = null;
            this.raiseAlert(this.frameChangeAlert);
        }
        if (this.getSelectedTransitionCount() > 0) {
            this.transitionChangeAlert.selected = false;
            this.transitionChangeAlert.changedTransitionFigure = null;
            this.raiseAlert(this.transitionChangeAlert);
        }
        this.selectedFrames.clear();
        this.selectedTransitions.clear();
    }

    public int getSelectedFrameCount() {
        return this.selectedFrames.size();
    }

    public Iterator getSelectedFrameFigures() {
        return this.selectedFrames.values().iterator();
    }

    public IFrame[] getSelectedFrames() {
        IFrame[] frames = new IFrame[this.selectedFrames.size()];
        Iterator frameIterator = this.selectedFrames.values().iterator();
        int i = 0;
        while (frameIterator.hasNext()) {
            DesignEditorFrame frameHolder = (DesignEditorFrame)frameIterator.next();
            frames[i++] = frameHolder.getFrame();
        }
        return frames;
    }

    public boolean isFrameSelected(IFrame f) {
        return this.selectedFrames.get(f) != null;
    }

    public int getSelectedTransitionCount() {
        return this.selectedTransitions.size();
    }

    public Iterator getSelectedTransitionFigures() {
        return this.selectedTransitions.values().iterator();
    }

    public ITransition[] getSelectedTransitions() {
        ITransition[] transitions = new ITransition[this.selectedTransitions.size()];
        Iterator transitionIterator = this.selectedTransitions.values().iterator();
        int i = 0;
        while (transitionIterator.hasNext()) {
            DesignEditorTransition transitionHolder = (DesignEditorTransition)((Object)transitionIterator.next());
            transitions[i++] = transitionHolder.getTransition();
        }
        return transitions;
    }

    public void setSelectedFrame(DesignEditorFrame singleFrame) {
        this.deselectAll();
        this.selectFrame(singleFrame);
    }

    public void selectFrame(DesignEditorFrame singleFrame) {
        if (this.selectedFrames.put(singleFrame.getFrame(), singleFrame) == null) {
            this.frameChangeAlert.selected = true;
            this.frameChangeAlert.changedFrameFigure = singleFrame;
            this.raiseAlert(this.frameChangeAlert);
        }
    }

    public void deselectFrame(DesignEditorFrame singleFrame) {
        if (this.selectedFrames.remove(singleFrame.getFrame()) != null) {
            this.frameChangeAlert.selected = false;
            this.frameChangeAlert.changedFrameFigure = singleFrame;
            this.raiseAlert(this.frameChangeAlert);
        }
    }

    public boolean isTransitionSelected(ITransition t) {
        return this.selectedTransitions.get(t) != null;
    }

    public void setSelectedTransition(DesignEditorTransition singleTransition) {
        this.deselectAll();
        this.selectTransition(singleTransition);
    }

    public void selectTransition(DesignEditorTransition singleTransition) {
        if (null == this.selectedTransitions.put(singleTransition.getTransition(), singleTransition)) {
            this.transitionChangeAlert.selected = true;
            this.transitionChangeAlert.changedTransitionFigure = singleTransition;
            this.raiseAlert(this.transitionChangeAlert);
        }
    }

    public void deselectTransition(DesignEditorTransition singleTransition) {
        ITransition t = singleTransition.getTransition();
        if (this.selectedTransitions.remove(t) != null) {
            this.transitionChangeAlert.selected = false;
            this.transitionChangeAlert.changedTransitionFigure = singleTransition;
            this.raiseAlert(this.transitionChangeAlert);
        }
    }

    public static class TransitionSelectionChange
    extends EventObject {
        public boolean selected;
        public DesignEditorTransition changedTransitionFigure = null;

        public TransitionSelectionChange(DesignEditorSelectionState source, boolean isSelection) {
            super(source);
            this.selected = isSelection;
        }

        public TransitionSelectionChange(DesignEditorSelectionState source, DesignEditorTransition figure, boolean isSelection) {
            this(source, isSelection);
            this.changedTransitionFigure = figure;
        }
    }

    public static class FrameSelectionChange
    extends EventObject {
        public boolean selected;
        public DesignEditorFrame changedFrameFigure = null;

        public FrameSelectionChange(DesignEditorSelectionState source, boolean isSelection) {
            super(source);
            this.selected = isSelection;
        }

        public FrameSelectionChange(DesignEditorSelectionState source, DesignEditorFrame figure, boolean isSelection) {
            this(source, isSelection);
            this.changedFrameFigure = figure;
        }
    }
}

